/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.arelle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.arelle.ArelleCliService;
import ru.cbr.xbrl.converter.arelle.ArelleCmdOptions;
import ru.cbr.xbrl.converter.arelle.ArelleOutputParser;
import ru.cbr.xbrl.converter.arelle.ArelleService;
import ru.cbr.xbrl.converter.arelle.data.XbrlParsedData;
import ru.cbr.xbrl.converter.arelle.executor.ArelleExecutor;
import ru.cbr.xbrl.converter.config.ConfigProperties;
import ru.cbr.xbrl.converter.exception.CancelledException;
import ru.cbr.xbrl.converter.exception.CommandExecutionException;
import ru.cbr.xbrl.converter.exception.EngineAuthorizeException;
import ru.cbr.xbrl.converter.exception.XbrlImportException;
import ru.cbr.xbrl.converter.model.XbrlPeriod;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.enums.XmlContentType;
import ru.cbr.xbrl.converter.model.log.EventLog;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.model.validation.CsvLineInfo;
import ru.cbr.xbrl.converter.model.validation.ValidationAspectInfo;
import ru.cbr.xbrl.converter.model.validation.ValidationEvent;
import ru.cbr.xbrl.converter.model.validation.ValidationItemRef;
import ru.cbr.xbrl.converter.model.validation.ValidationItemRefContext;
import ru.cbr.xbrl.converter.model.validation.ValidationLogEntry;
import ru.cbr.xbrl.converter.model.validation.ValidationLogInfo;
import ru.cbr.xbrl.converter.service.XbrlPackageService;
import ru.cbr.xbrl.converter.service.XbrlPeriodService;
import ru.cbr.xbrl.converter.service.import_export.CsvLineInfoService;
import ru.cbr.xbrl.converter.service.import_export.PeriodDates;
import ru.cbr.xbrl.converter.service.label_linkbase.LabelLinkbaseService;
import ru.cbr.xbrl.converter.service.log.EventLogService;
import ru.cbr.xbrl.converter.utils.FileUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.csv.CsvCommon;

@Service
public class ArelleCliService
implements ArelleService {
    private static final Logger log = LoggerFactory.getLogger(ArelleCliService.class);
    public static final String XML_SCHEMA_SYNTAX = "xmlSchema:syntax";
    @Autowired
    private ConfigProperties configProperties;
    @Autowired
    private ArelleExecutor arelleExecutor;
    @Autowired
    private XbrlPeriodService xbrlPeriodService;
    @Autowired
    private XbrlPackageService xbrlPackageService;
    private boolean isLastActionCancelled = false;
    @Autowired
    private EventLogService eventLogService;
    @Autowired
    private CsvLineInfoService csvLineInfoService;
    @Autowired
    private LabelLinkbaseService labelLinkbaseService;
    private static final String XBRLDIE_ILLEGAL_TYPED_DIMENSION_CONTENT_ERROR = "xbrldie:IllegalTypedDimensionContentError";
    private static final String XBRLDIE_PRIMARY_ITEM_DIMENSIONALLY_INVALID_ERROR = "xbrldie:PrimaryItemDimensionallyInvalidError";

    public XbrlParsedData read(String xbrlFile, String[] packages) throws CommandExecutionException, CancelledException {
        ArelleCmdOptions cmdOptions = new ArelleCmdOptions();
        cmdOptions.setArelleExecutable(this.configProperties.getArelleExecutable());
        cmdOptions.setFilePath(xbrlFile);
        cmdOptions.setValidation(Boolean.FALSE.booleanValue());
        cmdOptions.setPackages(packages);
        cmdOptions.setSaveFileOutput(Boolean.TRUE.booleanValue());
        this.setDateParameters(cmdOptions);
        this.execute(cmdOptions);
        Map<String, String> dataMap = Arrays.stream(ArelleCmdOptions.FILE_OUTPUT_OPTIONS).collect(Collectors.toMap(o -> o, o -> FileUtils.readTextFile((String)((String)cmdOptions.getOutputFiles().get(o)))));
        return new XbrlParsedData(dataMap);
    }

    public String convertIxbrlToXml(String xbrlFile, String[] packages) throws CommandExecutionException, CancelledException {
        String iXbrlConvertFileOption = "iXbrlConvertFile";
        String logFile = "logFile";
        String[] fileOutputOptions = new String[]{iXbrlConvertFileOption, logFile};
        Date startProcessing = new Date();
        log.info("Getting output files using arelle started...");
        ArelleCmdOptions cmdOptions = new ArelleCmdOptions();
        cmdOptions.setArelleExecutable(this.configProperties.getArelleExecutable());
        cmdOptions.setFilePath(xbrlFile);
        cmdOptions.setIXbrlConvert(Boolean.TRUE);
        cmdOptions.setVFlag(Boolean.FALSE.booleanValue());
        cmdOptions.setValidation(Boolean.FALSE.booleanValue());
        cmdOptions.setFormulaNone(Boolean.valueOf(true));
        cmdOptions.setPackages(packages);
        cmdOptions.setSaveFileOutput(Boolean.TRUE.booleanValue());
        cmdOptions.setEnabledFileOutputOptions(fileOutputOptions);
        this.execute(cmdOptions);
        log.info("Getting output files using arelle started completed in " + (new Date().getTime() - startProcessing.getTime()) + " msec");
        return (String)cmdOptions.getOutputFiles().get(iXbrlConvertFileOption);
    }

    public boolean checkXbrlFile(String xbrlFile, String[] packages, EventLog.EventLogType eventLogType, ValidationLogInfo validationLogInfo) throws CommandExecutionException, CancelledException, XbrlImportException {
        String[] fileOutputOptions = new String[]{"logFile"};
        Date startProcessing = new Date();
        log.info("Getting output files using arelle started...");
        String logFile = "logFile";
        ArelleCmdOptions cmdOptions = new ArelleCmdOptions();
        cmdOptions.setArelleExecutable(this.configProperties.getArelleExecutable());
        cmdOptions.setFilePath(xbrlFile);
        cmdOptions.setValidation(Boolean.FALSE.booleanValue());
        cmdOptions.setVFlag(Boolean.TRUE.booleanValue());
        cmdOptions.setPackages(packages);
        cmdOptions.setSaveFileOutput(Boolean.TRUE.booleanValue());
        cmdOptions.setEnabledFileOutputOptions(fileOutputOptions);
        cmdOptions.setFormulaNone(Boolean.valueOf(true));
        this.setDateParameters(cmdOptions);
        this.execute(cmdOptions);
        String logFilePath = (String)cmdOptions.getOutputFiles().get(logFile);
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        Long xbrlReportId = xbrlPackage.getXbrlReport().getId();
        AtomicBoolean valid = new AtomicBoolean(Boolean.TRUE);
        AtomicBoolean terminateImport = new AtomicBoolean(Boolean.FALSE);
        ArelleOutputParser.parseXmlFileValidation((String)logFilePath, (XbrlReport)new XbrlReport(), (Boolean)Boolean.FALSE, validationLogEntry -> {
            String level = validationLogEntry.getLevel();
            String code = validationLogEntry.getCode();
            if (level != null && level.toLowerCase().equals("error") && code.startsWith("xbrl.3.5.1.2")) {
                valid.set(Boolean.FALSE);
                EventLog eventLog = new EventLog();
                eventLog.setEventLogType(eventLogType);
                eventLog.setMessage(validationLogEntry.getMessage());
                eventLog.setXbrlReportId(xbrlReportId);
                this.eventLogService.createInNewTransaction(eventLog);
                terminateImport.set(true);
            }
            if (level != null && level.toLowerCase().equals("error") && (code.startsWith("xbrl.4.6.1") || code.startsWith("xbrl.4.6.2:numericUnit") || code.startsWith("xbrldie:") || code.startsWith("xmlSchema:") || code.startsWith("xml.3.3.1:idMustBeUnique") || code.startsWith("enumie:InvalidFactValue") || code.startsWith("xbrl.4.6.3:missingPrecisionDecimals") || code.startsWith("xbrl.4.7.2") || code.startsWith("xbrl.4.8.2:monetaryFactUnit-notMonetaryMeasure") || code.startsWith("EFM.6.05.07") || code.startsWith("EFM.6.05.12") || code.startsWith("EFM.6.05.11") || code.startsWith("Custom") || code.startsWith("EIOPA.2.22")) || StringUtils.equals((CharSequence)code, (CharSequence)"EBA.2.16")) {
                if (this.processContextError(validationLogEntry, xbrlPackage.getXbrlReport(), eventLogType).booleanValue()) {
                    return;
                }
                this.processValidationError(validationLogEntry, validationLogInfo);
                String msg = validationLogEntry.getMessage();
                if (!StringUtils.equals((CharSequence)code, (CharSequence)"EBA.2.16")) {
                    valid.set(Boolean.FALSE);
                    if (!StringUtils.equals((CharSequence)code, (CharSequence)"xbrldie:PrimaryItemIsNotDefinedForEntryPoint")) {
                        EventLog eventLog = new EventLog();
                        eventLog.setEventLogType(eventLogType);
                        eventLog.setMessage(validationLogEntry.getMessage());
                        eventLog.setXbrlReportId(xbrlReportId);
                        this.eventLogService.createInNewTransaction(eventLog);
                    }
                }
            }
        });
        log.info("Getting output files using arelle started completed in " + (new Date().getTime() - startProcessing.getTime()) + " msec");
        if (terminateImport.get()) {
            log.info("\u0412 \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0435 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0437\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u043c\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430 \u0432\u044b\u044f\u043b\u0435\u043d\u0430 \u043e\u0448\u0438\u0431\u043a\u0430, \u043f\u0440\u0435\u0440\u044b\u0432\u0430\u044e\u0449\u0430\u044f \u0434\u0430\u043b\u044c\u043d\u0435\u0439\u0448\u0443\u044e \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0443.");
            throw new XbrlImportException();
        }
        return valid.get();
    }

    private void processValidationError(ValidationLogEntry validationLogEntry, ValidationLogInfo validationLogInfo) {
        String[] hrefLink;
        ValidationItemRef validationItemRef;
        String href;
        List validationItemRefList;
        ValidationAspectInfo validationAspectInfo = new ValidationAspectInfo();
        Map messageAttributeMap = validationLogEntry.getMessageAttributeMap();
        ArrayList elementIndexList = new ArrayList();
        if (messageAttributeMap == null) {
            return;
        }
        String value = "";
        String typeName = "";
        String attribute = "";
        String element = "";
        String fact = "";
        String contextId = "";
        String unusedUnitIds = "";
        String parentElement = "";
        String message = validationLogEntry.getMessage();
        validationAspectInfo.setMessage(message);
        for (Map.Entry messageAttribute : messageAttributeMap.entrySet()) {
            String key;
            switch (key = (String)messageAttribute.getKey()) {
                case "typeName": {
                    typeName = (String)messageAttribute.getValue();
                    break;
                }
                case "attribute": {
                    attribute = (String)messageAttribute.getValue();
                    break;
                }
                case "value": {
                    value = (String)messageAttribute.getValue();
                    break;
                }
                case "element": {
                    element = (String)messageAttribute.getValue();
                    break;
                }
                case "parentElement": {
                    parentElement = (String)messageAttribute.getValue();
                    break;
                }
                case "fact": {
                    fact = (String)messageAttribute.getValue();
                    break;
                }
                case "contextID": {
                    contextId = (String)messageAttribute.getValue();
                    break;
                }
                case "unusedUnitIDs": {
                    unusedUnitIds = (String)messageAttribute.getValue();
                    break;
                }
                case "message": {
                    message = (String)messageAttribute.getValue();
                }
            }
        }
        if ((StringUtils.endsWith((CharSequence)element, (CharSequence)"divide") || StringUtils.endsWith((CharSequence)element, (CharSequence)"measure")) && parentElement.endsWith("unit")) {
            element = parentElement;
        }
        if (StringUtils.isNotBlank((CharSequence)element)) {
            if (StringUtils.endsWith((CharSequence)element, (CharSequence)"context")) {
                validationAspectInfo.setContentType(XmlContentType.CONTEXT);
            } else if (StringUtils.endsWith((CharSequence)element, (CharSequence)"unit")) {
                validationAspectInfo.setContentType(XmlContentType.UNIT);
            } else {
                validationAspectInfo.setContentType(XmlContentType.VALUE);
                validationAspectInfo.setId(element);
            }
            if (StringUtils.equals((CharSequence)attribute, (CharSequence)"id")) {
                validationAspectInfo.setId(value);
            }
            if (StringUtils.equals((CharSequence)attribute, (CharSequence)"contextRef")) {
                validationAspectInfo.setContextRef(value);
            }
        } else if (StringUtils.isNotBlank((CharSequence)fact) && StringUtils.isNotBlank((CharSequence)contextId)) {
            validationAspectInfo.setId(fact);
            validationAspectInfo.setContextRef(contextId);
            validationAspectInfo.setContentType(XmlContentType.VALUE);
        } else if (StringUtils.isNotBlank((CharSequence)contextId)) {
            validationAspectInfo.setId(contextId);
            validationAspectInfo.setContentType(XmlContentType.CONTEXT);
        } else if (StringUtils.isNotBlank((CharSequence)fact)) {
            validationAspectInfo.setId(fact);
            validationAspectInfo.setContentType(XmlContentType.VALUE);
        } else if (StringUtils.isNotBlank((CharSequence)unusedUnitIds)) {
            validationAspectInfo.setId(unusedUnitIds);
            validationAspectInfo.setContentType(XmlContentType.UNIT);
        }
        if (!CollectionUtils.isEmpty((Collection)(validationItemRefList = validationLogEntry.getValidationItemRefList())) && StringUtils.isNotBlank((CharSequence)(href = (validationItemRef = (ValidationItemRef)validationItemRefList.get(0)).getHref())) && StringUtils.isNotBlank((CharSequence)(hrefLink = StringUtils.substringAfterLast((String)href, (String)"#")))) {
            if (hrefLink.startsWith("element(")) {
                if (validationAspectInfo.getContentType() == XmlContentType.UNIT) {
                    String elementIdIndex = StringUtils.substringBetween((String)hrefLink, (String)"(", (String)")");
                    String elementId = StringUtils.substringBefore((String)elementIdIndex, (String)"/");
                    String elementIndex = StringUtils.substringAfter((String)elementIdIndex, (String)"/");
                    validationAspectInfo.setId(elementId);
                    try {
                        validationAspectInfo.setXmlIndex(Integer.valueOf(elementIndex));
                    }
                    catch (NumberFormatException e) {
                        log.warn("\u041f\u0430\u0440\u0441\u0438\u043d\u0433 \u043b\u043e\u0433\u0430 \u043f\u0440\u0435\u0434\u0432\u0430\u0440\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0439 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438. \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0438\u043d\u0434\u0435\u043a\u0441\u0430 \u0432 \u0441\u0441\u044b\u043b\u043a\u0435 \u043d\u0430 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0447\u0438\u0441\u043b\u043e\u043c, \u0441\u0441\u044b\u043b\u043a\u0430: {}", (Object)hrefLink);
                    }
                } else {
                    String elementIndex = StringUtils.substringBetween((String)hrefLink, (String)"(", (String)")");
                    elementIndex = StringUtils.substringAfter((String)elementIndex, (String)"/1/");
                    try {
                        validationAspectInfo.setXmlIndex(Integer.valueOf(elementIndex));
                    }
                    catch (NumberFormatException e) {
                        log.warn("\u041f\u0430\u0440\u0441\u0438\u043d\u0433 \u043b\u043e\u0433\u0430 \u043f\u0440\u0435\u0434\u0432\u0430\u0440\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0439 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438. \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0438\u043d\u0434\u0435\u043a\u0441\u0430 \u0432 \u0441\u0441\u044b\u043b\u043a\u0435 \u043d\u0430 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0447\u0438\u0441\u043b\u043e\u043c, \u0441\u0441\u044b\u043b\u043a\u0430: {}", (Object)hrefLink);
                    }
                }
            } else if (validationAspectInfo.getContentType() == XmlContentType.VALUE) {
                validationAspectInfo.setId((String)hrefLink);
                validationAspectInfo.setXmlIndex(Integer.valueOf(-1));
            }
        }
        if (validationAspectInfo.getContentType() == null) {
            return;
        }
        switch (1.$SwitchMap$ru$cbr$xbrl$converter$model$enums$XmlContentType[validationAspectInfo.getContentType().ordinal()]) {
            case 1: {
                validationLogInfo.getErrorContextMap().put(validationAspectInfo.getId(), validationAspectInfo);
                break;
            }
            case 2: {
                String unitId = validationAspectInfo.getId();
                String[] split = StringUtils.split((String)unitId, (String)", ");
                if (split != null && split.length > 1) {
                    for (String id : split) {
                        ValidationAspectInfo currentValidationAspectInfo = new ValidationAspectInfo(validationAspectInfo);
                        currentValidationAspectInfo.setId(id);
                        validationLogInfo.getErrorUnitMap().put(id, currentValidationAspectInfo);
                    }
                    break;
                }
                validationLogInfo.getErrorUnitMap().put(unitId, validationAspectInfo);
                break;
            }
            case 3: {
                String mainId = validationAspectInfo.getId();
                ArrayList<ValidationAspectInfo> validationAspectInfoList = (ArrayList<ValidationAspectInfo>)validationLogInfo.getErrorValueMap().get(mainId);
                if (validationAspectInfoList == null) {
                    validationAspectInfoList = new ArrayList<ValidationAspectInfo>();
                    validationLogInfo.getErrorValueMap().put(validationAspectInfo.getId(), validationAspectInfoList);
                }
                validationAspectInfoList.add(validationAspectInfo);
                if (!validationLogEntry.getCode().equals("EBA.2.16") || validationItemRefList.size() <= 1) break;
                for (int i = 1; i < validationItemRefList.size(); ++i) {
                    String hrefLink2;
                    String href2;
                    ValidationItemRefContext contextRef;
                    ValidationAspectInfo validationAspectInfoAdditional = new ValidationAspectInfo();
                    ValidationItemRef validationItemRef2 = (ValidationItemRef)validationItemRefList.get(i);
                    validationAspectInfoAdditional.setContentType(XmlContentType.VALUE);
                    Map propertyMap = validationItemRef2.getPropertyMap();
                    if (propertyMap != null) {
                        validationAspectInfoAdditional.setId((String)propertyMap.get("QName"));
                    }
                    if ((contextRef = validationItemRef2.getContextRef()) != null) {
                        validationAspectInfoAdditional.setContextRef(contextRef.getName());
                    }
                    if (StringUtils.isNotBlank((CharSequence)(href2 = validationItemRef2.getHref())) && StringUtils.isNotBlank((CharSequence)(hrefLink2 = StringUtils.substringAfterLast((String)href2, (String)"#")))) {
                        if (hrefLink2.startsWith("element(")) {
                            String elementIndex = StringUtils.substringBetween((String)hrefLink2, (String)"(", (String)")");
                            elementIndex = StringUtils.substringAfter((String)elementIndex, (String)"/1/");
                            try {
                                validationAspectInfoAdditional.setXmlIndex(Integer.valueOf(elementIndex));
                            }
                            catch (NumberFormatException e) {
                                log.warn("\u041f\u0430\u0440\u0441\u0438\u043d\u0433 \u043b\u043e\u0433\u0430 \u043f\u0440\u0435\u0434\u0432\u0430\u0440\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0439 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438. \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0438\u043d\u0434\u0435\u043a\u0441\u0430 \u0432 \u0441\u0441\u044b\u043b\u043a\u0435 \u043d\u0430 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0447\u0438\u0441\u043b\u043e\u043c, \u0441\u0441\u044b\u043b\u043a\u0430: {}", (Object)hrefLink2);
                            }
                        } else {
                            validationAspectInfoAdditional.setId(hrefLink2);
                            validationAspectInfoAdditional.setXmlIndex(Integer.valueOf(-1));
                        }
                    }
                    if (StringUtils.equals((CharSequence)mainId, (CharSequence)validationAspectInfoAdditional.getId())) {
                        validationAspectInfoList.add(validationAspectInfoAdditional);
                        continue;
                    }
                    ArrayList<ValidationAspectInfo> validationAspectInfoListAdditional = (ArrayList<ValidationAspectInfo>)validationLogInfo.getErrorValueMap().get(validationAspectInfoAdditional.getId());
                    if (validationAspectInfoListAdditional == null) {
                        validationAspectInfoListAdditional = new ArrayList<ValidationAspectInfo>();
                        validationLogInfo.getErrorValueMap().put(validationAspectInfoAdditional.getId(), validationAspectInfoListAdditional);
                    }
                    validationAspectInfoListAdditional.add(validationAspectInfoAdditional);
                }
                break;
            }
        }
    }

    public int execute(ArelleCmdOptions cmdOptions) throws CommandExecutionException, CancelledException {
        int attempt = 1;
        while (attempt < 6) {
            CommandLine command = cmdOptions.buildCommand();
            try {
                return this.arelleExecutor.commandExecute(command);
            }
            catch (EngineAuthorizeException e) {
                if (attempt >= 5) {
                    throw e;
                }
                log.warn("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0443 XBRL. \u041f\u043e\u043f\u044b\u0442\u043a\u0430 " + ++attempt);
            }
        }
        return -1;
    }

    private Boolean processContextError(ValidationLogEntry validationLogEntry, XbrlReport xbrlReport, EventLog.EventLogType eventLogType) {
        if (validationLogEntry == null) {
            return false;
        }
        String code = validationLogEntry.getCode();
        if (StringUtils.isBlank((CharSequence)code)) {
            return false;
        }
        switch (code) {
            case "xbrldie:IllegalTypedDimensionContentError": {
                if (eventLogType == EventLog.EventLogType.IMPORT_CSV) {
                    Map messageAttributeMap = validationLogEntry.getMessageAttributeMap();
                    if (CollectionUtils.isEmpty((Map)messageAttributeMap)) {
                        log.warn("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u043e\u0448\u0438\u0431\u043e\u043a \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 CSV. \u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u0432 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430\u0445 message");
                        return false;
                    }
                    String contextID = (String)messageAttributeMap.get("contextID");
                    if (StringUtils.isBlank((CharSequence)contextID)) {
                        log.warn("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u043e\u0448\u0438\u0431\u043e\u043a \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 CSV. \u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0434\u043b\u044f \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430 contextID \u0438\u043b\u0438 \u0430\u0442\u0440\u0438\u0431\u0443\u0442 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442. \r\n" + messageAttributeMap.toString());
                        return false;
                    }
                    List csvLineInfoList = this.csvLineInfoService.findByCsvIdAndType(contextID, CsvCommon.CSV_SOURCE_FILES.CONTEXTS);
                    if (CollectionUtils.isEmpty((Collection)csvLineInfoList)) {
                        log.warn("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u043e\u0448\u0438\u0431\u043e\u043a \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 CSV. \u041f\u043e \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u043c\u0443 \u0432 \u043b\u043e\u0433\u0430\u0445 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438 contextID {} \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442 \u0432 \u0441\u043f\u0438\u0441\u043a\u0435 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u043e\u0432 \u0438\u0437 CSV.", (Object)contextID);
                        return false;
                    }
                    CsvLineInfo csvLineInfo = (CsvLineInfo)csvLineInfoList.iterator().next();
                    if (csvLineInfo == null) {
                        return false;
                    }
                    Integer lineNumber = csvLineInfo.getLineNumber();
                    this.eventLogService.createCsvEventLogMessageInNewTransaction(String.format("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0442\u0435\u0433 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430 \u0434\u043b\u044f \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043c\u043d\u043e\u0433\u043e\u043c\u0435\u0440\u043d\u044b\u0445 \u0430\u043d\u0430\u043b\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u0440\u0430\u0437\u0440\u0435\u0437\u043e\u0432 \u043f\u043e \u0441\u0442\u0440\u043e\u043a\u0435 %s \u0432 \u0444\u0430\u0439\u043b\u0435 Context.csv", lineNumber), CsvCommon.CSV_SOURCE_FILES.CONTEXTS.name(), Integer.toString(lineNumber), xbrlReport);
                    return true;
                }
                return false;
            }
            case "xbrldie:PrimaryItemDimensionallyInvalidError": {
                if (eventLogType == EventLog.EventLogType.IMPORT_CSV) {
                    Map messageAttributeMap = validationLogEntry.getMessageAttributeMap();
                    if (CollectionUtils.isEmpty((Map)messageAttributeMap)) {
                        log.warn("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u043e\u0448\u0438\u0431\u043e\u043a \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 CSV. \u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u0432 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430\u0445 message");
                        return false;
                    }
                    String contextID = (String)messageAttributeMap.get("contextID");
                    String fact = (String)messageAttributeMap.get("fact");
                    if (StringUtils.isBlank((CharSequence)contextID)) {
                        log.warn("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u043e\u0448\u0438\u0431\u043e\u043a \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 CSV. \u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0434\u043b\u044f \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430 contextID \u0438\u043b\u0438 \u0430\u0442\u0440\u0438\u0431\u0443\u0442 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442. \r\n" + messageAttributeMap.toString());
                        return false;
                    }
                    List csvLineInfoList = this.csvLineInfoService.findByCsvIdAndType(contextID, CsvCommon.CSV_SOURCE_FILES.CONTEXTS);
                    if (CollectionUtils.isEmpty((Collection)csvLineInfoList)) {
                        log.warn("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u043e\u0448\u0438\u0431\u043e\u043a \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 CSV. \u041f\u043e \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u043c\u0443 \u0432 \u043b\u043e\u0433\u0430\u0445 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438 contextID {} \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442 \u0432 \u0441\u043f\u0438\u0441\u043a\u0435 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u043e\u0432 \u0438\u0437 CSV.", (Object)contextID);
                        return false;
                    }
                    CsvLineInfo csvLineInfo = (CsvLineInfo)csvLineInfoList.iterator().next();
                    if (csvLineInfo == null) {
                        return false;
                    }
                    Integer lineNumber = csvLineInfo.getLineNumber();
                    this.eventLogService.createCsvEventLogMessageInNewTransaction(String.format("\u0410\u043d\u0430\u043b\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0440\u0430\u0437\u0440\u0435\u0437 \u043f\u043e \u0441\u0442\u0440\u043e\u043a\u0435 %s \u0432 \u0444\u0430\u0439\u043b\u0435 \u00abContext.csv\u00bb \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u0432 \u0442\u0430\u043a\u0441\u043e\u043d\u043e\u043c\u0438\u0438 \u0434\u043b\u044f \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u0433\u043e \u043a\u043e\u043d\u0446\u0435\u043f\u0442\u0430 %s.", lineNumber, fact), CsvCommon.CSV_SOURCE_FILES.CONTEXTS.name(), Integer.toString(lineNumber), xbrlReport);
                    return true;
                }
                return false;
            }
            case "xmlSchema:syntax": {
                String fileName = (String)validationLogEntry.getMessageAttributeMap().get("fileName");
                String lineNumber = (String)validationLogEntry.getMessageAttributeMap().get("line");
                String columnNumber = (String)validationLogEntry.getMessageAttributeMap().get("column");
                String errorMessage = (String)validationLogEntry.getMessageAttributeMap().get("error");
                validationLogEntry.setMessage(String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0438\u043d\u0442\u0430\u043a\u0441\u0438\u0441\u0430 \u0432 \u0444\u0430\u0439\u043b\u0435 \"%s\". \u0421\u0442\u0440\u043e\u043a\u0430: %s, \u043f\u043e\u0437\u0438\u0446\u0438\u044f: %s. \u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435: %s", fileName, lineNumber, columnNumber, errorMessage));
                return false;
            }
        }
        return false;
    }

    public Map<String, String> saveOutputFiles(String xbrlFile, String[] packages, String[] fileOutputOptions) throws CommandExecutionException, CancelledException {
        Date startProcessing = new Date();
        log.info("Getting output files using arelle started...");
        ArelleCmdOptions cmdOptions = new ArelleCmdOptions();
        cmdOptions.setArelleExecutable(this.configProperties.getArelleExecutable());
        cmdOptions.setFilePath(xbrlFile);
        cmdOptions.setVFlag(Boolean.FALSE.booleanValue());
        cmdOptions.setValidation(Boolean.FALSE.booleanValue());
        cmdOptions.setFormulaNone(Boolean.valueOf(true));
        cmdOptions.setPackages(packages);
        cmdOptions.setSaveFileOutput(Boolean.TRUE.booleanValue());
        cmdOptions.setEnabledFileOutputOptions(fileOutputOptions);
        String activeLabelRole = this.labelLinkbaseService.getActiveLabelRole();
        if (StringUtils.isNotBlank((CharSequence)activeLabelRole)) {
            cmdOptions.setLabelRole(activeLabelRole);
        }
        this.setDateParameters(cmdOptions);
        this.execute(cmdOptions);
        log.info("Getting output files using arelle started completed in " + (new Date().getTime() - startProcessing.getTime()) + " msec");
        return cmdOptions.getOutputFiles();
    }

    public List<ValidationEvent> validate(XbrlReport xbrlReport, String[] packages, List<String> formulaRunIDs) throws CommandExecutionException, CancelledException {
        return this.validate(xbrlReport, xbrlReport.getFilePath(), packages, null);
    }

    public List<ValidationEvent> validate(XbrlReport xbrlReport, String xbrlFilePath, String[] packages, String formulaRunIDsFile) throws CommandExecutionException, CancelledException {
        String logFile = "logFile";
        ArelleCmdOptions cmdOptions = new ArelleCmdOptions();
        cmdOptions.setArelleExecutable(this.configProperties.getArelleExecutable());
        cmdOptions.setLogOverSocket(this.configProperties.getProcessLogOverSocket());
        cmdOptions.setSocketLogPort(this.configProperties.getLogSocketPort().intValue());
        cmdOptions.setFilePath(xbrlFilePath);
        cmdOptions.setValidation(Boolean.TRUE.booleanValue());
        cmdOptions.setSaveFileOutput(Boolean.TRUE.booleanValue());
        String[] options = new String[]{logFile};
        cmdOptions.setEnabledFileOutputOptions(options);
        cmdOptions.setPackages(packages);
        cmdOptions.setFormulaRunIDsFile(formulaRunIDsFile);
        this.setDateParameters(cmdOptions);
        log.info("Validation started...");
        Date validationStartDate = new Date();
        if (ArelleOutputParser.getIsLastActionCancelled()) {
            return null;
        }
        this.execute(cmdOptions);
        log.info("Validation completed in " + (new Date().getTime() - validationStartDate.getTime()) + " msec");
        String logFilePath = (String)cmdOptions.getOutputFiles().get(logFile);
        Date validationParsingStartDate = new Date();
        ArrayList<ValidationEvent> validationEventList = new ArrayList();
        if (!this.configProperties.getProcessLogOverSocket().booleanValue()) {
            validationEventList = ArelleOutputParser.parseXmlValidation((String)logFilePath, (XbrlReport)xbrlReport);
        }
        log.info("Validation parsing completed in " + (new Date().getTime() - validationParsingStartDate.getTime()) + " msec");
        return validationEventList;
    }

    public void killCurrentArelleProcess() {
        this.arelleExecutor.killCurrentArelleProcess();
    }

    private void setDateParameters(ArelleCmdOptions cmdOptions) {
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        if (xbrlPackage != null && !xbrlPackage.getXbrlParameters().isEmpty()) {
            HashMap periodsParam = new HashMap();
            List parameters = xbrlPackage.getXbrlParameters();
            parameters.forEach(xbrlParameter -> {
                String[] splitted = xbrlParameter.getQName().split(":");
                String par = splitted[1];
                String key = "{http://parameters}" + par;
                periodsParam.put(key, PeriodDates.formatDate((Date)xbrlParameter.getValue()));
            });
            cmdOptions.setParameters(periodsParam);
            return;
        }
        XbrlPeriod defaultPeriod = this.xbrlPeriodService.getDefaultPeriod();
        if (defaultPeriod == null) {
            log.warn("Not found default period!!");
            return;
        }
        HashMap<String, String> periodsParam = new HashMap<String, String>();
        periodsParam.put("{http://parameters}refPeriodEnd", PeriodDates.formatDate((Date)defaultPeriod.getEnd()));
        cmdOptions.setParameters(periodsParam);
    }

    public void setLastActionCancelled(boolean lastActionCancelled) {
        this.isLastActionCancelled = lastActionCancelled;
    }
}

