/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.arelle;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.arelle.ArelleOutputParser;
import ru.cbr.xbrl.converter.arelle.data.output.ArgUnsatisfied;
import ru.cbr.xbrl.converter.arelle.data.output.Ref;
import ru.cbr.xbrl.converter.model.PresentationConcept;
import ru.cbr.xbrl.converter.model.XbrlFormula;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.validation.Dimension;
import ru.cbr.xbrl.converter.model.validation.ValidationEvent;
import ru.cbr.xbrl.converter.model.validation.ValidationItemRef;
import ru.cbr.xbrl.converter.model.validation.ValidationItemRefContext;
import ru.cbr.xbrl.converter.model.validation.ValidationLogEntry;
import ru.cbr.xbrl.converter.model.validation.ValidationRefMessageId;
import ru.cbr.xbrl.converter.utils.TextUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ArelleOutputParser {
    private static final Logger log = LoggerFactory.getLogger(ArelleOutputParser.class);
    public static final String[] AVAILABLE_OPTIONS = new String[]{"messageCode", "message", "file", "refs", "levelname", "args"};
    public static final String COLUMN_DIVIDER = " DIVIDER ";
    public static final String ROW_DIVIDER = " ENDOFROW";
    private static final String ENTRY = "entry";
    private static final String CODE = "code";
    private static final String FORMULA_ASSERTION_UNSATISFIED = "formula:assertionUnsatisfied";
    private static final String CALCULATION_INCONSISTENCY = "calcInconsistency";
    private static final String MESSAGE = "message";
    private static final String REF = "ref";
    private static final String PROPERTY = "property";
    private static final String LEVEL = "level";
    private static final String LABEL = "label";
    private static final String FACT_VAR_BINDINGS = "factVarBindings";
    private static final String FALL_BACK = "fallback [0]";
    private static final String HREF = "href";
    private static final String SOURCE_LINE = "sourceLine";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String Q_NAME = "QName";
    private static final String CONTEXT_REF = "contextRef";
    private static final String ENTITY = "entity";
    private static final String SCHEME = "scheme";
    private static final String DIMENSIONS = "dimensions";
    private static final String INSTANT = "instant";
    private static final String START_DATE = "startDate";
    private static final String END_DATE = "endDate";
    private static final String LINK_ROLE = "linkrole";
    private static final String REPORTED_SUM = "reportedSum";
    private static final String COMPUTED_SUM = "computedSum";
    private static final String WEIGHT = "weight";
    private static final String NUMBER = "number";
    private static final String ID = "id";
    private static final String TYPE = "type";
    private static final String WARNING = "WARNING";
    private static final String VARIABLE = "variable";
    private static final String TEST = "test";
    private static final String TEST_RIGHT = "test-right";
    private static final String UNIT_REF = "unitRef";
    private static ObjectMapper mapper = new ObjectMapper();
    private static Boolean isLastActionCancelled = false;

    public ArelleOutputParser() {
        JsonFactory factory = new JsonFactory();
        factory.enable(JsonParser.Feature.ALLOW_SINGLE_QUOTES);
        mapper = new ObjectMapper(factory);
    }

    public static ValidationEvent parse(String text) {
        String message_errors;
        text = TextUtils.removeBoundaryQuotes((String)text);
        String[] cols = (text = text.replaceAll(" ENDOFROW", "")).split(" DIVIDER ");
        if (cols.length < AVAILABLE_OPTIONS.length) {
            if (!StringUtils.contains((CharSequence)text, (CharSequence)" DIVIDER ")) {
                ValidationEvent validationEvent = new ValidationEvent();
                validationEvent.setMessage(text);
                return validationEvent;
            }
            return null;
        }
        HashMap<String, String> colsMap = new HashMap<String, String>();
        for (int i = 0; i < AVAILABLE_OPTIONS.length; ++i) {
            colsMap.put(AVAILABLE_OPTIONS[i], cols[i].trim());
        }
        ValidationEvent validationEvent = new ValidationEvent();
        String messageCode = (String)colsMap.get("messageCode");
        messageCode = TextUtils.removeBoundaryQuotes((String)messageCode);
        validationEvent.setMessageCode(messageCode);
        validationEvent.setMessage((String)colsMap.get("message"));
        validationEvent.setFileName((String)colsMap.get("file"));
        validationEvent.setRefsString((String)colsMap.get("refs"));
        validationEvent.setLevel((String)colsMap.get("levelname"));
        validationEvent.setArgsString((String)colsMap.get("args"));
        Ref[] refs = ArelleOutputParser.parseRefs((String)((String)colsMap.get("refs")));
        validationEvent.setRefs(refs);
        Map args = ArelleOutputParser.parseArgs((String)((String)colsMap.get("args")));
        if (args != null && args.containsKey("message_errors") && (message_errors = (String)args.get("message_errors")) != null) {
            args.put("message_errors", message_errors.replaceAll("\u00ac", "\""));
            validationEvent.setMessage((String)args.get("message_errors"));
        }
        validationEvent.setArgs(args);
        if (refs != null && refs.length > 0) {
            Ref firstRef = refs[0];
            validationEvent.setRowNum(firstRef.getSourceLine());
            validationEvent.setFileName(firstRef.getHref());
        }
        return validationEvent;
    }

    private static Ref[] parseRefs(String refsJsonString) {
        if ((refsJsonString = ArelleOutputParser.repairJson((String)refsJsonString)) == null) {
            return null;
        }
        try {
            Ref[] refs = (Ref[])mapper.reader().forType(Ref[].class).readValue(refsJsonString);
            return refs;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static Map<String, String> parseArgs(String argsJsonString) {
        if ((argsJsonString = ArelleOutputParser.repairJson((String)argsJsonString)) == null) {
            return null;
        }
        try {
            Map arg = (Map)mapper.readValue(argsJsonString, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return arg;
        }
        catch (IOException e) {
            log.error("Arg parse error: " + argsJsonString);
            log.error(e.toString());
            return null;
        }
    }

    private static String repairJson(String json) {
        if (json == null || json.equals("()")) {
            return null;
        }
        String[] quotedStrings = StringUtils.substringsBetween((String)json, (String)"\"", (String)"\"");
        if (quotedStrings != null) {
            String[] repairedStrings = (String[])Arrays.stream(quotedStrings).map(s -> s.replaceAll("'", "```").replaceAll("\"", "```")).toArray(String[]::new);
            for (int i = 0; i < quotedStrings.length; ++i) {
                json = json.replace(quotedStrings[i], repairedStrings[i]);
            }
        }
        if (json.equals("()")) {
            return null;
        }
        json = json.replaceAll("'", "\"");
        json = json.replaceAll("```", "'");
        return json;
    }

    public static List<ValidationEvent> parseXmlValidation(String filePath, XbrlReport xbrlReport) {
        return ArelleOutputParser.parseXmlFileValidation((String)filePath, (XbrlReport)xbrlReport, (Boolean)true, null);
    }

    public static List<ValidationEvent> parseXmlFileValidation(String filePath, XbrlReport xbrlReport, Boolean isValidation, Consumer<ValidationLogEntry> validationLogEntryConsumer) {
        Map xbrlFormulaMap = ArelleOutputParser.getXbrlFormulaMap((XbrlReport)xbrlReport);
        Map xbrlConceptMap = ArelleOutputParser.getConceptMap((XbrlReport)xbrlReport);
        XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
        xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        return ArelleOutputParser.processXmlFile((XMLInputFactory)xmlInputFactory, (String)filePath, (Boolean)isValidation, validationLogEntryConsumer, (Map)xbrlFormulaMap, (Map)xbrlConceptMap);
    }

    public static List<ValidationEvent> parseXmlStringValidation(String xmlStr, XbrlReport xbrlReport) {
        Map xbrlFormulaMap = ArelleOutputParser.getXbrlFormulaMap((XbrlReport)xbrlReport);
        Map xbrlConceptMap = ArelleOutputParser.getConceptMap((XbrlReport)xbrlReport);
        XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
        xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        return ArelleOutputParser.processXmlString((String)xmlStr, (XMLInputFactory)xmlInputFactory, (Map)xbrlFormulaMap, (Map)xbrlConceptMap);
    }

    private static List<ValidationEvent> processXmlString(String str, XMLInputFactory xmlInputFactory, Map<String, XbrlFormula> xbrlFormulaMap, Map<String, String> xbrlConceptMap) {
        try {
            XMLStreamReader reader = xmlInputFactory.createXMLStreamReader(IOUtils.toInputStream((String)str));
            return ArelleOutputParser.processXmlLines((XMLStreamReader)reader, (Boolean)true, null, xbrlFormulaMap, xbrlConceptMap);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<ValidationEvent> processXmlFile(XMLInputFactory xmlInputFactory, String filePath, Boolean isValidation, Consumer<ValidationLogEntry> validationLogEntryConsumer, Map<String, XbrlFormula> xbrlFormulaMap, Map<String, String> xbrlConceptMap) {
        try (FileInputStream fileInputStream = new FileInputStream(filePath);){
            XMLStreamReader reader = xmlInputFactory.createXMLStreamReader(new BufferedInputStream(fileInputStream));
            List list = ArelleOutputParser.processXmlLines((XMLStreamReader)reader, (Boolean)isValidation, validationLogEntryConsumer, xbrlFormulaMap, xbrlConceptMap);
            return list;
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Collections.emptyList();
    }

    private static List<ValidationEvent> processXmlLines(XMLStreamReader reader, Boolean isValidation, Consumer<ValidationLogEntry> validationLogEntryConsumer, Map<String, XbrlFormula> xbrlFormulaMap, Map<String, String> xbrlConceptMap) throws XMLStreamException {
        if (reader == null) {
            return null;
        }
        ArrayList<ValidationLogEntry> validationLogEntryList = new ArrayList<ValidationLogEntry>();
        ValidationLogEntry validationLogEntry = new ValidationLogEntry();
        LinkedHashMap<ValidationRefMessageId, String> messageCacheMap = new LinkedHashMap<ValidationRefMessageId, String>();
        LinkedList<ValidationRefMessageId> validationRefMessageIdList = new LinkedList<ValidationRefMessageId>();
        LinkedHashMap<ValidationRefMessageId, ValidationLogEntry> assertionCacheMap = new LinkedHashMap<ValidationRefMessageId, ValidationLogEntry>();
        LinkedList<ValidationRefMessageId> validationRefAssertionIdList = new LinkedList<ValidationRefMessageId>();
        ValidationItemRef currentValidationItemRef = new ValidationItemRef();
        Boolean isEntryForParsing = false;
        Integer contextRefLevel = 0;
        int cacheSize = 10;
        ValidationItemRefContext currentContextRef = new ValidationItemRefContext();
        block26: while (reader.hasNext()) {
            int eventType = reader.next();
            if (isLastActionCancelled.booleanValue()) {
                return Collections.emptyList();
            }
            switch (eventType) {
                case 7: {
                    break;
                }
                case 1: {
                    String currentStartElement = reader.getName().toString();
                    if (StringUtils.equalsIgnoreCase((CharSequence)"entry", (CharSequence)currentStartElement)) {
                        String level = "";
                        int n = reader.getAttributeCount();
                        for (int i = 0; i < n; ++i) {
                            QName attributeName = reader.getAttributeName(i);
                            String attributeValue = reader.getAttributeValue(i);
                            if (isValidation.booleanValue()) {
                                if (StringUtils.equalsIgnoreCase((CharSequence)"code", (CharSequence)attributeName.toString())) {
                                    if (StringUtils.equalsIgnoreCase((CharSequence)attributeValue, (CharSequence)"formula:assertionUnsatisfied")) {
                                        validationLogEntry.setCode("formula:assertionUnsatisfied");
                                        isEntryForParsing = true;
                                    } else {
                                        if (StringUtils.containsIgnoreCase((CharSequence)attributeValue, (CharSequence)"calcInconsistency")) {
                                            ArelleOutputParser.parseCalculationInconsistency((XMLStreamReader)reader, validationLogEntryList);
                                            break;
                                        }
                                        if (StringUtils.containsIgnoreCase((CharSequence)attributeValue, (CharSequence)"message")) {
                                            Map entryMessage = ArelleOutputParser.parseAssertionMessage((XMLStreamReader)reader, validationLogEntryList);
                                            if (entryMessage == null) break;
                                            ValidationRefMessageId processedMessageId = (ValidationRefMessageId)entryMessage.keySet().iterator().next();
                                            String message = (String)entryMessage.get(processedMessageId);
                                            ValidationLogEntry cachedValidationLogEntry = (ValidationLogEntry)assertionCacheMap.get(processedMessageId);
                                            if (cachedValidationLogEntry != null && StringUtils.isBlank((CharSequence)cachedValidationLogEntry.getMessage()) && !StringUtils.isBlank((CharSequence)message)) {
                                                cachedValidationLogEntry.setMessage(message);
                                            }
                                            if (validationRefMessageIdList.size() > cacheSize) {
                                                messageCacheMap.remove(validationRefMessageIdList.get(cacheSize));
                                                validationRefMessageIdList.remove(cacheSize);
                                            }
                                            messageCacheMap.put(processedMessageId, message);
                                            validationRefMessageIdList.add(0, processedMessageId);
                                            break;
                                        }
                                        isEntryForParsing = false;
                                        continue;
                                    }
                                }
                                if (!StringUtils.equalsIgnoreCase((CharSequence)"level", (CharSequence)attributeName.toString())) continue;
                                level = attributeValue;
                                continue;
                            }
                            isEntryForParsing = true;
                            if (StringUtils.equalsIgnoreCase((CharSequence)"code", (CharSequence)attributeName.toString())) {
                                validationLogEntry.setCode(attributeValue);
                            }
                            if (!StringUtils.equalsIgnoreCase((CharSequence)"level", (CharSequence)attributeName.toString())) continue;
                            validationLogEntry.setLevel(attributeValue);
                        }
                        if (!isValidation.booleanValue() || !isEntryForParsing.booleanValue()) break;
                        validationLogEntry.setLevel(level);
                        break;
                    }
                    if (!isEntryForParsing.booleanValue()) break;
                    if (StringUtils.equalsIgnoreCase((CharSequence)"message", (CharSequence)currentStartElement)) {
                        int n = reader.getAttributeCount();
                        for (int i = 0; i < n; ++i) {
                            QName attributeName = reader.getAttributeName(i);
                            if (!StringUtils.isNotBlank((CharSequence)attributeName.toString())) continue;
                            validationLogEntry.getMessageAttributeMap().put(attributeName.toString(), reader.getAttributeValue(i));
                        }
                        String message = reader.getElementText();
                        ValidationEvent parsedMessage = ArelleOutputParser.parse((String)message);
                        if (parsedMessage == null) {
                            validationLogEntry.setArgUnsatisfied(null);
                            break;
                        }
                        validationLogEntry.getMessageAttributeMap().put("args_message_error", parsedMessage.getMessage());
                        validationLogEntry.setArgUnsatisfied(ArelleOutputParser.getArgUnsatisfied((Map)parsedMessage.getArgs()));
                        if (isValidation.booleanValue() || !StringUtils.isNotBlank((CharSequence)message)) break;
                        String preparedMessage = message;
                        String[] rows = message.split(" ENDOFROW");
                        if (rows.length <= 0) continue block26;
                        String[] cols = rows[0].split(" DIVIDER ");
                        String newMessage = cols.length >= 4 ? cols[0] + " " + cols[1] + " " + cols[2] : cols[0];
                        validationLogEntry.setMessage(newMessage);
                        break;
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)"ref", (CharSequence)currentStartElement)) {
                        int n = reader.getAttributeCount();
                        for (int i = 0; i < n; ++i) {
                            QName attributeName = reader.getAttributeName(i);
                            if (StringUtils.equalsIgnoreCase((CharSequence)"href", (CharSequence)attributeName.toString())) {
                                currentValidationItemRef.setHref(reader.getAttributeValue(i));
                            }
                            if (!StringUtils.equalsIgnoreCase((CharSequence)"sourceLine", (CharSequence)attributeName.toString())) continue;
                            try {
                                currentValidationItemRef.setSourceLine(Long.valueOf(Long.parseLong(reader.getAttributeValue(i))));
                                continue;
                            }
                            catch (NumberFormatException e) {
                                log.trace("\u041e\u0448\u0438\u0431\u043a\u0430. \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0441\u043f\u043e\u0437\u043d\u0430\u0442\u044c \u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438. \u041f\u0430\u0440\u0441\u0438\u043d\u0433 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438. \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 {}", (Object)reader.getAttributeValue(i));
                            }
                        }
                        continue block26;
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)"property", (CharSequence)currentStartElement)) {
                        if (contextRefLevel > 0) {
                            Integer i = contextRefLevel;
                            Integer n = contextRefLevel = Integer.valueOf(contextRefLevel + 1);
                        }
                        String name = null;
                        String value = null;
                        int n = reader.getAttributeCount();
                        for (int i = 0; i < n; ++i) {
                            QName attributeName = reader.getAttributeName(i);
                            if (StringUtils.equalsIgnoreCase((CharSequence)"name", (CharSequence)attributeName.toString())) {
                                name = reader.getAttributeValue(i);
                            }
                            if (!StringUtils.equalsIgnoreCase((CharSequence)"value", (CharSequence)attributeName.toString())) continue;
                            value = reader.getAttributeValue(i);
                        }
                        switch (name) {
                            case "contextRef": {
                                Integer n2 = contextRefLevel;
                                Integer n3 = contextRefLevel = Integer.valueOf(contextRefLevel + 1);
                                currentContextRef.setName(value);
                                break;
                            }
                            case "entity": {
                                currentContextRef.setEntity(value);
                                break;
                            }
                            case "scheme": {
                                currentContextRef.setScheme(value);
                                break;
                            }
                            case "instant": {
                                currentContextRef.setInstant(value);
                                break;
                            }
                            case "startDate": {
                                currentContextRef.setStartDate(value);
                                break;
                            }
                            case "endDate": {
                                currentContextRef.setEndDate(value);
                                break;
                            }
                            case "dimensions": {
                                currentContextRef.setDimensions(ArelleOutputParser.processDimensionsContextProperty((XMLStreamReader)reader));
                                currentContextRef.setDimensionsLabel(value);
                                Integer n2 = contextRefLevel;
                                Integer n3 = contextRefLevel = Integer.valueOf(contextRefLevel - 1);
                                break;
                            }
                        }
                        if (!StringUtils.isNotBlank((CharSequence)name) || contextRefLevel != 0) break;
                        currentValidationItemRef.getPropertyMap().put(name, value);
                        break;
                    }
                }
                case 2: {
                    if (!isEntryForParsing.booleanValue()) break;
                    String currentEndElement = reader.getName().toString();
                    if (StringUtils.equalsIgnoreCase((CharSequence)"entry", (CharSequence)currentEndElement)) {
                        if (!isValidation.booleanValue() && validationLogEntryConsumer != null) {
                            validationLogEntryConsumer.accept(validationLogEntry);
                        }
                        validationLogEntryList.add(validationLogEntry);
                        validationLogEntry = new ValidationLogEntry();
                        break;
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)"message", (CharSequence)currentEndElement)) break;
                    if (StringUtils.equalsIgnoreCase((CharSequence)"ref", (CharSequence)currentEndElement)) {
                        Map propertyMap = currentValidationItemRef.getPropertyMap();
                        if (isValidation.booleanValue() && propertyMap.containsKey("test")) {
                            String id = (String)propertyMap.get("id");
                            String label = (String)propertyMap.get("label");
                            validationLogEntry.setMessage((String)messageCacheMap.get(new ValidationRefMessageId(id, label)));
                            if (StringUtils.isBlank((CharSequence)validationLogEntry.getMessage())) {
                                if (validationRefAssertionIdList.size() > cacheSize) {
                                    assertionCacheMap.remove(validationRefAssertionIdList.get(cacheSize));
                                    validationRefAssertionIdList.remove(cacheSize);
                                }
                                ValidationRefMessageId processedMessageId = new ValidationRefMessageId(id, label);
                                assertionCacheMap.put(processedMessageId, validationLogEntry);
                                validationRefAssertionIdList.add(0, processedMessageId);
                            }
                        }
                        validationLogEntry.getValidationItemRefList().add(currentValidationItemRef);
                        currentValidationItemRef = new ValidationItemRef();
                        break;
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)"property", (CharSequence)currentEndElement) || contextRefLevel <= 0) break;
                    Integer n = contextRefLevel;
                    Integer n4 = contextRefLevel = Integer.valueOf(contextRefLevel - 1);
                    if (contextRefLevel != 0) break;
                    currentValidationItemRef.setContextRef(currentContextRef);
                    currentContextRef = new ValidationItemRefContext();
                    break;
                }
                case 8: {
                    break;
                }
            }
        }
        return ArelleOutputParser.buildValidationEventList(xbrlFormulaMap, xbrlConceptMap, validationLogEntryList);
    }

    private static Map<String, String> getConceptMap(XbrlReport xbrlReport) {
        HashMap<String, String> xbrlConceptMap = new HashMap<String, String>();
        List xbrlReportConceptList = xbrlReport.getXbrlReportConceptList();
        if (!CollectionUtils.isEmpty((Collection)xbrlReportConceptList)) {
            for (PresentationConcept presentationConcept : xbrlReportConceptList) {
                String name;
                if (presentationConcept == null || StringUtils.isBlank((CharSequence)(name = presentationConcept.getName()))) continue;
                xbrlConceptMap.put(name, presentationConcept.getLabel());
            }
        }
        return xbrlConceptMap;
    }

    private static Map<String, XbrlFormula> getXbrlFormulaMap(XbrlReport xbrlReport) {
        HashMap<String, XbrlFormula> xbrlFormulaMap = new HashMap<String, XbrlFormula>();
        List xbrlFormulaList = xbrlReport.getXbrlReportFormulaList();
        if (!CollectionUtils.isEmpty((Collection)xbrlFormulaList)) {
            for (XbrlFormula xbrlFormula : xbrlFormulaList) {
                if (xbrlFormula == null) continue;
                xbrlFormulaMap.put(xbrlFormula.getName(), xbrlFormula);
            }
        }
        return xbrlFormulaMap;
    }

    private static Map<ValidationRefMessageId, String> parseAssertionMessage(XMLStreamReader reader, List<ValidationLogEntry> validationLogEntryList) throws XMLStreamException {
        if (reader == null || validationLogEntryList == null) {
            return null;
        }
        ValidationRefMessageId currentValidationRefMessageId = new ValidationRefMessageId();
        String message = null;
        block4: while (reader.hasNext()) {
            int eventType = reader.next();
            switch (eventType) {
                case 1: {
                    String currentStartElement = reader.getName().getLocalPart();
                    if (StringUtils.equalsIgnoreCase((CharSequence)"message", (CharSequence)currentStartElement)) {
                        message = reader.getElementText();
                        ValidationEvent parsedMessage = ArelleOutputParser.parse((String)message);
                        if (parsedMessage == null) {
                            return null;
                        }
                        message = parsedMessage.getMessage();
                        break;
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)"property", (CharSequence)currentStartElement)) break;
                    String name = null;
                    String value = null;
                    int n = reader.getAttributeCount();
                    for (int i = 0; i < n; ++i) {
                        QName attributeName = reader.getAttributeName(i);
                        if (StringUtils.equalsIgnoreCase((CharSequence)"name", (CharSequence)attributeName.toString())) {
                            name = reader.getAttributeValue(i);
                        }
                        if (!StringUtils.equalsIgnoreCase((CharSequence)"value", (CharSequence)attributeName.toString())) continue;
                        value = reader.getAttributeValue(i);
                    }
                    if (StringUtils.equals(name, (CharSequence)"id")) {
                        currentValidationRefMessageId.setId(value);
                    }
                    if (!StringUtils.equals(name, (CharSequence)"label")) continue block4;
                    currentValidationRefMessageId.setLabel(value);
                    break;
                }
                case 2: {
                    String currentEndElement = reader.getName().toString();
                    if (!StringUtils.equalsIgnoreCase((CharSequence)"entry", (CharSequence)currentEndElement)) break;
                    if (!(StringUtils.isBlank((CharSequence)currentValidationRefMessageId.getId()) || StringUtils.isBlank((CharSequence)currentValidationRefMessageId.getLabel()) || StringUtils.isBlank((CharSequence)message))) {
                        HashMap<ValidationRefMessageId, String> assertionMessage = new HashMap<ValidationRefMessageId, String>();
                        assertionMessage.put(currentValidationRefMessageId, message);
                        return assertionMessage;
                    }
                    return null;
                }
            }
        }
        return null;
    }

    private static void parseCalculationInconsistency(XMLStreamReader reader, List<ValidationLogEntry> validationLogEntryList) throws XMLStreamException {
        if (reader == null || validationLogEntryList == null) {
            return;
        }
        CalcVal calcVal = new CalcVal();
        block4: while (reader.hasNext()) {
            if (isLastActionCancelled.booleanValue()) {
                return;
            }
            int eventType = reader.next();
            switch (eventType) {
                case 1: {
                    ValidationItemRef validationItemRef;
                    String currentStartElement = reader.getName().getLocalPart();
                    if (StringUtils.equalsIgnoreCase((CharSequence)"message", (CharSequence)currentStartElement)) {
                        int n = reader.getAttributeCount();
                        for (int i = 0; i < n; ++i) {
                            QName attributeName = reader.getAttributeName(i);
                            if (StringUtils.equalsIgnoreCase((CharSequence)"linkrole", (CharSequence)attributeName.toString())) {
                                calcVal.setLinkrole(reader.getAttributeValue(i));
                            }
                            if (StringUtils.equalsIgnoreCase((CharSequence)"reportedSum", (CharSequence)attributeName.toString())) {
                                calcVal.setReported(reader.getAttributeValue(i));
                            }
                            if (!StringUtils.equalsIgnoreCase((CharSequence)"computedSum", (CharSequence)attributeName.toString())) continue;
                            calcVal.setComputed(reader.getAttributeValue(i));
                        }
                        continue block4;
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)"ref", (CharSequence)currentStartElement) || (validationItemRef = ArelleOutputParser.parseCalculationRef((XMLStreamReader)reader, (CalcVal)calcVal)) == null || StringUtils.isBlank((CharSequence)((CharSequence)validationItemRef.getPropertyMap().get("QName")))) break;
                    String weight = (String)validationItemRef.getPropertyMap().get("weight");
                    if (StringUtils.isBlank((CharSequence)weight)) {
                        validationItemRef.getPropertyMap().put("test", "$1 =");
                        validationItemRef.getPropertyMap().put("variable", "$1");
                        calcVal.setValidationItemRef(validationItemRef);
                        break;
                    }
                    ValidationItemRef existValidationItemRef = calcVal.getValidationItemRef();
                    if (existValidationItemRef == null) {
                        log.error("\u041f\u0440\u0430\u0432\u0430\u044f \u0447\u0430\u0441\u0442\u044c \u0434\u043e \u043b\u0435\u0432\u043e\u0439!!!");
                        break;
                    }
                    String testRight = (String)existValidationItemRef.getPropertyMap().get("test-right");
                    calcVal.getValidationItemRefList().add(validationItemRef);
                    int currentNumber = calcVal.getValidationItemRefList().size() + 1;
                    validationItemRef.getPropertyMap().put("number", String.valueOf(currentNumber));
                    validationItemRef.getPropertyMap().put("variable", "$" + currentNumber);
                    testRight = StringUtils.isBlank((CharSequence)testRight) ? TextUtils.buildCalculationWeightValue((String)weight, (Boolean)true) + "$" + currentNumber : testRight + TextUtils.buildCalculationWeightValue((String)weight, (Boolean)false) + "$" + currentNumber;
                    existValidationItemRef.getPropertyMap().put("test-right", testRight);
                    break;
                }
                case 2: {
                    String endElement = reader.getName().getLocalPart();
                    if (!StringUtils.equalsIgnoreCase((CharSequence)"entry", (CharSequence)endElement)) break;
                    ArelleOutputParser.addCalculationToValidationLogEntry((CalcVal)calcVal, validationLogEntryList);
                    return;
                }
            }
        }
    }

    private static void addCalculationToValidationLogEntry(CalcVal calcVal, List<ValidationLogEntry> validationLogEntryList) {
        ValidationLogEntry validationLogEntry = new ValidationLogEntry();
        ValidationItemRef validationItemRef = new ValidationItemRef();
        ValidationItemRef validationItemRefMain = calcVal.getValidationItemRef();
        Map propertyMap = validationItemRefMain.getPropertyMap();
        String test = (String)propertyMap.get("test") + (String)propertyMap.get("test-right");
        validationItemRef.setContextRef(validationItemRefMain.getContextRef());
        validationItemRef.getPropertyMap().put("test", test);
        validationItemRef.getPropertyMap().put("number", "0");
        validationItemRef.getPropertyMap().put("id", "0");
        validationItemRef.getPropertyMap().put("QName", propertyMap.get("QName"));
        validationItemRef.getPropertyMap().put("contextRef", propertyMap.get("contextRef"));
        validationItemRef.getPropertyMap().put("type", "calcInconsistency");
        validationItemRef.getPropertyMap().put("variable", propertyMap.get("variable"));
        validationItemRef.getPropertyMap().put("label", propertyMap.get("label"));
        validationItemRef.getPropertyMap().put("unitRef", propertyMap.get("unitRef"));
        validationItemRef.getPropertyMap().put("computedSum", calcVal.getComputed());
        validationItemRef.getPropertyMap().put("reportedSum", calcVal.getReported());
        validationLogEntry.getValidationItemRefList().add(validationItemRef);
        validationLogEntry.setCode("calcInconsistency");
        for (ValidationItemRef itemRef : calcVal.getValidationItemRefList()) {
            Map propertyMapPart = itemRef.getPropertyMap();
            ValidationItemRef validationItemRefPart = new ValidationItemRef();
            validationItemRefPart.setContextRef(itemRef.getContextRef());
            validationItemRefPart.getPropertyMap().put("number", propertyMapPart.get("number"));
            validationItemRefPart.getPropertyMap().put("QName", propertyMapPart.get("QName"));
            validationItemRefPart.getPropertyMap().put("contextRef", propertyMapPart.get("contextRef"));
            validationItemRefPart.getPropertyMap().put("type", "calcInconsistency");
            validationItemRefPart.getPropertyMap().put("variable", propertyMapPart.get("variable"));
            validationLogEntry.getValidationItemRefList().add(validationItemRefPart);
        }
        validationLogEntryList.add(validationLogEntry);
    }

    private static ValidationItemRef parseCalculationRef(XMLStreamReader reader, CalcVal calcVal) throws XMLStreamException {
        ValidationItemRef validationItemRef = new ValidationItemRef();
        if (reader == null || calcVal == null) {
            return validationItemRef;
        }
        Boolean isHrefExist = false;
        int n = reader.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            QName attributeName = reader.getAttributeName(i);
            if (!StringUtils.equalsIgnoreCase((CharSequence)"href", (CharSequence)attributeName.toString())) continue;
            isHrefExist = true;
            break;
        }
        if (!isHrefExist.booleanValue()) {
            return validationItemRef;
        }
        ValidationItemRefContext currentContextRef = new ValidationItemRefContext();
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String currentStartElement = reader.getName().toString();
                    if (!StringUtils.equalsIgnoreCase((CharSequence)"property", (CharSequence)currentStartElement)) break;
                    String name = null;
                    String value = null;
                    int n2 = reader.getAttributeCount();
                    for (int i = 0; i < n2; ++i) {
                        QName attributeName = reader.getAttributeName(i);
                        if (StringUtils.equalsIgnoreCase((CharSequence)"name", (CharSequence)attributeName.toString())) {
                            name = reader.getAttributeValue(i);
                        }
                        if (!StringUtils.equalsIgnoreCase((CharSequence)"value", (CharSequence)attributeName.toString())) continue;
                        value = reader.getAttributeValue(i);
                    }
                    if (StringUtils.isBlank(name)) {
                        return validationItemRef;
                    }
                    switch (name) {
                        case "contextRef": {
                            currentContextRef.setName(value);
                            break block0;
                        }
                        case "entity": {
                            currentContextRef.setEntity(value);
                            break block0;
                        }
                        case "scheme": {
                            currentContextRef.setScheme(value);
                            break block0;
                        }
                        case "instant": {
                            currentContextRef.setInstant(value);
                            break block0;
                        }
                        case "startDate": {
                            currentContextRef.setStartDate(value);
                            break block0;
                        }
                        case "endDate": {
                            currentContextRef.setEndDate(value);
                            break block0;
                        }
                        case "dimensions": {
                            currentContextRef.setDimensions(ArelleOutputParser.processDimensionsContextProperty((XMLStreamReader)reader));
                            break block0;
                        }
                    }
                    validationItemRef.getPropertyMap().put(name, value);
                    break;
                }
                case 2: {
                    String currentEndElement = reader.getName().toString();
                    if (!StringUtils.equalsIgnoreCase((CharSequence)"ref", (CharSequence)currentEndElement)) break;
                    validationItemRef.setContextRef(currentContextRef);
                    return validationItemRef;
                }
            }
        }
        return null;
    }

    private static List<ValidationEvent> buildValidationEventList(Map<String, XbrlFormula> xbrlFormulaMap, Map<String, String> xbrlConceptMap, List<ValidationLogEntry> validationLogEntryList) {
        int logEntryNumber = 1;
        ArrayList<ValidationEvent> validationEventList = new ArrayList<ValidationEvent>();
        for (ValidationLogEntry logEntry : validationLogEntryList) {
            String level = logEntry.getLevel();
            ArgUnsatisfied argUnsatisfied = logEntry.getArgUnsatisfied();
            if (!ArelleOutputParser.isDisplayedValidationEntries((ValidationLogEntry)logEntry)) continue;
            XbrlFormula currentXbrlFormula = null;
            if (argUnsatisfied != null && (currentXbrlFormula = xbrlFormulaMap.get(argUnsatisfied.getLabel())) == null) continue;
            ValidationEvent validationEvent = new ValidationEvent();
            validationEvent.setNumber(Integer.valueOf(logEntryNumber++));
            for (ValidationItemRef validationItemRef : logEntry.getValidationItemRefList()) {
                Map propertyMap = validationItemRef.getPropertyMap();
                String id = (String)propertyMap.get("id");
                if (id == null) continue;
                validationEvent.setId(id);
                validationEvent.setFormula((String)propertyMap.get("test"));
                String href = validationItemRef.getHref();
                if (!StringUtils.isNotBlank((CharSequence)href)) break;
                validationEvent.setHref(href);
                int lastSlashIndex = href.lastIndexOf(47);
                if (lastSlashIndex <= -1) break;
                String roleSystemId = href.substring(0, lastSlashIndex);
                validationEvent.setRoleSystemId(roleSystemId);
                break;
            }
            Boolean isFirstFill = false;
            for (ValidationItemRef validationItemRef : logEntry.getValidationItemRefList()) {
                ValidationEvent currentValidationEvent = new ValidationEvent();
                Map propertyMap = validationItemRef.getPropertyMap();
                if (!propertyMap.containsKey("QName")) continue;
                String qName = (String)propertyMap.get("QName");
                String conceptLabel = xbrlConceptMap.get(qName);
                if (!isFirstFill.booleanValue()) {
                    if (argUnsatisfied != null && StringUtils.contains((CharSequence)argUnsatisfied.getLabel(), (CharSequence)"existenceAssertion")) {
                        validationEvent.setPeriodStart("");
                        validationEvent.setPeriodStop("");
                    } else {
                        validationEvent.setIndex(StringUtils.isBlank((CharSequence)conceptLabel) ? qName : conceptLabel);
                        validationEvent.setSection(ArelleOutputParser.getSectionForConceptRef((ValidationItemRef)validationItemRef));
                        validationEvent.setValidationItemRefContext(validationItemRef.getContextRef());
                        ArelleOutputParser.setPeriodForValidationEvent((ValidationEvent)validationEvent, (ValidationItemRef)validationItemRef);
                        validationEvent.setConceptQName(qName);
                    }
                    if (StringUtils.equals((CharSequence)((CharSequence)propertyMap.get("type")), (CharSequence)"calcInconsistency")) {
                        validationEvent.setVariable((String)propertyMap.get("variable"));
                        validationEvent.setMessage("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044c " + (String)propertyMap.get("label") + " \u0437\u0430 \u043f\u0435\u0440\u0438\u043e\u0434 " + validationEvent.getPeriodStart() + (StringUtils.isBlank((CharSequence)validationEvent.getPeriodStop()) ? " " : " - " + validationEvent.getPeriodStop()) + " \u0441 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u043e\u043c " + validationItemRef.getContextRef().getName() + " \u0440\u0430\u0432\u0435\u043d " + (String)propertyMap.get("reportedSum") + " " + (String)propertyMap.get("unitRef") + ". \u041e\u0436\u0438\u0434\u0430\u0435\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 " + (String)propertyMap.get("computedSum") + " " + (String)propertyMap.get("unitRef"));
                    } else {
                        validationEvent.setVariable(ArelleOutputParser.getVariableByBinding((String)qName, (ValidationLogEntry)logEntry));
                    }
                    isFirstFill = true;
                    continue;
                }
                if (argUnsatisfied != null && StringUtils.contains((CharSequence)argUnsatisfied.getLabel(), (CharSequence)"existenceAssertion")) {
                    currentValidationEvent.setPeriodStart("");
                    currentValidationEvent.setPeriodStop("");
                } else {
                    currentValidationEvent.setIndex(StringUtils.isBlank((CharSequence)conceptLabel) ? qName : conceptLabel);
                    currentValidationEvent.setSection(ArelleOutputParser.getSectionForConceptRef((ValidationItemRef)validationItemRef));
                    currentValidationEvent.setValidationItemRefContext(validationItemRef.getContextRef());
                    currentValidationEvent.setConceptQName(qName);
                    ArelleOutputParser.setPeriodForValidationEvent((ValidationEvent)currentValidationEvent, (ValidationItemRef)validationItemRef);
                }
                if (StringUtils.equals((CharSequence)((CharSequence)propertyMap.get("type")), (CharSequence)"calcInconsistency")) {
                    currentValidationEvent.setVariable((String)propertyMap.get("variable"));
                } else {
                    currentValidationEvent.setVariable(ArelleOutputParser.getVariableByBinding((String)qName, (ValidationLogEntry)logEntry));
                }
                validationEvent.getItemDescriptionList().add(currentValidationEvent);
            }
            validationEvent.getArgs().put("args_message_error", logEntry.getMessageAttributeMap().get("args_message_error"));
            if (currentXbrlFormula == null) {
                validationEvent.setType("valueAssertion");
                validationEvent.setSeverity("WARNING");
            } else {
                if (StringUtils.isNotBlank((CharSequence)logEntry.getMessage())) {
                    validationEvent.setMessage(logEntry.getMessage());
                } else {
                    validationEvent.setMessage(currentXbrlFormula.getLabel());
                }
                validationEvent.setSeverity(currentXbrlFormula.getSeverity());
                validationEvent.setType(currentXbrlFormula.getType());
            }
            validationEventList.add(validationEvent);
        }
        return validationEventList;
    }

    private static boolean isDisplayedValidationEntries(ValidationLogEntry logEntry) {
        return true;
    }

    private static String getSectionForConceptRef(ValidationItemRef validationItemRef) {
        if (validationItemRef == null) {
            return "";
        }
        ValidationItemRefContext contextRef = validationItemRef.getContextRef();
        if (contextRef == null) {
            return "";
        }
        if (contextRef.getDimensionsLabel() != null) {
            return contextRef.getDimensionsLabel();
        }
        return contextRef.getDimensions().stream().filter(d -> StringUtils.isNotBlank((CharSequence)d.getDimension())).map(d -> d.getDimension() + " - " + d.getMember()).collect(Collectors.joining("\n"));
    }

    private static List<Dimension> processDimensionsContextProperty(XMLStreamReader reader) throws XMLStreamException {
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        if (reader == null || !reader.hasNext()) {
            return dimensions;
        }
        Integer dimensionsLevel = 0;
        block4: while (reader.hasNext() && dimensionsLevel >= 0) {
            int eventType = reader.next();
            switch (eventType) {
                case 1: {
                    String currentStartElement = reader.getName().toString();
                    if (!StringUtils.equalsIgnoreCase((CharSequence)"property", (CharSequence)currentStartElement)) break;
                    Integer n = dimensionsLevel;
                    Integer n2 = dimensionsLevel = Integer.valueOf(dimensionsLevel + 1);
                    String name = null;
                    String value = null;
                    int n3 = reader.getAttributeCount();
                    for (int i = 0; i < n3; ++i) {
                        QName attributeName = reader.getAttributeName(i);
                        if (StringUtils.equalsIgnoreCase((CharSequence)"name", (CharSequence)attributeName.toString())) {
                            name = reader.getAttributeValue(i);
                        }
                        if (!StringUtils.equalsIgnoreCase((CharSequence)"value", (CharSequence)attributeName.toString())) continue;
                        value = reader.getAttributeValue(i);
                    }
                    if (!StringUtils.isNotBlank(name)) continue block4;
                    dimensions.add(new Dimension(name, value));
                    break;
                }
                case 2: {
                    String currentEndElement = reader.getName().toString();
                    if (!StringUtils.equalsIgnoreCase((CharSequence)"property", (CharSequence)currentEndElement)) break;
                    Integer n = dimensionsLevel;
                    Integer n2 = dimensionsLevel = Integer.valueOf(dimensionsLevel - 1);
                    break;
                }
            }
        }
        return dimensions;
    }

    private static void setPeriodForValidationEvent(ValidationEvent validationEvent, ValidationItemRef validationItemRef) {
        if (validationItemRef == null) {
            return;
        }
        ValidationItemRefContext contextRef = validationItemRef.getContextRef();
        if (contextRef == null) {
            return;
        }
        String instant = contextRef.getInstant();
        if (StringUtils.isNotBlank((CharSequence)instant)) {
            validationEvent.setPeriodStart(instant);
            return;
        }
        validationEvent.setPeriodStart(contextRef.getStartDate());
        validationEvent.setPeriodStop(contextRef.getEndDate());
    }

    private static String getVariableByBinding(String qName, ValidationLogEntry logEntry) {
        if (logEntry == null) {
            return null;
        }
        ArgUnsatisfied argUnsatisfied = logEntry.getArgUnsatisfied();
        if (argUnsatisfied == null) {
            return null;
        }
        for (Map.Entry factVarBinding : argUnsatisfied.getBindingVarMap().entrySet()) {
            if (!StringUtils.equals((CharSequence)((CharSequence)factVarBinding.getValue()), (CharSequence)qName)) continue;
            String key = (String)factVarBinding.getKey();
            argUnsatisfied.getBindingVarMap().remove(key);
            return key;
        }
        return null;
    }

    private static ArgUnsatisfied getArgUnsatisfied(Map<String, String> args) {
        String[] varBindingValues;
        ArgUnsatisfied argUnsatisfied = new ArgUnsatisfied();
        if (CollectionUtils.isEmpty(args)) {
            return argUnsatisfied;
        }
        argUnsatisfied.setLabel(args.get("label"));
        String factVarBindingsStr = args.get("factVarBindings");
        if (StringUtils.isBlank((CharSequence)factVarBindingsStr)) {
            return argUnsatisfied;
        }
        factVarBindingsStr = StringUtils.remove((String)StringUtils.removeStart((String)factVarBindingsStr, (String)", "), (String)"\n");
        for (String varBindingValue : varBindingValues = StringUtils.splitByWholeSeparator((String)factVarBindingsStr, (String)",")) {
            String[] currentVarBinding = StringUtils.splitByWholeSeparator((String)varBindingValue, (String)":", (int)2);
            if (currentVarBinding.length != 2) {
                log.trace("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u043f\u0430\u0440\u0443 \u043a\u043b\u044e\u0447-\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0434\u043b\u044f factVarBinding. \u0412\u0445\u043e\u0434\u044f\u0449\u0435\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435: {}", (Object)varBindingValue);
                continue;
            }
            String trimmedVarBuildingValue = StringUtils.trim((String)currentVarBinding[1]);
            if (StringUtils.equalsIgnoreCase((CharSequence)trimmedVarBuildingValue, (CharSequence)"fallback [0]")) {
                argUnsatisfied.getBindingVarMap().put(StringUtils.trim((String)currentVarBinding[0]), "fallback [0]");
                continue;
            }
            argUnsatisfied.getBindingVarMap().put(StringUtils.trim((String)currentVarBinding[0]), StringUtils.trim((String)StringUtils.substringBefore((String)trimmedVarBuildingValue, (String)" ")));
        }
        return argUnsatisfied;
    }

    public static void setIsLastActionCancelled(Boolean isLastActionCancelled) {
        ArelleOutputParser.isLastActionCancelled = isLastActionCancelled;
    }

    public static boolean getIsLastActionCancelled() {
        return isLastActionCancelled;
    }
}

