/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.arelle.executor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import org.apache.commons.exec.CommandLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Service;
import ru.cbr.xbrl.converter.arelle.ArelleOutputParser;
import ru.cbr.xbrl.converter.arelle.executor.ServerLogProcessingThread;
import ru.cbr.xbrl.converter.config.ConfigProperties;
import ru.cbr.xbrl.converter.exception.CancelledException;
import ru.cbr.xbrl.converter.exception.EngineAuthorizeException;
import ru.cbr.xbrl.converter.model.validation.ValidationEvent;
import ru.cbr.xbrl.converter.service.XbrlPackageService;
import ru.cbr.xbrl.converter.service.XbrlReportService;
import ru.cbr.xbrl.converter.service.XbrlValidateServiceImpl;

@Service
public class ArelleExecutor {
    private static final Logger log = LoggerFactory.getLogger(ArelleExecutor.class);
    @Autowired
    private XbrlPackageService xbrlPackageService;
    @Autowired
    private SimpMessagingTemplate simpMessagingTemplate;
    @Autowired
    private XbrlReportService xbrlReportService;
    @Autowired
    private XbrlValidateServiceImpl xbrlValidateService;
    @Autowired
    private ConfigProperties configProperties;
    private static String COMMAND_ARG_DELIMITER = " ";
    private static AtomicReference<Process> processReference = new AtomicReference();

    private ValidationEvent sendEvent(ValidationEvent validationEvent) {
        this.simpMessagingTemplate.convertAndSend((Object)"/topic/validation-event", (Object)validationEvent);
        return validationEvent;
    }

    public int commandExecute(CommandLine commandLine) throws CancelledException, EngineAuthorizeException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(commandLine.getExecutable());
        cmd.addAll(Arrays.asList(commandLine.getArguments()));
        int lastCmdLineSize = cmd.size();
        cmd = cmd.stream().filter(x -> !x.equals("--logOverSocket")).collect(Collectors.toList());
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.redirectOutput(new File("NUL"));
        this.killCurrentArelleProcess();
        log.info("Execute command: " + String.join((CharSequence)COMMAND_ARG_DELIMITER, cmd));
        try {
            ServerLogProcessingThread server = null;
            if (lastCmdLineSize != cmd.size()) {
                for (int i = 0; i < cmd.size(); ++i) {
                    if (!((String)cmd.get(i)).equals("--formula") || i + 1 >= cmd.size() || !((String)cmd.get(i + 1)).equals("run")) continue;
                    server = new ServerLogProcessingThread(this.configProperties.getLogSocketPort().intValue(), this.xbrlPackageService.findLastPackage().getXbrlReport(), this.xbrlReportService, this.xbrlValidateService);
                    break;
                }
            }
            long exchangeProcessStart = System.currentTimeMillis();
            Process process = pb.start();
            processReference.set(process);
            int errCode = process.waitFor();
            log.info("Exchange Data Time: " + (System.currentTimeMillis() - exchangeProcessStart) + " ms");
            if (server != null && !server.getServerSocket().isClosed()) {
                long startFinishingSocketThread = System.currentTimeMillis();
                server.getServerSocket().close();
                server.join();
                log.info("Socket Thread Time Finished in " + (System.currentTimeMillis() - startFinishingSocketThread) + " ms");
                log.info("Parse Time: " + server.getParseTime() + " ms");
                log.info("Save Time: " + server.getSaveTime() + " ms");
            }
            log.info("Process completed, errCode: " + errCode);
            switch (errCode) {
                case 0: 
                case 1: 
                case 20: 
                case 25: 
                case 26: 
                case 27: 
                case 30: 
                case 40: {
                    return errCode;
                }
                case 401: {
                    throw new EngineAuthorizeException();
                }
            }
            throw new CancelledException();
        }
        catch (IOException e) {
            log.warn("Arelle process IOException " + e);
            throw new CancelledException();
        }
        catch (InterruptedException e) {
            log.warn("Arelle process interrupted");
            throw new CancelledException();
        }
    }

    private void parseLine(String line) {
        ValidationEvent validationEvent = ArelleOutputParser.parse((String)line);
        if (validationEvent != null) {
            this.sendEvent(validationEvent);
        }
    }

    public synchronized void killCurrentArelleProcess() {
        Process process = (Process)processReference.get();
        if (process != null) {
            if (process.isAlive()) {
                log.info("Destroy process: " + process + ", isAlive: " + process.isAlive());
            }
            process.destroy();
        }
    }

    @PreDestroy
    private void preDestroy() {
        this.killCurrentArelleProcess();
    }
}

