/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.config.database;

import com.zaxxer.hikari.HikariDataSource;
import java.util.HashMap;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@EnableJpaRepositories(basePackages={"ru.cbr.xbrl.converter.repository"}, entityManagerFactoryRef="cacheEntityManager", transactionManagerRef="cacheTransactionManager")
public class CacheDatabaseConfig {
    @Autowired
    private Environment env;
    @Value(value="${converter.datasource.cache.properties.hibernate.dialect}")
    private String hibernateDialect;
    @Value(value="${converter.datasource.cache.properties.hibernate.show_sql}")
    private String hibernateShowSql;
    @Value(value="${converter.datasource.cache.properties.hibernate.hbm2ddl.auto}")
    private String hibernateHbm2ddlAuto;

    @Bean
    @ConfigurationProperties(prefix="converter.datasource.cache")
    public DataSourceProperties cacheDataSourceProperties() {
        return new DataSourceProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="converter.datasource.cache")
    public HikariDataSource cacheDataSource() {
        return (HikariDataSource)this.cacheDataSourceProperties().initializeDataSourceBuilder().type(HikariDataSource.class).build();
    }

    @Bean
    public NamedParameterJdbcTemplate cachedJDBCTemplate() {
        return new NamedParameterJdbcTemplate((DataSource)this.cacheDataSource());
    }

    @Bean
    public LocalContainerEntityManagerFactoryBean cacheEntityManager() {
        LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
        em.setDataSource((DataSource)this.cacheDataSource());
        em.setPackagesToScan(new String[]{"ru.cbr.xbrl.converter.model"});
        em.setPersistenceUnitName("cachePU");
        HibernateJpaVendorAdapter vendorAdapter = new HibernateJpaVendorAdapter();
        em.setJpaVendorAdapter((JpaVendorAdapter)vendorAdapter);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("hibernate.hbm2ddl.auto", this.hibernateHbm2ddlAuto);
        properties.put("hibernate.dialect", this.hibernateDialect);
        properties.put("hibernate.show_sql", this.hibernateShowSql);
        em.setJpaPropertyMap(properties);
        return em;
    }

    @Bean
    public PlatformTransactionManager cacheTransactionManager() {
        JpaTransactionManager transactionManager = new JpaTransactionManager();
        transactionManager.setEntityManagerFactory(this.cacheEntityManager().getObject());
        return transactionManager;
    }
}

