/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Controller;
import ru.cbr.xbrl.converter.exception.CancelledException;
import ru.cbr.xbrl.converter.exception.CommandExecutionException;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.TaxonomyNotFoundException;
import ru.cbr.xbrl.converter.exception.XbrlExportException;
import ru.cbr.xbrl.converter.service.XbrlValidateService;

@Controller
public class EventController {
    private static final Logger log = LoggerFactory.getLogger(EventController.class);
    @Autowired
    private SimpMessagingTemplate simpMessagingTemplate;
    @Autowired
    private XbrlValidateService xbrlValidateService;

    @MessageMapping(value={"/exec-validation"})
    public void execValidation(Long xbrlReportId) throws CommandExecutionException, CancelledException, TaxonomyNotFoundException, NotFoundException, XbrlExportException {
        log.info("EventController.execValidation, xbrlReportId = " + xbrlReportId);
        this.xbrlValidateService.validate(xbrlReportId);
    }

    @MessageMapping(value={"/cancel-validation"})
    public void cancelValidation() {
        log.info("cancelValidation");
        this.xbrlValidateService.cancelValidation();
    }
}

