/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.controller;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.EnumUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import ru.cbr.xbrl.converter.exception.BadRequestException;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.model.log.EventLog;
import ru.cbr.xbrl.converter.service.log.EventLogService;

@RestController
@RequestMapping(value={"event-log"})
public class EventLogController {
    private static final Logger log = LoggerFactory.getLogger(EventLogController.class);
    @Autowired
    private EventLogService eventLogService;

    @GetMapping(value={"{xbrlReportId}/{eventLogType}/page/{pageNum}"})
    public Page<EventLog> getPage(@PathVariable(value="xbrlReportId") Long xbrlReportId, @PathVariable(value="eventLogType") String eventLogTypeStr, @PathVariable(value="pageNum") Integer pageNum) throws NotFoundException, BadRequestException {
        if (!EnumUtils.isValidEnum(EventLog.EventLogType.class, (String)eventLogTypeStr)) {
            throw new BadRequestException();
        }
        EventLog.EventLogType eventLogType = EventLog.EventLogType.valueOf((String)eventLogTypeStr);
        return this.eventLogService.getPage(xbrlReportId, eventLogType, pageNum);
    }

    @PostMapping(value={"export-xlsx"})
    public void exportXlsx(@RequestParam(value="xbrlReportId") Long xbrlReportId, @RequestParam(value="tabName") String tabName, @RequestParam(value="filePath") String filePath, @RequestParam(value="xlsxFileName") String xlsxFileName) throws NotFoundException {
        String fullName = FilenameUtils.concat((String)filePath, (String)xlsxFileName);
        EventLog.EventLogType eventLogType = EventLog.EventLogType.valueOf((String)tabName);
        this.eventLogService.exportEventsToXlsx(xbrlReportId, eventLogType, fullName);
    }
}

