/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.controller;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import ru.cbr.xbrl.converter.exception.IncorrectTaxonomyUpdateUrl;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.ServerUnavailableException;
import ru.cbr.xbrl.converter.exception.TaxonomyHashCheckingFailedException;
import ru.cbr.xbrl.converter.exception.TaxonomyVersionExistsException;
import ru.cbr.xbrl.converter.exception.UploadException;
import ru.cbr.xbrl.converter.exception.WrongTaxonomyPackageException;
import ru.cbr.xbrl.converter.exception.ZipExtractFileException;
import ru.cbr.xbrl.converter.model_main.Taxonomy;
import ru.cbr.xbrl.converter.service.TaxonomyService;
import ru.cbr.xbrl.converter.service.TaxonomyUpdateService;
import ru.cbr.xbrl.converter.taxonomy.taxonomy_package.data.TaxonomyDescription;

@RestController
@RequestMapping(value={"taxonomy"})
public class TaxonomyController {
    private static final Logger log = LoggerFactory.getLogger(TaxonomyController.class);
    @Autowired
    private TaxonomyService taxonomyService;
    @Autowired
    private TaxonomyUpdateService taxonomyUpdateService;

    @GetMapping(value={"/"})
    public List<Taxonomy> list() {
        return this.taxonomyService.list();
    }

    @PostMapping(value={"/"})
    public Taxonomy upload(@RequestParam(value="localPath") String localPath) throws UploadException, ZipExtractFileException, TaxonomyVersionExistsException, WrongTaxonomyPackageException {
        return this.taxonomyService.uploadLocal(localPath);
    }

    @GetMapping(value={"/{id}"})
    public Taxonomy find(@PathVariable(value="id") Long id) throws NotFoundException {
        return this.taxonomyService.find(id);
    }

    @GetMapping(value={"/params"})
    public Map<String, Object> getTaxonomyParams() {
        return this.taxonomyUpdateService.getTaxonomyParams();
    }

    @PostMapping(value={"/descriptions"})
    public List<TaxonomyDescription> syncTaxonomies(@RequestParam(value="checkUpdate") Boolean checkUpdate, @RequestParam(value="taxonomyUpdateUrl") String taxonomyUpdateUrl) throws IncorrectTaxonomyUpdateUrl, ServerUnavailableException {
        return this.taxonomyUpdateService.getTaxonomyDescriptions(checkUpdate.booleanValue(), taxonomyUpdateUrl);
    }

    @PostMapping(value={"/load"})
    public void loadTaxonomy(@RequestParam(value="filePath") String filePath) throws UploadException, ZipExtractFileException, TaxonomyVersionExistsException, WrongTaxonomyPackageException, TaxonomyHashCheckingFailedException {
        this.taxonomyUpdateService.setLastActionCancelled(Boolean.valueOf(false));
        this.taxonomyUpdateService.uploadTaxonomyFromHttp(filePath);
    }

    @PostMapping(value={"/cancel"})
    public void cancel() {
        this.taxonomyUpdateService.setLastActionCancelled(Boolean.valueOf(true));
    }

    @GetMapping(value={"/has-new-actual"})
    public Boolean hasNewActual() throws IncorrectTaxonomyUpdateUrl, ServerUnavailableException {
        return this.taxonomyUpdateService.hasNewActual();
    }

    @DeleteMapping(value={"/{id}"})
    public void deleteTaxonomy(@PathVariable(value="id") Long id) throws NotFoundException, IOException {
        this.taxonomyService.deleteWithFile(id);
    }

    @PostMapping(value={"/taxonomy-form-settings"})
    public void saveTaxonomyFormSettings(@RequestParam(value="taxonomyUrl") String taxonomyUrl, @RequestParam(value="taxonomyAutoUpdate") Boolean taxonomyAutoUpdate) throws IncorrectTaxonomyUpdateUrl {
        this.taxonomyUpdateService.saveTaxonomyFormSettings(taxonomyUrl, taxonomyAutoUpdate);
    }
}

