/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.controller;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import net.lingala.zip4j.exception.ZipException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import ru.cbr.xbrl.converter.controller.import_export.ExportTemplateStruct;
import ru.cbr.xbrl.converter.exception.AccessDeniedDirectoryException;
import ru.cbr.xbrl.converter.exception.DeleteTemplateException;
import ru.cbr.xbrl.converter.exception.DeltaNotFoundException;
import ru.cbr.xbrl.converter.exception.DeltaTagNameNotCorrectException;
import ru.cbr.xbrl.converter.exception.FileAlreadyExistsException;
import ru.cbr.xbrl.converter.exception.IncorrectTemplateArchiveException;
import ru.cbr.xbrl.converter.exception.MappingNotFoundException;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.RewritableFileOpenException;
import ru.cbr.xbrl.converter.exception.TemplateArchiveEncryptionException;
import ru.cbr.xbrl.converter.exception.TemplateDoesNotExistException;
import ru.cbr.xbrl.converter.exception.TemplateNotFoundException;
import ru.cbr.xbrl.converter.exception.UploadException;
import ru.cbr.xbrl.converter.exception.WriteFileException;
import ru.cbr.xbrl.converter.exception.WrongTemplatePackageFilesNumberException;
import ru.cbr.xbrl.converter.exception.ZipExtractFileException;
import ru.cbr.xbrl.converter.model_main.Template;
import ru.cbr.xbrl.converter.service.TemplateService;

@RestController
@RequestMapping(value={"template"})
public class TemplateController {
    private static final Logger log = LoggerFactory.getLogger(TemplateController.class);
    @Autowired
    private TemplateService templateService;

    @GetMapping(value={"/"})
    public List<Template> list() {
        return this.templateService.getList();
    }

    @GetMapping(value={"/sortedList"})
    public List<Template> getSortedList() {
        return this.templateService.getSortedList();
    }

    @GetMapping(value={"/byEntryPoint"})
    public List<Template> getAllByEntryPoint(@RequestParam(value="entryPoint") String entryPoint) {
        return this.templateService.listByEntryPoint(entryPoint);
    }

    @GetMapping(value={"/getNextTemplateVersion"})
    public int getNextTemplateVersion(@RequestParam(value="entryPoint") String entryPoint) {
        return this.templateService.getNextTemplateVersion(entryPoint);
    }

    @PostMapping(value={"/"})
    public boolean upload(@RequestParam(value="localPath") String localPath) throws UploadException, ZipExtractFileException, ZipException, IncorrectTemplateArchiveException, TemplateArchiveEncryptionException, IOException, MappingNotFoundException, DeltaNotFoundException, TemplateNotFoundException, WrongTemplatePackageFilesNumberException, DeltaTagNameNotCorrectException {
        return this.templateService.uploadLocal(localPath, false);
    }

    @PostMapping(value={"/updateTemplate"})
    public boolean updateTemplate(@RequestParam(value="localPath") String localPath) throws IncorrectTemplateArchiveException, IOException, TemplateArchiveEncryptionException, ZipExtractFileException, ZipException, UploadException, MappingNotFoundException, DeltaNotFoundException, TemplateNotFoundException, WrongTemplatePackageFilesNumberException, DeltaTagNameNotCorrectException {
        return this.templateService.uploadLocal(localPath, true);
    }

    @PostMapping(value={"/export-template"})
    public void exportTemplate(@RequestBody ExportTemplateStruct exportTemplateStruct) throws NotFoundException, FileAlreadyExistsException, WriteFileException, IOException, RewritableFileOpenException, XMLStreamException, AccessDeniedDirectoryException {
        this.templateService.exportTemplate(exportTemplateStruct);
    }

    @PostMapping(value={"/export-form"})
    public void exportForm(@RequestParam(value="id") Long templateId, @RequestParam(value="exportPath") String exportPath, @RequestParam(value="allowOverwriteFile") boolean allowOverwriteFile, @RequestParam(value="multipartFiles") boolean multipartFiles, @RequestParam(value="mainAxisZ") String mainAxisZ) throws IOException, NotFoundException, XMLStreamException, FileAlreadyExistsException, WriteFileException, RewritableFileOpenException, IncorrectTemplateArchiveException, ZipException, TemplateArchiveEncryptionException, TemplateNotFoundException {
        this.templateService.exportForm(templateId, exportPath, multipartFiles, mainAxisZ, allowOverwriteFile);
    }

    @DeleteMapping(value={"/delete"})
    public void delete(@RequestParam(value="id") Long templateId) throws IOException, NotFoundException, TemplateNotFoundException, DeleteTemplateException, TemplateDoesNotExistException {
        this.templateService.delete(templateId);
    }

    @GetMapping(value={"/getZAxes"})
    public Set<String> getZAxes(@RequestParam(value="id") Long templateId) throws NotFoundException, IOException {
        return this.templateService.getZAxisTitlesForTemplate(templateId);
    }
}

