/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.controller;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.xml.bind.DataBindingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import ru.cbr.xbrl.converter.exception.AccessDeniedDirectoryException;
import ru.cbr.xbrl.converter.exception.BadRequestException;
import ru.cbr.xbrl.converter.exception.CancelledException;
import ru.cbr.xbrl.converter.exception.IncompatibleSchemaRefException;
import ru.cbr.xbrl.converter.exception.IncorrectPackageException;
import ru.cbr.xbrl.converter.exception.MoveFileException;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.RemoveFileException;
import ru.cbr.xbrl.converter.exception.SavePackageException;
import ru.cbr.xbrl.converter.exception.TaxonomyNotFoundException;
import ru.cbr.xbrl.converter.exception.UploadException;
import ru.cbr.xbrl.converter.exception.XbrlExportException;
import ru.cbr.xbrl.converter.exception.XbrlImportException;
import ru.cbr.xbrl.converter.exception.ZipExtractFileException;
import ru.cbr.xbrl.converter.model.XbrlPeriod;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.model.web.rest.RoleDTO;
import ru.cbr.xbrl.converter.service.UpdateService;
import ru.cbr.xbrl.converter.service.XbrlPackageService;
import ru.cbr.xbrl.converter.service.XbrlParameterService;

@RestController
@RequestMapping(value={"xbrl-package"})
public class XbrlPackageController {
    private static final Logger log = LoggerFactory.getLogger(XbrlPackageController.class);
    private final XbrlPackageService xbrlPackageService;
    private final XbrlParameterService xbrlParameterService;
    private final UpdateService updateService;

    @GetMapping(value={"/"})
    public List<XbrlPackage> list() {
        List items = this.xbrlPackageService.list();
        items.stream().forEach(xbrlPackage -> xbrlPackage.prepareForJson());
        return items;
    }

    @GetMapping(value={"/last"})
    public XbrlPackage findLast() {
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        if (xbrlPackage != null) {
            xbrlPackage.prepareForJson();
            if (xbrlPackage.getXbrlReport() != null) {
                Collections.sort(xbrlPackage.getXbrlReport().getXbrlReportRoles(), Comparator.comparing(XbrlReportRole::getCompareString));
            }
        } else {
            xbrlPackage = this.updateService.recoveryPackage();
        }
        return xbrlPackage;
    }

    @GetMapping(value={"/is-empty"})
    public boolean isEmptyReport() {
        return this.xbrlPackageService.isEmpty();
    }

    @GetMapping(value={"/{id}"})
    public XbrlPackage find(@PathVariable(value="id") Long id) throws NotFoundException {
        XbrlPackage xbrlPackage = this.xbrlPackageService.find(id);
        if (xbrlPackage != null) {
            xbrlPackage.prepareForJson();
        }
        return xbrlPackage;
    }

    @PostMapping(value={"/open"})
    public XbrlPackage open(@RequestParam(value="localPath") String localPath) throws UploadException, XbrlImportException, ZipExtractFileException, XbrlExportException, RemoveFileException, CancelledException, TaxonomyNotFoundException, NotFoundException, MoveFileException, IncompatibleSchemaRefException, IncorrectPackageException {
        XbrlPackage xbrlPackage;
        this.xbrlPackageService.resetCancelPackageProcess();
        try {
            xbrlPackage = this.xbrlPackageService.open(localPath);
        }
        catch (IOException | NullPointerException | DataBindingException e) {
            throw new IncorrectPackageException();
        }
        if (xbrlPackage != null) {
            xbrlPackage.prepareForJson();
            this.updateService.saveCurrentPackagePath(xbrlPackage);
        }
        return xbrlPackage;
    }

    @PostMapping(value={"/"})
    public XbrlPackage create(@RequestBody XbrlPackage xbrlPackage) throws UploadException, TaxonomyNotFoundException, CancelledException, NotFoundException, RemoveFileException, MoveFileException, XbrlExportException {
        this.xbrlPackageService.resetCancelPackageProcess();
        if (xbrlPackage.getContextPeriod() != null) {
            xbrlPackage.getContextPeriod().setXbrlPackage(xbrlPackage);
        }
        XbrlPackage created = this.xbrlPackageService.create(xbrlPackage);
        List xbrlParameters = this.xbrlParameterService.findAll();
        created.getXbrlParameters().addAll(xbrlParameters);
        xbrlPackage.prepareForJson();
        this.updateService.saveCurrentPackagePath(xbrlPackage);
        return created;
    }

    @PostMapping(value={"/{id}/update"})
    public XbrlPackage update(@RequestBody XbrlPackage xbrlPackage) throws UploadException, TaxonomyNotFoundException, SavePackageException, MoveFileException, NotFoundException, CancelledException {
        XbrlPackage updated = this.xbrlPackageService.update(xbrlPackage);
        updated.prepareForJson();
        return updated;
    }

    @PutMapping(value={"/{id}/save"})
    public void save(@PathVariable(value="id") Long id) throws NotFoundException, MoveFileException, SavePackageException, AccessDeniedDirectoryException {
        this.xbrlPackageService.save(id);
    }

    @PostMapping(value={"/{id}/close"})
    public void close(@PathVariable(value="id") Long id) throws RemoveFileException, NotFoundException {
        this.updateService.deletePackagePath();
        this.xbrlPackageService.close(id);
    }

    @PostMapping(value={"/{id}/save-reporting-package"})
    public void saveReportingPackage(@PathVariable(value="id") Long xbrlPackageId, @RequestParam(value="packageDate") Long packageDateLong) throws MoveFileException, NotFoundException, SavePackageException, AccessDeniedDirectoryException {
        Date packageDate = new Date(packageDateLong);
        this.xbrlPackageService.saveReportingPackage(xbrlPackageId, packageDate);
    }

    @GetMapping(value={"/{id}/periods"})
    public List<XbrlPeriod> findPeriods(@PathVariable(value="id") Long id) throws NotFoundException, BadRequestException {
        return this.xbrlPackageService.findPackagePeriodList(id);
    }

    @PostMapping(value={"/{id}/period", "/{id}/period/{roleId}"})
    public List<XbrlPeriod> createPeriod(@PathVariable(value="id") Long id, @PathVariable(value="roleId", required=false) Long roleId, @RequestBody XbrlPeriod xbrlPeriod) throws NotFoundException, BadRequestException {
        if (xbrlPeriod == null) {
            log.info("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u0430. \u041f\u0435\u0440\u0438\u043e\u0434 = null");
            throw new BadRequestException();
        }
        if (xbrlPeriod.getStart() == null) {
            log.info("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u0430. \u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u0434\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u043f\u0435\u0440\u0438\u043e\u0434\u0430");
            throw new BadRequestException();
        }
        return this.xbrlPackageService.createPeriod(id, roleId, xbrlPeriod);
    }

    @PutMapping(value={"{id}/period/{periodId}"})
    public List<XbrlPeriod> updatePeriod(@PathVariable(value="id") Long id, @PathVariable(value="periodId") Long periodId, @RequestBody XbrlPeriod xbrlPeriod) throws NotFoundException {
        return this.xbrlPackageService.updatePeriod(id, periodId, xbrlPeriod);
    }

    @DeleteMapping(value={"/{id}/period/{periodId}", "/{id}/period/{periodId}/{roleId}"})
    public RoleDTO deletePeriod(@PathVariable(value="id") Long id, @PathVariable(value="periodId") Long periodId, @PathVariable(value="roleId", required=false) Long roleId, @RequestParam(required=false, defaultValue="false") boolean confirm) throws NotFoundException, BadRequestException {
        return this.xbrlPackageService.deletePeriod(id, periodId, roleId, confirm);
    }

    @PutMapping(value={"{id}/period/toggle/{state}"})
    public List<XbrlPeriod> togglePeriodList(@PathVariable(value="id") Long id, @PathVariable(value="state") Boolean state) throws NotFoundException {
        return this.xbrlPackageService.togglePeriodList(id, state);
    }

    @PostMapping(value={"/cancel"})
    public void cancelProcessing() {
        this.xbrlPackageService.cancelProcessing();
    }

    @ConstructorProperties(value={"xbrlPackageService", "xbrlParameterService", "updateService"})
    public XbrlPackageController(XbrlPackageService xbrlPackageService, XbrlParameterService xbrlParameterService, UpdateService updateService) {
        this.xbrlPackageService = xbrlPackageService;
        this.xbrlParameterService = xbrlParameterService;
        this.updateService = updateService;
    }
}

