/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.model;

import java.beans.ConstructorProperties;
import java.util.LinkedList;
import java.util.List;

public class DimensionValuePair {
    private final String dimension;
    private final String schemaValue;
    private final String value;
    private final String hash;
    private final int level;
    private List<DimensionValuePair> childList = new LinkedList();

    public int getLevel() {
        if (this.schemaValue == null) {
            return this.level;
        }
        int indexOfSchemaValue = this.value.indexOf(this.schemaValue);
        if (indexOfSchemaValue == -1) {
            return 0;
        }
        String spaces = this.value.substring(0, indexOfSchemaValue);
        return spaces.length() / 6;
    }

    public String getClearedValue() {
        if (this.schemaValue == null) {
            return this.value;
        }
        int indexOfSchemaValue = this.value.indexOf(this.schemaValue);
        if (indexOfSchemaValue == -1) {
            return "";
        }
        int schemaEnd = indexOfSchemaValue + this.schemaValue.length() + 1;
        if (this.value.length() <= schemaEnd) {
            return "";
        }
        return this.value.substring(schemaEnd);
    }

    @ConstructorProperties(value={"dimension", "schemaValue", "value", "hash", "level"})
    private DimensionValuePair(String dimension, String schemaValue, String value, String hash, int level) {
        this.dimension = dimension;
        this.schemaValue = schemaValue;
        this.value = value;
        this.hash = hash;
        this.level = level;
    }

    public static DimensionValuePair of(String dimension, String schemaValue, String value, String hash, int level) {
        return new DimensionValuePair(dimension, schemaValue, value, hash, level);
    }

    public String getDimension() {
        return this.dimension;
    }

    public String getSchemaValue() {
        return this.schemaValue;
    }

    public String getValue() {
        return this.value;
    }

    public String getHash() {
        return this.hash;
    }

    public List<DimensionValuePair> getChildList() {
        return this.childList;
    }

    public void setChildList(List<DimensionValuePair> childList) {
        this.childList = childList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DimensionValuePair)) {
            return false;
        }
        DimensionValuePair other = (DimensionValuePair)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$dimension = this.getDimension();
        String other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !this$dimension.equals(other$dimension)) {
            return false;
        }
        String this$schemaValue = this.getSchemaValue();
        String other$schemaValue = other.getSchemaValue();
        if (this$schemaValue == null ? other$schemaValue != null : !this$schemaValue.equals(other$schemaValue)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        if (this.getLevel() != other.getLevel()) {
            return false;
        }
        List this$childList = this.getChildList();
        List other$childList = other.getChildList();
        return !(this$childList == null ? other$childList != null : !((Object)this$childList).equals(other$childList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DimensionValuePair;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : $dimension.hashCode());
        String $schemaValue = this.getSchemaValue();
        result = result * 59 + ($schemaValue == null ? 43 : $schemaValue.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        result = result * 59 + this.getLevel();
        List $childList = this.getChildList();
        result = result * 59 + ($childList == null ? 43 : ((Object)$childList).hashCode());
        return result;
    }

    public String toString() {
        return "DimensionValuePair(dimension=" + this.getDimension() + ", schemaValue=" + this.getSchemaValue() + ", value=" + this.getValue() + ", hash=" + this.getHash() + ", level=" + this.getLevel() + ", childList=" + this.getChildList() + ")";
    }
}

