/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.model;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import ru.cbr.xbrl.converter.model.XbrlRolePeriod;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.model.xbrl_content.PeriodType;
import ru.cbr.xbrl.converter.service.import_export.PeriodDates;

@Entity
@Table
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class XbrlPeriod {
    @Id
    @GeneratedValue
    @XmlTransient
    private Long id;
    private String title;
    @Temporal(value=TemporalType.DATE)
    private Date start;
    @Temporal(value=TemporalType.DATE)
    private Date end;
    @Enumerated(value=EnumType.STRING)
    private PeriodType type = PeriodType.DURATION;
    @JsonProperty(value="default")
    private Boolean isDefaultPeriod = false;
    @JsonProperty(value="editable")
    private Boolean isEditablePeriod = true;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="xbrlPeriod")
    @JsonIgnore
    @XmlTransient
    private List<XbrlRolePeriod> periodList = new ArrayList();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(foreignKey=@ForeignKey(name="FK_XBRL_PERIOD_PACKAGE"))
    @JsonBackReference
    @XmlTransient
    private XbrlPackage xbrlPackage;
    @JsonProperty(value="filePath")
    private String filePath;
    @Transient
    private Boolean active = true;
    @Transient
    private Boolean isData;

    public XbrlPeriod(XbrlPackage xbrlPackage, PeriodDates periodDates) {
        this.setType(periodDates.getPeriodType());
        this.setXbrlPackage(xbrlPackage);
        if (periodDates.getPeriodType() == PeriodType.INSTANT) {
            this.setStart(periodDates.getInstantDate());
            this.setTitle(periodDates.formatDate());
        } else if (periodDates.getPeriodType() == PeriodType.DURATION) {
            this.setStart(periodDates.getStartDate());
            this.setEnd(periodDates.getEndDate());
            this.setTitle(periodDates.formatDate());
        } else {
            throw new IllegalArgumentException("Unknown periodType: " + periodDates.getPeriodType());
        }
    }

    public XbrlPeriod(Date start, Date end, String title) {
        this.start = start;
        this.end = end;
        this.title = title;
    }

    public PeriodDates toPeriodDates() {
        PeriodDates periodDates = this.getType() == PeriodType.DURATION ? PeriodDates.buildDuration((Date)this.getStart(), (Date)this.getEnd()) : PeriodDates.buildInstant((Date)this.getStart());
        return periodDates;
    }

    public PeriodDates getAdditionalInstant() {
        return PeriodDates.buildInstant((Date)this.getEnd());
    }

    public Long getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public Date getStart() {
        return this.start;
    }

    public Date getEnd() {
        return this.end;
    }

    public PeriodType getType() {
        return this.type;
    }

    public Boolean getIsDefaultPeriod() {
        return this.isDefaultPeriod;
    }

    public Boolean getIsEditablePeriod() {
        return this.isEditablePeriod;
    }

    public List<XbrlRolePeriod> getPeriodList() {
        return this.periodList;
    }

    public XbrlPackage getXbrlPackage() {
        return this.xbrlPackage;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public Boolean getActive() {
        return this.active;
    }

    public Boolean getIsData() {
        return this.isData;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public void setType(PeriodType type) {
        this.type = type;
    }

    public void setIsDefaultPeriod(Boolean isDefaultPeriod) {
        this.isDefaultPeriod = isDefaultPeriod;
    }

    public void setIsEditablePeriod(Boolean isEditablePeriod) {
        this.isEditablePeriod = isEditablePeriod;
    }

    public void setPeriodList(List<XbrlRolePeriod> periodList) {
        this.periodList = periodList;
    }

    public void setXbrlPackage(XbrlPackage xbrlPackage) {
        this.xbrlPackage = xbrlPackage;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public void setIsData(Boolean isData) {
        this.isData = isData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XbrlPeriod)) {
            return false;
        }
        XbrlPeriod other = (XbrlPeriod)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        Date this$start = this.getStart();
        Date other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        Date this$end = this.getEnd();
        Date other$end = other.getEnd();
        if (this$end == null ? other$end != null : !((Object)this$end).equals(other$end)) {
            return false;
        }
        PeriodType this$type = this.getType();
        PeriodType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Boolean this$isDefaultPeriod = this.getIsDefaultPeriod();
        Boolean other$isDefaultPeriod = other.getIsDefaultPeriod();
        if (this$isDefaultPeriod == null ? other$isDefaultPeriod != null : !((Object)this$isDefaultPeriod).equals(other$isDefaultPeriod)) {
            return false;
        }
        Boolean this$isEditablePeriod = this.getIsEditablePeriod();
        Boolean other$isEditablePeriod = other.getIsEditablePeriod();
        if (this$isEditablePeriod == null ? other$isEditablePeriod != null : !((Object)this$isEditablePeriod).equals(other$isEditablePeriod)) {
            return false;
        }
        List this$periodList = this.getPeriodList();
        List other$periodList = other.getPeriodList();
        if (this$periodList == null ? other$periodList != null : !((Object)this$periodList).equals(other$periodList)) {
            return false;
        }
        XbrlPackage this$xbrlPackage = this.getXbrlPackage();
        XbrlPackage other$xbrlPackage = other.getXbrlPackage();
        if (this$xbrlPackage == null ? other$xbrlPackage != null : !this$xbrlPackage.equals(other$xbrlPackage)) {
            return false;
        }
        String this$filePath = this.getFilePath();
        String other$filePath = other.getFilePath();
        if (this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        Boolean this$isData = this.getIsData();
        Boolean other$isData = other.getIsData();
        return !(this$isData == null ? other$isData != null : !((Object)this$isData).equals(other$isData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XbrlPeriod;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        Date $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        Date $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        PeriodType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Boolean $isDefaultPeriod = this.getIsDefaultPeriod();
        result = result * 59 + ($isDefaultPeriod == null ? 43 : ((Object)$isDefaultPeriod).hashCode());
        Boolean $isEditablePeriod = this.getIsEditablePeriod();
        result = result * 59 + ($isEditablePeriod == null ? 43 : ((Object)$isEditablePeriod).hashCode());
        List $periodList = this.getPeriodList();
        result = result * 59 + ($periodList == null ? 43 : ((Object)$periodList).hashCode());
        XbrlPackage $xbrlPackage = this.getXbrlPackage();
        result = result * 59 + ($xbrlPackage == null ? 43 : $xbrlPackage.hashCode());
        String $filePath = this.getFilePath();
        result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        Boolean $isData = this.getIsData();
        result = result * 59 + ($isData == null ? 43 : ((Object)$isData).hashCode());
        return result;
    }

    public String toString() {
        return "XbrlPeriod(id=" + this.getId() + ", title=" + this.getTitle() + ", start=" + this.getStart() + ", end=" + this.getEnd() + ", type=" + this.getType() + ", isDefaultPeriod=" + this.getIsDefaultPeriod() + ", isEditablePeriod=" + this.getIsEditablePeriod() + ", periodList=" + this.getPeriodList() + ", filePath=" + this.getFilePath() + ", active=" + this.getActive() + ", isData=" + this.getIsData() + ")";
    }

    public XbrlPeriod() {
    }
}

