/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.model;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.model.PresentationConcept;
import ru.cbr.xbrl.converter.model.XbrlFormula;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.XbrlReportValidationEvent;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.utils.FileUtils;
import ru.cbr.xbrl.converter.utils.GzipUtils;

@Entity
@Table(indexes={@Index(name="idx_filename", columnList="fileName")})
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
public class XbrlReport {
    private static final Logger log = LoggerFactory.getLogger(XbrlReport.class);
    @XmlTransient
    @Id
    @GeneratedValue
    private Long id;
    private String fileName;
    @XmlTransient
    private Date uploadTime;
    private String filePath;
    @JsonManagedReference
    @OneToMany(fetch=FetchType.EAGER, mappedBy="xbrlReport", cascade={CascadeType.ALL}, orphanRemoval=true)
    @XmlTransient
    private List<XbrlReportRole> xbrlReportRoles = new ArrayList();
    @JsonManagedReference
    @OneToMany(fetch=FetchType.LAZY, mappedBy="xbrlReport", cascade={CascadeType.ALL}, orphanRemoval=true)
    @XmlTransient
    private List<XbrlFormula> xbrlReportFormulaList = new ArrayList();
    @JsonManagedReference
    @OneToMany(fetch=FetchType.LAZY, mappedBy="xbrlReport", cascade={CascadeType.ALL}, orphanRemoval=true)
    @XmlTransient
    private List<PresentationConcept> xbrlReportConceptList = new ArrayList();
    @OneToOne
    @JsonBackReference
    @JoinColumn(name="package_id")
    @XmlTransient
    private XbrlPackage xbrlPackage;
    @JsonManagedReference
    @OneToMany(fetch=FetchType.LAZY, mappedBy="xbrlReport", cascade={CascadeType.ALL}, orphanRemoval=true)
    @XmlTransient
    @JsonIgnore
    private List<XbrlReportValidationEvent> xbrlReportValidationEvents = new ArrayList();
    @Lob
    @JsonIgnore
    private byte[] dimXml;
    @Lob
    @JsonIgnore
    private byte[] preXml;
    @Lob
    @JsonIgnore
    private byte[] dimensionsDefaultJsonGzipped;
    @Lob
    @JsonIgnore
    private byte[] enumerationsJsonGzipped;

    public XbrlReport() {
    }

    public XbrlReport(Long id) {
        this.id = id;
    }

    public void prepareForJson() {
        Collections.sort(this.getXbrlReportRoles(), Comparator.comparing(XbrlReportRole::getCompareString));
        this.getXbrlReportRoles().stream().forEach(r -> {
            r.setJson(null);
            r.setStaticStructureJson(null);
            r.setPeriodList(Collections.emptyList());
            r.setXbrlRoleDimensionList(Collections.emptyList());
            r.setXbrlReport(null);
        });
        this.getXbrlReportValidationEvents().clear();
        this.getXbrlReportConceptList().clear();
        this.getXbrlReportFormulaList().clear();
        this.setXbrlPackage(null);
    }

    public void initAllLazy() {
        if (this.xbrlReportValidationEvents != null) {
            this.xbrlReportValidationEvents.size();
        }
        this.xbrlReportRoles.size();
        this.xbrlReportConceptList.size();
        this.xbrlReportFormulaList.size();
    }

    public void storeArelleFiles(String prePath, String dimPath) {
        Date d = new Date();
        try {
            String preString = FileUtils.readTextFile((String)prePath);
            this.setPreXml(GzipUtils.compressString((String)preString));
            String dimString = FileUtils.readTextFile((String)dimPath);
            this.setDimXml(GzipUtils.compressString((String)dimString));
            log.info("Compress pre.xml and dim.xml completed in " + (new Date().getTime() - d.getTime()) + " msec");
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public Long getId() {
        return this.id;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Date getUploadTime() {
        return this.uploadTime;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public List<XbrlReportRole> getXbrlReportRoles() {
        return this.xbrlReportRoles;
    }

    public List<XbrlFormula> getXbrlReportFormulaList() {
        return this.xbrlReportFormulaList;
    }

    public List<PresentationConcept> getXbrlReportConceptList() {
        return this.xbrlReportConceptList;
    }

    public XbrlPackage getXbrlPackage() {
        return this.xbrlPackage;
    }

    public List<XbrlReportValidationEvent> getXbrlReportValidationEvents() {
        return this.xbrlReportValidationEvents;
    }

    public byte[] getDimXml() {
        return this.dimXml;
    }

    public byte[] getPreXml() {
        return this.preXml;
    }

    public byte[] getDimensionsDefaultJsonGzipped() {
        return this.dimensionsDefaultJsonGzipped;
    }

    public byte[] getEnumerationsJsonGzipped() {
        return this.enumerationsJsonGzipped;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setUploadTime(Date uploadTime) {
        this.uploadTime = uploadTime;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setXbrlReportRoles(List<XbrlReportRole> xbrlReportRoles) {
        this.xbrlReportRoles = xbrlReportRoles;
    }

    public void setXbrlReportFormulaList(List<XbrlFormula> xbrlReportFormulaList) {
        this.xbrlReportFormulaList = xbrlReportFormulaList;
    }

    public void setXbrlReportConceptList(List<PresentationConcept> xbrlReportConceptList) {
        this.xbrlReportConceptList = xbrlReportConceptList;
    }

    public void setXbrlPackage(XbrlPackage xbrlPackage) {
        this.xbrlPackage = xbrlPackage;
    }

    public void setXbrlReportValidationEvents(List<XbrlReportValidationEvent> xbrlReportValidationEvents) {
        this.xbrlReportValidationEvents = xbrlReportValidationEvents;
    }

    public void setDimXml(byte[] dimXml) {
        this.dimXml = dimXml;
    }

    public void setPreXml(byte[] preXml) {
        this.preXml = preXml;
    }

    public void setDimensionsDefaultJsonGzipped(byte[] dimensionsDefaultJsonGzipped) {
        this.dimensionsDefaultJsonGzipped = dimensionsDefaultJsonGzipped;
    }

    public void setEnumerationsJsonGzipped(byte[] enumerationsJsonGzipped) {
        this.enumerationsJsonGzipped = enumerationsJsonGzipped;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XbrlReport)) {
            return false;
        }
        XbrlReport other = (XbrlReport)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        Date this$uploadTime = this.getUploadTime();
        Date other$uploadTime = other.getUploadTime();
        if (this$uploadTime == null ? other$uploadTime != null : !((Object)this$uploadTime).equals(other$uploadTime)) {
            return false;
        }
        String this$filePath = this.getFilePath();
        String other$filePath = other.getFilePath();
        if (this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath)) {
            return false;
        }
        List this$xbrlReportRoles = this.getXbrlReportRoles();
        List other$xbrlReportRoles = other.getXbrlReportRoles();
        if (this$xbrlReportRoles == null ? other$xbrlReportRoles != null : !((Object)this$xbrlReportRoles).equals(other$xbrlReportRoles)) {
            return false;
        }
        List this$xbrlReportFormulaList = this.getXbrlReportFormulaList();
        List other$xbrlReportFormulaList = other.getXbrlReportFormulaList();
        if (this$xbrlReportFormulaList == null ? other$xbrlReportFormulaList != null : !((Object)this$xbrlReportFormulaList).equals(other$xbrlReportFormulaList)) {
            return false;
        }
        List this$xbrlReportConceptList = this.getXbrlReportConceptList();
        List other$xbrlReportConceptList = other.getXbrlReportConceptList();
        if (this$xbrlReportConceptList == null ? other$xbrlReportConceptList != null : !((Object)this$xbrlReportConceptList).equals(other$xbrlReportConceptList)) {
            return false;
        }
        XbrlPackage this$xbrlPackage = this.getXbrlPackage();
        XbrlPackage other$xbrlPackage = other.getXbrlPackage();
        if (this$xbrlPackage == null ? other$xbrlPackage != null : !this$xbrlPackage.equals(other$xbrlPackage)) {
            return false;
        }
        List this$xbrlReportValidationEvents = this.getXbrlReportValidationEvents();
        List other$xbrlReportValidationEvents = other.getXbrlReportValidationEvents();
        if (this$xbrlReportValidationEvents == null ? other$xbrlReportValidationEvents != null : !((Object)this$xbrlReportValidationEvents).equals(other$xbrlReportValidationEvents)) {
            return false;
        }
        if (!Arrays.equals(this.getDimXml(), other.getDimXml())) {
            return false;
        }
        if (!Arrays.equals(this.getPreXml(), other.getPreXml())) {
            return false;
        }
        if (!Arrays.equals(this.getDimensionsDefaultJsonGzipped(), other.getDimensionsDefaultJsonGzipped())) {
            return false;
        }
        return Arrays.equals(this.getEnumerationsJsonGzipped(), other.getEnumerationsJsonGzipped());
    }

    protected boolean canEqual(Object other) {
        return other instanceof XbrlReport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        Date $uploadTime = this.getUploadTime();
        result = result * 59 + ($uploadTime == null ? 43 : ((Object)$uploadTime).hashCode());
        String $filePath = this.getFilePath();
        result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
        List $xbrlReportRoles = this.getXbrlReportRoles();
        result = result * 59 + ($xbrlReportRoles == null ? 43 : ((Object)$xbrlReportRoles).hashCode());
        List $xbrlReportFormulaList = this.getXbrlReportFormulaList();
        result = result * 59 + ($xbrlReportFormulaList == null ? 43 : ((Object)$xbrlReportFormulaList).hashCode());
        List $xbrlReportConceptList = this.getXbrlReportConceptList();
        result = result * 59 + ($xbrlReportConceptList == null ? 43 : ((Object)$xbrlReportConceptList).hashCode());
        XbrlPackage $xbrlPackage = this.getXbrlPackage();
        result = result * 59 + ($xbrlPackage == null ? 43 : $xbrlPackage.hashCode());
        List $xbrlReportValidationEvents = this.getXbrlReportValidationEvents();
        result = result * 59 + ($xbrlReportValidationEvents == null ? 43 : ((Object)$xbrlReportValidationEvents).hashCode());
        result = result * 59 + Arrays.hashCode(this.getDimXml());
        result = result * 59 + Arrays.hashCode(this.getPreXml());
        result = result * 59 + Arrays.hashCode(this.getDimensionsDefaultJsonGzipped());
        result = result * 59 + Arrays.hashCode(this.getEnumerationsJsonGzipped());
        return result;
    }

    public String toString() {
        return "XbrlReport(id=" + this.getId() + ", fileName=" + this.getFileName() + ", uploadTime=" + this.getUploadTime() + ", filePath=" + this.getFilePath() + ", xbrlPackage=" + this.getXbrlPackage() + ", dimXml=" + Arrays.toString(this.getDimXml()) + ", preXml=" + Arrays.toString(this.getPreXml()) + ", dimensionsDefaultJsonGzipped=" + Arrays.toString(this.getDimensionsDefaultJsonGzipped()) + ", enumerationsJsonGzipped=" + Arrays.toString(this.getEnumerationsJsonGzipped()) + ")";
    }
}

