/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.model.pkg;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import ru.cbr.xbrl.converter.model.Attachment;
import ru.cbr.xbrl.converter.model.UnitsConfiguration;
import ru.cbr.xbrl.converter.model.XbrlParameter;
import ru.cbr.xbrl.converter.model.XbrlPeriod;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.pkg.ContextPeriod;
import ru.cbr.xbrl.converter.model.pkg.ContextPeriodCode;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackageFile;
import ru.cbr.xbrl.converter.model_main.TaxonomyEntryPoint;

@Entity
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
public class XbrlPackage {
    public static final String PACKAGE_EXTENSION = ".pkg";
    @Id
    @GeneratedValue
    @XmlTransient
    private Long id;
    private String name;
    private String ogrn;
    private Integer year;
    private String nfoType;
    @Lob
    private String nfoTypeRus;
    private String reportType;
    @Column(length=4096)
    private String reportTypeRus;
    private String reportPeriodType;
    private String reportPeriodTypeRus;
    private String taxonomyVersion;
    @XmlTransient
    private String pathForPackage;
    @OneToOne(cascade={CascadeType.ALL}, mappedBy="xbrlPackage")
    private ContextPeriod contextPeriod;
    @OneToOne(cascade={CascadeType.ALL}, mappedBy="xbrlPackage")
    private XbrlReport xbrlReport;
    @JsonManagedReference
    @OneToMany(fetch=FetchType.LAZY, mappedBy="xbrlPackage", cascade={CascadeType.ALL}, orphanRemoval=true)
    @XmlElement(name="period")
    @XmlElementWrapper(name="periods")
    private List<XbrlPeriod> xbrlPackagePeriodList = new ArrayList();
    @JsonManagedReference
    @OneToMany(fetch=FetchType.LAZY, mappedBy="xbrlPackage", cascade={CascadeType.ALL}, orphanRemoval=true)
    @XmlElement(name="parameter")
    @XmlElementWrapper(name="parameters")
    private List<XbrlParameter> xbrlParameters = new ArrayList();
    private String pathToXsd;
    @OneToMany(cascade={CascadeType.ALL})
    @XmlElement(name="attachment")
    @XmlElementWrapper(name="attachments")
    private List<Attachment> attachments = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL})
    private List<XbrlPackageFile> files;
    @XmlTransient
    private Date uploadTime;
    @Transient
    @XmlElement
    private Map<String, DimensionList> presentationDefinitionInactiveOpenAxisMembers = new HashMap();
    @Transient
    @XmlElement
    private Map<String, DimensionList> presentationDefinitionInactiveClosedAxisMembers = new HashMap();
    @Transient
    @XmlElement
    private Map<String, DimensionList> tablelinkbaseInactiveOpenAxisMembers = new HashMap();
    @Transient
    @XmlElement
    private Map<String, DimensionList> tablelinkbaseInactiveClosedAxisMembers = new HashMap();
    @Transient
    private String error;
    @Transient
    @XmlTransient
    @JsonProperty(value="isMoveFacts")
    private boolean isMoveFacts;
    @Transient
    @XmlElement(name="unitsConfiguration")
    @XmlElementWrapper(name="unitsConfigurations")
    private List<UnitsConfiguration> unitsConfiguration = new ArrayList();

    public XbrlPackage() {
        this.uploadTime = new Date();
    }

    public void fillTaxonomyEntryPointInfo(TaxonomyEntryPoint entryPoint) {
        this.setNfoType(entryPoint.getNfoType());
        this.setNfoTypeRus(entryPoint.getNfoTypeRus());
        this.setReportType(entryPoint.getReportType());
        this.setReportTypeRus(entryPoint.getReportTypeRus());
        this.setReportPeriodType(entryPoint.getReportPeriodType());
        this.setReportPeriodTypeRus(entryPoint.getReportPeriodTypeRus());
    }

    public String generateXbrlName() {
        String prefix = "XBRL";
        String extension = "xml";
        return this.generateXbrlZipName(prefix, extension);
    }

    public String generateXbrlName(String prefix, String extension) {
        boolean isYearly = this.getReportPeriodType().equals(ContextPeriodCode.YEAR.name());
        String periodSuffix = !isYearly ? String.format("_%s%d", this.getReportPeriodType(), this.getContextPeriod().getPeriodNumber()) : "";
        return String.format("%s_%s_%s_%s_%s_%d%s.%s", prefix, this.getOgrn(), this.getNfoType(), this.getReportType(), this.getReportPeriodType(), this.getYear(), periodSuffix, extension);
    }

    public String generateXbrlZipName(String prefix, String extension) {
        Date packageDate = this.getContextPeriod() == null ? null : this.getContextPeriod().getEndDate();
        String entryPointXsdName = FilenameUtils.getBaseName((String)this.getPathToXsd());
        String name = StringUtils.join(Arrays.asList(prefix, this.getOgrn(), entryPointXsdName, DateFormatUtils.format((Date)packageDate, (String)"yyyyMMdd")), (char)'_');
        return name + "." + extension;
    }

    public void prepareForJson() {
        if (this.xbrlReport != null) {
            this.xbrlReport.prepareForJson();
        }
        if (this.contextPeriod != null) {
            this.contextPeriod.setXbrlPackage(null);
        }
    }

    public String getPkgPath() {
        return FilenameUtils.concat((String)this.pathForPackage, (String)(this.name + PACKAGE_EXTENSION));
    }

    public void initAllLazy() {
        if (this.files != null) {
            this.files.size();
        }
        this.xbrlPackagePeriodList.size();
        this.xbrlParameters.size();
        this.attachments.size();
        if (this.xbrlReport != null) {
            this.xbrlReport.initAllLazy();
        }
    }

    public XbrlParameter getRefPeriodEndValue(List<XbrlParameter> xbrlParameters) {
        for (XbrlParameter xbrlParameter : xbrlParameters) {
            String[] split;
            if (xbrlParameter == null || (split = StringUtils.split((String)xbrlParameter.getQName(), (String)":")) == null) continue;
            if (split.length == 2 && StringUtils.equals((CharSequence)split[1], (CharSequence)"refPeriodEnd")) {
                return xbrlParameter;
            }
            if (split.length != 1 || !StringUtils.equals((CharSequence)split[0], (CharSequence)"refPeriodEnd")) continue;
            return xbrlParameter;
        }
        return null;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getOgrn() {
        return this.ogrn;
    }

    public Integer getYear() {
        return this.year;
    }

    public String getNfoType() {
        return this.nfoType;
    }

    public String getNfoTypeRus() {
        return this.nfoTypeRus;
    }

    public String getReportType() {
        return this.reportType;
    }

    public String getReportTypeRus() {
        return this.reportTypeRus;
    }

    public String getReportPeriodType() {
        return this.reportPeriodType;
    }

    public String getReportPeriodTypeRus() {
        return this.reportPeriodTypeRus;
    }

    public String getTaxonomyVersion() {
        return this.taxonomyVersion;
    }

    public String getPathForPackage() {
        return this.pathForPackage;
    }

    public ContextPeriod getContextPeriod() {
        return this.contextPeriod;
    }

    public XbrlReport getXbrlReport() {
        return this.xbrlReport;
    }

    public List<XbrlPeriod> getXbrlPackagePeriodList() {
        return this.xbrlPackagePeriodList;
    }

    public List<XbrlParameter> getXbrlParameters() {
        return this.xbrlParameters;
    }

    public String getPathToXsd() {
        return this.pathToXsd;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public List<XbrlPackageFile> getFiles() {
        return this.files;
    }

    public Date getUploadTime() {
        return this.uploadTime;
    }

    public Map<String, DimensionList> getPresentationDefinitionInactiveOpenAxisMembers() {
        return this.presentationDefinitionInactiveOpenAxisMembers;
    }

    public Map<String, DimensionList> getPresentationDefinitionInactiveClosedAxisMembers() {
        return this.presentationDefinitionInactiveClosedAxisMembers;
    }

    public Map<String, DimensionList> getTablelinkbaseInactiveOpenAxisMembers() {
        return this.tablelinkbaseInactiveOpenAxisMembers;
    }

    public Map<String, DimensionList> getTablelinkbaseInactiveClosedAxisMembers() {
        return this.tablelinkbaseInactiveClosedAxisMembers;
    }

    public String getError() {
        return this.error;
    }

    public boolean isMoveFacts() {
        return this.isMoveFacts;
    }

    public List<UnitsConfiguration> getUnitsConfiguration() {
        return this.unitsConfiguration;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOgrn(String ogrn) {
        this.ogrn = ogrn;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public void setNfoType(String nfoType) {
        this.nfoType = nfoType;
    }

    public void setNfoTypeRus(String nfoTypeRus) {
        this.nfoTypeRus = nfoTypeRus;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public void setReportTypeRus(String reportTypeRus) {
        this.reportTypeRus = reportTypeRus;
    }

    public void setReportPeriodType(String reportPeriodType) {
        this.reportPeriodType = reportPeriodType;
    }

    public void setReportPeriodTypeRus(String reportPeriodTypeRus) {
        this.reportPeriodTypeRus = reportPeriodTypeRus;
    }

    public void setTaxonomyVersion(String taxonomyVersion) {
        this.taxonomyVersion = taxonomyVersion;
    }

    public void setPathForPackage(String pathForPackage) {
        this.pathForPackage = pathForPackage;
    }

    public void setContextPeriod(ContextPeriod contextPeriod) {
        this.contextPeriod = contextPeriod;
    }

    public void setXbrlReport(XbrlReport xbrlReport) {
        this.xbrlReport = xbrlReport;
    }

    public void setXbrlPackagePeriodList(List<XbrlPeriod> xbrlPackagePeriodList) {
        this.xbrlPackagePeriodList = xbrlPackagePeriodList;
    }

    public void setXbrlParameters(List<XbrlParameter> xbrlParameters) {
        this.xbrlParameters = xbrlParameters;
    }

    public void setPathToXsd(String pathToXsd) {
        this.pathToXsd = pathToXsd;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public void setFiles(List<XbrlPackageFile> files) {
        this.files = files;
    }

    public void setUploadTime(Date uploadTime) {
        this.uploadTime = uploadTime;
    }

    public void setPresentationDefinitionInactiveOpenAxisMembers(Map<String, DimensionList> presentationDefinitionInactiveOpenAxisMembers) {
        this.presentationDefinitionInactiveOpenAxisMembers = presentationDefinitionInactiveOpenAxisMembers;
    }

    public void setPresentationDefinitionInactiveClosedAxisMembers(Map<String, DimensionList> presentationDefinitionInactiveClosedAxisMembers) {
        this.presentationDefinitionInactiveClosedAxisMembers = presentationDefinitionInactiveClosedAxisMembers;
    }

    public void setTablelinkbaseInactiveOpenAxisMembers(Map<String, DimensionList> tablelinkbaseInactiveOpenAxisMembers) {
        this.tablelinkbaseInactiveOpenAxisMembers = tablelinkbaseInactiveOpenAxisMembers;
    }

    public void setTablelinkbaseInactiveClosedAxisMembers(Map<String, DimensionList> tablelinkbaseInactiveClosedAxisMembers) {
        this.tablelinkbaseInactiveClosedAxisMembers = tablelinkbaseInactiveClosedAxisMembers;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void setMoveFacts(boolean isMoveFacts) {
        this.isMoveFacts = isMoveFacts;
    }

    public void setUnitsConfiguration(List<UnitsConfiguration> unitsConfiguration) {
        this.unitsConfiguration = unitsConfiguration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XbrlPackage)) {
            return false;
        }
        XbrlPackage other = (XbrlPackage)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$ogrn = this.getOgrn();
        String other$ogrn = other.getOgrn();
        if (this$ogrn == null ? other$ogrn != null : !this$ogrn.equals(other$ogrn)) {
            return false;
        }
        Integer this$year = this.getYear();
        Integer other$year = other.getYear();
        if (this$year == null ? other$year != null : !((Object)this$year).equals(other$year)) {
            return false;
        }
        String this$nfoType = this.getNfoType();
        String other$nfoType = other.getNfoType();
        if (this$nfoType == null ? other$nfoType != null : !this$nfoType.equals(other$nfoType)) {
            return false;
        }
        String this$nfoTypeRus = this.getNfoTypeRus();
        String other$nfoTypeRus = other.getNfoTypeRus();
        if (this$nfoTypeRus == null ? other$nfoTypeRus != null : !this$nfoTypeRus.equals(other$nfoTypeRus)) {
            return false;
        }
        String this$reportType = this.getReportType();
        String other$reportType = other.getReportType();
        if (this$reportType == null ? other$reportType != null : !this$reportType.equals(other$reportType)) {
            return false;
        }
        String this$reportTypeRus = this.getReportTypeRus();
        String other$reportTypeRus = other.getReportTypeRus();
        if (this$reportTypeRus == null ? other$reportTypeRus != null : !this$reportTypeRus.equals(other$reportTypeRus)) {
            return false;
        }
        String this$reportPeriodType = this.getReportPeriodType();
        String other$reportPeriodType = other.getReportPeriodType();
        if (this$reportPeriodType == null ? other$reportPeriodType != null : !this$reportPeriodType.equals(other$reportPeriodType)) {
            return false;
        }
        String this$reportPeriodTypeRus = this.getReportPeriodTypeRus();
        String other$reportPeriodTypeRus = other.getReportPeriodTypeRus();
        if (this$reportPeriodTypeRus == null ? other$reportPeriodTypeRus != null : !this$reportPeriodTypeRus.equals(other$reportPeriodTypeRus)) {
            return false;
        }
        String this$taxonomyVersion = this.getTaxonomyVersion();
        String other$taxonomyVersion = other.getTaxonomyVersion();
        if (this$taxonomyVersion == null ? other$taxonomyVersion != null : !this$taxonomyVersion.equals(other$taxonomyVersion)) {
            return false;
        }
        String this$pathForPackage = this.getPathForPackage();
        String other$pathForPackage = other.getPathForPackage();
        if (this$pathForPackage == null ? other$pathForPackage != null : !this$pathForPackage.equals(other$pathForPackage)) {
            return false;
        }
        ContextPeriod this$contextPeriod = this.getContextPeriod();
        ContextPeriod other$contextPeriod = other.getContextPeriod();
        if (this$contextPeriod == null ? other$contextPeriod != null : !this$contextPeriod.equals(other$contextPeriod)) {
            return false;
        }
        XbrlReport this$xbrlReport = this.getXbrlReport();
        XbrlReport other$xbrlReport = other.getXbrlReport();
        if (this$xbrlReport == null ? other$xbrlReport != null : !this$xbrlReport.equals(other$xbrlReport)) {
            return false;
        }
        List this$xbrlPackagePeriodList = this.getXbrlPackagePeriodList();
        List other$xbrlPackagePeriodList = other.getXbrlPackagePeriodList();
        if (this$xbrlPackagePeriodList == null ? other$xbrlPackagePeriodList != null : !((Object)this$xbrlPackagePeriodList).equals(other$xbrlPackagePeriodList)) {
            return false;
        }
        List this$xbrlParameters = this.getXbrlParameters();
        List other$xbrlParameters = other.getXbrlParameters();
        if (this$xbrlParameters == null ? other$xbrlParameters != null : !((Object)this$xbrlParameters).equals(other$xbrlParameters)) {
            return false;
        }
        String this$pathToXsd = this.getPathToXsd();
        String other$pathToXsd = other.getPathToXsd();
        if (this$pathToXsd == null ? other$pathToXsd != null : !this$pathToXsd.equals(other$pathToXsd)) {
            return false;
        }
        List this$attachments = this.getAttachments();
        List other$attachments = other.getAttachments();
        if (this$attachments == null ? other$attachments != null : !((Object)this$attachments).equals(other$attachments)) {
            return false;
        }
        List this$files = this.getFiles();
        List other$files = other.getFiles();
        if (this$files == null ? other$files != null : !((Object)this$files).equals(other$files)) {
            return false;
        }
        Date this$uploadTime = this.getUploadTime();
        Date other$uploadTime = other.getUploadTime();
        if (this$uploadTime == null ? other$uploadTime != null : !((Object)this$uploadTime).equals(other$uploadTime)) {
            return false;
        }
        Map this$presentationDefinitionInactiveOpenAxisMembers = this.getPresentationDefinitionInactiveOpenAxisMembers();
        Map other$presentationDefinitionInactiveOpenAxisMembers = other.getPresentationDefinitionInactiveOpenAxisMembers();
        if (this$presentationDefinitionInactiveOpenAxisMembers == null ? other$presentationDefinitionInactiveOpenAxisMembers != null : !((Object)this$presentationDefinitionInactiveOpenAxisMembers).equals(other$presentationDefinitionInactiveOpenAxisMembers)) {
            return false;
        }
        Map this$presentationDefinitionInactiveClosedAxisMembers = this.getPresentationDefinitionInactiveClosedAxisMembers();
        Map other$presentationDefinitionInactiveClosedAxisMembers = other.getPresentationDefinitionInactiveClosedAxisMembers();
        if (this$presentationDefinitionInactiveClosedAxisMembers == null ? other$presentationDefinitionInactiveClosedAxisMembers != null : !((Object)this$presentationDefinitionInactiveClosedAxisMembers).equals(other$presentationDefinitionInactiveClosedAxisMembers)) {
            return false;
        }
        Map this$tablelinkbaseInactiveOpenAxisMembers = this.getTablelinkbaseInactiveOpenAxisMembers();
        Map other$tablelinkbaseInactiveOpenAxisMembers = other.getTablelinkbaseInactiveOpenAxisMembers();
        if (this$tablelinkbaseInactiveOpenAxisMembers == null ? other$tablelinkbaseInactiveOpenAxisMembers != null : !((Object)this$tablelinkbaseInactiveOpenAxisMembers).equals(other$tablelinkbaseInactiveOpenAxisMembers)) {
            return false;
        }
        Map this$tablelinkbaseInactiveClosedAxisMembers = this.getTablelinkbaseInactiveClosedAxisMembers();
        Map other$tablelinkbaseInactiveClosedAxisMembers = other.getTablelinkbaseInactiveClosedAxisMembers();
        if (this$tablelinkbaseInactiveClosedAxisMembers == null ? other$tablelinkbaseInactiveClosedAxisMembers != null : !((Object)this$tablelinkbaseInactiveClosedAxisMembers).equals(other$tablelinkbaseInactiveClosedAxisMembers)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
            return false;
        }
        if (this.isMoveFacts() != other.isMoveFacts()) {
            return false;
        }
        List this$unitsConfiguration = this.getUnitsConfiguration();
        List other$unitsConfiguration = other.getUnitsConfiguration();
        return !(this$unitsConfiguration == null ? other$unitsConfiguration != null : !((Object)this$unitsConfiguration).equals(other$unitsConfiguration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XbrlPackage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $ogrn = this.getOgrn();
        result = result * 59 + ($ogrn == null ? 43 : $ogrn.hashCode());
        Integer $year = this.getYear();
        result = result * 59 + ($year == null ? 43 : ((Object)$year).hashCode());
        String $nfoType = this.getNfoType();
        result = result * 59 + ($nfoType == null ? 43 : $nfoType.hashCode());
        String $nfoTypeRus = this.getNfoTypeRus();
        result = result * 59 + ($nfoTypeRus == null ? 43 : $nfoTypeRus.hashCode());
        String $reportType = this.getReportType();
        result = result * 59 + ($reportType == null ? 43 : $reportType.hashCode());
        String $reportTypeRus = this.getReportTypeRus();
        result = result * 59 + ($reportTypeRus == null ? 43 : $reportTypeRus.hashCode());
        String $reportPeriodType = this.getReportPeriodType();
        result = result * 59 + ($reportPeriodType == null ? 43 : $reportPeriodType.hashCode());
        String $reportPeriodTypeRus = this.getReportPeriodTypeRus();
        result = result * 59 + ($reportPeriodTypeRus == null ? 43 : $reportPeriodTypeRus.hashCode());
        String $taxonomyVersion = this.getTaxonomyVersion();
        result = result * 59 + ($taxonomyVersion == null ? 43 : $taxonomyVersion.hashCode());
        String $pathForPackage = this.getPathForPackage();
        result = result * 59 + ($pathForPackage == null ? 43 : $pathForPackage.hashCode());
        ContextPeriod $contextPeriod = this.getContextPeriod();
        result = result * 59 + ($contextPeriod == null ? 43 : $contextPeriod.hashCode());
        XbrlReport $xbrlReport = this.getXbrlReport();
        result = result * 59 + ($xbrlReport == null ? 43 : $xbrlReport.hashCode());
        List $xbrlPackagePeriodList = this.getXbrlPackagePeriodList();
        result = result * 59 + ($xbrlPackagePeriodList == null ? 43 : ((Object)$xbrlPackagePeriodList).hashCode());
        List $xbrlParameters = this.getXbrlParameters();
        result = result * 59 + ($xbrlParameters == null ? 43 : ((Object)$xbrlParameters).hashCode());
        String $pathToXsd = this.getPathToXsd();
        result = result * 59 + ($pathToXsd == null ? 43 : $pathToXsd.hashCode());
        List $attachments = this.getAttachments();
        result = result * 59 + ($attachments == null ? 43 : ((Object)$attachments).hashCode());
        List $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        Date $uploadTime = this.getUploadTime();
        result = result * 59 + ($uploadTime == null ? 43 : ((Object)$uploadTime).hashCode());
        Map $presentationDefinitionInactiveOpenAxisMembers = this.getPresentationDefinitionInactiveOpenAxisMembers();
        result = result * 59 + ($presentationDefinitionInactiveOpenAxisMembers == null ? 43 : ((Object)$presentationDefinitionInactiveOpenAxisMembers).hashCode());
        Map $presentationDefinitionInactiveClosedAxisMembers = this.getPresentationDefinitionInactiveClosedAxisMembers();
        result = result * 59 + ($presentationDefinitionInactiveClosedAxisMembers == null ? 43 : ((Object)$presentationDefinitionInactiveClosedAxisMembers).hashCode());
        Map $tablelinkbaseInactiveOpenAxisMembers = this.getTablelinkbaseInactiveOpenAxisMembers();
        result = result * 59 + ($tablelinkbaseInactiveOpenAxisMembers == null ? 43 : ((Object)$tablelinkbaseInactiveOpenAxisMembers).hashCode());
        Map $tablelinkbaseInactiveClosedAxisMembers = this.getTablelinkbaseInactiveClosedAxisMembers();
        result = result * 59 + ($tablelinkbaseInactiveClosedAxisMembers == null ? 43 : ((Object)$tablelinkbaseInactiveClosedAxisMembers).hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        result = result * 59 + (this.isMoveFacts() ? 79 : 97);
        List $unitsConfiguration = this.getUnitsConfiguration();
        result = result * 59 + ($unitsConfiguration == null ? 43 : ((Object)$unitsConfiguration).hashCode());
        return result;
    }

    public String toString() {
        return "XbrlPackage(id=" + this.getId() + ", name=" + this.getName() + ", ogrn=" + this.getOgrn() + ", year=" + this.getYear() + ", nfoType=" + this.getNfoType() + ", nfoTypeRus=" + this.getNfoTypeRus() + ", reportType=" + this.getReportType() + ", reportTypeRus=" + this.getReportTypeRus() + ", reportPeriodType=" + this.getReportPeriodType() + ", reportPeriodTypeRus=" + this.getReportPeriodTypeRus() + ", taxonomyVersion=" + this.getTaxonomyVersion() + ", pathForPackage=" + this.getPathForPackage() + ", contextPeriod=" + this.getContextPeriod() + ", xbrlReport=" + this.getXbrlReport() + ", xbrlPackagePeriodList=" + this.getXbrlPackagePeriodList() + ", xbrlParameters=" + this.getXbrlParameters() + ", pathToXsd=" + this.getPathToXsd() + ", attachments=" + this.getAttachments() + ", files=" + this.getFiles() + ", uploadTime=" + this.getUploadTime() + ", presentationDefinitionInactiveOpenAxisMembers=" + this.getPresentationDefinitionInactiveOpenAxisMembers() + ", presentationDefinitionInactiveClosedAxisMembers=" + this.getPresentationDefinitionInactiveClosedAxisMembers() + ", tablelinkbaseInactiveOpenAxisMembers=" + this.getTablelinkbaseInactiveOpenAxisMembers() + ", tablelinkbaseInactiveClosedAxisMembers=" + this.getTablelinkbaseInactiveClosedAxisMembers() + ", error=" + this.getError() + ", isMoveFacts=" + this.isMoveFacts() + ", unitsConfiguration=" + this.getUnitsConfiguration() + ")";
    }
}

