/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.model.pkg.report;

import java.util.Date;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import ru.cbr.xbrl.converter.model.pkg.ContextPeriod;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackageFile;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackageFiles;
import ru.cbr.xbrl.converter.model.pkg.report.ReportingPackage;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="ServiceInfo")
public class ReportingPackage {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    @XmlElement(name="Name")
    private String name;
    @XmlElement(name="Type_Message")
    private TypeMessage typeMessage;
    @XmlElement(name="Files")
    private XbrlPackageFiles xbrlPackageFiles;
    @XmlElement(name="ReportDate")
    private String reportDate;

    public ReportingPackage(XbrlPackage xbrlPackage, Date packageDate) {
        this.name = xbrlPackage.generateXbrlZipName("Service", "xml");
        this.typeMessage = TypeMessage.XBRL;
        ContextPeriod contextPeriod = xbrlPackage.getContextPeriod();
        if (contextPeriod != null) {
            packageDate = contextPeriod.getEndDate();
        }
        DateTime packageCreated = new DateTime((Object)packageDate);
        this.reportDate = DATE_TIME_FORMATTER.print((ReadableInstant)packageCreated);
        XbrlPackageFiles xbrlPackageFiles = new XbrlPackageFiles();
        this.setXbrlPackageFiles(xbrlPackageFiles);
        if (xbrlPackage.getXbrlReport() != null) {
            String fileDescription = "XBRL \u0444\u0430\u0439\u043b \u043f\u0430\u043a\u0435\u0442\u0430 \u043e\u0442\u0447\u0451\u0442\u043d\u043e\u0441\u0442\u0438";
            XbrlPackageFile xbrlPackageFile = new XbrlPackageFile(xbrlPackage.generateXbrlZipName("XBRL", "xml"), fileDescription);
            xbrlPackageFiles.getFiles().add(xbrlPackageFile);
            xbrlPackageFiles.getFiles().addAll(xbrlPackage.getAttachments().stream().map(attachment -> new XbrlPackageFile(attachment.getName(), attachment.getDescription())).collect(Collectors.toList()));
        }
    }

    public String getName() {
        return this.name;
    }

    public TypeMessage getTypeMessage() {
        return this.typeMessage;
    }

    public XbrlPackageFiles getXbrlPackageFiles() {
        return this.xbrlPackageFiles;
    }

    public String getReportDate() {
        return this.reportDate;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTypeMessage(TypeMessage typeMessage) {
        this.typeMessage = typeMessage;
    }

    public void setXbrlPackageFiles(XbrlPackageFiles xbrlPackageFiles) {
        this.xbrlPackageFiles = xbrlPackageFiles;
    }

    public void setReportDate(String reportDate) {
        this.reportDate = reportDate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReportingPackage)) {
            return false;
        }
        ReportingPackage other = (ReportingPackage)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        TypeMessage this$typeMessage = this.getTypeMessage();
        TypeMessage other$typeMessage = other.getTypeMessage();
        if (this$typeMessage == null ? other$typeMessage != null : !this$typeMessage.equals(other$typeMessage)) {
            return false;
        }
        XbrlPackageFiles this$xbrlPackageFiles = this.getXbrlPackageFiles();
        XbrlPackageFiles other$xbrlPackageFiles = other.getXbrlPackageFiles();
        if (this$xbrlPackageFiles == null ? other$xbrlPackageFiles != null : !this$xbrlPackageFiles.equals(other$xbrlPackageFiles)) {
            return false;
        }
        String this$reportDate = this.getReportDate();
        String other$reportDate = other.getReportDate();
        return !(this$reportDate == null ? other$reportDate != null : !this$reportDate.equals(other$reportDate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReportingPackage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        TypeMessage $typeMessage = this.getTypeMessage();
        result = result * 59 + ($typeMessage == null ? 43 : $typeMessage.hashCode());
        XbrlPackageFiles $xbrlPackageFiles = this.getXbrlPackageFiles();
        result = result * 59 + ($xbrlPackageFiles == null ? 43 : $xbrlPackageFiles.hashCode());
        String $reportDate = this.getReportDate();
        result = result * 59 + ($reportDate == null ? 43 : $reportDate.hashCode());
        return result;
    }

    public String toString() {
        return "ReportingPackage(name=" + this.getName() + ", typeMessage=" + this.getTypeMessage() + ", xbrlPackageFiles=" + this.getXbrlPackageFiles() + ", reportDate=" + this.getReportDate() + ")";
    }

    public ReportingPackage() {
    }
}

