/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.model.tableLinkBase;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import ru.cbr.xbrl.converter.model.tableLinkBase.NodeType;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AxisMemberHierarchy {
    private String axis;
    private String label;
    private String id;
    private String hash;
    private NodeType nodeType = NodeType.RULE;
    private List<String> childAspectNodes;
    private List<AxisMemberHierarchy> axisMemberHierarchyList = new LinkedList();
    private List<AspectData> aspectDataList = new ArrayList();
    private boolean abstractNode;
    private String nodeTagSelector;
    private String definitionNodeId;
    private String parentDefinitionNodeId;
    private String unitRole;
    private String rcCode;

    public void iterate(BiConsumer<AxisMemberHierarchy, List<AxisMemberHierarchy>> consumer) {
        this.iterate(consumer, new ArrayList());
    }

    private void iterate(BiConsumer<AxisMemberHierarchy, List<AxisMemberHierarchy>> consumer, List<AxisMemberHierarchy> parents) {
        consumer.accept(this, parents);
        ArrayList<AxisMemberHierarchy> newParents = new ArrayList<AxisMemberHierarchy>();
        newParents.addAll(parents);
        newParents.add(this);
        this.axisMemberHierarchyList.forEach(axisMemberHierarchy -> axisMemberHierarchy.iterate(consumer, newParents));
    }

    public Set<String> findDimensionsOfAspectNodes() {
        HashSet<String> aspectNodesDimensions = new HashSet<String>();
        this.iterate((node, parents) -> {
            if (node.getNodeType() == NodeType.ASPECT) {
                List dimensions = new AspectCellData(node.getAspectDataList()).getDimensions().stream().map(AspectData::getAspect).collect(Collectors.toList());
                aspectNodesDimensions.addAll(dimensions);
            }
        });
        return aspectNodesDimensions;
    }

    public Map<String, String> findDimensionPatterns() {
        HashMap<String, String> aspectNodesDimensions = new HashMap<String, String>();
        this.iterate((node, parents) -> {
            Map<String, String> dimensions = new AspectCellData(node.getAspectDataList()).getDimensions().stream().filter(d -> StringUtils.isNotBlank((CharSequence)d.getPattern())).collect(Collectors.toMap(AspectData::getAspect, AspectData::getPattern));
            aspectNodesDimensions.putAll(dimensions);
        });
        return aspectNodesDimensions;
    }

    public void printDimensions(int indent) {
        AspectData aspectData = this.getAspectDataList().stream().findFirst().orElse(new AspectData());
        String pad = StringUtils.leftPad((String)" ", (int)(indent * 4));
        String label = pad + aspectData.getAspect() + "  ->  " + aspectData.getAspectValue();
        System.out.println(label);
        this.getAxisMemberHierarchyList().stream().forEach(axisMemberHierarchy -> axisMemberHierarchy.printDimensions(indent + 1));
    }

    public String getAxis() {
        return this.axis;
    }

    public String getLabel() {
        return this.label;
    }

    public String getId() {
        return this.id;
    }

    public String getHash() {
        return this.hash;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public List<String> getChildAspectNodes() {
        return this.childAspectNodes;
    }

    public List<AxisMemberHierarchy> getAxisMemberHierarchyList() {
        return this.axisMemberHierarchyList;
    }

    public List<AspectData> getAspectDataList() {
        return this.aspectDataList;
    }

    public boolean isAbstractNode() {
        return this.abstractNode;
    }

    public String getNodeTagSelector() {
        return this.nodeTagSelector;
    }

    public String getDefinitionNodeId() {
        return this.definitionNodeId;
    }

    public String getParentDefinitionNodeId() {
        return this.parentDefinitionNodeId;
    }

    public String getUnitRole() {
        return this.unitRole;
    }

    public String getRcCode() {
        return this.rcCode;
    }

    public void setAxis(String axis) {
        this.axis = axis;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setNodeType(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public void setChildAspectNodes(List<String> childAspectNodes) {
        this.childAspectNodes = childAspectNodes;
    }

    public void setAxisMemberHierarchyList(List<AxisMemberHierarchy> axisMemberHierarchyList) {
        this.axisMemberHierarchyList = axisMemberHierarchyList;
    }

    public void setAspectDataList(List<AspectData> aspectDataList) {
        this.aspectDataList = aspectDataList;
    }

    public void setAbstractNode(boolean abstractNode) {
        this.abstractNode = abstractNode;
    }

    public void setNodeTagSelector(String nodeTagSelector) {
        this.nodeTagSelector = nodeTagSelector;
    }

    public void setDefinitionNodeId(String definitionNodeId) {
        this.definitionNodeId = definitionNodeId;
    }

    public void setParentDefinitionNodeId(String parentDefinitionNodeId) {
        this.parentDefinitionNodeId = parentDefinitionNodeId;
    }

    public void setUnitRole(String unitRole) {
        this.unitRole = unitRole;
    }

    public void setRcCode(String rcCode) {
        this.rcCode = rcCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AxisMemberHierarchy)) {
            return false;
        }
        AxisMemberHierarchy other = (AxisMemberHierarchy)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$axis = this.getAxis();
        String other$axis = other.getAxis();
        if (this$axis == null ? other$axis != null : !this$axis.equals(other$axis)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        NodeType this$nodeType = this.getNodeType();
        NodeType other$nodeType = other.getNodeType();
        if (this$nodeType == null ? other$nodeType != null : !this$nodeType.equals(other$nodeType)) {
            return false;
        }
        List this$childAspectNodes = this.getChildAspectNodes();
        List other$childAspectNodes = other.getChildAspectNodes();
        if (this$childAspectNodes == null ? other$childAspectNodes != null : !((Object)this$childAspectNodes).equals(other$childAspectNodes)) {
            return false;
        }
        List this$axisMemberHierarchyList = this.getAxisMemberHierarchyList();
        List other$axisMemberHierarchyList = other.getAxisMemberHierarchyList();
        if (this$axisMemberHierarchyList == null ? other$axisMemberHierarchyList != null : !((Object)this$axisMemberHierarchyList).equals(other$axisMemberHierarchyList)) {
            return false;
        }
        List this$aspectDataList = this.getAspectDataList();
        List other$aspectDataList = other.getAspectDataList();
        if (this$aspectDataList == null ? other$aspectDataList != null : !((Object)this$aspectDataList).equals(other$aspectDataList)) {
            return false;
        }
        if (this.isAbstractNode() != other.isAbstractNode()) {
            return false;
        }
        String this$nodeTagSelector = this.getNodeTagSelector();
        String other$nodeTagSelector = other.getNodeTagSelector();
        if (this$nodeTagSelector == null ? other$nodeTagSelector != null : !this$nodeTagSelector.equals(other$nodeTagSelector)) {
            return false;
        }
        String this$definitionNodeId = this.getDefinitionNodeId();
        String other$definitionNodeId = other.getDefinitionNodeId();
        if (this$definitionNodeId == null ? other$definitionNodeId != null : !this$definitionNodeId.equals(other$definitionNodeId)) {
            return false;
        }
        String this$parentDefinitionNodeId = this.getParentDefinitionNodeId();
        String other$parentDefinitionNodeId = other.getParentDefinitionNodeId();
        if (this$parentDefinitionNodeId == null ? other$parentDefinitionNodeId != null : !this$parentDefinitionNodeId.equals(other$parentDefinitionNodeId)) {
            return false;
        }
        String this$unitRole = this.getUnitRole();
        String other$unitRole = other.getUnitRole();
        if (this$unitRole == null ? other$unitRole != null : !this$unitRole.equals(other$unitRole)) {
            return false;
        }
        String this$rcCode = this.getRcCode();
        String other$rcCode = other.getRcCode();
        return !(this$rcCode == null ? other$rcCode != null : !this$rcCode.equals(other$rcCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AxisMemberHierarchy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $axis = this.getAxis();
        result = result * 59 + ($axis == null ? 43 : $axis.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        NodeType $nodeType = this.getNodeType();
        result = result * 59 + ($nodeType == null ? 43 : $nodeType.hashCode());
        List $childAspectNodes = this.getChildAspectNodes();
        result = result * 59 + ($childAspectNodes == null ? 43 : ((Object)$childAspectNodes).hashCode());
        List $axisMemberHierarchyList = this.getAxisMemberHierarchyList();
        result = result * 59 + ($axisMemberHierarchyList == null ? 43 : ((Object)$axisMemberHierarchyList).hashCode());
        List $aspectDataList = this.getAspectDataList();
        result = result * 59 + ($aspectDataList == null ? 43 : ((Object)$aspectDataList).hashCode());
        result = result * 59 + (this.isAbstractNode() ? 79 : 97);
        String $nodeTagSelector = this.getNodeTagSelector();
        result = result * 59 + ($nodeTagSelector == null ? 43 : $nodeTagSelector.hashCode());
        String $definitionNodeId = this.getDefinitionNodeId();
        result = result * 59 + ($definitionNodeId == null ? 43 : $definitionNodeId.hashCode());
        String $parentDefinitionNodeId = this.getParentDefinitionNodeId();
        result = result * 59 + ($parentDefinitionNodeId == null ? 43 : $parentDefinitionNodeId.hashCode());
        String $unitRole = this.getUnitRole();
        result = result * 59 + ($unitRole == null ? 43 : $unitRole.hashCode());
        String $rcCode = this.getRcCode();
        result = result * 59 + ($rcCode == null ? 43 : $rcCode.hashCode());
        return result;
    }

    public String toString() {
        return "AxisMemberHierarchy(axis=" + this.getAxis() + ", label=" + this.getLabel() + ", id=" + this.getId() + ", hash=" + this.getHash() + ", nodeType=" + this.getNodeType() + ", childAspectNodes=" + this.getChildAspectNodes() + ", axisMemberHierarchyList=" + this.getAxisMemberHierarchyList() + ", aspectDataList=" + this.getAspectDataList() + ", abstractNode=" + this.isAbstractNode() + ", nodeTagSelector=" + this.getNodeTagSelector() + ", definitionNodeId=" + this.getDefinitionNodeId() + ", parentDefinitionNodeId=" + this.getParentDefinitionNodeId() + ", unitRole=" + this.getUnitRole() + ", rcCode=" + this.getRcCode() + ")";
    }
}

