/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.model.xbrl_content;

import java.util.Arrays;
import java.util.List;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlUnitId;

@Entity
public class XbrlUnit {
    @EmbeddedId
    private XbrlUnitId xbrlUnitId = new XbrlUnitId();
    private String measure;
    private String numeratorMeasure;
    private String denominatorMeasure;
    @Transient
    private String rawContent;

    @Transient
    public String getContent() {
        return this.measure != null ? this.measure : this.numeratorMeasure + " / " + this.denominatorMeasure;
    }

    @Transient
    public void setContent(String content) {
        this.rawContent = content;
        if (content.contains("/")) {
            String[] splitted = content.split("\\s+/\\s+");
            this.numeratorMeasure = splitted[0];
            this.denominatorMeasure = splitted[1];
        } else {
            this.measure = content;
        }
    }

    public static boolean isMonetary(XbrlUnit xbrlUnit) {
        List<String> nonMonetary = Arrays.asList("PURE", "SHARES");
        return !nonMonetary.contains(xbrlUnit.getXbrlUnitId().getUnitId());
    }

    public XbrlUnitId getXbrlUnitId() {
        return this.xbrlUnitId;
    }

    public String getMeasure() {
        return this.measure;
    }

    public String getNumeratorMeasure() {
        return this.numeratorMeasure;
    }

    public String getDenominatorMeasure() {
        return this.denominatorMeasure;
    }

    public String getRawContent() {
        return this.rawContent;
    }

    public void setXbrlUnitId(XbrlUnitId xbrlUnitId) {
        this.xbrlUnitId = xbrlUnitId;
    }

    public void setMeasure(String measure) {
        this.measure = measure;
    }

    public void setNumeratorMeasure(String numeratorMeasure) {
        this.numeratorMeasure = numeratorMeasure;
    }

    public void setDenominatorMeasure(String denominatorMeasure) {
        this.denominatorMeasure = denominatorMeasure;
    }

    public void setRawContent(String rawContent) {
        this.rawContent = rawContent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XbrlUnit)) {
            return false;
        }
        XbrlUnit other = (XbrlUnit)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        XbrlUnitId this$xbrlUnitId = this.getXbrlUnitId();
        XbrlUnitId other$xbrlUnitId = other.getXbrlUnitId();
        if (this$xbrlUnitId == null ? other$xbrlUnitId != null : !this$xbrlUnitId.equals(other$xbrlUnitId)) {
            return false;
        }
        String this$measure = this.getMeasure();
        String other$measure = other.getMeasure();
        if (this$measure == null ? other$measure != null : !this$measure.equals(other$measure)) {
            return false;
        }
        String this$numeratorMeasure = this.getNumeratorMeasure();
        String other$numeratorMeasure = other.getNumeratorMeasure();
        if (this$numeratorMeasure == null ? other$numeratorMeasure != null : !this$numeratorMeasure.equals(other$numeratorMeasure)) {
            return false;
        }
        String this$denominatorMeasure = this.getDenominatorMeasure();
        String other$denominatorMeasure = other.getDenominatorMeasure();
        if (this$denominatorMeasure == null ? other$denominatorMeasure != null : !this$denominatorMeasure.equals(other$denominatorMeasure)) {
            return false;
        }
        String this$rawContent = this.getRawContent();
        String other$rawContent = other.getRawContent();
        return !(this$rawContent == null ? other$rawContent != null : !this$rawContent.equals(other$rawContent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XbrlUnit;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        XbrlUnitId $xbrlUnitId = this.getXbrlUnitId();
        result = result * 59 + ($xbrlUnitId == null ? 43 : $xbrlUnitId.hashCode());
        String $measure = this.getMeasure();
        result = result * 59 + ($measure == null ? 43 : $measure.hashCode());
        String $numeratorMeasure = this.getNumeratorMeasure();
        result = result * 59 + ($numeratorMeasure == null ? 43 : $numeratorMeasure.hashCode());
        String $denominatorMeasure = this.getDenominatorMeasure();
        result = result * 59 + ($denominatorMeasure == null ? 43 : $denominatorMeasure.hashCode());
        String $rawContent = this.getRawContent();
        result = result * 59 + ($rawContent == null ? 43 : $rawContent.hashCode());
        return result;
    }

    public String toString() {
        return "XbrlUnit(xbrlUnitId=" + this.getXbrlUnitId() + ", measure=" + this.getMeasure() + ", numeratorMeasure=" + this.getNumeratorMeasure() + ", denominatorMeasure=" + this.getDenominatorMeasure() + ", rawContent=" + this.getRawContent() + ")";
    }
}

