/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.model.xbrl_content;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.model.DataType;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContext;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValueId;
import ru.cbr.xbrl.converter.utils.GzipUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;

@Entity
@Table(indexes={@Index(name="idx_xbrl_value_datatype", columnList="dataType"), @Index(name="idx_xbrl_value_guid", columnList="guid"), @Index(name="idx_xbrl_value_xbrlunit", columnList="xbrlUnit"), @Index(name="idx_xbrl_value_contextid", columnList="xbrlContextId"), @Index(name="idx_xbrl_value_element_label", columnList="elementLabel")})
public class XbrlValue
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(XbrlValue.class);
    public static final int CSV_COL_CONTEXT = 5;
    public static final int CSV_COL_UNIT = 6;
    @EmbeddedId
    private XbrlValueId xbrlValueId = new XbrlValueId();
    @Enumerated(value=EnumType.STRING)
    private DataType dataType;
    private String elementUri;
    @Column(length=2048)
    private String elementName;
    @Lob
    private String value;
    private String nil;
    private String xbrlUnit;
    private String tuple;
    private Integer precision;
    private Integer decimals;
    private String lang;
    private String contextIdHash;
    @Column(length=8092)
    private String id;
    private String guid;
    @Lob
    @JsonIgnore
    @XmlTransient
    private byte[] aspectDataJson;
    @Transient
    private List<AspectData> aspectDataList;

    public void unpackAspectDataList() {
        try {
            String json = GzipUtils.decompressString((byte[])this.aspectDataJson);
            ObjectMapper objectMapper = new ObjectMapper();
            List aspectDataList = (List)objectMapper.readValue((Reader)new StringReader(json), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            this.setAspectDataList(aspectDataList);
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new RuntimeException("Unpack value aspectData error");
        }
    }

    public void packAspectDataList() {
        ObjectMapper objectMapper = new ObjectMapper();
        String aspectDataList = null;
        try {
            aspectDataList = objectMapper.writeValueAsString((Object)this.getAspectDataList());
            this.setAspectDataJson(GzipUtils.compressString((String)aspectDataList));
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new RuntimeException("Unpack value aspectData error");
        }
    }

    public void buildAspectDataList(XbrlContext xbrlContext) {
        AspectData conceptAspect = new AspectData();
        conceptAspect.setAspect("concept");
        conceptAspect.setAspectValue(this.getXbrlValueId().getElementLabel());
        conceptAspect.setType(AspectType.CONCEPT);
        conceptAspect.setConceptPeriodType(xbrlContext.getPeriodType());
        this.setAspectDataList(new ArrayList());
        this.getAspectDataList().add(conceptAspect);
        conceptAspect.setConceptDataType(this.getDataType());
        if (xbrlContext.getAspectDataList() != null) {
            this.getAspectDataList().addAll(xbrlContext.getAspectDataList());
        }
        this.packAspectDataList();
    }

    public void buildGuid() {
        String uidString = this.getXbrlValueId().getXbrlContextId() + " " + this.getXbrlValueId().getElementLabel() + " " + this.getXbrlValueId().getXbrlReportId();
        this.guid = DigestUtils.md5Hex((String)uidString);
    }

    public XbrlValueId getXbrlValueId() {
        return this.xbrlValueId;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public String getElementUri() {
        return this.elementUri;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getValue() {
        return this.value;
    }

    public String getNil() {
        return this.nil;
    }

    public String getXbrlUnit() {
        return this.xbrlUnit;
    }

    public String getTuple() {
        return this.tuple;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public Integer getDecimals() {
        return this.decimals;
    }

    public String getLang() {
        return this.lang;
    }

    public String getContextIdHash() {
        return this.contextIdHash;
    }

    public String getId() {
        return this.id;
    }

    public String getGuid() {
        return this.guid;
    }

    public byte[] getAspectDataJson() {
        return this.aspectDataJson;
    }

    public List<AspectData> getAspectDataList() {
        return this.aspectDataList;
    }

    public void setXbrlValueId(XbrlValueId xbrlValueId) {
        this.xbrlValueId = xbrlValueId;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public void setElementUri(String elementUri) {
        this.elementUri = elementUri;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setNil(String nil) {
        this.nil = nil;
    }

    public void setXbrlUnit(String xbrlUnit) {
        this.xbrlUnit = xbrlUnit;
    }

    public void setTuple(String tuple) {
        this.tuple = tuple;
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    public void setDecimals(Integer decimals) {
        this.decimals = decimals;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public void setContextIdHash(String contextIdHash) {
        this.contextIdHash = contextIdHash;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public void setAspectDataJson(byte[] aspectDataJson) {
        this.aspectDataJson = aspectDataJson;
    }

    public void setAspectDataList(List<AspectData> aspectDataList) {
        this.aspectDataList = aspectDataList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XbrlValue)) {
            return false;
        }
        XbrlValue other = (XbrlValue)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        XbrlValueId this$xbrlValueId = this.getXbrlValueId();
        XbrlValueId other$xbrlValueId = other.getXbrlValueId();
        if (this$xbrlValueId == null ? other$xbrlValueId != null : !this$xbrlValueId.equals(other$xbrlValueId)) {
            return false;
        }
        DataType this$dataType = this.getDataType();
        DataType other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        String this$elementUri = this.getElementUri();
        String other$elementUri = other.getElementUri();
        if (this$elementUri == null ? other$elementUri != null : !this$elementUri.equals(other$elementUri)) {
            return false;
        }
        String this$elementName = this.getElementName();
        String other$elementName = other.getElementName();
        if (this$elementName == null ? other$elementName != null : !this$elementName.equals(other$elementName)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$nil = this.getNil();
        String other$nil = other.getNil();
        if (this$nil == null ? other$nil != null : !this$nil.equals(other$nil)) {
            return false;
        }
        String this$xbrlUnit = this.getXbrlUnit();
        String other$xbrlUnit = other.getXbrlUnit();
        if (this$xbrlUnit == null ? other$xbrlUnit != null : !this$xbrlUnit.equals(other$xbrlUnit)) {
            return false;
        }
        String this$tuple = this.getTuple();
        String other$tuple = other.getTuple();
        if (this$tuple == null ? other$tuple != null : !this$tuple.equals(other$tuple)) {
            return false;
        }
        Integer this$precision = this.getPrecision();
        Integer other$precision = other.getPrecision();
        if (this$precision == null ? other$precision != null : !((Object)this$precision).equals(other$precision)) {
            return false;
        }
        Integer this$decimals = this.getDecimals();
        Integer other$decimals = other.getDecimals();
        if (this$decimals == null ? other$decimals != null : !((Object)this$decimals).equals(other$decimals)) {
            return false;
        }
        String this$lang = this.getLang();
        String other$lang = other.getLang();
        if (this$lang == null ? other$lang != null : !this$lang.equals(other$lang)) {
            return false;
        }
        String this$contextIdHash = this.getContextIdHash();
        String other$contextIdHash = other.getContextIdHash();
        if (this$contextIdHash == null ? other$contextIdHash != null : !this$contextIdHash.equals(other$contextIdHash)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$guid = this.getGuid();
        String other$guid = other.getGuid();
        if (this$guid == null ? other$guid != null : !this$guid.equals(other$guid)) {
            return false;
        }
        if (!Arrays.equals(this.getAspectDataJson(), other.getAspectDataJson())) {
            return false;
        }
        List this$aspectDataList = this.getAspectDataList();
        List other$aspectDataList = other.getAspectDataList();
        return !(this$aspectDataList == null ? other$aspectDataList != null : !((Object)this$aspectDataList).equals(other$aspectDataList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XbrlValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        XbrlValueId $xbrlValueId = this.getXbrlValueId();
        result = result * 59 + ($xbrlValueId == null ? 43 : $xbrlValueId.hashCode());
        DataType $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        String $elementUri = this.getElementUri();
        result = result * 59 + ($elementUri == null ? 43 : $elementUri.hashCode());
        String $elementName = this.getElementName();
        result = result * 59 + ($elementName == null ? 43 : $elementName.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $nil = this.getNil();
        result = result * 59 + ($nil == null ? 43 : $nil.hashCode());
        String $xbrlUnit = this.getXbrlUnit();
        result = result * 59 + ($xbrlUnit == null ? 43 : $xbrlUnit.hashCode());
        String $tuple = this.getTuple();
        result = result * 59 + ($tuple == null ? 43 : $tuple.hashCode());
        Integer $precision = this.getPrecision();
        result = result * 59 + ($precision == null ? 43 : ((Object)$precision).hashCode());
        Integer $decimals = this.getDecimals();
        result = result * 59 + ($decimals == null ? 43 : ((Object)$decimals).hashCode());
        String $lang = this.getLang();
        result = result * 59 + ($lang == null ? 43 : $lang.hashCode());
        String $contextIdHash = this.getContextIdHash();
        result = result * 59 + ($contextIdHash == null ? 43 : $contextIdHash.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $guid = this.getGuid();
        result = result * 59 + ($guid == null ? 43 : $guid.hashCode());
        result = result * 59 + Arrays.hashCode(this.getAspectDataJson());
        List $aspectDataList = this.getAspectDataList();
        result = result * 59 + ($aspectDataList == null ? 43 : ((Object)$aspectDataList).hashCode());
        return result;
    }

    public String toString() {
        return "XbrlValue(xbrlValueId=" + this.getXbrlValueId() + ", dataType=" + this.getDataType() + ", elementUri=" + this.getElementUri() + ", elementName=" + this.getElementName() + ", value=" + this.getValue() + ", nil=" + this.getNil() + ", xbrlUnit=" + this.getXbrlUnit() + ", tuple=" + this.getTuple() + ", precision=" + this.getPrecision() + ", decimals=" + this.getDecimals() + ", lang=" + this.getLang() + ", contextIdHash=" + this.getContextIdHash() + ", id=" + this.getId() + ", guid=" + this.getGuid() + ", aspectDataList=" + this.getAspectDataList() + ")";
    }
}

