/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.model_main;

import com.fasterxml.jackson.annotation.JsonManagedReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import ru.cbr.xbrl.converter.model_main.TaxonomyEntryPoint;

@Entity
public class Taxonomy {
    @Id
    @GeneratedValue
    private Long id;
    private String fileName;
    private Date uploadTime;
    private String filePath;
    private Boolean active;
    private String taxonomyPackageIdentifier;
    private String taxonomyPackageName;
    private String taxonomyPackageVersion;
    private String descriptionVersion;
    private Date descriptionDateBegin;
    private Date descriptionDateEnd;
    private Date descriptionDatePublic;
    private String descriptionComments;
    @JsonManagedReference
    @OneToMany(mappedBy="taxonomy", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<TaxonomyEntryPoint> taxonomyEntryPoints = new ArrayList();

    public TaxonomyEntryPoint getEntryPointByXsdPath(String pathToXsd) {
        return this.taxonomyEntryPoints.stream().filter(ep -> ep.getPathToXsd().equals(pathToXsd)).findFirst().orElse(null);
    }

    public Long getId() {
        return this.id;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Date getUploadTime() {
        return this.uploadTime;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public Boolean getActive() {
        return this.active;
    }

    public String getTaxonomyPackageIdentifier() {
        return this.taxonomyPackageIdentifier;
    }

    public String getTaxonomyPackageName() {
        return this.taxonomyPackageName;
    }

    public String getTaxonomyPackageVersion() {
        return this.taxonomyPackageVersion;
    }

    public String getDescriptionVersion() {
        return this.descriptionVersion;
    }

    public Date getDescriptionDateBegin() {
        return this.descriptionDateBegin;
    }

    public Date getDescriptionDateEnd() {
        return this.descriptionDateEnd;
    }

    public Date getDescriptionDatePublic() {
        return this.descriptionDatePublic;
    }

    public String getDescriptionComments() {
        return this.descriptionComments;
    }

    public List<TaxonomyEntryPoint> getTaxonomyEntryPoints() {
        return this.taxonomyEntryPoints;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setUploadTime(Date uploadTime) {
        this.uploadTime = uploadTime;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public void setTaxonomyPackageIdentifier(String taxonomyPackageIdentifier) {
        this.taxonomyPackageIdentifier = taxonomyPackageIdentifier;
    }

    public void setTaxonomyPackageName(String taxonomyPackageName) {
        this.taxonomyPackageName = taxonomyPackageName;
    }

    public void setTaxonomyPackageVersion(String taxonomyPackageVersion) {
        this.taxonomyPackageVersion = taxonomyPackageVersion;
    }

    public void setDescriptionVersion(String descriptionVersion) {
        this.descriptionVersion = descriptionVersion;
    }

    public void setDescriptionDateBegin(Date descriptionDateBegin) {
        this.descriptionDateBegin = descriptionDateBegin;
    }

    public void setDescriptionDateEnd(Date descriptionDateEnd) {
        this.descriptionDateEnd = descriptionDateEnd;
    }

    public void setDescriptionDatePublic(Date descriptionDatePublic) {
        this.descriptionDatePublic = descriptionDatePublic;
    }

    public void setDescriptionComments(String descriptionComments) {
        this.descriptionComments = descriptionComments;
    }

    public void setTaxonomyEntryPoints(List<TaxonomyEntryPoint> taxonomyEntryPoints) {
        this.taxonomyEntryPoints = taxonomyEntryPoints;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Taxonomy)) {
            return false;
        }
        Taxonomy other = (Taxonomy)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        Date this$uploadTime = this.getUploadTime();
        Date other$uploadTime = other.getUploadTime();
        if (this$uploadTime == null ? other$uploadTime != null : !((Object)this$uploadTime).equals(other$uploadTime)) {
            return false;
        }
        String this$filePath = this.getFilePath();
        String other$filePath = other.getFilePath();
        if (this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        String this$taxonomyPackageIdentifier = this.getTaxonomyPackageIdentifier();
        String other$taxonomyPackageIdentifier = other.getTaxonomyPackageIdentifier();
        if (this$taxonomyPackageIdentifier == null ? other$taxonomyPackageIdentifier != null : !this$taxonomyPackageIdentifier.equals(other$taxonomyPackageIdentifier)) {
            return false;
        }
        String this$taxonomyPackageName = this.getTaxonomyPackageName();
        String other$taxonomyPackageName = other.getTaxonomyPackageName();
        if (this$taxonomyPackageName == null ? other$taxonomyPackageName != null : !this$taxonomyPackageName.equals(other$taxonomyPackageName)) {
            return false;
        }
        String this$taxonomyPackageVersion = this.getTaxonomyPackageVersion();
        String other$taxonomyPackageVersion = other.getTaxonomyPackageVersion();
        if (this$taxonomyPackageVersion == null ? other$taxonomyPackageVersion != null : !this$taxonomyPackageVersion.equals(other$taxonomyPackageVersion)) {
            return false;
        }
        String this$descriptionVersion = this.getDescriptionVersion();
        String other$descriptionVersion = other.getDescriptionVersion();
        if (this$descriptionVersion == null ? other$descriptionVersion != null : !this$descriptionVersion.equals(other$descriptionVersion)) {
            return false;
        }
        Date this$descriptionDateBegin = this.getDescriptionDateBegin();
        Date other$descriptionDateBegin = other.getDescriptionDateBegin();
        if (this$descriptionDateBegin == null ? other$descriptionDateBegin != null : !((Object)this$descriptionDateBegin).equals(other$descriptionDateBegin)) {
            return false;
        }
        Date this$descriptionDateEnd = this.getDescriptionDateEnd();
        Date other$descriptionDateEnd = other.getDescriptionDateEnd();
        if (this$descriptionDateEnd == null ? other$descriptionDateEnd != null : !((Object)this$descriptionDateEnd).equals(other$descriptionDateEnd)) {
            return false;
        }
        Date this$descriptionDatePublic = this.getDescriptionDatePublic();
        Date other$descriptionDatePublic = other.getDescriptionDatePublic();
        if (this$descriptionDatePublic == null ? other$descriptionDatePublic != null : !((Object)this$descriptionDatePublic).equals(other$descriptionDatePublic)) {
            return false;
        }
        String this$descriptionComments = this.getDescriptionComments();
        String other$descriptionComments = other.getDescriptionComments();
        if (this$descriptionComments == null ? other$descriptionComments != null : !this$descriptionComments.equals(other$descriptionComments)) {
            return false;
        }
        List this$taxonomyEntryPoints = this.getTaxonomyEntryPoints();
        List other$taxonomyEntryPoints = other.getTaxonomyEntryPoints();
        return !(this$taxonomyEntryPoints == null ? other$taxonomyEntryPoints != null : !((Object)this$taxonomyEntryPoints).equals(other$taxonomyEntryPoints));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Taxonomy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        Date $uploadTime = this.getUploadTime();
        result = result * 59 + ($uploadTime == null ? 43 : ((Object)$uploadTime).hashCode());
        String $filePath = this.getFilePath();
        result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        String $taxonomyPackageIdentifier = this.getTaxonomyPackageIdentifier();
        result = result * 59 + ($taxonomyPackageIdentifier == null ? 43 : $taxonomyPackageIdentifier.hashCode());
        String $taxonomyPackageName = this.getTaxonomyPackageName();
        result = result * 59 + ($taxonomyPackageName == null ? 43 : $taxonomyPackageName.hashCode());
        String $taxonomyPackageVersion = this.getTaxonomyPackageVersion();
        result = result * 59 + ($taxonomyPackageVersion == null ? 43 : $taxonomyPackageVersion.hashCode());
        String $descriptionVersion = this.getDescriptionVersion();
        result = result * 59 + ($descriptionVersion == null ? 43 : $descriptionVersion.hashCode());
        Date $descriptionDateBegin = this.getDescriptionDateBegin();
        result = result * 59 + ($descriptionDateBegin == null ? 43 : ((Object)$descriptionDateBegin).hashCode());
        Date $descriptionDateEnd = this.getDescriptionDateEnd();
        result = result * 59 + ($descriptionDateEnd == null ? 43 : ((Object)$descriptionDateEnd).hashCode());
        Date $descriptionDatePublic = this.getDescriptionDatePublic();
        result = result * 59 + ($descriptionDatePublic == null ? 43 : ((Object)$descriptionDatePublic).hashCode());
        String $descriptionComments = this.getDescriptionComments();
        result = result * 59 + ($descriptionComments == null ? 43 : $descriptionComments.hashCode());
        List $taxonomyEntryPoints = this.getTaxonomyEntryPoints();
        result = result * 59 + ($taxonomyEntryPoints == null ? 43 : ((Object)$taxonomyEntryPoints).hashCode());
        return result;
    }

    public String toString() {
        return "Taxonomy(id=" + this.getId() + ", fileName=" + this.getFileName() + ", uploadTime=" + this.getUploadTime() + ", filePath=" + this.getFilePath() + ", active=" + this.getActive() + ", taxonomyPackageIdentifier=" + this.getTaxonomyPackageIdentifier() + ", taxonomyPackageName=" + this.getTaxonomyPackageName() + ", taxonomyPackageVersion=" + this.getTaxonomyPackageVersion() + ", descriptionVersion=" + this.getDescriptionVersion() + ", descriptionDateBegin=" + this.getDescriptionDateBegin() + ", descriptionDateEnd=" + this.getDescriptionDateEnd() + ", descriptionDatePublic=" + this.getDescriptionDatePublic() + ", descriptionComments=" + this.getDescriptionComments() + ", taxonomyEntryPoints=" + this.getTaxonomyEntryPoints() + ")";
    }
}

