/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.multitasking;

import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import ru.cbr.xbrl.converter.multitasking.ProcessEvent;
import ru.cbr.xbrl.converter.multitasking.ProcessService;
import ru.cbr.xbrl.converter.multitasking.ProcessState;
import ru.cbr.xbrl.converter.multitasking.ProcessThread;

public abstract class AbstractProcess {
    protected ProcessThread workingThread;
    private ApplicationEventPublisher applicationEventPublisher;

    public AbstractProcess(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    protected abstract String getProcessDescription();

    protected abstract String getThreadName();

    protected abstract void performOperations();

    public ProcessState getProcessState() {
        if (this.workingThread == null) {
            throw new UnsupportedOperationException("process not started");
        }
        return this.workingThread.getProcessState();
    }

    protected void notifyProcessStateChanged() {
        ProcessEvent processEvent = new ProcessEvent(this);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)processEvent);
    }

    public void start() {
        if (this.workingThread != null) {
            throw new UnsupportedOperationException("thread already created");
        }
        this.workingThread = new ProcessThread(() -> this.performOperations(), this.getProcessDescription(), this.getThreadName());
        this.workingThread.setDaemon(true);
        this.workingThread.start();
        ProcessService.registerProcess((AbstractProcess)this);
    }

    public void stop() {
        if (this.workingThread == null) {
            throw new UnsupportedOperationException("process not started");
        }
        Thread stoppingThread = new Thread(() -> {
            this.workingThread.interrupt();
            while (this.workingThread.isAlive()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            ProcessService.unregisterProcess((AbstractProcess)this);
        });
        stoppingThread.setDaemon(true);
        stoppingThread.start();
    }

    protected double getProgressPercent() {
        return this.getProcessState().getProgressPercent();
    }

    protected void setProgressPercent(double progressPercent) {
        this.getProcessState().setProgressPercent(progressPercent);
    }
}

