/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.exception.ExcessRoleCountException;
import ru.cbr.xbrl.converter.exception.IncompatibleCsvFilterFileEncodingException;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.ReadFileException;
import ru.cbr.xbrl.converter.exception.WrongFilepathException;
import ru.cbr.xbrl.converter.model.OpenAxisValidationRule;
import ru.cbr.xbrl.converter.model.XbrlDimension;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.tableLinkBase.AspectNodeMember;
import ru.cbr.xbrl.converter.model.tableLinkBase.AxisMemberHierarchy;
import ru.cbr.xbrl.converter.model.tableLinkBase.DimensionDTO;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterOpenAxis;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterOpenAxisValue;
import ru.cbr.xbrl.converter.model.tableLinkBase.MemberDTO;
import ru.cbr.xbrl.converter.model.tableLinkBase.NodeType;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBaseStructure;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextDimension;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValue;
import ru.cbr.xbrl.converter.repository.AspectNodeMemberRepository;
import ru.cbr.xbrl.converter.repository.XbrlDimensionRepository;
import ru.cbr.xbrl.converter.service.AspectNodeService;
import ru.cbr.xbrl.converter.service.ConceptInMemoryService;
import ru.cbr.xbrl.converter.service.OpenAxisValidationRulesService;
import ru.cbr.xbrl.converter.service.XbrlReportService;
import ru.cbr.xbrl.converter.service.internal.XbrlFilterOpenAxisMemberService;
import ru.cbr.xbrl.converter.service.internal.XbrlFilterOpenAxisService;
import ru.cbr.xbrl.converter.service.internal.XbrlReportCrudService;
import ru.cbr.xbrl.converter.service.internal.xbrl.XbrlValueCrudService;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AspectNodeService {
    private static final Logger log = LoggerFactory.getLogger(AspectNodeService.class);
    public static final String AXIS_ID_TECHNICAL_COLUMN_NAME = "AXIS_ID_TC";
    private static final String CHARSET = "cp1251";
    private final XbrlFilterOpenAxisService filterOpenAxisService;
    private final XbrlReportCrudService xbrlReportCrudService;
    private final XbrlReportService xbrlReportService;
    private final XbrlFilterOpenAxisMemberService xbrlFilterOpenAxisMemberService;
    private final XbrlDimensionRepository xbrlDimensionRepository;
    private final AspectNodeMemberRepository aspectNodeMemberRepository;
    private final OpenAxisValidationRulesService openAxisValidationRulesService;
    @Autowired
    private ConceptInMemoryService conceptInMemoryService;
    @PersistenceContext(unitName="cachePU")
    private EntityManager entityManager;
    private ObjectMapper objectMapper = new ObjectMapper();
    @Autowired
    private XbrlValueCrudService xbrlValueCrudService;

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public DimensionDTO getMembersForDimension(String dim) {
        List allByDimInt = this.xbrlDimensionRepository.findAllByRoleSystemIdAndDimInt(null, dim);
        if (!allByDimInt.isEmpty()) {
            List members = allByDimInt.stream().map(it -> new MemberDTO(it.getMemIntLabel(), it.getMemInt())).collect(Collectors.toList());
            return new DimensionDTO(((XbrlDimension)allByDimInt.get(0)).getDimIntLabel(), DimensionType.EXPLICIT_MEMBER, members);
        }
        List filterOpenAxisList = this.filterOpenAxisService.findFilterOpenAxisBySystemId(dim);
        if (filterOpenAxisList != null && !filterOpenAxisList.isEmpty()) {
            FilterOpenAxis filterOpenAxis = (FilterOpenAxis)filterOpenAxisList.get(0);
            List members = filterOpenAxis.getAxisMemberList().stream().map(it -> new MemberDTO(it.getValue(), it.getValue())).collect(Collectors.toList());
            filterOpenAxis.getAxisMemberList().size();
            return new DimensionDTO(filterOpenAxis.getTitle(), DimensionType.TYPED_MEMBER, members);
        }
        return new DimensionDTO("", DimensionType.EXPLICIT_MEMBER, new ArrayList());
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public DimensionDTO getMembersForNodeDimension(String dim, Long roleId, String hash) throws NotFoundException {
        XbrlReportRole reportRole = this.xbrlReportService.findReportRole(roleId);
        List allByDimInt = this.xbrlDimensionRepository.findAllByRoleSystemIdAndDimInt(reportRole.getSystemId(), dim);
        if (!allByDimInt.isEmpty()) {
            List members = allByDimInt.stream().map(it -> new MemberDTO(it.getMemIntLabel(), it.getMemInt())).collect(Collectors.toList());
            return new DimensionDTO(((XbrlDimension)allByDimInt.get(0)).getDimIntLabel(), DimensionType.EXPLICIT_MEMBER, members);
        }
        return this.getMembersForDimension(dim);
    }

    private String getRootNodeHashByDim(String dim, String hash, XbrlReportRole reportRole) throws IOException {
        TableLinkBaseStructure tableLinkBaseStructure = (TableLinkBaseStructure)this.objectMapper.readValue(reportRole.getStaticStructureJson(), TableLinkBaseStructure.class);
        AxisMemberHierarchy target = StringUtils.equalsIgnoreCase((CharSequence)hash, (CharSequence)"rootx") ? tableLinkBaseStructure.getXAxis() : tableLinkBaseStructure.getYAxis();
        List axisMemberHierarchyList = target.getAxisMemberHierarchyList();
        for (AxisMemberHierarchy axisMemberHierarchy : axisMemberHierarchyList) {
            if (axisMemberHierarchy == null) continue;
            List aspectDataList = axisMemberHierarchy.getAspectDataList();
            for (AspectData aspectData : aspectDataList) {
                if (aspectData.getType() != AspectType.DIMENSION || !StringUtils.equals((CharSequence)aspectData.getAspect(), (CharSequence)dim)) continue;
                return axisMemberHierarchy.getId();
            }
        }
        return hash;
    }

    @Transactional(value="cacheTransactionManager")
    public AspectNodeMember saveMember(Long reportRoleId, String dimension, String member, String hash, String axisId) throws NotFoundException {
        return this.saveMember(reportRoleId, dimension, member, hash, axisId, UUID.randomUUID().toString());
    }

    @Transactional(value="cacheTransactionManager")
    public AspectNodeMember saveMember(Long reportRoleId, String dimension, String member, String hash, String axisId, String externalId) throws NotFoundException {
        FilterOpenAxisValue target;
        String value = member == null ? null : member.trim();
        XbrlReportRole reportRole = this.xbrlReportService.findReportRole(reportRoleId);
        List allByDimInt = this.xbrlDimensionRepository.findAllByRoleSystemIdAndDimInt(reportRole.getSystemId(), dimension);
        if (CollectionUtils.isEmpty((Collection)allByDimInt)) {
            allByDimInt = this.xbrlDimensionRepository.findAllByRoleSystemIdAndDimInt(null, dimension);
        }
        if (!allByDimInt.isEmpty()) {
            Optional<XbrlDimension> first = allByDimInt.stream().filter(it -> it.getMemInt().equals(value) || StringUtils.trim((String)it.getMemIntLabel()).equals(StringUtils.trim((String)value))).findFirst();
            if (!first.isPresent()) {
                return null;
            }
            XbrlDimension target2 = first.get();
            Optional<AspectNodeMember> existingAspectNodeMember = reportRole.getAspectNodeMembers().stream().filter(a -> a.getDimension().equals(dimension) && a.getHash().equals(hash) && a.getClosedMemberValue().equals(target2.getMemInt())).findAny();
            if (existingAspectNodeMember.isPresent()) {
                return existingAspectNodeMember.get();
            }
            AspectNodeMember aspectNodeMember = new AspectNodeMember();
            aspectNodeMember.setXbrlReportRole(reportRole);
            aspectNodeMember.setClosedMemberValue(target2.getMemInt());
            aspectNodeMember.setClosedMemberLabel(target2.getMemIntLabel());
            aspectNodeMember.setDimension(dimension);
            aspectNodeMember.setHash(hash);
            aspectNodeMember.setCommonId(externalId);
            aspectNodeMember.setAxisId(axisId);
            reportRole.getAspectNodeMembers().add(aspectNodeMember);
            this.xbrlReportCrudService.updateXbrlReportRole(reportRole);
            return aspectNodeMember;
        }
        List filterOpenAxisList = this.filterOpenAxisService.findFilterOpenAxisBySystemId(dimension);
        if (filterOpenAxisList.isEmpty()) {
            log.error("Dimension not found: {}", (Object)dimension);
            throw new NotFoundException();
        }
        FilterOpenAxis filterOpenAxis = (FilterOpenAxis)filterOpenAxisList.get(0);
        this.openAxisValidationRulesService.validate(dimension, value);
        List filterOpenAxisValues = this.xbrlFilterOpenAxisMemberService.getFilterOpenAxisValuesByFilterOpenAxisAndValue(filterOpenAxis, value);
        Optional first = filterOpenAxisValues.stream().findFirst();
        if (first.isPresent()) {
            target = (FilterOpenAxisValue)first.get();
        } else {
            target = new FilterOpenAxisValue();
            target.setFilterOpenAxis(filterOpenAxis);
            target.setValue(value);
            target = this.xbrlFilterOpenAxisMemberService.update(target);
        }
        Optional<AspectNodeMember> existingAspectNodeMember = reportRole.getAspectNodeMembers().stream().filter(a -> a.getDimension().equals(dimension) && a.getHash().equals(hash) && a.getFilterOpenAxisValue().getValue().equals(value)).findAny();
        if (existingAspectNodeMember.isPresent()) {
            return existingAspectNodeMember.get();
        }
        filterOpenAxis.getAxisMemberList().add(target);
        this.filterOpenAxisService.update(filterOpenAxis);
        AspectNodeMember aspectNodeMember = new AspectNodeMember();
        aspectNodeMember.setXbrlReportRole(reportRole);
        aspectNodeMember.setFilterOpenAxisValue(target);
        aspectNodeMember.setDimension(dimension);
        aspectNodeMember.setHash(hash);
        aspectNodeMember.setCommonId(externalId);
        aspectNodeMember.setAxisId(axisId);
        reportRole.getAspectNodeMembers().add(aspectNodeMember);
        this.xbrlReportCrudService.updateXbrlReportRole(reportRole);
        return aspectNodeMember;
    }

    private List<XbrlDimension> initAllByDimInt(HashMap<String, List<XbrlDimension>> mapDims, XbrlReportRole reportRole, String dimension, HashMap<String, OpenAxisValidationRule> mapDimRules) {
        List allByDimInt = mapDims.get(dimension);
        if (allByDimInt == null) {
            allByDimInt = this.xbrlDimensionRepository.findAllByRoleSystemIdAndDimInt(reportRole.getSystemId(), dimension);
            if (allByDimInt.size() > 0) {
                log.info("dimension:" + dimension + ":" + allByDimInt.size());
            }
            if (CollectionUtils.isEmpty((Collection)allByDimInt) && (allByDimInt = this.xbrlDimensionRepository.findAllByRoleSystemIdAndDimInt(null, dimension)).size() > 0) {
                log.info(">dimension:" + dimension + ":" + allByDimInt.size());
            }
            mapDims.putIfAbsent(dimension, allByDimInt);
            OpenAxisValidationRule rule = this.openAxisValidationRulesService.findByDimension(dimension);
            if (rule != null) {
                mapDimRules.put(dimension, rule);
            }
        }
        return allByDimInt;
    }

    @Transactional(value="cacheTransactionManager")
    public void saveMembers(XbrlReportRole reportRole, List<AspectNodeMember> aspectNodeMemberList) throws NotFoundException {
        HashMap mapDims = new HashMap();
        HashMap mapDimRules = new HashMap();
        HashMap<String, FilterOpenAxis> filterOpenAxisMap = new HashMap<String, FilterOpenAxis>();
        for (AspectNodeMember aspectNodeMember1 : aspectNodeMemberList) {
            FilterOpenAxisValue target;
            Optional first;
            String member = aspectNodeMember1.getClosedMemberLabel();
            String dimension = aspectNodeMember1.getDimension();
            String hash = aspectNodeMember1.getHash();
            String axisId = null;
            String externalId = aspectNodeMember1.getCommonId();
            String value = member == null ? null : member.trim();
            List allByDimInt = this.initAllByDimInt(mapDims, reportRole, dimension, mapDimRules);
            if (!allByDimInt.isEmpty()) {
                Optional<XbrlDimension> first2 = allByDimInt.stream().filter(it -> it.getMemInt().equals(value) || StringUtils.trim((String)it.getMemIntLabel()).equals(StringUtils.trim((String)value))).findFirst();
                if (!first2.isPresent()) continue;
                XbrlDimension target2 = first2.get();
                Optional<AspectNodeMember> existingAspectNodeMember = reportRole.getAspectNodeMembers().stream().filter(a -> a.getDimension().equals(dimension) && a.getHash().equals(hash) && a.getClosedMemberValue().equals(target2.getMemInt())).findAny();
                if (existingAspectNodeMember.isPresent()) continue;
                AspectNodeMember aspectNodeMember = new AspectNodeMember();
                aspectNodeMember.setXbrlReportRole(reportRole);
                aspectNodeMember.setClosedMemberValue(target2.getMemInt());
                aspectNodeMember.setClosedMemberLabel(target2.getMemIntLabel());
                aspectNodeMember.setDimension(dimension);
                aspectNodeMember.setHash(hash);
                aspectNodeMember.setCommonId(externalId);
                aspectNodeMember.setAxisId(axisId);
                reportRole.getAspectNodeMembers().add(aspectNodeMember);
                continue;
            }
            FilterOpenAxis filterOpenAxis = (FilterOpenAxis)filterOpenAxisMap.get(dimension);
            if (filterOpenAxis == null) {
                List filterOpenAxisList = this.filterOpenAxisService.findFilterOpenAxisBySystemId(dimension);
                if (filterOpenAxisList.isEmpty()) {
                    log.error("Dimension not found: {}", (Object)dimension);
                    throw new NotFoundException();
                }
                filterOpenAxis = (FilterOpenAxis)filterOpenAxisList.get(0);
                filterOpenAxisMap.putIfAbsent(dimension, filterOpenAxis);
            }
            if (mapDimRules.get(dimension) != null) {
                log.info("rule:" + dimension);
                this.openAxisValidationRulesService.validateValue((OpenAxisValidationRule)mapDimRules.get(dimension), value);
            }
            if ((first = filterOpenAxis.findValue(value)).isPresent()) {
                target = (FilterOpenAxisValue)first.get();
            } else {
                target = new FilterOpenAxisValue();
                target.setFilterOpenAxis(filterOpenAxis);
                target.setValue(value);
                target = this.xbrlFilterOpenAxisMemberService.update(target);
            }
            Optional<AspectNodeMember> existingAspectNodeMember = reportRole.getAspectNodeMembers().stream().filter(a -> a.getDimension().equals(dimension) && a.getHash().equals(hash) && a.getFilterOpenAxisValue().getValue().equals(value)).findAny();
            if (existingAspectNodeMember.isPresent()) continue;
            filterOpenAxis.getAxisMemberList().add(target);
            filterOpenAxis = this.filterOpenAxisService.update(filterOpenAxis);
            filterOpenAxisMap.put(dimension, filterOpenAxis);
            AspectNodeMember aspectNodeMember = new AspectNodeMember();
            aspectNodeMember.setXbrlReportRole(reportRole);
            aspectNodeMember.setFilterOpenAxisValue(target);
            aspectNodeMember.setDimension(dimension);
            aspectNodeMember.setHash(hash);
            aspectNodeMember.setCommonId(externalId);
            aspectNodeMember.setAxisId(axisId);
            reportRole.getAspectNodeMembers().add(aspectNodeMember);
        }
        this.xbrlReportCrudService.updateXbrlReportRole(reportRole);
    }

    @Transactional(value="cacheTransactionManager")
    public AspectNodeMember saveMemberForRole(XbrlReportRole xbrlReportRole, String dimint, String member, String hash, String axisId, XbrlReportRoleDimensionCache xbrlReportRoleDimensionCache) throws NotFoundException {
        String value = member == null ? null : member.trim();
        String externalId = UUID.randomUUID().toString();
        if (XbrlReportRoleDimensionCache.access$000((XbrlReportRoleDimensionCache)xbrlReportRoleDimensionCache)) {
            List allByDimInt = this.xbrlDimensionRepository.findAllByRoleSystemIdAndDimInt(xbrlReportRole.getSystemId(), dimint);
            if (CollectionUtils.isEmpty((Collection)allByDimInt)) {
                allByDimInt = this.xbrlDimensionRepository.findAllByRoleSystemIdAndDimInt(null, dimint);
            }
            if (!allByDimInt.isEmpty()) {
                Optional<XbrlDimension> first = allByDimInt.stream().filter(it -> it.getMemInt().equals(value) || StringUtils.trim((String)it.getMemIntLabel()).equals(StringUtils.trim((String)value))).findFirst();
                if (!first.isPresent()) {
                    return null;
                }
                XbrlDimension target = first.get();
                Map aspectNodeMemberByHashMap = xbrlReportRoleDimensionCache.getAspectNodeMemberByHashMap();
                Map aspectNodeMemberValueMap = aspectNodeMemberByHashMap.computeIfAbsent(hash, k -> new HashMap());
                List aspectNodeMemberList = aspectNodeMemberValueMap.computeIfAbsent(target.getMemInt(), k -> new ArrayList());
                Optional<AspectNodeMember> existingAspectNodeMember = aspectNodeMemberList.stream().filter(a -> a.getDimension().equals(dimint) && a.getHash().equals(hash) && a.getClosedMemberValue().equals(target.getMemInt())).findAny();
                if (existingAspectNodeMember.isPresent()) {
                    return existingAspectNodeMember.get();
                }
                AspectNodeMember aspectNodeMember = new AspectNodeMember();
                aspectNodeMember.setXbrlReportRole(xbrlReportRole);
                aspectNodeMember.setClosedMemberValue(target.getMemInt());
                aspectNodeMember.setClosedMemberLabel(target.getMemIntLabel());
                aspectNodeMember.setDimension(dimint);
                aspectNodeMember.setHash(hash);
                aspectNodeMember.setCommonId(externalId);
                aspectNodeMember.setAxisId(axisId);
                xbrlReportRole.getAspectNodeMembers().add(aspectNodeMember);
                this.xbrlReportCrudService.updateXbrlReportRole(xbrlReportRole);
                aspectNodeMemberList.add(aspectNodeMember);
                return aspectNodeMember;
            }
        }
        if (XbrlReportRoleDimensionCache.access$100((XbrlReportRoleDimensionCache)xbrlReportRoleDimensionCache)) {
            FilterOpenAxisValue target;
            Long existingId;
            Map validateMap;
            Map filterOpenAxisMap = xbrlReportRoleDimensionCache.getFilterOpenAxisMap();
            FilterOpenAxis filterOpenAxis = (FilterOpenAxis)filterOpenAxisMap.get(dimint);
            if (filterOpenAxis == null) {
                List filterOpenAxisList = this.filterOpenAxisService.findFilterOpenAxisBySystemId(dimint);
                if (filterOpenAxisList.isEmpty()) {
                    log.error("Dimension not found: {}", (Object)dimint);
                    throw new NotFoundException();
                }
                filterOpenAxis = (FilterOpenAxis)filterOpenAxisList.get(0);
                filterOpenAxisMap.put(dimint, filterOpenAxis);
            }
            if ((validateMap = xbrlReportRoleDimensionCache.getValidateMap()) != null) {
                OpenAxisValidationRule openAxisValidationRule = (OpenAxisValidationRule)validateMap.get(dimint);
                this.openAxisValidationRulesService.validateValue(openAxisValidationRule, value);
            }
            if ((existingId = this.xbrlFilterOpenAxisMemberService.getFilterOpenAxisValueId(filterOpenAxis, value)) != null) {
                target = this.xbrlFilterOpenAxisMemberService.find(existingId);
            } else {
                target = new FilterOpenAxisValue();
                target.setFilterOpenAxis(filterOpenAxis);
                target.setValue(value);
                target = this.xbrlFilterOpenAxisMemberService.update(target);
                this.entityManager.flush();
            }
            Map aspectNodeMemberByHashMap = xbrlReportRoleDimensionCache.getAspectNodeMemberByHashMap();
            Map aspectNodeMemberValueMap = aspectNodeMemberByHashMap.computeIfAbsent(hash, k -> new HashMap());
            List aspectNodeMemberList = aspectNodeMemberValueMap.computeIfAbsent(value, k -> new ArrayList());
            Optional<AspectNodeMember> existingAspectNodeMember = aspectNodeMemberList.stream().filter(a -> a.getDimension().equals(dimint) && a.getHash().equals(hash) && a.getFilterOpenAxisValue().getValue().equals(value)).findAny();
            if (existingAspectNodeMember.isPresent()) {
                return existingAspectNodeMember.get();
            }
            filterOpenAxis.getAxisMemberList().add(target);
            this.filterOpenAxisService.update(filterOpenAxis);
            AspectNodeMember aspectNodeMember = new AspectNodeMember();
            aspectNodeMember.setXbrlReportRole(xbrlReportRole);
            aspectNodeMember.setFilterOpenAxisValue(target);
            aspectNodeMember.setDimension(dimint);
            aspectNodeMember.setHash(hash);
            aspectNodeMember.setCommonId(externalId);
            aspectNodeMember.setAxisId(axisId);
            xbrlReportRole.getAspectNodeMembers().add(aspectNodeMember);
            this.aspectNodeMemberRepository.save((Object)aspectNodeMember);
            this.entityManager.flush();
            aspectNodeMemberList.add(aspectNodeMember);
            return aspectNodeMember;
        }
        log.error("Dimension not found: {}", (Object)dimint);
        throw new NotFoundException();
    }

    @Transactional(value="cacheTransactionManager")
    public void importMembers(Long reportRoleId, String rootDimension, String rootHash, String fileName, String rootAxisType) throws ReadFileException, IncompatibleCsvFilterFileEncodingException, WrongFilepathException {
        this.checkFilepathCorrectness(fileName);
        try {
            AxisMemberHierarchy aspectNodeHierarchy;
            XbrlReportRole xbrlReportRole = this.xbrlReportService.findReportRole(reportRoleId);
            ObjectMapper mapper = new ObjectMapper();
            TableLinkBaseStructure tableLinkBaseStructure = (TableLinkBaseStructure)mapper.readValue(xbrlReportRole.getStaticStructureJson(), TableLinkBaseStructure.class);
            XbrlReportRoleDimensionCache xbrlReportRoleDimensionCache = this.initXbrlReportRoleDimensionCache(xbrlReportRole);
            AxisMemberHierarchy axisMemberHierarchy = tableLinkBaseStructure.findAxis(TableLinkBaseStructure.TableAxis.search((String)rootAxisType));
            String parentHash = axisMemberHierarchy.getId();
            AxisMemberHierarchy current = aspectNodeHierarchy = (AxisMemberHierarchy)axisMemberHierarchy.getAxisMemberHierarchyList().stream().filter(a -> a.getNodeType().equals((Object)NodeType.ASPECT)).findAny().orElse(null);
            ArrayList<String> dimensions = new ArrayList<String>();
            dimensions.add(((AspectData)current.getAspectDataList().get(0)).getAspect());
            while (!current.getAxisMemberHierarchyList().isEmpty()) {
                current = (AxisMemberHierarchy)current.getAxisMemberHierarchyList().get(0);
                dimensions.add(((AspectData)current.getAspectDataList().get(0)).getAspect());
            }
            boolean hasAxisIdTechnicalColumn = this.hasAxisIdTechnicalColumn(fileName);
            this.readMembersFromCsv(fileName, row -> {
                boolean hasBlankMembers = row.stream().anyMatch(StringUtils::isBlank);
                if (!hasBlankMembers) {
                    String currentHash = parentHash;
                    int size = hasAxisIdTechnicalColumn ? row.size() - 1 : row.size();
                    for (int colIndex = 0; colIndex < size; ++colIndex) {
                        String dimint;
                        String axisId = null;
                        if (colIndex == size - 1 && hasAxisIdTechnicalColumn) {
                            axisId = (String)row.get(colIndex + 1);
                        }
                        try {
                            dimint = (String)dimensions.get(colIndex);
                        }
                        catch (IndexOutOfBoundsException e) {
                            throw new ExcessRoleCountException();
                        }
                        try {
                            AspectNodeMember newMember = this.saveMemberForRole(xbrlReportRole, dimint, (String)row.get(colIndex), currentHash, axisId, xbrlReportRoleDimensionCache);
                            currentHash = newMember.getCommonId();
                            continue;
                        }
                        catch (NotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
        catch (JsonParseException | JsonMappingException | NotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private XbrlReportRoleDimensionCache initXbrlReportRoleDimensionCache(XbrlReportRole xbrlReportRole) {
        XbrlReportRoleDimensionCache xbrlReportRoleDimensionCache = new XbrlReportRoleDimensionCache(this);
        xbrlReportRoleDimensionCache.setOpenAxisPresent(xbrlReportRole.getXbrlRoleDimensionList().stream().anyMatch(xbrlRoleDimension -> xbrlRoleDimension.getDimensionType() == DimensionType.TYPED_MEMBER));
        xbrlReportRoleDimensionCache.setExplicitAxisPresent(xbrlReportRole.getXbrlRoleDimensionList().stream().anyMatch(xbrlRoleDimension -> xbrlRoleDimension.getDimensionType() == DimensionType.EXPLICIT_MEMBER));
        List aspectNodeMembers = xbrlReportRole.getAspectNodeMembers();
        if (!CollectionUtils.isEmpty((Collection)aspectNodeMembers)) {
            for (AspectNodeMember aspectNodeMember : aspectNodeMembers) {
                String hash = aspectNodeMember.getHash();
                String value = null;
                if (StringUtils.isNotBlank((CharSequence)aspectNodeMember.getClosedMemberValue())) {
                    value = aspectNodeMember.getClosedMemberValue();
                } else if (aspectNodeMember.getFilterOpenAxisValue() != null && StringUtils.isNotBlank((CharSequence)aspectNodeMember.getFilterOpenAxisValue().getValue())) {
                    value = aspectNodeMember.getFilterOpenAxisValue().getValue();
                }
                if (StringUtils.isBlank((CharSequence)value)) continue;
                Map aspectNodeMemberByHashMap = xbrlReportRoleDimensionCache.getAspectNodeMemberByHashMap();
                Map aspectNodeMemberByValueMap = aspectNodeMemberByHashMap.computeIfAbsent(hash, k -> new HashMap());
                List aspectNodeMemberList = aspectNodeMemberByValueMap.computeIfAbsent(value, k -> new ArrayList());
                aspectNodeMemberList.add(aspectNodeMember);
            }
        }
        xbrlReportRoleDimensionCache.setValidateMap(this.openAxisValidationRulesService.findAll().stream().collect(Collectors.toMap(OpenAxisValidationRule::getDimension, Function.identity())));
        return xbrlReportRoleDimensionCache;
    }

    @Transactional(value="cacheTransactionManager")
    public List<AspectNodeMember> getClosedAspectNodeMembersByDimension(String dimension) {
        return this.aspectNodeMemberRepository.findAllByDimensionAndFilterOpenAxisValue(dimension, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasAxisIdTechnicalColumn(String csvFile) throws ReadFileException {
        try (InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(csvFile), Charset.forName("cp1251"));){
            CSVParser parse = CSVFormat.EXCEL.withFirstRecordAsHeader().withDelimiter(';').parse((Reader)in);
            Map headerMap = parse.getHeaderMap();
            boolean bl = headerMap.keySet().contains("AXIS_ID_TC");
            return bl;
        }
        catch (IOException e) {
            throw new ReadFileException();
        }
    }

    public Function<AspectCellData, String> calcDimensionOpenHashByAspectCellData(Map<String, String> dimensionsDefault) {
        return aspectCellData -> {
            List dimensionList = aspectCellData.getDimensions();
            dimensionList = XbrlContextDimension.removeDefaultDimensions((List)dimensionList, (Map)dimensionsDefault);
            List xbrlContextDimensionList = XbrlContextDimension.buildFromAspectDataList((List)dimensionList);
            return XbrlContextDimension.dimensionsOpenToHash((List)xbrlContextDimensionList, (Set)this.conceptInMemoryService.getExplicitAspectNodeSet());
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional(value="cacheTransactionManager")
    public void readMembersFromCsv(String csvFile, Consumer<List<String>> rowConsumer) throws ReadFileException, IncompatibleCsvFilterFileEncodingException {
        try {
            InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(csvFile), Charset.forName("cp1251"));
            CSVParser records = CSVFormat.EXCEL.withFirstRecordAsHeader().withDelimiter(';').parse((Reader)in);
            for (CSVRecord record : records) {
                ArrayList<String> row = new ArrayList<String>();
                for (int i = 0; i < record.size(); ++i) {
                    row.add(record.get(i));
                }
                try {
                    rowConsumer.accept(row);
                }
                catch (NullPointerException e) {
                    log.error("\u0418\u043c\u043f\u043e\u0440\u0442 \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044f \u043e\u0441\u0435\u0439 \u0438\u0437 .csv \u0444\u0430\u0439\u043b\u0430. \u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0438\u043b\u0438 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0430.", (Throwable)e);
                    throw new IncompatibleCsvFilterFileEncodingException();
                    return;
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new ReadFileException();
        }
        catch (IOException e) {
            throw new ReadFileException();
        }
    }

    private void checkFilepathCorrectness(String fileName) throws WrongFilepathException {
        File f = new File(fileName);
        if (!f.exists() || f.isDirectory()) {
            throw new WrongFilepathException();
        }
    }

    @Transactional(value="cacheTransactionManager")
    public void deleteMember(Long reportRoleId, String hash, Boolean deleteChildren) {
        try {
            System.out.println("try to delete:" + reportRoleId + " hash:" + hash);
            XbrlReportRole reportRole = this.xbrlReportService.findReportRole(reportRoleId);
            Optional<AspectNodeMember> existingAspectNodeMember = reportRole.getAspectNodeMembers().stream().filter(a -> a.getCommonId().equals(hash)).findAny();
            if (existingAspectNodeMember.isPresent()) {
                FilterOpenAxisValue openAxisValue;
                AspectNodeMember memberForDelete = existingAspectNodeMember.get();
                System.out.println("\u043d\u0430\u0448\u0435\u043b:" + memberForDelete.getCommonId());
                int s = reportRole.getAspectNodeMembers().size();
                System.out.println("size:" + s);
                for (int i = 0; i < s; ++i) {
                    if (!((AspectNodeMember)reportRole.getAspectNodeMembers().get(i)).getCommonId().equals(hash)) continue;
                    reportRole.getAspectNodeMembers().remove(i);
                    memberForDelete.setXbrlReportRole(null);
                    break;
                }
                if ((openAxisValue = memberForDelete.getFilterOpenAxisValue()) != null) {
                    for (int i = 0; i < openAxisValue.getAspectNodeMemberList().size(); ++i) {
                        if (!((AspectNodeMember)openAxisValue.getAspectNodeMemberList().get(i)).getCommonId().equals(hash)) continue;
                        openAxisValue.getAspectNodeMemberList().remove(i);
                        memberForDelete.setFilterOpenAxisValue(null);
                        break;
                    }
                }
                this.xbrlReportCrudService.updateXbrlReportRole(reportRole);
                List xbrlValues = this.xbrlValueCrudService.list();
                for (XbrlValue value : xbrlValues) {
                    value.unpackAspectDataList();
                    System.out.println(">>>" + value.getValue());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @ConstructorProperties(value={"filterOpenAxisService", "xbrlReportCrudService", "xbrlReportService", "xbrlFilterOpenAxisMemberService", "xbrlDimensionRepository", "aspectNodeMemberRepository", "openAxisValidationRulesService"})
    public AspectNodeService(XbrlFilterOpenAxisService filterOpenAxisService, XbrlReportCrudService xbrlReportCrudService, XbrlReportService xbrlReportService, XbrlFilterOpenAxisMemberService xbrlFilterOpenAxisMemberService, XbrlDimensionRepository xbrlDimensionRepository, AspectNodeMemberRepository aspectNodeMemberRepository, OpenAxisValidationRulesService openAxisValidationRulesService) {
        this.filterOpenAxisService = filterOpenAxisService;
        this.xbrlReportCrudService = xbrlReportCrudService;
        this.xbrlReportService = xbrlReportService;
        this.xbrlFilterOpenAxisMemberService = xbrlFilterOpenAxisMemberService;
        this.xbrlDimensionRepository = xbrlDimensionRepository;
        this.aspectNodeMemberRepository = aspectNodeMemberRepository;
        this.openAxisValidationRulesService = openAxisValidationRulesService;
    }
}

