/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import ru.cbr.xbrl.converter.config.ConfigProperties;
import ru.cbr.xbrl.converter.exception.FileNameIsEmptyException;
import ru.cbr.xbrl.converter.exception.FileNameIsNotUnique;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.ZipExtractFileException;
import ru.cbr.xbrl.converter.model.Attachment;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.repository.AttachmentRepository;
import ru.cbr.xbrl.converter.service.AttachmentService;
import ru.cbr.xbrl.converter.service.XbrlPackageService;
import ru.cbr.xbrl.converter.utils.ZipUtils;

@Service
public class AttachmentServiceImpl
implements AttachmentService {
    private static final Logger log = LoggerFactory.getLogger(AttachmentServiceImpl.class);
    public static final String ATTACHMENTS_PATH = "attachments";
    private final XbrlPackageService xbrlPackageService;
    private final AttachmentRepository attachmentRepository;
    private final ConfigProperties configProperties;

    @Transactional(value="cacheTransactionManager")
    public List<Attachment> getList() {
        return this.attachmentRepository.findAll();
    }

    @Transactional(value="cacheTransactionManager")
    public void createAttachment(Long xbrlPackageId, String localPath, String description) throws NotFoundException, IOException, FileNameIsEmptyException, FileNameIsNotUnique {
        XbrlPackage xbrlPackage = this.xbrlPackageService.find(xbrlPackageId);
        String checkedFileName = this.checkFileName(localPath, null);
        this.saveFileToLocalStorage(localPath, checkedFileName);
        Attachment attachment = new Attachment();
        attachment.setName(checkedFileName);
        attachment.setDescription(description);
        this.attachmentRepository.save((Object)attachment);
        xbrlPackage.getAttachments().add(attachment);
    }

    @Transactional(value="cacheTransactionManager")
    public void updateAttachment(Long xbrlPackageId, Long attachmentId, String localPath, String description) throws NotFoundException, IOException, FileNameIsNotUnique, FileNameIsEmptyException {
        Attachment attachment = (Attachment)this.attachmentRepository.findOne((Serializable)attachmentId);
        if (attachment == null) {
            log.error("Attachment {} not found", (Object)attachmentId);
            throw new NotFoundException();
        }
        XbrlPackage xbrlPackage = this.xbrlPackageService.find(xbrlPackageId);
        if (!StringUtils.isEmpty((CharSequence)localPath)) {
            String checkedFileName = this.checkFileName(localPath, attachment);
            this.removeFileFromLocalStorage(attachment.getName());
            xbrlPackage.getAttachments().remove(attachment);
            this.saveFileToLocalStorage(localPath, checkedFileName);
            attachment.setName(checkedFileName);
            xbrlPackage.getAttachments().add(attachment);
        }
        attachment.setDescription(description);
        this.attachmentRepository.save((Object)attachment);
    }

    @Transactional(value="cacheTransactionManager")
    public void deleteAttachment(Long attachmentId, Long xbrlPackageId) throws NotFoundException, IOException {
        XbrlPackage xbrlPackage = this.xbrlPackageService.find(xbrlPackageId);
        Attachment attachment = xbrlPackage.getAttachments().stream().filter(attach -> attach.getId().equals(attachmentId)).findFirst().orElseThrow(NotFoundException::new);
        this.removeFileFromLocalStorage(attachment.getName());
        xbrlPackage.getAttachments().remove(attachment);
        this.attachmentRepository.delete((Object)attachment);
    }

    @Transactional(value="cacheTransactionManager")
    public void loadAttachments(String localPath, XbrlPackage xbrlPackage) throws IOException, ZipExtractFileException {
        String attachmentsStorePath = ru.cbr.xbrl.converter.utils.FileUtils.relativePathToAbsolute((String)this.configProperties.getAttachmentsStorePath());
        Path attachmentDirectory = Paths.get(attachmentsStorePath, new String[0]);
        if (!attachmentDirectory.toFile().exists()) {
            Files.createDirectory(attachmentDirectory, new FileAttribute[0]);
        }
        FileUtils.cleanDirectory((File)attachmentDirectory.toFile());
        for (Attachment attachment : xbrlPackage.getAttachments()) {
            ZipUtils.extractFile((String)localPath, (String)FilenameUtils.concat((String)ATTACHMENTS_PATH, (String)attachment.getName()), (String)FilenameUtils.concat((String)attachmentsStorePath, (String)attachment.getName()));
        }
    }

    public String checkAttachmentFilePath(Long xbrlPackageId, String filePath) throws NotFoundException {
        String originalFileName;
        try {
            originalFileName = this.getOriginalFileName(filePath);
        }
        catch (FileNameIsEmptyException e) {
            return "\u0418\u043c\u044f \u0444\u0430\u0439\u043b\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c";
        }
        String fileName = FilenameUtils.getName((String)this.xbrlPackageService.find(xbrlPackageId).getXbrlReport().getFilePath());
        if (fileName.equals(originalFileName)) {
            return "\u0424\u0430\u0439\u043b \u0441 \u0442\u0430\u043a\u0438\u043c \u0438\u043c\u0435\u043d\u0435\u043c \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u043f\u0430\u043a\u0435\u0442\u0435 \u043e\u0442\u0447\u0435\u0442\u043d\u043e\u0441\u0442\u0438, \u043f\u0440\u0438\u043a\u0440\u0435\u043f\u0438\u0442\u0435 \u0434\u0440\u0443\u0433\u043e\u0439 \u0444\u0430\u0439\u043b";
        }
        return "";
    }

    private void saveFileToLocalStorage(String path, String filename) throws IOException {
        String attachmentsStorePath = ru.cbr.xbrl.converter.utils.FileUtils.relativePathToAbsolute((String)this.configProperties.getAttachmentsStorePath());
        String attachmentPathInternal = FilenameUtils.concat((String)attachmentsStorePath, (String)filename);
        FileUtils.copyFile((File)new File(path), (File)new File(attachmentPathInternal));
    }

    private void removeFileFromLocalStorage(String localName) throws IOException {
        String attachmentsStorePath = ru.cbr.xbrl.converter.utils.FileUtils.relativePathToAbsolute((String)this.configProperties.getAttachmentsStorePath());
        String attachmentPathInternal = FilenameUtils.concat((String)attachmentsStorePath, (String)localName);
        FileUtils.forceDelete((File)new File(attachmentPathInternal));
    }

    private String getOriginalFileName(String localPath) throws FileNameIsEmptyException {
        String originalFileName = FilenameUtils.getName((String)localPath);
        if (originalFileName == null || StringUtils.isEmpty((CharSequence)originalFileName.trim())) {
            throw new FileNameIsEmptyException();
        }
        return originalFileName.trim();
    }

    private boolean isUniqueFileName(String fileName) {
        return !this.attachmentRepository.findByName(fileName).isPresent();
    }

    private String checkFileName(String localPath, Attachment attachment) throws FileNameIsEmptyException, FileNameIsNotUnique {
        String originalFileName = this.getOriginalFileName(localPath);
        if (!(this.isUniqueFileName(originalFileName) || attachment != null && originalFileName.equalsIgnoreCase(attachment.getName()))) {
            throw new FileNameIsNotUnique();
        }
        return originalFileName;
    }

    @ConstructorProperties(value={"xbrlPackageService", "attachmentRepository", "configProperties"})
    public AttachmentServiceImpl(XbrlPackageService xbrlPackageService, AttachmentRepository attachmentRepository, ConfigProperties configProperties) {
        this.xbrlPackageService = xbrlPackageService;
        this.attachmentRepository = attachmentRepository;
        this.configProperties = configProperties;
    }
}

