/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.tableLinkBase.EnumerateItem;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBaseStructure;
import ru.cbr.xbrl.converter.utils.GzipUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class EnumerationsService {
    private static final Logger log = LoggerFactory.getLogger(EnumerationsService.class);
    private Map<String, List<EnumerateItem>> enumerations;
    private Map<String, Set<String>> enumerationsByLabelMap;

    public void loadFromReport(XbrlReport xbrlReport) {
        this.enumerations = EnumerationsService.decompressEnumerations((byte[])xbrlReport.getEnumerationsJsonGzipped());
        this.enumerationsByLabelMap = new HashMap();
        log.info("Enumerations reloaded, size = " + this.enumerations.size());
    }

    public Map<String, List<EnumerateItem>> getEnumerations() {
        return this.enumerations;
    }

    public static byte[] compressEnumerations(List<TableLinkBaseStructure> tableLinkBaseStructures) {
        HashMap enums = new HashMap();
        List<Map> rolesEnums = tableLinkBaseStructures.stream().map(tableLinkBaseStructure -> tableLinkBaseStructure.getEnumerations()).collect(Collectors.toList());
        rolesEnums.forEach(stringListMap -> stringListMap.keySet().forEach(key -> enums.putIfAbsent(key, stringListMap.get(key))));
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String json = objectMapper.writeValueAsString(enums);
            byte[] gzipped = GzipUtils.compressString((String)json);
            return gzipped;
        }
        catch (JsonProcessingException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public static Map<String, List<EnumerateItem>> decompressEnumerations(byte[] gzipped) {
        if (gzipped == null) {
            return new HashMap<String, List<EnumerateItem>>();
        }
        try {
            String json = GzipUtils.decompressString((byte[])gzipped);
            ObjectMapper objectMapper = new ObjectMapper();
            Map enumerations = (Map)objectMapper.readValue(json, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return enumerations;
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return new HashMap<String, List<EnumerateItem>>();
        }
    }

    public Set<String> getMembersByLabelContains(String label) {
        if (StringUtils.isBlank((CharSequence)label)) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        this.rebuildEnumerationsByLabel();
        this.enumerationsByLabelMap.keySet().forEach(item -> {
            if (StringUtils.equals((CharSequence)item, (CharSequence)label)) {
                result.addAll((Collection)this.enumerationsByLabelMap.get(item));
            }
        });
        return result;
    }

    private void rebuildEnumerationsByLabel() {
        if (!CollectionUtils.isEmpty((Map)this.enumerationsByLabelMap)) {
            return;
        }
        this.enumerations.forEach((concept, itemList) -> {
            if (CollectionUtils.isEmpty((Collection)itemList)) {
                return;
            }
            Map map = itemList.stream().collect(Collectors.groupingBy(EnumerateItem::getLabel, Collectors.mapping(EnumerateItem::getMember, Collectors.toSet())));
            map.forEach((label, memberSet) -> {
                Set set = this.enumerationsByLabelMap.computeIfAbsent(label, s -> new HashSet());
                set.addAll(memberSet);
            });
        });
    }

    public Set<String> getMemberPrefixSet() {
        HashSet<String> prefixSet = new HashSet<String>();
        if (CollectionUtils.isEmpty((Map)this.enumerations)) {
            return prefixSet;
        }
        return this.enumerations.values().stream().flatMap(itemList -> itemList.stream().map(enumerateItem -> {
            String member = enumerateItem.getMember();
            if (StringUtils.isBlank((CharSequence)member)) {
                return "";
            }
            return StringUtils.split((String)member, (String)":")[0];
        })).collect(Collectors.toSet());
    }
}

