/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.math3.util.Precision;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import oshi.SystemInfo;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import ru.cbr.xbrl.converter.arelle.ArelleCmdOptions;
import ru.cbr.xbrl.converter.arelle.ArelleOutputParser;
import ru.cbr.xbrl.converter.arelle.ArelleService;
import ru.cbr.xbrl.converter.config.ConfigProperties;
import ru.cbr.xbrl.converter.controller.import_export.PerformanceCheckStruct;
import ru.cbr.xbrl.converter.exception.ActionCancelledException;
import ru.cbr.xbrl.converter.exception.CancelledException;
import ru.cbr.xbrl.converter.exception.CommandExecutionException;
import ru.cbr.xbrl.converter.exception.DifferenceProtocolWritingException;
import ru.cbr.xbrl.converter.exception.EmptyCheckList;
import ru.cbr.xbrl.converter.exception.FileAlreadyExistsException;
import ru.cbr.xbrl.converter.exception.FilesStructuresAreEqualException;
import ru.cbr.xbrl.converter.exception.IncompatibleReportsException;
import ru.cbr.xbrl.converter.exception.IncorrectXlsxHeaderException;
import ru.cbr.xbrl.converter.exception.IncorrectXlsxStructureException;
import ru.cbr.xbrl.converter.exception.InputFilesAreEqualException;
import ru.cbr.xbrl.converter.exception.LogsCalculationException;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.RemoveFileException;
import ru.cbr.xbrl.converter.exception.RepParamsEmptyException;
import ru.cbr.xbrl.converter.exception.RepParamsNotFoundException;
import ru.cbr.xbrl.converter.exception.ReportDataHasDuplicatesException;
import ru.cbr.xbrl.converter.exception.ReportsIncompleteException;
import ru.cbr.xbrl.converter.exception.ReportsNotFoundException;
import ru.cbr.xbrl.converter.exception.RewritableFileOpenException;
import ru.cbr.xbrl.converter.exception.ValidateModLogException;
import ru.cbr.xbrl.converter.exception.WriteFileException;
import ru.cbr.xbrl.converter.exception.XMLSyntaxException;
import ru.cbr.xbrl.converter.exception.XwandLogException;
import ru.cbr.xbrl.converter.model.ReportData;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.event.NotificationEvent;
import ru.cbr.xbrl.converter.model.log.EventLog;
import ru.cbr.xbrl.converter.model.pkg.ContextPeriod;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.model.validation.ValidationEvent;
import ru.cbr.xbrl.converter.model_main.Taxonomy;
import ru.cbr.xbrl.converter.model_main.TaxonomyEntryPoint;
import ru.cbr.xbrl.converter.service.CacheManagementService;
import ru.cbr.xbrl.converter.service.PerformanceCheckService;
import ru.cbr.xbrl.converter.service.PerformanceCheckServiceImpl;
import ru.cbr.xbrl.converter.service.TaxonomyService;
import ru.cbr.xbrl.converter.service.XbrlPackageService;
import ru.cbr.xbrl.converter.service.XbrlValidateService;
import ru.cbr.xbrl.converter.service.event.NotificationEventService;
import ru.cbr.xbrl.converter.service.event.NotificationEventServiceImpl;
import ru.cbr.xbrl.converter.service.import_export.ImportXbrlService;
import ru.cbr.xbrl.converter.service.import_export.PeriodDates;
import ru.cbr.xbrl.converter.utils.FileUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.MetricType;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XlsxPerformanceLogWriter;
import ru.cbr.xbrl.converter.xbrl.import_export.xml.PerformanceMetricsWriter;
import ru.cbr.xbrl.converter.xbrl.import_export.xml.RepParamsXmlParser;

@Service
public class PerformanceCheckServiceImpl
implements PerformanceCheckService {
    private static final Logger log = LoggerFactory.getLogger(PerformanceCheckServiceImpl.class);
    @Autowired
    private XbrlPackageService xbrlPackageService;
    @Autowired
    private ImportXbrlService importXbrlService;
    @Autowired
    private TaxonomyService taxonomyService;
    @Autowired
    private ConfigProperties configProperties;
    @Autowired
    private NotificationEventService notificationEventService;
    @Autowired
    private ArelleService arelleService;
    @Autowired
    private XbrlValidateService xbrlValidateService;
    @Autowired
    private CacheManagementService cacheManagementService;
    private static final String REP_PARAMS_FILENAME = "RepParams.xml";
    private static final String AR_LOG_FILENAME = "Log_AR";
    private static final String METRICS_LOG_FILENAME = "Log_Metric";
    private static final String DIFF_PROTOCOL_FILENAME = "DiffProtocol";
    private static final String PERFORMANCE_LOG_FILENAME = "Log_Performance";
    private static final String VALIDATION_RESULTS_DIR = "Validation_Results";
    private static final String timePattern = "HH:mm:ss";
    private boolean isLastActionCanceled = false;
    private static int processingReports;
    private static int successfullyProcessedReports;
    private static int totalReports;
    private static int errorReports;
    private static int prepareValidationLogSeconds;
    private static int buildDifferenceLogSeconds;
    private static int creatingPackagesSeconds;
    private static int uploadPackagesSeconds;
    private static int validateReportsSeconds;
    private static final OperatingSystem OPERATING_SYSTEM;
    private static final int LOGICAL_PROCESSOR_COUNT;
    private static final List<String> PROCESS_NAMES;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processData(PerformanceCheckStruct performanceCheckStruct, boolean onlyValidationMode) throws Exception {
        this.clearModel(onlyValidationMode);
        List reportDataList = null;
        ArrayList<File> checkableReports = new ArrayList<File>();
        File baseDir = new File(performanceCheckStruct.getPath());
        for (File nextFile : Optional.ofNullable(baseDir.listFiles()).orElse(new File[0])) {
            if (nextFile.getName().equals(REP_PARAMS_FILENAME)) {
                try {
                    reportDataList = new RepParamsXmlParser().parseXml(nextFile, onlyValidationMode);
                    Set duplicates = this.findDuplicates(reportDataList);
                    if (duplicates.size() <= 0) continue;
                    throw new ReportDataHasDuplicatesException(this.getDuplicatesString(duplicates));
                }
                catch (ReportDataHasDuplicatesException | XMLSyntaxException e) {
                    throw e;
                }
                catch (Exception e) {
                    log.error(ExceptionUtils.getStackTrace((Throwable)e));
                    throw e;
                }
            }
            if (nextFile.getName().equals(this.getLogFilename(AR_LOG_FILENAME)) || nextFile.getName().equals(VALIDATION_RESULTS_DIR)) {
                this.checkAndDeleteFile(performanceCheckStruct.isAllowOverwriteFile(), nextFile);
                continue;
            }
            if ((nextFile.getName().equals(this.getLogFilename(PERFORMANCE_LOG_FILENAME)) || nextFile.getName().equals(this.getLogFilename(METRICS_LOG_FILENAME))) && !onlyValidationMode) {
                this.checkAndDeleteFile(performanceCheckStruct.isAllowOverwriteFile(), nextFile);
                continue;
            }
            if (!nextFile.getName().contains(".xbrl") && !nextFile.getName().contains(".xml")) continue;
            checkableReports.add(nextFile);
        }
        if (reportDataList == null) {
            throw new RepParamsNotFoundException();
        }
        if (reportDataList.size() == 0) {
            throw new RepParamsEmptyException();
        }
        if (checkableReports.isEmpty()) {
            throw new ReportsNotFoundException();
        }
        List filteredCheckableReports = this.getFilteredCheckableReports(reportDataList, checkableReports, performanceCheckStruct.isCheckReportListsDiff());
        Taxonomy taxonomy = this.taxonomyService.findByVersionSafe(performanceCheckStruct.getTaxonomyVersion());
        Map entrypointsByFilename = this.findEntrypoints(filteredCheckableReports);
        List incompatibleReports = entrypointsByFilename.keySet().stream().filter(name -> taxonomy.getTaxonomyEntryPoints().stream().noneMatch(taxonomyEntryPoint -> taxonomyEntryPoint.getPathToXsd().equals(entrypointsByFilename.get(name)))).collect(Collectors.toList());
        if (incompatibleReports.size() > 0) {
            if (performanceCheckStruct.getIncompatibleReportsProcessType() == 0) {
                log.info("Directory contains incompatible reports");
                throw new IncompatibleReportsException();
            }
            if (performanceCheckStruct.getIncompatibleReportsProcessType() == -1) {
                filteredCheckableReports = filteredCheckableReports.stream().filter(file -> incompatibleReports.stream().noneMatch(filename -> file.getName().equals(filename))).collect(Collectors.toList());
            }
        }
        List filteredReportDataList = this.getFilteredReportDataList(reportDataList, filteredCheckableReports);
        this.initUi(reportDataList, filteredReportDataList);
        if (onlyValidationMode) {
            Timer logTimer = this.startTimer(this.initLogTimerTask());
            try {
                this.runPackageValidation(filteredCheckableReports, filteredReportDataList, taxonomy, performanceCheckStruct.getPath() + File.separator + this.getLogFilename(AR_LOG_FILENAME));
            }
            finally {
                this.pauseTimer(logTimer);
            }
        } else {
            this.runPerformanceCheck(filteredCheckableReports, filteredReportDataList, taxonomy, performanceCheckStruct, entrypointsByFilename);
        }
        if (this.isLastActionCanceled) {
            this.cancelPackageProcess();
        }
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.TESTING_END, new NotificationEvent(LocalTime.now().format(DateTimeFormatter.ofPattern(timePattern))));
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.TESTING_PROCESSING_STATUS, new NotificationEvent(errorReports > 0 ? "\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e \u0441 \u043e\u0448\u0438\u0431\u043a\u0430\u043c\u0438" : "\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void formDifferenceProtocol(String xWandPath, String arellePath, boolean isAllowOverwriteFile) throws IOException, CommandExecutionException, CancelledException, FileAlreadyExistsException, WriteFileException, RewritableFileOpenException, XwandLogException, ValidateModLogException, LogsCalculationException, DifferenceProtocolWritingException, InputFilesAreEqualException, FilesStructuresAreEqualException, IncorrectXlsxHeaderException, IncorrectXlsxStructureException {
        File differentProtocolPath = new File(FilenameUtils.getFullPath((String)xWandPath) + this.getLogFilename(DIFF_PROTOCOL_FILENAME));
        if (differentProtocolPath.exists()) {
            this.checkAndDeleteFile(isAllowOverwriteFile, differentProtocolPath);
        }
        buildDifferenceLogSeconds = 0;
        Timer timer = this.startTimer(this.initFormTimerTask());
        try {
            this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.FORM_FORM_START, new NotificationEvent(LocalTime.now().format(DateTimeFormatter.ofPattern(timePattern))));
            this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.FORM_STATUS, new NotificationEvent("\u0418\u0434\u0435\u0442 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435"));
            try (FileInputStream xWand = new FileInputStream(xWandPath);
                 FileInputStream arelle = new FileInputStream(arellePath);){
                int arelleRowCount = this.countWorkbookRows(new XSSFWorkbook((InputStream)arelle), false);
                this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.FORM_TOTAL_ARELLE, new NotificationEvent((Number)arelleRowCount));
                int xWandRowCount = this.countWorkbookRows(new XSSFWorkbook((InputStream)xWand), true);
                this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.FORM_TOTAL_XWAND, new NotificationEvent((Number)xWandRowCount));
            }
            catch (Exception e) {
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
                throw e;
            }
            ArelleCmdOptions cmdOptions = new ArelleCmdOptions();
            cmdOptions.setArelleExecutable(this.configProperties.getDifferenceProtocolExecutable());
            cmdOptions.getParameters().put("xWandLogPath", xWandPath);
            cmdOptions.getParameters().put("LogARPath ", arellePath);
            cmdOptions.getParameters().put("differenceProtocolPath", differentProtocolPath.getAbsolutePath());
            if (this.isLastActionCanceled) {
                this.cancelPackageProcess();
            }
            switch (this.arelleService.execute(cmdOptions)) {
                case 0: {
                    this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.FORM_STATUS, new NotificationEvent("\u041f\u0440\u043e\u0442\u043e\u043a\u043e\u043b \u0440\u0430\u0437\u043b\u0438\u0447\u0438\u0439 \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d"));
                    break;
                }
                case 1: {
                    this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.FORM_STATUS, new NotificationEvent("\u0420\u0430\u0437\u043b\u0438\u0447\u0438\u0439 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e"));
                    break;
                }
                case 20: {
                    throw new XwandLogException();
                }
                case 25: {
                    throw new ValidateModLogException();
                }
                case 26: {
                    throw new InputFilesAreEqualException();
                }
                case 27: {
                    throw new FilesStructuresAreEqualException();
                }
                case 30: {
                    throw new LogsCalculationException();
                }
                case 40: {
                    throw new DifferenceProtocolWritingException();
                }
            }
            if (this.isLastActionCanceled) {
                this.cancelPackageProcess();
            }
            this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.FORM_FORM_END, new NotificationEvent(LocalTime.now().format(DateTimeFormatter.ofPattern(timePattern))));
        }
        finally {
            this.arelleService.killCurrentArelleProcess();
            this.pauseTimer(timer);
        }
    }

    public void setLastActionCanceled(boolean lastActionCanceled) {
        this.isLastActionCanceled = lastActionCanceled;
    }

    private void checkAndDeleteFile(boolean isAllowOverwriteFile, File file) throws FileAlreadyExistsException, WriteFileException, RewritableFileOpenException {
        FileUtils.checkFileWritable((String)file.getAbsolutePath(), (Boolean)isAllowOverwriteFile);
        if (!file.delete() && !file.isDirectory()) {
            throw new RewritableFileOpenException();
        }
        try {
            if (file.isDirectory()) {
                FileUtils.deleteDir((String)file.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new RewritableFileOpenException();
        }
    }

    private List<ReportData> getFilteredReportDataList(List<ReportData> reportDataList, List<File> filteredCheckableReports) {
        Set filenames = filteredCheckableReports.stream().map(File::getName).collect(Collectors.toSet());
        return reportDataList.stream().filter(x -> filenames.contains(x.getFilename())).collect(Collectors.toList());
    }

    private List<File> getFilteredCheckableReports(List<ReportData> reportDataList, List<File> checkableReports, boolean isCheckReportsListsDiff) throws ReportsNotFoundException, ReportsIncompleteException {
        Set reportDataFilenames = reportDataList.stream().map(ReportData::getFilename).collect(Collectors.toSet());
        int uniqueReportDataFilenames = reportDataFilenames.size();
        Set checkableReportsFilenames = checkableReports.stream().map(File::getName).collect(Collectors.toSet());
        reportDataFilenames.removeAll(checkableReportsFilenames);
        if (reportDataFilenames.size() == uniqueReportDataFilenames && isCheckReportsListsDiff) {
            throw new ReportsNotFoundException();
        }
        if (reportDataFilenames.size() < uniqueReportDataFilenames && reportDataFilenames.size() > 0 && isCheckReportsListsDiff) {
            throw new ReportsIncompleteException();
        }
        Set finalReportDataFilenames = reportDataList.stream().map(ReportData::getFilename).collect(Collectors.toSet());
        return checkableReports.stream().filter(x -> finalReportDataFilenames.contains(x.getName())).collect(Collectors.toList());
    }

    private String getLogFilename(String logPrefix) {
        String result = logPrefix + "_" + LocalDate.now().toString();
        return logPrefix.equals(AR_LOG_FILENAME) || logPrefix.equals(PERFORMANCE_LOG_FILENAME) || logPrefix.equals(DIFF_PROTOCOL_FILENAME) ? result + ".xlsx" : result + ".xml";
    }

    private void runPackageValidation(List<File> checkableReports, List<ReportData> reportDataList, Taxonomy taxonomy, String validationLog) throws EmptyCheckList, CommandExecutionException, CancelledException {
        if (CollectionUtils.isEmpty(reportDataList)) {
            throw new EmptyCheckList();
        }
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.TESTING_TEST_NAME, new NotificationEvent("\u0412\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u044f \u043e\u0442\u0447\u0435\u0442\u0430"));
        for (ReportData reportData : reportDataList) {
            this.cacheManagementService.clearCache();
            this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.TESTING_COUNT_PROCESSING_REPORT, new NotificationEvent((Number)(++processingReports)));
            if (this.isLastActionCanceled) {
                this.cancelPackageProcess();
            }
            File file = checkableReports.stream().filter(report -> report.getName().equals(reportData.getFilename())).findFirst().get();
            this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.TESTING_REPORT_NAME, new NotificationEvent(reportData.getFilename()));
            if (this.testValidation(validationLog, file, taxonomy, reportData.getRefPeriodEnd(), false) == 0) {
                this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.TESTING_COUNT_SUCCESSFULLY_PROCESSED_REPORTS, new NotificationEvent((Number)(++successfullyProcessedReports)));
            } else {
                this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.TESTING_COUNT_ERROR_REPORTS, new NotificationEvent((Number)(++errorReports)));
            }
            this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.TESTING_COUNT_LEFT_REPORTS, new NotificationEvent((Number)this.countLeftReports()));
        }
        this.mergeXlsxResultsParts(validationLog);
    }

    private Stream<OSProcess> getProcessesStream() {
        return Stream.concat(Stream.of(OPERATING_SYSTEM.getProcess(OPERATING_SYSTEM.getProcessId())), Arrays.stream(OPERATING_SYSTEM.getProcesses(0, OperatingSystem.ProcessSort.NEWEST)).filter(osProcess -> PROCESS_NAMES.stream().anyMatch(name -> StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)osProcess.getName()))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPerformanceCheck(List<File> checkableReports, List<ReportData> reportDataList, Taxonomy taxonomy, PerformanceCheckStruct performanceCheckStruct, Map<String, String> entrypointsByFilename) throws IOException, XMLStreamException, NotFoundException, RemoveFileException, EmptyCheckList, CommandExecutionException, CancelledException {
        if (CollectionUtils.isEmpty(reportDataList)) {
            throw new EmptyCheckList();
        }
        String validationLog = performanceCheckStruct.getPath() + File.separator + this.getLogFilename(AR_LOG_FILENAME);
        String metricsLog = performanceCheckStruct.getPath() + File.separator + this.getLogFilename(METRICS_LOG_FILENAME);
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(metricsLog));){
            PerformanceMetricsWriter performanceMetricsWriter = new PerformanceMetricsWriter((OutputStream)bufferedOutputStream);
            for (ReportData reportData : reportDataList) {
                this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.TESTING_COUNT_PROCESSING_REPORT, new NotificationEvent((Number)(++processingReports)));
                File file = checkableReports.stream().filter(report -> report.getName().equals(reportData.getFilename())).findFirst().get();
                this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.TESTING_REPORT_NAME, new NotificationEvent(reportData.getFilename()));
                ScheduledExecutorService executor = Executors.newScheduledThreadPool(3);
                try {
                    XbrlPackage xbrlPackage;
                    if (this.isLastActionCanceled) {
                        this.cancelPackageProcess();
                    }
                    this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.TESTING_TEST_NAME, new NotificationEvent("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0443\u0441\u0442\u043e\u0433\u043e \u043f\u0430\u043a\u0435\u0442\u0430 \u043e\u0442\u0447\u0435\u0442\u0430"));
                    1 oldBytes = new /* Unavailable Anonymous Inner Class!! */;
                    if (reportData.getHddCheckRate() > 0) {
                        executor.scheduleWithFixedDelay(() -> this.lambda$runPerformanceCheck$12((List)oldBytes, performanceMetricsWriter, reportData), 0L, Math.max(10, reportData.getHddCheckRate()), TimeUnit.SECONDS);
                    }
                    if (reportData.getCpuCheckRate() > 0) {
                        executor.scheduleWithFixedDelay(() -> {
                            double cpuUsage = this.getProcessesStream().mapToDouble(OSProcess::calculateCpuPercent).sum() * 100.0;
                            cpuUsage = cpuUsage > (double)(LOGICAL_PROCESSOR_COUNT * 100) ? 100.0 : (cpuUsage /= (double)LOGICAL_PROCESSOR_COUNT);
                            performanceMetricsWriter.writeMetricValue(reportData.getFilename(), MetricType.CPU, Precision.round((double)cpuUsage, (int)3));
                        }, 0L, Math.max(10, reportData.getCpuCheckRate()), TimeUnit.SECONDS);
                    }
                    if (reportData.getRamCheckRate() > 0) {
                        executor.scheduleWithFixedDelay(() -> {
                            long memoryUsage = this.getProcessesStream().mapToLong(OSProcess::getResidentSetSize).sum();
                            performanceMetricsWriter.writeMetricValue(reportData.getFilename(), MetricType.RAM, (double)(memoryUsage / 1024L / 1024L));
                        }, 0L, Math.max(10, reportData.getRamCheckRate()), TimeUnit.SECONDS);
                    }
                    long moment = System.currentTimeMillis();
                    Timer createTimer = this.startTimer(this.initCreateTimerTask());
                    try {
                        xbrlPackage = this.testCreatePackage(performanceCheckStruct, reportData, taxonomy.getEntryPointByXsdPath(entrypointsByFilename.get(file.getName())));
                    }
                    finally {
                        this.pauseTimer(createTimer);
                    }
                    performanceMetricsWriter.writeMetricValue(reportData.getFilename(), MetricType.TIME_CREATE, Precision.round((double)((double)(System.currentTimeMillis() - moment) / 1000.0), (int)3));
                    if (this.isLastActionCanceled) {
                        this.cancelPackageProcess();
                    }
                    moment = System.currentTimeMillis();
                    this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.TESTING_TEST_NAME, new NotificationEvent("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u043f\u0430\u043a\u0435\u0442\u0430 \u043e\u0442\u0447\u0435\u0442\u0430"));
                    Timer uploadTimer = this.startTimer(this.initUploadTimerTask());
                    try {
                        xbrlPackage = this.testUploadReport(file.getAbsolutePath(), xbrlPackage);
                    }
                    finally {
                        this.pauseTimer(uploadTimer);
                    }
                    performanceMetricsWriter.writeMetricValue(reportData.getFilename(), MetricType.TIME_UPLOAD, Precision.round((double)((double)(System.currentTimeMillis() - moment) / 1000.0), (int)3));
                    if (this.isLastActionCanceled) {
                        this.cancelPackageProcess();
                    }
                    moment = System.currentTimeMillis();
                    this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.TESTING_TEST_NAME, new NotificationEvent("\u0412\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u044f \u043e\u0442\u0447\u0435\u0442\u0430"));
                    Timer validateTimer = this.startTimer(this.initValidateTimerTask());
                    try {
                        this.testValidation(validationLog, file, taxonomy, reportData.getRefPeriodEnd(), true);
                    }
                    finally {
                        this.pauseTimer(validateTimer);
                    }
                    double endValidationMoment = (double)System.currentTimeMillis() - (double)moment;
                    executor.shutdown();
                    for (int i = 0; i <= 30 && !executor.isTerminated(); ++i) {
                        Thread.sleep(400L);
                    }
                    performanceMetricsWriter.writeMetricValue(reportData.getFilename(), MetricType.TIME_VALIDATION, Precision.round((double)(endValidationMoment / 1000.0), (int)3));
                    this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.TESTING_COUNT_SUCCESSFULLY_PROCESSED_REPORTS, new NotificationEvent((Number)(++successfullyProcessedReports)));
                    this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.TESTING_COUNT_LEFT_REPORTS, new NotificationEvent((Number)this.countLeftReports()));
                }
                catch (ActionCancelledException e) {
                    performanceMetricsWriter.closeWriting();
                    throw e;
                }
                catch (Exception e) {
                    this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.TESTING_COUNT_ERROR_REPORTS, new NotificationEvent((Number)(++errorReports)));
                    this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.TESTING_COUNT_LEFT_REPORTS, new NotificationEvent((Number)this.countLeftReports()));
                    log.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
                finally {
                    this.closeLastPackage();
                    if (executor.isTerminated()) continue;
                    executor.shutdownNow();
                }
            }
            performanceMetricsWriter.closeWriting();
            this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.FORM_STATUS, new NotificationEvent("\u0424\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u0434\u0438\u043d\u0435\u043d\u043d\u043e\u0433\u043e \u043b\u043e\u0433\u0430"));
            this.mergeXlsxResultsParts(validationLog);
            if (this.isLastActionCanceled) {
                this.cancelPackageProcess();
            }
            new XlsxPerformanceLogWriter(validationLog, metricsLog, performanceCheckStruct.getPath());
        }
        catch (ActionCancelledException e) {
            throw e;
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw e;
        }
    }

    private void mergeXlsxResultsParts(String validationLog) throws CommandExecutionException, CancelledException {
        try {
            ArelleCmdOptions cmdOptions = new ArelleCmdOptions();
            cmdOptions.setArelleExecutable(this.configProperties.getDifferenceProtocolExecutable());
            cmdOptions.setMergedARXlsxLogPath("\"" + validationLog + "\"");
            this.arelleService.execute(cmdOptions);
        }
        finally {
            this.arelleService.killCurrentArelleProcess();
        }
    }

    private void closeLastPackage() throws NotFoundException, RemoveFileException {
        if (this.xbrlPackageService.findLastPackage() != null) {
            this.xbrlPackageService.close(this.xbrlPackageService.findLastPackage().getId());
        }
    }

    private void clearModel(boolean onlyValidationMode) {
        successfullyProcessedReports = 0;
        processingReports = 0;
        totalReports = 0;
        errorReports = 0;
        if (onlyValidationMode) {
            prepareValidationLogSeconds = 0;
        } else {
            creatingPackagesSeconds = 0;
            uploadPackagesSeconds = 0;
            validateReportsSeconds = 0;
        }
    }

    private int countLeftReports() {
        return totalReports - successfullyProcessedReports;
    }

    private Timer startTimer(TimerTask task) {
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(task, 1000L, 1000L);
        return timer;
    }

    private void pauseTimer(Timer timer) {
        timer.cancel();
    }

    private void cancelPackageProcess() {
        this.arelleService.killCurrentArelleProcess();
        log.info("Package processing cancelled by user");
        this.setLastActionCanceled(false);
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.CANCEL, new NotificationEvent());
        throw new ActionCancelledException();
    }

    private Map<String, String> findEntrypoints(List<File> checkableReports) {
        HashMap<String, String> entrypointsByFilename = new HashMap<String, String>();
        for (File checkableReport : checkableReports) {
            try {
                2 parser = new /* Unavailable Anonymous Inner Class!! */;
                entrypointsByFilename.put(checkableReport.getName(), parser.getEntryPoint().replace("http:/", ".."));
            }
            catch (Exception e) {
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return entrypointsByFilename;
    }

    private int testValidation(String validationLog, File file, Taxonomy taxonomy, Date refPeriodEnd, boolean includeTiming) {
        try {
            String logFile = "logFile";
            ArelleCmdOptions cmdOptions = new ArelleCmdOptions();
            cmdOptions.setArelleExecutable(this.configProperties.getArelleExecutable());
            cmdOptions.setFilePath(file.getAbsolutePath());
            cmdOptions.setValidation(Boolean.TRUE.booleanValue());
            cmdOptions.setSaveFileOutput(Boolean.TRUE.booleanValue());
            cmdOptions.setPackages(new String[]{taxonomy.getFilePath()});
            cmdOptions.setXlsxLogPath(validationLog);
            cmdOptions.getParameters().put("{http://parameters}refPeriodEnd", PeriodDates.formatDate((Date)refPeriodEnd));
            cmdOptions.setIncludeTiming(includeTiming);
            if (includeTiming) {
                cmdOptions.setLogOverSocket(this.configProperties.getProcessLogOverSocket());
                cmdOptions.setSocketLogPort(this.configProperties.getLogSocketPort().intValue());
            }
            cmdOptions.setEnabledFileOutputOptions(new String[]{logFile});
            int errCode = this.arelleService.execute(cmdOptions);
            if (includeTiming && !this.configProperties.getProcessLogOverSocket().booleanValue()) {
                this.configProperties.setLogSocketPort(Integer.valueOf(this.configProperties.getLogSocketPort() + 1));
                XbrlReport xbrlReport = this.xbrlPackageService.findLastPackage().getXbrlReport();
                List validationEvents = ArelleOutputParser.parseXmlValidation((String)((String)cmdOptions.getOutputFiles().get(logFile)), (XbrlReport)xbrlReport);
                for (ValidationEvent validationEvent : validationEvents) {
                    this.xbrlValidateService.fillAspectData(xbrlReport.getXbrlPackage().getContextPeriod(), validationEvent);
                    this.xbrlValidateService.sendValidationEvent(xbrlReport, validationEvent);
                }
            }
            return errCode;
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return -1;
        }
    }

    private XbrlPackage testCreatePackage(PerformanceCheckStruct performanceCheckStruct, ReportData reportData, TaxonomyEntryPoint entryPoint) {
        XbrlPackage xbrlPackage = new XbrlPackage();
        xbrlPackage.setName("");
        xbrlPackage.setOgrn("");
        xbrlPackage.setTaxonomyVersion(performanceCheckStruct.getTaxonomyVersion());
        xbrlPackage.setPathForPackage(performanceCheckStruct.getPath());
        ContextPeriod contextPeriod = this.buildContextPeriod(reportData, entryPoint);
        contextPeriod.setXbrlPackage(xbrlPackage);
        xbrlPackage.setContextPeriod(contextPeriod);
        xbrlPackage.setPathToXsd(entryPoint.getPathToXsd());
        xbrlPackage.setUploadTime(new Date(System.currentTimeMillis()));
        try {
            return this.xbrlPackageService.create(xbrlPackage);
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    private ContextPeriod buildContextPeriod(ReportData reportData, TaxonomyEntryPoint entryPoint) {
        Date reportDate = reportData.getReportDate();
        LocalDate localReportDate = Instant.ofEpochMilli(reportDate.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
        String periodType = entryPoint.getReportPeriodType();
        ContextPeriod contextPeriod = new ContextPeriod();
        contextPeriod.setReportPeriodType(periodType);
        contextPeriod.setYear(Integer.valueOf(localReportDate.getYear()));
        switch (periodType) {
            case "y": 
            case "r": {
                localReportDate = localReportDate.minusYears(1L);
                break;
            }
            case "q": {
                localReportDate = localReportDate.minusMonths(3L);
                break;
            }
            case "m": {
                localReportDate = localReportDate.minusMonths(1L);
                break;
            }
            case "w": {
                localReportDate = localReportDate.minusWeeks(1L);
                break;
            }
            case "d": {
                localReportDate = localReportDate.minusDays(1L);
            }
        }
        contextPeriod.setStartDate(Date.from(localReportDate.atStartOfDay(ZoneId.systemDefault()).toInstant()));
        contextPeriod.setEndDate(reportDate);
        contextPeriod.setTitle(contextPeriod.getStartDate() + " - " + contextPeriod.getEndDate());
        return contextPeriod;
    }

    private XbrlPackage testUploadReport(String localPath, XbrlPackage xbrlPackage) {
        try {
            XbrlPackage result;
            String extension = FilenameUtils.getExtension((String)localPath);
            if (StringUtils.equals((CharSequence)extension, (CharSequence)"htm") || StringUtils.equals((CharSequence)extension, (CharSequence)"html")) {
                localPath = this.importXbrlService.convertIxbrlToXml(localPath);
            }
            if ((result = this.importXbrlService.importXmlAndRefreshView(xbrlPackage.getXbrlReport().getId(), localPath, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), EventLog.EventLogType.IMPORT_XML)).getXbrlReport() != null) {
                result.getXbrlReport().prepareForJson();
            }
            return result;
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    private TimerTask initLogTimerTask() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private TimerTask initValidateTimerTask() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private TimerTask initCreateTimerTask() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private TimerTask initUploadTimerTask() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private TimerTask initFormTimerTask() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private String getAbsoluteDiffProtocolDirectoryPath() throws IOException {
        String absoluteDiffProtocolDirectoryPath = FileUtils.relativePathToAbsolute((String)this.configProperties.getDiffProtocolStorePath());
        File diffProtocolDir = new File(absoluteDiffProtocolDirectoryPath);
        diffProtocolDir.mkdirs();
        if (!diffProtocolDir.isDirectory()) {
            throw new IOException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u0438 \u0434\u043b\u044f \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430 \u0440\u0430\u0437\u043b\u0438\u0447\u0438\u0439");
        }
        return absoluteDiffProtocolDirectoryPath;
    }

    private Set<ReportData> findDuplicates(List<ReportData> reportDataList) {
        ArrayList<ReportData> originalReportDataList = new ArrayList<ReportData>(reportDataList);
        HashSet<ReportData> reportDataSet = new HashSet<ReportData>(originalReportDataList);
        ArrayList<ReportData> uniqueOriginalReportDataList = new ArrayList<ReportData>(reportDataSet);
        Iterator originalListIterator = originalReportDataList.iterator();
        block0: while (originalListIterator.hasNext()) {
            ReportData originalData = (ReportData)originalListIterator.next();
            Iterator<ReportData> uniqueListIterator = uniqueOriginalReportDataList.iterator();
            while (uniqueListIterator.hasNext()) {
                if (!originalData.equals((Object)uniqueListIterator.next())) continue;
                originalListIterator.remove();
                uniqueListIterator.remove();
                continue block0;
            }
        }
        return new HashSet<ReportData>(originalReportDataList);
    }

    private String getDuplicatesString(Set<ReportData> duplicates) {
        return duplicates.stream().map(ReportData::getFilename).collect(Collectors.joining("\n"));
    }

    private void initUi(List<ReportData> reportDataList, List<ReportData> filteredReportDataList) {
        totalReports = reportDataList.size();
        successfullyProcessedReports = errorReports = totalReports - filteredReportDataList.size();
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.TESTING_PROCESSING_STATUS, new NotificationEvent("\u0418\u0434\u0435\u0442 \u0442\u0435\u0441\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435"));
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.TESTING_START, new NotificationEvent(LocalTime.now().format(DateTimeFormatter.ofPattern(timePattern))));
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.TESTING_TOTAL_REPORTS, new NotificationEvent((Number)totalReports));
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.TESTING_COUNT_SUCCESSFULLY_PROCESSED_REPORTS, new NotificationEvent((Number)successfullyProcessedReports));
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.TESTING_COUNT_ERROR_REPORTS, new NotificationEvent((Number)errorReports));
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.TESTING_SHOW_PROGRESS_DIALOG, new NotificationEvent());
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.TESTING_COUNT_SUITABLE_REPORTS, new NotificationEvent((Number)totalReports));
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.TESTING_COUNT_LEFT_REPORTS, new NotificationEvent((Number)this.countLeftReports()));
        processingReports = errorReports;
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.TESTING_COUNT_PROCESSING_REPORT, new NotificationEvent((Number)(errorReports > 0 ? errorReports : 1)));
    }

    private int getSheetHeaderLength(XSSFWorkbook wb, boolean isXWandWorkbook) throws IncorrectXlsxHeaderException {
        XSSFRow headerRow = wb.getSheetAt(0).getRow(0);
        int result = 0;
        for (Cell cell : headerRow) {
            if (!this.isNotCellEmpty(cell)) continue;
            ++result;
        }
        if (isXWandWorkbook && result != headerRow.getLastCellNum() - 1 || !isXWandWorkbook && result != headerRow.getLastCellNum()) {
            throw new IncorrectXlsxHeaderException(isXWandWorkbook ? "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0432 \u043b\u043e\u0433\u0435 XWand" : "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0432 \u043b\u043e\u0433\u0435 \u0410\u043d\u043a\u0435\u0442\u044b-\u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0430");
        }
        return headerRow.getLastCellNum();
    }

    private boolean isNotCellEmpty(Cell cell) {
        if (cell == null || cell.getCellType() == CellType.BLANK) {
            return false;
        }
        return cell.getCellType() != CellType.STRING || !cell.getStringCellValue().isEmpty();
    }

    private boolean isNotBlankRow(Row row, int sheetHeaderLength, boolean isXWandWorkbook) throws IncorrectXlsxStructureException {
        if (row.getLastCellNum() > sheetHeaderLength) {
            throw new IncorrectXlsxStructureException(isXWandWorkbook ? "\u0412 \u043b\u043e\u0433\u0435 XWand \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u043c\u0438 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0434\u0430\u043d\u043d\u044b\u0435" : "\u0412 \u043b\u043e\u0433\u0435 \u0410\u043d\u043a\u0435\u0442\u044b-\u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0430 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u043c\u0438 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0434\u0430\u043d\u043d\u044b\u0435");
        }
        for (Cell next : row) {
            if (!this.isNotCellEmpty(next)) continue;
            return true;
        }
        return false;
    }

    private int countWorkbookRows(XSSFWorkbook wb, boolean isXWandWorkbook) throws IncorrectXlsxHeaderException, IncorrectXlsxStructureException {
        int result = 0;
        int headerLength = this.getSheetHeaderLength(wb, isXWandWorkbook);
        for (Sheet sheet : wb) {
            for (Row row : sheet) {
                if (!this.isNotBlankRow(row, headerLength, isXWandWorkbook)) continue;
                ++result;
            }
        }
        return result;
    }

    private /* synthetic */ void lambda$runPerformanceCheck$12(List oldBytes, PerformanceMetricsWriter performanceMetricsWriter, ReportData reportData) {
        long oldBytesRead = ((Map)oldBytes.get(0)).values().stream().reduce(0L, Long::sum);
        HashMap bytesReadByPid = new HashMap((Map)oldBytes.get(0));
        this.getProcessesStream().forEach(osProcess -> bytesReadByPid.put(osProcess.getProcessID(), osProcess.getBytesRead()));
        long bytesRead = bytesReadByPid.values().stream().reduce(0L, Long::sum);
        oldBytes.set(0, bytesReadByPid);
        performanceMetricsWriter.writeMetricValue(reportData.getFilename(), MetricType.HDD_READ, Precision.round((double)((double)(bytesRead - oldBytesRead) / 1024.0 / 1024.0), (int)3));
        long oldBytesWritten = ((Map)oldBytes.get(1)).values().stream().reduce(0L, Long::sum);
        HashMap bytesWrittenByPid = new HashMap((Map)oldBytes.get(1));
        this.getProcessesStream().forEach(osProcess -> bytesWrittenByPid.put(osProcess.getProcessID(), osProcess.getBytesWritten()));
        long bytesWritten = bytesWrittenByPid.values().stream().reduce(0L, Long::sum);
        oldBytes.set(1, bytesWrittenByPid);
        performanceMetricsWriter.writeMetricValue(reportData.getFilename(), MetricType.HDD_WRITE, Precision.round((double)((double)(bytesWritten - oldBytesWritten) / 1024.0 / 1024.0), (int)3));
    }

    static /* synthetic */ Stream access$000(PerformanceCheckServiceImpl x0) {
        return x0.getProcessesStream();
    }

    static /* synthetic */ int access$104() {
        return ++prepareValidationLogSeconds;
    }

    static /* synthetic */ NotificationEventService access$200(PerformanceCheckServiceImpl x0) {
        return x0.notificationEventService;
    }

    static /* synthetic */ int access$304() {
        return ++validateReportsSeconds;
    }

    static /* synthetic */ int access$404() {
        return ++creatingPackagesSeconds;
    }

    static /* synthetic */ int access$504() {
        return ++uploadPackagesSeconds;
    }

    static /* synthetic */ int access$604() {
        return ++buildDifferenceLogSeconds;
    }

    static {
        OPERATING_SYSTEM = new SystemInfo().getOperatingSystem();
        LOGICAL_PROCESSOR_COUNT = new SystemInfo().getHardware().getProcessor().getLogicalProcessorCount();
        PROCESS_NAMES = Arrays.asList("Electron", "Anketa-Redaktor XBRL", "\u0410\u043d\u043a\u0435\u0442\u0430-\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 XBRL", "ValidateModule", "socketServerExportExcel");
    }
}

