/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.model.XbrlDimension;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.filter.FilterViewType;
import ru.cbr.xbrl.converter.model.tableLinkBase.AspectNodeMember;
import ru.cbr.xbrl.converter.model.tableLinkBase.AxisMemberHierarchy;
import ru.cbr.xbrl.converter.model.tableLinkBase.NodeType;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBaseStructure;
import ru.cbr.xbrl.converter.model.web.rest.AspectDataWrapper;
import ru.cbr.xbrl.converter.model.web.rest.ColumnHeader;
import ru.cbr.xbrl.converter.model.web.rest.SearchResult;
import ru.cbr.xbrl.converter.service.SearchService;
import ru.cbr.xbrl.converter.service.TableLinkBaseDataService;
import ru.cbr.xbrl.converter.service.TableLinkBaseDynamicStructureService;
import ru.cbr.xbrl.converter.service.XbrlDimensionService;
import ru.cbr.xbrl.converter.service.XbrlPackageServiceImpl;
import ru.cbr.xbrl.converter.service.internal.xbrl.XbrlValueCrudService;
import ru.cbr.xbrl.converter.service.presentation_definition.InactiveMembersService;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionRole;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionRoleMember;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionService;
import ru.cbr.xbrl.converter.service.tablelinkbase.AxisService;
import ru.cbr.xbrl.converter.utils.LabelUtils;
import ru.cbr.xbrl.converter.utils.LispStyleUtil;
import ru.cbr.xbrl.converter.utils.TextUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;

@Service
public class SearchServiceImpl
implements SearchService {
    private static final Logger log = LoggerFactory.getLogger(SearchServiceImpl.class);
    public static final String DELIMITER = "-";
    private final XbrlDimensionService xbrlDimensionService;
    private final ObjectMapper objectMapper;
    private final XbrlValueCrudService xbrlValueCrudService;
    private final PresentationDefinitionService presentationDefinitionService;
    private final XbrlPackageServiceImpl xbrlPackageService;
    private final TableLinkBaseDynamicStructureService tableLinkBaseDynamicStructureService;
    private final InactiveMembersService inactiveMembersService;
    private final AxisService axisService;

    @Transactional(value="cacheTransactionManager")
    public SearchResult searchByLabelPresDef(String term) {
        SearchResult searchResult = new SearchResult();
        AtomicInteger counter = new AtomicInteger();
        AtomicBoolean found = new AtomicBoolean();
        List presentationDefinitionRoleList = this.presentationDefinitionService.getPresentationDefinitionRoles();
        for (PresentationDefinitionRole presDefRole : presentationDefinitionRoleList) {
            Integer count;
            List dimensionList;
            Integer count2;
            found.set(false);
            PresentationDefinitionRole presentationDefinitionRole = this.presentationDefinitionService.getPresentationDefinitionRole(presDefRole.getCode());
            List aspectCellDataList = this.presentationDefinitionService.getRoleListItems(presDefRole.getCode());
            HashMap memberFilteredMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)aspectCellDataList)) {
                for (AspectCellData aspectCellData : aspectCellDataList) {
                    AspectData conceptInfo = aspectCellData.getConcept();
                    String conceptLabel = (String)presentationDefinitionRole.getConcepts().stream().filter(conceptPair -> ((String)conceptPair.getKey()).equals(conceptInfo.getAspectValue())).findAny().get().getValue();
                    count2 = TextUtils.countMatchesIgnoreCase((String)conceptLabel, (String)term);
                    if (count2 > 0) {
                        this.foundActionWithCount(counter, found, count2);
                    }
                    List dimensionAspectList = aspectCellData.getDimensions();
                    dimensionAspectList.forEach(dimensionAspectData -> {
                        memberFilteredMap.putIfAbsent(dimensionAspectData.getAspect(), new HashSet());
                        ((Set)memberFilteredMap.get(dimensionAspectData.getAspect())).add(dimensionAspectData.getAspectValue());
                    });
                }
            }
            if (!CollectionUtils.isEmpty((Collection)(dimensionList = presentationDefinitionRole.getDimensions()))) {
                AspectCellData aspectCellData;
                aspectCellData = dimensionList.iterator();
                while (aspectCellData.hasNext()) {
                    List membersInfoList;
                    Pair dimensionInfo = (Pair)aspectCellData.next();
                    String dimensionQName = (String)dimensionInfo.getKey();
                    Set allowedMembers = (Set)memberFilteredMap.get(dimensionQName);
                    Integer count3 = TextUtils.countMatchesIgnoreCase((String)((String)dimensionInfo.getValue()), (String)term);
                    if (count3 > 0) {
                        this.foundActionWithCount(counter, found, count3);
                    }
                    if (CollectionUtils.isEmpty((Collection)allowedMembers) || CollectionUtils.isEmpty((Collection)(membersInfoList = (List)presentationDefinitionRole.getMembers().get(dimensionQName)))) continue;
                    for (Pair memberInfo : membersInfoList) {
                        String memberQname = (String)memberInfo.getKey();
                        if (!allowedMembers.contains(memberQname) || (count3 = TextUtils.countMatchesIgnoreCase((String)((PresentationDefinitionRoleMember)memberInfo.getValue()).getValue(), (String)term)) <= 0) continue;
                        this.foundActionWithCount(counter, found, count3);
                    }
                }
            }
            List periodList = presentationDefinitionRole.getPeriods();
            if (!CollectionUtils.isEmpty((Collection)dimensionList)) {
                for (Pair periodInfo : periodList) {
                    count2 = TextUtils.countMatchesIgnoreCase((String)((String)periodInfo.getValue()), (String)term);
                    if (count2 <= 0) continue;
                    this.foundActionWithCount(counter, found, count2);
                }
            }
            if ((count = TextUtils.countMatchesIgnoreCase((String)"\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044f", (String)term)) > 0) {
                this.foundActionWithCount(counter, found, count);
            }
            if (!found.get()) continue;
            searchResult.getPreDefRoles().add(presDefRole.getSystemId());
        }
        searchResult.setTotalPreDef(Integer.valueOf(counter.get()));
        return searchResult;
    }

    @Transactional(value="cacheTransactionManager")
    public SearchResult searchByLabel(String term) {
        XbrlReport processedReport = this.xbrlPackageService.findLastPackage().getXbrlReport();
        if (StringUtils.isBlank((CharSequence)term) || processedReport == null) {
            return null;
        }
        this.checkLabelsMismatches();
        AtomicInteger i = new AtomicInteger(0);
        String trimmedTerm = StringUtils.trim((String)term);
        SearchResult searchResult = new SearchResult();
        searchResult.setSearchMode(SearchResult.SearchMode.LABEL);
        searchResult.setTerm(trimmedTerm);
        Long countInactiveOpenMember = this.inactiveMembersService.countInactiveOpenMember();
        Long countInactiveClosedMember = this.inactiveMembersService.countInactiveClosedMember();
        for (XbrlReportRole xbrlReportRole : processedReport.getXbrlReportRoles()) {
            AtomicBoolean found = new AtomicBoolean(false);
            List aspectNodeMemberList = xbrlReportRole.getAspectNodeMembers();
            String staticStructureJson = xbrlReportRole.getStaticStructureJson();
            Map<String, List<AspectNodeMember>> aspNodeMembers = aspectNodeMemberList.stream().collect(Collectors.groupingBy(AspectNodeMember::getHash));
            try {
                TableLinkBaseStructure tableLinkBaseStructure = (TableLinkBaseStructure)this.objectMapper.readValue(staticStructureJson, TableLinkBaseStructure.class);
                AtomicBoolean enablePeriod = new AtomicBoolean(true);
                if (StringUtils.isBlank((CharSequence)tableLinkBaseStructure.getPeriodAxis()) || StringUtils.equalsIgnoreCase((CharSequence)tableLinkBaseStructure.getPeriodAxis(), (CharSequence)"z") || CollectionUtils.isEmpty((Collection)tableLinkBaseStructure.getPeriods())) {
                    enablePeriod.set(false);
                }
                tableLinkBaseStructure.setXAxis((AxisMemberHierarchy)LispStyleUtil.car((List)this.tableLinkBaseDynamicStructureService.cortegeFilledAxis(xbrlReportRole.getSystemId(), aspNodeMembers, tableLinkBaseStructure.getXAxis(), tableLinkBaseStructure.getXAxis(), new ArrayList(), true, 0)));
                this.axisService.fillDates(tableLinkBaseStructure, xbrlReportRole);
                ColumnHeader columnHeader = TableLinkBaseDataService.buildColumnsFromHierarchy((AxisMemberHierarchy)tableLinkBaseStructure.getXAxis(), (String)tableLinkBaseStructure.getPeriodAxis());
                this.searchInColumnsHeader(columnHeader, trimmedTerm, i, found);
                tableLinkBaseStructure.iterateYAxisMemberHierarchy(axisMemberHierarchy -> {
                    List aspectNodeMembers;
                    if (axisMemberHierarchy.getNodeType() == NodeType.RULE) {
                        String label = LabelUtils.calcLabel((List)axisMemberHierarchy.getAspectDataList(), (String)axisMemberHierarchy.getLabel());
                        Integer count = TextUtils.countMatchesIgnoreCase((String)label, (String)trimmedTerm);
                        if (count > 0) {
                            this.foundActionWithCount(i, found, count);
                        }
                    } else if (axisMemberHierarchy.getNodeType() == NodeType.ASPECT && (aspectNodeMembers = (List)aspNodeMembers.get(axisMemberHierarchy.getHash())) != null) {
                        for (AspectNodeMember aspectNodeMember : aspectNodeMembers) {
                            Integer count;
                            String value;
                            String label;
                            boolean isOpenAxis;
                            Optional<AspectData> target = axisMemberHierarchy.getAspectDataList().stream().filter(it -> it.getAspect().equals(aspectNodeMember.getDimension())).findFirst();
                            if (!target.isPresent()) continue;
                            AspectData targetAspectData = target.get();
                            AxisMemberHierarchy newAspectAxisMemberHierarchy = new AxisMemberHierarchy();
                            newAspectAxisMemberHierarchy.setAxis(axisMemberHierarchy.getAxis());
                            newAspectAxisMemberHierarchy.setId(aspectNodeMember.getCommonId());
                            boolean bl = isOpenAxis = aspectNodeMember.getFilterOpenAxisValue() != null;
                            if (isOpenAxis) {
                                label = aspectNodeMember.getFilterOpenAxisValue().getValue();
                                value = aspectNodeMember.getFilterOpenAxisValue().getValue();
                            } else {
                                label = aspectNodeMember.getClosedMemberLabel();
                                value = aspectNodeMember.getClosedMemberValue();
                            }
                            AspectData aspectData = new AspectData();
                            aspectData.setAspect(targetAspectData.getAspect());
                            aspectData.setLabel(targetAspectData.getLabel() + DELIMITER + label);
                            aspectData.setAspectValue(value);
                            aspectData.setType(AspectType.DIMENSION);
                            aspectData.setDimensionType(targetAspectData.getDimensionType());
                            aspectData.setDomain(targetAspectData.getDomain());
                            newAspectAxisMemberHierarchy.getAspectDataList().add(aspectData);
                            newAspectAxisMemberHierarchy.getAspectDataList().addAll(axisMemberHierarchy.getAspectDataList().stream().filter(it -> it.getType().equals((Object)AspectType.CONCEPT)).collect(Collectors.toList()));
                            newAspectAxisMemberHierarchy.setLabel(LabelUtils.calcLabel((List)newAspectAxisMemberHierarchy.getAspectDataList(), null));
                            newAspectAxisMemberHierarchy.setChildAspectNodes(TableLinkBaseDynamicStructureService.calcChildAspectNodes((AxisMemberHierarchy)axisMemberHierarchy));
                            newAspectAxisMemberHierarchy.setHash(aspectNodeMember.getCommonId());
                            boolean bl2 = isOpenAxis ? countInactiveOpenMember == 0L || !this.inactiveMembersService.isInactiveOpenMember(xbrlReportRole.getSystemId(), aspectNodeMember.getFilterOpenAxisValue().getId(), FilterViewType.TABLELINKBASE) : countInactiveClosedMember == 0L || !this.inactiveMembersService.isInactiveClosedMember(xbrlReportRole.getSystemId(), aspectData.getAspect(), aspectData.getAspectValue(), FilterViewType.TABLELINKBASE);
                            boolean isActive = bl2;
                            if (!isActive || (count = TextUtils.countMatchesIgnoreCase((String)newAspectAxisMemberHierarchy.getLabel(), (String)trimmedTerm)) <= 0) continue;
                            this.foundActionWithCount(i, found, count);
                        }
                    }
                });
                if (!found.get()) continue;
                searchResult.getTableRoles().add(xbrlReportRole.getSystemId());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        searchResult.setTotalTable(Integer.valueOf(i.get()));
        return searchResult;
    }

    private void checkLabelsMismatches() {
        HashMap<String, String> dimensionQnameLabelMap = new HashMap<String, String>();
        HashMap<String, String> dimensionMemberQnameLabelMap = new HashMap<String, String>();
        List xbrlDimensionList = this.xbrlDimensionService.findAll();
        for (XbrlDimension xbrlDimension : xbrlDimensionList) {
            String dimInt = xbrlDimension.getDimInt();
            String dimIntLabel = xbrlDimension.getDimIntLabel();
            String dimIntLabelMapValue = (String)dimensionQnameLabelMap.get(dimInt);
            if (!StringUtils.equals((CharSequence)dimIntLabelMapValue, (CharSequence)dimIntLabel) && StringUtils.isNotBlank((CharSequence)dimIntLabelMapValue) && StringUtils.isNotBlank((CharSequence)dimIntLabel)) {
                log.info("\u043d\u0435\u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435. dimInt: {}, dimIntLabel1 {}, dimIntLabel2: {}", new Object[]{dimInt, dimIntLabelMapValue, dimIntLabel});
            }
            dimensionQnameLabelMap.put(dimInt, dimIntLabel);
            String memInt = xbrlDimension.getMemInt();
            String memIntLabel = xbrlDimension.getMemIntLabel();
            String memIntLabelMapValue = (String)dimensionMemberQnameLabelMap.get(memInt);
            if (!StringUtils.equals((CharSequence)memIntLabelMapValue, (CharSequence)memIntLabel) && StringUtils.isNotBlank((CharSequence)memIntLabelMapValue) && StringUtils.isNotBlank((CharSequence)memIntLabel)) {
                log.info("\u043d\u0435\u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435. memint: {}, memLabel1 {}, memlabel2: {}", new Object[]{memInt, memIntLabelMapValue, memIntLabel});
            }
            dimensionMemberQnameLabelMap.put(memInt, memIntLabel);
        }
    }

    private void searchInColumnsHeader(ColumnHeader columnHeader, String trimmedTerm, AtomicInteger i, AtomicBoolean found) {
        if (columnHeader == null || StringUtils.isBlank((CharSequence)trimmedTerm) || i == null || found == null) {
            return;
        }
        Integer count = TextUtils.countMatchesIgnoreCase((String)columnHeader.getCaption(), (String)trimmedTerm);
        if (count > 0) {
            this.foundActionWithCount(i, found, count);
        }
        for (ColumnHeader currentColumnHeader : columnHeader.getColumnList()) {
            this.searchInColumnsHeader(currentColumnHeader, trimmedTerm, i, found);
        }
    }

    private void foundAction(AtomicInteger i, AtomicBoolean found) {
        this.foundActionWithCount(i, found, Integer.valueOf(1));
    }

    private void foundActionWithCount(AtomicInteger i, AtomicBoolean found, Integer countValue) {
        found.set(true);
        i.set(i.get() + countValue);
    }

    @Transactional(value="cacheTransactionManager")
    public List<AspectDataWrapper> searchByValue(String query) {
        if (StringUtils.isBlank((CharSequence)query)) {
            return Collections.emptyList();
        }
        List xbrlValueDTOList = this.xbrlValueCrudService.findAllByValue(query);
        return this.xbrlValueCrudService.getAspectDataByXbrlValueDTO(xbrlValueDTOList);
    }

    @ConstructorProperties(value={"xbrlDimensionService", "objectMapper", "xbrlValueCrudService", "presentationDefinitionService", "xbrlPackageService", "tableLinkBaseDynamicStructureService", "inactiveMembersService", "axisService"})
    public SearchServiceImpl(XbrlDimensionService xbrlDimensionService, ObjectMapper objectMapper, XbrlValueCrudService xbrlValueCrudService, PresentationDefinitionService presentationDefinitionService, XbrlPackageServiceImpl xbrlPackageService, TableLinkBaseDynamicStructureService tableLinkBaseDynamicStructureService, InactiveMembersService inactiveMembersService, AxisService axisService) {
        this.xbrlDimensionService = xbrlDimensionService;
        this.objectMapper = objectMapper;
        this.xbrlValueCrudService = xbrlValueCrudService;
        this.presentationDefinitionService = presentationDefinitionService;
        this.xbrlPackageService = xbrlPackageService;
        this.tableLinkBaseDynamicStructureService = tableLinkBaseDynamicStructureService;
        this.inactiveMembersService = inactiveMembersService;
        this.axisService = axisService;
    }
}

