/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.config.ConfigProperties;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.UnsupportedAlternativeExportRoleException;
import ru.cbr.xbrl.converter.model.XbrlPeriod;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.tableLinkBase.AxisMemberHierarchy;
import ru.cbr.xbrl.converter.model.tableLinkBase.NodeType;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBaseStructure;
import ru.cbr.xbrl.converter.model.tableLinkBase.XbrlFootnoteDTO;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.Fact;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.PeriodLevel;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.TLBUiModel;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.YLevel;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.ZLevel;
import ru.cbr.xbrl.converter.model.web.rest.ColumnHeader;
import ru.cbr.xbrl.converter.model.xbrl_content.PeriodType;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextDimension;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValueId;
import ru.cbr.xbrl.converter.repository.XbrlValueRepository;
import ru.cbr.xbrl.converter.service.CellEditableCheckerService;
import ru.cbr.xbrl.converter.service.ConceptInMemoryService;
import ru.cbr.xbrl.converter.service.TableLinkBaseDynamicStructureService;
import ru.cbr.xbrl.converter.service.XbrlContectValueDTO;
import ru.cbr.xbrl.converter.service.XbrlPeriodService;
import ru.cbr.xbrl.converter.service.import_export.PeriodDates;
import ru.cbr.xbrl.converter.service.internal.xbrl.XbrlFootnoteCrudService;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionService;
import ru.cbr.xbrl.converter.service.tablelinkbase.AxisService;
import ru.cbr.xbrl.converter.utils.AspectUtils;
import ru.cbr.xbrl.converter.utils.LabelUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class TableLinkBaseDataService {
    private static final Logger log = LoggerFactory.getLogger(TableLinkBaseDataService.class);
    private final ConfigProperties configProperties;
    private static final String GENERATED = "EMPTY_AXIS";
    private static final String X = "x";
    @Autowired
    private XbrlValueRepository xbrlValueRepository;
    @Autowired
    private TableLinkBaseDynamicStructureService tableLinkBaseDynamicStructureService;
    @Autowired
    private XbrlPeriodService xbrlPeriodService;
    @Autowired
    private ConceptInMemoryService conceptInMemoryService;
    @Autowired
    private PresentationDefinitionService presentationDefinitionService;
    @Autowired
    private XbrlFootnoteCrudService xbrlFootnoteCrudService;
    private Map<String, List<XbrlContectValueDTO>> cachedConcepts = new HashMap();
    @Autowired
    private CellEditableCheckerService cellEditableCheckerService;
    @Autowired
    private AxisService axisService;

    @Transactional(value="cacheTransactionManager")
    public void updateTableLinkBaseUI(XbrlReportRole xbrlReportRole) throws NotFoundException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            TLBUiModel tableLinkBaseUI = this.getTableLinkBaseUIFrom(xbrlReportRole, true);
            xbrlReportRole.setJson(mapper.writeValueAsString((Object)tableLinkBaseUI));
            List filterAxisList = this.axisService.fillFilterAxisList(xbrlReportRole.getSystemId(), xbrlReportRole.getXbrlRoleDimensionList());
            xbrlReportRole.setFilterAxisList(filterAxisList);
        }
        catch (IOException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Transactional(value="cacheTransactionManager")
    public TLBUiModel getTableLinkBaseUIFrom(XbrlReportRole xbrlReportRole) throws NotFoundException {
        return this.getTableLinkBaseUIFrom(xbrlReportRole, false);
    }

    @Transactional(value="cacheTransactionManager")
    public TLBUiModel getTableLinkBaseUIFrom(XbrlReportRole xbrlReportRole, boolean modelForUI) throws NotFoundException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            TableLinkBaseStructure structure = (TableLinkBaseStructure)mapper.readValue(xbrlReportRole.getStaticStructureJson(), TableLinkBaseStructure.class);
            this.tableLinkBaseDynamicStructureService.fillDynamicMembers(structure, xbrlReportRole);
            List roleCells = xbrlReportRole.getRoleCellsJson() != null ? (List)mapper.readValue(xbrlReportRole.getRoleCellsJson(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */) : null;
            TLBUiModel tlbUiModel = this.generateUIModel(structure, structure.getDimensionsDefault(), modelForUI);
            tlbUiModel.setDimensionsDefault(structure.getDimensionsDefault());
            tlbUiModel.setEnumerations(structure.getEnumerations());
            tlbUiModel.setDimensionPattens(structure.getDimensionPattens());
            tlbUiModel.setRoleId(xbrlReportRole.getId());
            tlbUiModel.setStaticStructure(structure);
            return tlbUiModel;
        }
        catch (IOException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public Function<XbrlReportRole, TLBUiModel> getTableLinkBaseUIFromFunction() {
        return xbrlReportRole -> {
            try {
                return this.getTableLinkBaseUIFrom(xbrlReportRole);
            }
            catch (NotFoundException e) {
                return null;
            }
        };
    }

    public TLBUiModel generateUIModel(TableLinkBaseStructure tableLinkBaseStructure, Map<String, String> dimensionsDefault) {
        return this.generateUIModel(tableLinkBaseStructure, dimensionsDefault, false);
    }

    public TLBUiModel generateUIModel(TableLinkBaseStructure tableLinkBaseStructure, Map<String, String> dimensionsDefault, boolean modelForUI) {
        TLBUiModel tlbUiModel = new TLBUiModel();
        tlbUiModel.setName(tableLinkBaseStructure.getName());
        tlbUiModel.setLabel(tableLinkBaseStructure.getLabel());
        tlbUiModel.setPeriodSet(tableLinkBaseStructure.getPeriods());
        AxisMemberHierarchy xRootAxis = tableLinkBaseStructure.getXAxis();
        AxisMemberHierarchy yRootAxis = tableLinkBaseStructure.getYAxis();
        tlbUiModel.setColumnList(TableLinkBaseDataService.buildColumnsFromHierarchy((AxisMemberHierarchy)xRootAxis, (String)tableLinkBaseStructure.getPeriodAxis()).getColumnList());
        for (AxisMemberHierarchy axisMemberHierarchy : tableLinkBaseStructure.getZAxis().getAxisMemberHierarchyList()) {
            tlbUiModel.getZSet().add(axisMemberHierarchy.getLabel());
        }
        tlbUiModel.setXRootAspectNodes(xRootAxis.getChildAspectNodes());
        tlbUiModel.setYRootAspectNodes(yRootAxis.getChildAspectNodes());
        tlbUiModel.setXRootHash(xRootAxis.getHash());
        tlbUiModel.setYRootHash(yRootAxis.getHash());
        tlbUiModel.setXRcCodePresent(StringUtils.equalsIgnoreCase((CharSequence)xRootAxis.getRcCode(), (CharSequence)"true"));
        tlbUiModel.setYRcCodePresent(StringUtils.equalsIgnoreCase((CharSequence)yRootAxis.getRcCode(), (CharSequence)"true"));
        this.cachedConcepts = new HashMap();
        List footnoteCountList = this.xbrlValueRepository.findFootnoteCountByXbrlValueId();
        HashMap<XbrlValueId, Integer> footnoteCountMap = new HashMap<XbrlValueId, Integer>();
        for (XbrlFootnoteDTO xbrlFootnoteDTO : footnoteCountList) {
            if (xbrlFootnoteDTO == null) continue;
            footnoteCountMap.put(new XbrlValueId(xbrlFootnoteDTO.getElementLabel(), xbrlFootnoteDTO.getXbrlReportId(), xbrlFootnoteDTO.getContext()), xbrlFootnoteDTO.getCount());
        }
        PeriodDates reportedPeriod = PeriodDates.from((XbrlPeriod)this.xbrlPeriodService.getDefaultPeriod());
        for (String period : tableLinkBaseStructure.getPeriods()) {
            if (StringUtils.isBlank((CharSequence)period)) continue;
            PeriodLevel periodLevel = new PeriodLevel();
            periodLevel.setLabel(period);
            AspectData globalPeriodAspectData = new AspectData();
            globalPeriodAspectData.setAspect(AspectType.PERIOD.toValue());
            globalPeriodAspectData.setType(AspectType.PERIOD);
            globalPeriodAspectData.setAspectValue(period);
            if (!period.equals("EMPTY_AXIS")) {
                periodLevel.getAspectDataList().add(globalPeriodAspectData);
            }
            for (AxisMemberHierarchy zAxisMemberHierarchy : tableLinkBaseStructure.getZAxis().getAxisMemberHierarchyList()) {
                if (StringUtils.isBlank((CharSequence)zAxisMemberHierarchy.getLabel())) continue;
                ZLevel zLevel = new ZLevel();
                zLevel.setTitle(zAxisMemberHierarchy.getLabel());
                zLevel.setAspectDataList(zAxisMemberHierarchy.getAspectDataList());
                LinkedHashMap flatY = new LinkedHashMap();
                LinkedHashMap flatX = new LinkedHashMap();
                this.flatten(yRootAxis, new ArrayList(), flatY);
                this.flatten(xRootAxis, new ArrayList(), flatX);
                if (!this.configProperties.getXlsxWriteAxisId().booleanValue() || !modelForUI) {
                    for (AxisMemberHierarchy yItem : yRootAxis.getAxisMemberHierarchyList()) {
                        ArrayList parents = new ArrayList();
                        YLevel ylevel = this.fillYRow(yItem, flatX, flatY, zLevel.getAspectDataList(), globalPeriodAspectData, dimensionsDefault, reportedPeriod, footnoteCountMap, parents);
                        if (ylevel.getTitle() == null) continue;
                        zLevel.getYLevelList().add(ylevel);
                    }
                }
                periodLevel.getZLevelList().add(zLevel);
            }
            if (periodLevel.getZLevelList().isEmpty()) {
                periodLevel.getZLevelList().add(this.generateEmptyZAxis());
                tlbUiModel.getZSet().add("<\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b>");
            }
            tlbUiModel.getPeriodLevelList().add(periodLevel);
        }
        return tlbUiModel;
    }

    private ZLevel generateEmptyZAxis() {
        ZLevel zLevel = new ZLevel();
        zLevel.setTitle("<\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b>");
        return zLevel;
    }

    private YLevel fillYRow(AxisMemberHierarchy yItem, Map<String, List<AspectData>> flatX, Map<String, List<AspectData>> flatY, List<AspectData> zAspectData, AspectData periodAspectData, Map<String, String> dimensionsDefault, PeriodDates reportedPeriod, Map<XbrlValueId, Integer> footnoteCountMap, List<AxisMemberHierarchy> parents) {
        YLevel yLevel = new YLevel();
        yLevel.setTitle(yItem.getLabel());
        yLevel.setRcCode(yItem.getRcCode());
        yLevel.setChildAspectNodes(yItem.getChildAspectNodes());
        yLevel.setHash(yItem.getHash());
        yLevel.setNodeType(yItem.getNodeType());
        yLevel.setAspectDataList(yItem.getAspectDataList());
        AspectData concept = null;
        AspectData tagSelectorAspectData = null;
        for (String xKey : flatX.keySet()) {
            ArrayList<Object> all = new ArrayList<Object>();
            List<AspectData> xAspectData = flatX.get(xKey);
            if (xAspectData != null) {
                all.addAll(xAspectData);
            }
            ArrayList yAspectData = new ArrayList();
            parents.forEach(axisMemberHierarchy -> yAspectData.addAll(axisMemberHierarchy.getAspectDataList()));
            yAspectData.addAll(yItem.getAspectDataList());
            if (yAspectData != null) {
                all.addAll(yAspectData);
            }
            if (!zAspectData.isEmpty()) {
                all.addAll(zAspectData);
            }
            if (!"EMPTY_AXIS".equals(periodAspectData.getAspectValue())) {
                all.add(periodAspectData);
            }
            AspectCellData aspectCellData = new AspectCellData();
            aspectCellData.setAspectDataList(all);
            if (yItem.getNodeTagSelector() != null) {
                concept = aspectCellData.getConceptByTag(yItem.getNodeTagSelector());
                tagSelectorAspectData = new AspectData();
                tagSelectorAspectData.setType(AspectType.TAG_LABEL);
                tagSelectorAspectData.setTagSelector(yItem.getNodeTagSelector());
            } else {
                concept = aspectCellData.getConcept();
            }
            PeriodDates defaultPeriodDates = AspectUtils.getDefaultPeriodDates((AspectCellData)aspectCellData);
            List dimensions = aspectCellData.getDimensions();
            List dimensionsWithoutDefaults = XbrlContextDimension.removeDefaultDimensions((List)dimensions, dimensionsDefault);
            if (concept == null) {
                yLevel.getFactMap().put(xKey, new Fact("", true, null, null, null, Integer.valueOf(0)));
                continue;
            }
            List byElementName = (List)this.cachedConcepts.get(concept.getAspectValue());
            if (byElementName == null) {
                byElementName = this.xbrlValueRepository.findByXbrlValueIdElementLabel(concept.getAspectValue());
                this.cachedConcepts.put(concept.getAspectValue(), byElementName);
            }
            List xbrlContextDimensions = dimensionsWithoutDefaults.stream().map(d -> {
                if (d.getDimensionType() == DimensionType.TYPED_MEMBER) {
                    return new XbrlContextDimension(d.getAspect(), d.getDomain(), d.getAspectValue());
                }
                return new XbrlContextDimension(d.getAspect(), d.getAspectValue());
            }).collect(Collectors.toList());
            String dimensionsString = XbrlContextDimension.dimensionsToString(xbrlContextDimensions);
            String dimensionsHash = XbrlContextDimension.dimensionToHash(xbrlContextDimensions);
            String dimensionHashWithClearedDomains = XbrlContextDimension.dimensionToHash((List)XbrlContextDimension.clearDomainsFromDimensions(xbrlContextDimensions));
            String dimintsString = XbrlContextDimension.dimintsToString(xbrlContextDimensions);
            PeriodDates periodDates = AspectUtils.getPeriodDatesForConceptOrDefault1((List)aspectCellData.getAspectDataList(), (AspectData)concept, (PeriodDates)defaultPeriodDates, (String)yItem.getNodeTagSelector());
            if (periodDates == null) {
                periodDates = reportedPeriod;
            }
            Boolean isNotEditableNew = this.cellEditableCheckerService.checkNotEditable(aspectCellData);
            Boolean isNotEditable = this.cellEditableCheckerService != null && this.cellEditableCheckerService.checkNotEditable(dimensionHashWithClearedDomains, xbrlContextDimensions, concept.getAspectValue()) != false;
            if (!isNotEditable.equals(isNotEditableNew)) {
                log.debug("Editable results not equals, old: {} new: {} aspects: {} ", new Object[]{isNotEditable, isNotEditableNew, aspectCellData.toShortString()});
            }
            if (yItem.isAbstractNode() || concept.isAbstractNode() || isNotEditableNew.booleanValue()) {
                yLevel.getFactMap().put(xKey, new Fact("", true, null, null, null, Integer.valueOf(0)));
                continue;
            }
            for (XbrlContectValueDTO xbrlContectValueDTO : byElementName) {
                if (xbrlContectValueDTO == null || !dimensionsHash.equals(xbrlContectValueDTO.getDimensionsHash())) continue;
                XbrlValueId xbrlValueId = new XbrlValueId(xbrlContectValueDTO.getElementLabel(), xbrlContectValueDTO.getXbrlReportId(), xbrlContectValueDTO.getXbrlContextId());
                Integer footnoteCount = footnoteCountMap.getOrDefault(xbrlValueId, 0);
                String value = xbrlContectValueDTO.getValue();
                if (periodDates.getPeriodType() == PeriodType.INSTANT && this.isSameDaySafe(periodDates.getInstantDate(), xbrlContectValueDTO.getInstantDate())) {
                    yLevel.getFactMap().put(xKey, new Fact(value, false, xbrlContectValueDTO.getDecimals(), xbrlContectValueDTO.getPrecision(), xbrlContectValueDTO.getUnitId(), footnoteCount));
                }
                if (periodDates.getPeriodType() == PeriodType.DURATION && this.isSameDaySafe(periodDates.getStartDate(), xbrlContectValueDTO.getStartDate()) && this.isSameDaySafe(periodDates.getEndDate(), xbrlContectValueDTO.getEndDate())) {
                    yLevel.getFactMap().put(xKey, new Fact(value, false, xbrlContectValueDTO.getDecimals(), xbrlContectValueDTO.getPrecision(), xbrlContectValueDTO.getUnitId(), footnoteCount));
                }
                if (concept.getConceptPeriodType() == null) {
                    log.info("" + concept);
                    continue;
                }
                if (!periodDates.getPeriodType().equals((Object)PeriodType.DURATION) || !concept.getConceptPeriodType().equals((Object)PeriodType.INSTANT) || !this.isSameDaySafe(xbrlContectValueDTO.getInstantDate(), periodDates.getEndDate())) continue;
                yLevel.getFactMap().put(xKey, new Fact(value, false, xbrlContectValueDTO.getDecimals(), xbrlContectValueDTO.getPrecision(), xbrlContectValueDTO.getUnitId(), footnoteCount));
            }
        }
        for (AxisMemberHierarchy axisMemberHierarchy2 : yItem.getAxisMemberHierarchyList()) {
            ArrayList<AxisMemberHierarchy> newParents = new ArrayList<AxisMemberHierarchy>();
            newParents.addAll(parents);
            newParents.add(yItem);
            yLevel.getYLevelList().add(this.fillYRow(axisMemberHierarchy2, flatX, flatY, zAspectData, periodAspectData, dimensionsDefault, reportedPeriod, footnoteCountMap, newParents));
        }
        if (tagSelectorAspectData != null) {
            yLevel.getAspectDataList().add(tagSelectorAspectData);
        }
        return yLevel;
    }

    private boolean isSameDaySafe(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        return DateUtils.isSameDay((Date)date1, (Date)date2);
    }

    public static ColumnHeader buildColumnsFromHierarchy(AxisMemberHierarchy xHierarchy, String periodAxis) {
        ColumnHeader columns = new ColumnHeader();
        if (xHierarchy == null) {
            return columns;
        }
        List axisMemberHierarchyChildList = xHierarchy.getAxisMemberHierarchyList();
        columns.setCaption(xHierarchy.getLabel());
        columns.setRcCode(xHierarchy.getRcCode());
        columns.setDataField(StringUtils.equals((CharSequence)periodAxis, (CharSequence)"x") && !StringUtils.equals((CharSequence)xHierarchy.getId(), (CharSequence)"title") ? xHierarchy.getLabel() : xHierarchy.getId());
        columns.setAspectDataList(xHierarchy.getAspectDataList());
        columns.setAbstractNode(xHierarchy.isAbstractNode());
        columns.setChildAspectNodes(xHierarchy.getChildAspectNodes());
        columns.setHash(xHierarchy.getHash());
        if (CollectionUtils.isEmpty((Collection)axisMemberHierarchyChildList)) {
            return columns;
        }
        for (AxisMemberHierarchy axisMemberHierarchy : axisMemberHierarchyChildList) {
            columns.getColumnList().add(TableLinkBaseDataService.buildColumnsFromHierarchy((AxisMemberHierarchy)axisMemberHierarchy, (String)periodAxis));
        }
        return columns;
    }

    public ColumnHeader buildColumnsFromHierarchyWithAspectColumn(AxisMemberHierarchy axisHierarchy, String periodAxis, ColumnHeader aspectColumnHeader, Map<Integer, Set<String>> levelAspectMap, int level, Function<AspectCellData, String> calcDimensionOpenHashByAspectCellData) throws UnsupportedAlternativeExportRoleException {
        ColumnHeader columnHeader = new ColumnHeader();
        if (axisHierarchy == null) {
            return columnHeader;
        }
        columnHeader.setRcCode(axisHierarchy.getRcCode());
        if (aspectColumnHeader == null) {
            aspectColumnHeader = new ColumnHeader();
            aspectColumnHeader.setHash("aspectColumn");
            aspectColumnHeader.setColspan(Integer.valueOf(1));
            aspectColumnHeader.setDataField("aspectColumn");
            columnHeader.getColumnList().add(aspectColumnHeader);
        }
        List axisMemberHierarchyChildList = axisHierarchy.getAxisMemberHierarchyList();
        columnHeader.setDataField(StringUtils.equals((CharSequence)periodAxis, (CharSequence)"x") && !StringUtils.equals((CharSequence)axisHierarchy.getId(), (CharSequence)"title") ? axisHierarchy.getLabel() : axisHierarchy.getId());
        List aspectDataList = axisHierarchy.getAspectDataList();
        AspectCellData aspectCellData = new AspectCellData(aspectDataList);
        NodeType nodeType = axisHierarchy.getNodeType();
        List aspectColumnList = aspectColumnHeader.getColumnList();
        if (level >= 0) {
            if (nodeType == NodeType.ASPECT) {
                String dimensionOpenHash = calcDimensionOpenHashByAspectCellData.apply(aspectCellData);
                axisHierarchy.setLabel(LabelUtils.calcMemberValueLabel((List)axisHierarchy.getAspectDataList()));
                Set<String> axisMemberHierarchySet = levelAspectMap.get(level);
                if (CollectionUtils.isEmpty(axisMemberHierarchySet)) {
                    levelAspectMap.put(level, new HashSet<String>(Collections.singletonList(dimensionOpenHash)));
                    ColumnHeader aspectHeader = new ColumnHeader();
                    aspectHeader.setHash(axisHierarchy.getHash());
                    aspectHeader.setColspan(Integer.valueOf(1));
                    aspectHeader.setDataField("Level_" + level);
                    aspectHeader.setCaption(LabelUtils.calcMemberLabel((List)axisHierarchy.getAspectDataList()));
                    if (aspectColumnList.size() == level) {
                        aspectColumnList.add(level, aspectHeader);
                    } else if (aspectColumnList.size() > level) {
                        aspectColumnList.set(level, aspectHeader);
                    }
                } else if (axisMemberHierarchySet.size() > 0 && !axisMemberHierarchySet.contains(dimensionOpenHash)) {
                    log.error("\u041d\u0430 \u043e\u0434\u043d\u043e\u043c \u0443\u0440\u043e\u0432\u043d\u0435 \u0438\u0435\u0440\u0430\u0440\u0445\u0438\u0438 \u043e\u043a\u0430\u0437\u0430\u043b\u0430\u0441\u044c \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043e\u0434\u043d\u0430 \u0430\u0441\u043f\u0435\u043a\u0442 \u043d\u043e\u0434\u0430. \u041e\u0441\u044c {}, \u0443\u0440\u043e\u0432\u0435\u043d\u044c \u0432\u043b\u043e\u0436\u0435\u043d\u043d\u043e\u0441\u0442\u0438: {}. \u041e\u0447\u0435\u0440\u0435\u0434\u043d\u043e\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0430\u0441\u043f\u0435\u043a\u0442 \u043d\u043e\u0434\u044b: {}", new Object[]{axisHierarchy.getAxis(), String.valueOf(level), axisHierarchy.getLabel()});
                    throw new UnsupportedAlternativeExportRoleException();
                }
            } else {
                levelAspectMap.putIfAbsent(level, new HashSet());
                axisHierarchy.setLabel(LabelUtils.calcLabel((List)axisHierarchy.getAspectDataList(), (String)axisHierarchy.getLabel()));
                if (CollectionUtils.isEmpty((Collection)aspectColumnList) || aspectColumnList.size() == level) {
                    ColumnHeader aspectHeader = new ColumnHeader();
                    aspectHeader.setColspan(Integer.valueOf(1));
                    aspectHeader.setDataField("Level_" + level);
                    aspectColumnList.add(level, aspectHeader);
                }
            }
        }
        columnHeader.setAspectDataList(aspectDataList);
        columnHeader.setAbstractNode(axisHierarchy.isAbstractNode());
        columnHeader.setChildAspectNodes(axisHierarchy.getChildAspectNodes());
        columnHeader.setHash(axisHierarchy.getHash());
        columnHeader.setCaption(axisHierarchy.getLabel());
        if (CollectionUtils.isEmpty((Collection)axisMemberHierarchyChildList)) {
            columnHeader.setColspan(Integer.valueOf(1));
            return columnHeader;
        }
        int colspan = 0;
        for (AxisMemberHierarchy axisMemberHierarchy : axisMemberHierarchyChildList) {
            ColumnHeader childColumnHeader = this.buildColumnsFromHierarchyWithAspectColumn(axisMemberHierarchy, periodAxis, aspectColumnHeader, levelAspectMap, level + 1, calcDimensionOpenHashByAspectCellData);
            columnHeader.getColumnList().add(childColumnHeader);
            colspan += childColumnHeader.getColspan().intValue();
        }
        if (!axisHierarchy.isAbstractNode()) {
            columnHeader.setAbstractNode(false);
            ++colspan;
        } else {
            columnHeader.setAbstractNode(true);
        }
        columnHeader.setColspan(Integer.valueOf(colspan));
        return columnHeader;
    }

    public static ColumnHeader buildColumnsFromHierarchy1(AxisMemberHierarchy xHierarchy, String periodAxis) {
        ColumnHeader columns = new ColumnHeader();
        if (xHierarchy == null) {
            return columns;
        }
        List axisMemberHierarchyChildList = xHierarchy.getAxisMemberHierarchyList();
        if (CollectionUtils.isEmpty((Collection)axisMemberHierarchyChildList)) {
            columns.setCaption(xHierarchy.getLabel());
            columns.setDataField(StringUtils.equals((CharSequence)periodAxis, (CharSequence)"x") && !StringUtils.equals((CharSequence)xHierarchy.getId(), (CharSequence)"title") ? xHierarchy.getLabel() : xHierarchy.getId());
            columns.setAspectDataList(xHierarchy.getAspectDataList());
            return columns;
        }
        if (StringUtils.isNotBlank((CharSequence)xHierarchy.getId())) {
            columns.setCaption(xHierarchy.getLabel());
            columns.setDataField(StringUtils.equals((CharSequence)periodAxis, (CharSequence)"x") && !StringUtils.equals((CharSequence)xHierarchy.getId(), (CharSequence)"title") ? xHierarchy.getLabel() : xHierarchy.getId());
            columns.setAspectDataList(xHierarchy.getAspectDataList());
        }
        for (AxisMemberHierarchy axisMemberHierarchy : axisMemberHierarchyChildList) {
            ColumnHeader columnHeader = new ColumnHeader();
            columnHeader.setCaption(axisMemberHierarchy.getLabel());
            columnHeader.setDataField(StringUtils.equals((CharSequence)periodAxis, (CharSequence)"x") && !StringUtils.equals((CharSequence)axisMemberHierarchy.getId(), (CharSequence)"title") ? axisMemberHierarchy.getLabel() : axisMemberHierarchy.getId());
            columnHeader.setAspectDataList(axisMemberHierarchy.getAspectDataList());
            columnHeader.setChildAspectNodes(axisMemberHierarchy.getChildAspectNodes());
            columnHeader.setHash(axisMemberHierarchy.getHash());
            List axisMemberHierarchyList = axisMemberHierarchy.getAxisMemberHierarchyList();
            if (!CollectionUtils.isEmpty((Collection)axisMemberHierarchyList)) {
                for (AxisMemberHierarchy memberHierarchy : axisMemberHierarchyList) {
                    columnHeader.getColumnList().add(TableLinkBaseDataService.buildColumnsFromHierarchy((AxisMemberHierarchy)memberHierarchy, (String)periodAxis));
                }
            }
            columns.getColumnList().add(columnHeader);
        }
        return columns;
    }

    private void flatten(AxisMemberHierarchy axis, List<AspectData> aspectDataList, Map<String, List<AspectData>> result) {
        this.flatten(axis, aspectDataList, result, axis.getNodeType() == NodeType.ASPECT);
    }

    private void flatten(AxisMemberHierarchy axis, List<AspectData> aspectDataList, Map<String, List<AspectData>> result, boolean isAspectNodeInHierarchy) {
        ArrayList<AspectData> newList = new ArrayList<AspectData>(aspectDataList);
        if (!axis.getAspectDataList().isEmpty()) {
            newList.addAll(axis.getAspectDataList());
        }
        if (!CollectionUtils.isEmpty(newList) || !isAspectNodeInHierarchy && axis.getAxisMemberHierarchyList().isEmpty() && axis.getId().contains("ruleNode") && axis.getNodeType() != NodeType.ASPECT && "x".equals(axis.getAxis())) {
            result.put(axis.getId(), newList);
        }
        for (AxisMemberHierarchy child : axis.getAxisMemberHierarchyList()) {
            this.flatten(child, newList, result, axis.getNodeType() == NodeType.ASPECT || isAspectNodeInHierarchy);
        }
    }

    @ConstructorProperties(value={"configProperties"})
    public TableLinkBaseDataService(ConfigProperties configProperties) {
        this.configProperties = configProperties;
    }
}

