/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import ru.cbr.xbrl.converter.arelle.parse.HypercubeService;
import ru.cbr.xbrl.converter.arelle.parse.definition_hypercube.dto.DefinitionHypercubeDimension;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.model.XbrlPeriod;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.filter.FilterViewType;
import ru.cbr.xbrl.converter.model.tableLinkBase.AspectNodeMember;
import ru.cbr.xbrl.converter.model.tableLinkBase.AxisMemberHierarchy;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterOpenAxis;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterOpenAxisValue;
import ru.cbr.xbrl.converter.model.tableLinkBase.NodeType;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBaseStructure;
import ru.cbr.xbrl.converter.model.tableLinkBase.XbrlRoleDimension;
import ru.cbr.xbrl.converter.service.XbrlDimensionService;
import ru.cbr.xbrl.converter.service.XbrlReportService;
import ru.cbr.xbrl.converter.service.import_export.PeriodDates;
import ru.cbr.xbrl.converter.service.presentation_definition.InactiveMembersService;
import ru.cbr.xbrl.converter.utils.LabelUtils;
import ru.cbr.xbrl.converter.utils.LispStyleUtil;
import ru.cbr.xbrl.converter.utils.MathUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class TableLinkBaseDynamicStructureService {
    private static final Logger log = LoggerFactory.getLogger(TableLinkBaseDynamicStructureService.class);
    private static final String PERIOD = "period";
    private static final String X = "x";
    private static final String Y = "y";
    private static final String Z = "z";
    private static final String GENERATED = "EMPTY_AXIS";
    public static final String ASPECT_DELIMETER = " -> ";
    @Autowired
    private XbrlReportService xbrlReportService;
    @Autowired
    private InactiveMembersService inactiveMembersService;
    @Autowired
    private XbrlDimensionService xbrlDimensionService;
    @Autowired
    private HypercubeService hypercubeService;

    public void fillDynamicMembers(TableLinkBaseStructure structure, XbrlReportRole xbrlRole) throws NotFoundException {
        xbrlRole = this.xbrlReportService.findReportRole(xbrlRole.getId());
        this.fillTypedAxis(structure, xbrlRole);
        this.fillDates(structure, xbrlRole.getId());
    }

    private void fillTypedAxis(TableLinkBaseStructure structure, XbrlReportRole xbrlRole) {
        String systemRoleId = structure.getName();
        List originalAspectNodeMembers = xbrlRole.getAspectNodeMembers();
        Map<String, List<AspectNodeMember>> aspNodeMembers = originalAspectNodeMembers.stream().collect(Collectors.groupingBy(AspectNodeMember::getHash));
        this.inactiveMembersService.calculateInactiveMemberCounters();
        structure.setXAxis((AxisMemberHierarchy)LispStyleUtil.car((List)this.cortegeFilledAxis(systemRoleId, aspNodeMembers, structure.getXAxis(), structure.getXAxis(), new ArrayList(), false, 0)));
        structure.setYAxis((AxisMemberHierarchy)LispStyleUtil.car((List)this.cortegeFilledAxis(systemRoleId, aspNodeMembers, structure.getYAxis(), structure.getYAxis(), new ArrayList(), false, 0)));
        this.inactiveMembersService.resetInactiveMemberCounters();
        structure.setZAxis((AxisMemberHierarchy)LispStyleUtil.car((List)this.createFilledAxis(structure.getZAxis(), xbrlRole)));
    }

    public List<AxisMemberHierarchy> cortegeFilledAxis(String systemRoleId, Map<String, List<AspectNodeMember>> aspNodeMembers, AxisMemberHierarchy original, AxisMemberHierarchy parent, List<AspectData> parentAspectData, boolean sort, int depth) {
        List<AspectNodeMember> aspectNodeMembers;
        ArrayList<AxisMemberHierarchy> filled = new ArrayList<AxisMemberHierarchy>();
        ArrayList<AspectData> currentAspectDataList = new ArrayList<AspectData>(parentAspectData);
        if (original.getNodeType() == NodeType.RULE) {
            AxisMemberHierarchy newSimpleAxisMemberHierarchy = new AxisMemberHierarchy();
            newSimpleAxisMemberHierarchy.setAxis(original.getAxis());
            if ("title".equals(original.getId())) {
                newSimpleAxisMemberHierarchy.setId("title");
            } else if (StringUtils.equals((CharSequence)original.getId(), (CharSequence)"rcCode")) {
                newSimpleAxisMemberHierarchy.setId(original.getId());
            } else {
                newSimpleAxisMemberHierarchy.setId(original.getId() + "_" + depth);
            }
            newSimpleAxisMemberHierarchy.setAspectDataList(original.getAspectDataList());
            newSimpleAxisMemberHierarchy.setLabel(LabelUtils.calcLabel((List)newSimpleAxisMemberHierarchy.getAspectDataList(), (String)original.getLabel()));
            newSimpleAxisMemberHierarchy.setRcCode(original.getRcCode());
            newSimpleAxisMemberHierarchy.setChildAspectNodes(TableLinkBaseDynamicStructureService.calcChildAspectNodes((AxisMemberHierarchy)original));
            newSimpleAxisMemberHierarchy.setAbstractNode(original.isAbstractNode());
            newSimpleAxisMemberHierarchy.setNodeTagSelector(original.getNodeTagSelector());
            currentAspectDataList.addAll(newSimpleAxisMemberHierarchy.getAspectDataList());
            newSimpleAxisMemberHierarchy.setHash(original.getId());
            newSimpleAxisMemberHierarchy.setNodeType(original.getNodeType());
            newSimpleAxisMemberHierarchy.setUnitRole(original.getUnitRole());
            filled.add(newSimpleAxisMemberHierarchy);
        } else if (original.getNodeType() == NodeType.ASPECT && (aspectNodeMembers = aspNodeMembers.get(parent.getHash())) != null) {
            for (AspectNodeMember aspectNodeMember : aspectNodeMembers) {
                String value;
                String label;
                boolean isOpenAxis;
                Optional<AspectData> target = original.getAspectDataList().stream().filter(it -> it.getAspect().equals(aspectNodeMember.getDimension())).findFirst();
                if (!target.isPresent()) continue;
                AspectData targetAspectData = target.get();
                AxisMemberHierarchy newAspectAxisMemberHierarchy = new AxisMemberHierarchy();
                newAspectAxisMemberHierarchy.setAxis(original.getAxis());
                newAspectAxisMemberHierarchy.setId(aspectNodeMember.getCommonId());
                boolean bl = isOpenAxis = aspectNodeMember.getFilterOpenAxisValue() != null;
                if (isOpenAxis) {
                    label = aspectNodeMember.getFilterOpenAxisValue().getValue();
                    value = aspectNodeMember.getFilterOpenAxisValue().getValue();
                } else {
                    label = aspectNodeMember.getClosedMemberLabel();
                    value = aspectNodeMember.getClosedMemberValue();
                }
                AspectData aspectData = new AspectData();
                aspectData.setAspect(targetAspectData.getAspect());
                aspectData.setAxisLabel(targetAspectData.getLabel());
                aspectData.setAxisValueLabel(label);
                aspectData.setLabel(targetAspectData.getLabel() + "-" + label);
                aspectData.setAspectValue(value);
                aspectData.setType(AspectType.DIMENSION);
                aspectData.setDimensionType(targetAspectData.getDimensionType());
                aspectData.setDomain(targetAspectData.getDomain());
                aspectData.setAxisId(aspectNodeMember.getAxisId());
                newAspectAxisMemberHierarchy.getAspectDataList().add(aspectData);
                newAspectAxisMemberHierarchy.getAspectDataList().addAll(original.getAspectDataList().stream().filter(it -> it.getType().equals((Object)AspectType.CONCEPT)).collect(Collectors.toList()));
                newAspectAxisMemberHierarchy.setAbstractNode(original.isAbstractNode());
                newAspectAxisMemberHierarchy.setLabel(LabelUtils.calcLabel((List)newAspectAxisMemberHierarchy.getAspectDataList(), null));
                newAspectAxisMemberHierarchy.setRcCode(original.getRcCode());
                newAspectAxisMemberHierarchy.setChildAspectNodes(TableLinkBaseDynamicStructureService.calcChildAspectNodes((AxisMemberHierarchy)original));
                newAspectAxisMemberHierarchy.setNodeType(original.getNodeType());
                newAspectAxisMemberHierarchy.setUnitRole(original.getUnitRole());
                currentAspectDataList.addAll(newAspectAxisMemberHierarchy.getAspectDataList());
                newAspectAxisMemberHierarchy.setHash(aspectNodeMember.getCommonId());
                boolean bl2 = isOpenAxis ? this.inactiveMembersService.getCountInactiveOpenMember() == 0L || !this.inactiveMembersService.isInactiveOpenMember(systemRoleId, aspectNodeMember.getFilterOpenAxisValue().getId(), FilterViewType.TABLELINKBASE) : this.inactiveMembersService.getCountInactiveClosedMember() == 0L || !this.inactiveMembersService.isInactiveClosedMember(systemRoleId, aspectData.getAspect(), aspectData.getAspectValue(), FilterViewType.TABLELINKBASE);
                boolean isActive = bl2;
                if (!isActive) continue;
                filled.add(newAspectAxisMemberHierarchy);
            }
        }
        for (AxisMemberHierarchy originalChild : original.getAxisMemberHierarchyList()) {
            for (int i = 0; i < filled.size(); ++i) {
                AxisMemberHierarchy it2 = (AxisMemberHierarchy)filled.get(i);
                it2.getAxisMemberHierarchyList().addAll(this.cortegeFilledAxis(systemRoleId, aspNodeMembers, originalChild, it2, currentAspectDataList, sort, i));
            }
        }
        if (sort) {
            Collections.sort(filled, Comparator.comparing(AxisMemberHierarchy::getLabel));
        }
        return filled;
    }

    private String md5Aspects(List<AspectData> aspectData, String alternative) {
        ArrayList<String> stringAspects = new ArrayList<String>();
        for (AspectData aspect : aspectData) {
            if (aspect.getType() == AspectType.CONCEPT) {
                stringAspects.add(aspect.getAspectValue());
            }
            if (aspect.getType() == AspectType.DIMENSION) {
                if (aspect.getDimensionType() == DimensionType.EXPLICIT_MEMBER) {
                    stringAspects.add(aspect.getAspect() + " -> " + aspect.getAspectValue());
                }
                if (aspect.getDimensionType() == DimensionType.TYPED_MEMBER) {
                    stringAspects.add(aspect.getAspect() + " -> " + aspect.getAspectValue() + " -> " + aspect.getDomain());
                }
            }
            if (aspect.getType() != AspectType.PARAMS_PERIOD) continue;
            stringAspects.add(aspect.getAspect() + " -> " + aspect.getAspectValue());
        }
        if (stringAspects.isEmpty()) {
            return DigestUtils.md5Hex((String)alternative);
        }
        return DigestUtils.md5Hex((String)stringAspects.stream().sorted().collect(Collectors.joining(";")));
    }

    public static List<String> calcChildAspectNodes(AxisMemberHierarchy original) {
        for (AxisMemberHierarchy child : original.getAxisMemberHierarchyList()) {
            Optional<AspectData> first;
            if (child.getNodeType() != NodeType.ASPECT || !(first = child.getAspectDataList().stream().filter(it -> it.getType() == AspectType.DIMENSION).findFirst()).isPresent()) continue;
            return Collections.singletonList(first.get().getAspect());
        }
        return null;
    }

    private List<AxisMemberHierarchy> createFilledAxis(AxisMemberHierarchy original, XbrlReportRole xbrlRole) {
        ArrayList<AxisMemberHierarchy> filled = new ArrayList<AxisMemberHierarchy>();
        ArrayList values = new ArrayList();
        List typedAspects = original.getAspectDataList().stream().filter(it -> it.getType() == AspectType.DIMENSION && it.getDimensionType() == DimensionType.TYPED_MEMBER).collect(Collectors.toList());
        for (AspectData effectiveAspect : typedAspects) {
            String dimension = effectiveAspect.getAspect();
            Optional<FilterOpenAxis> first = xbrlRole.getXbrlRoleDimensionList().stream().map(XbrlRoleDimension::getFilterOpenAxis).filter(it -> it.getSystemId().equals(dimension)).findFirst();
            if (!first.isPresent()) continue;
            ArrayList aspects = new ArrayList();
            this.getActiveMemberList(xbrlRole, first.get()).forEach(filterOpenAxisValue -> {
                AspectData aspectData = new AspectData();
                aspectData.setAspect(filterOpenAxisValue.getFilterOpenAxis().getSystemId());
                aspectData.setLabel(filterOpenAxisValue.getFilterOpenAxis().getTitle() + "-" + filterOpenAxisValue.getValue());
                aspectData.setAspectValue(filterOpenAxisValue.getValue());
                aspectData.setType(AspectType.DIMENSION);
                aspectData.setDimensionType(DimensionType.TYPED_MEMBER);
                aspectData.setDomain(filterOpenAxisValue.getFilterOpenAxis().getDomain());
                aspects.add(aspectData);
            });
            values.add(aspects);
        }
        List explicitAspects = original.getAspectDataList().stream().filter(it -> it.getType() == AspectType.DIMENSION && it.getDimensionType() == DimensionType.EXPLICIT_MEMBER).collect(Collectors.toList());
        for (AspectData effectiveAspect : explicitAspects) {
            String dimension = effectiveAspect.getAspect();
            List members = this.xbrlDimensionService.findMembers(xbrlRole.getSystemId(), dimension);
            ArrayList aspects = new ArrayList();
            if (members.isEmpty()) continue;
            members.forEach(xbrlDimension -> {
                if (!this.inactiveMembersService.isInactiveClosedMember(xbrlRole.getSystemId(), dimension, xbrlDimension.getMemInt(), FilterViewType.TABLELINKBASE)) {
                    AspectData aspectData = new AspectData();
                    aspectData.setAspect(dimension);
                    aspectData.setType(effectiveAspect.getType());
                    aspectData.setAspectValue(xbrlDimension.getMemInt());
                    aspectData.setDimensionType(effectiveAspect.getDimensionType());
                    aspectData.setLabel(xbrlDimension.getMemIntLabel());
                    aspects.add(aspectData);
                }
            });
            values.add(aspects);
        }
        MathUtils.cartesianProduct(values).forEach(aspectDataList -> {
            boolean axisAvailable = this.isAxisAvailable(aspectDataList);
            if (axisAvailable) {
                AxisMemberHierarchy newAxisMemberHierarchy = new AxisMemberHierarchy();
                newAxisMemberHierarchy.setAxis(original.getAxis());
                newAxisMemberHierarchy.setAspectDataList(aspectDataList);
                if (aspectDataList.stream().filter(aspectData -> aspectData.getDimensionType().equals((Object)DimensionType.EXPLICIT_MEMBER)).count() == (long)aspectDataList.size() && !StringUtils.isEmpty((CharSequence)original.getId()) && original.getId().equals("title")) {
                    newAxisMemberHierarchy.setId("title");
                } else {
                    newAxisMemberHierarchy.setId(UUID.randomUUID().toString());
                }
                newAxisMemberHierarchy.setLabel(LabelUtils.calcLabel((List)newAxisMemberHierarchy.getAspectDataList(), (String)(aspectDataList.stream().anyMatch(aspectData -> aspectData.getLabel() != null) ? null : original.getLabel())));
                filled.add(newAxisMemberHierarchy);
            }
        });
        for (AxisMemberHierarchy originalChild : original.getAxisMemberHierarchyList()) {
            List axisPool = originalChild.getNodeType().equals((Object)NodeType.RULE) ? Collections.singletonList(originalChild) : this.createFilledAxis(originalChild, xbrlRole);
            filled.forEach(it -> it.getAxisMemberHierarchyList().addAll(axisPool));
        }
        return filled;
    }

    public boolean isAxisAvailable(List<AspectData> aspectDataList) {
        return this.hypercubeService.getRolesDefinitionHypercubeMap().values().stream().anyMatch(hypercubeList -> hypercubeList.stream().anyMatch(definitionHypercube -> aspectDataList.stream().allMatch(aspectData -> definitionHypercube.getDimensions().containsKey(aspectData.getAspect()) && (aspectData.getDimensionType().equals((Object)DimensionType.TYPED_MEMBER) || ((DefinitionHypercubeDimension)definitionHypercube.getDimensions().get(aspectData.getAspect())).getMembers() != null && ((DefinitionHypercubeDimension)definitionHypercube.getDimensions().get(aspectData.getAspect())).getMembers().contains(aspectData.getAspectValue())))));
    }

    public List<FilterOpenAxisValue> getActiveMemberList(XbrlReportRole xbrlReportRole, FilterOpenAxis filterOpenAxis) {
        if (xbrlReportRole == null || filterOpenAxis == null) {
            return Collections.emptyList();
        }
        List axisMemberList = filterOpenAxis.getAxisMemberList();
        Long countInactiveOpenMember = this.inactiveMembersService.countInactiveOpenMember();
        if (countInactiveOpenMember == 0L) {
            return axisMemberList;
        }
        return axisMemberList.stream().filter(filterOpenAxisValue -> !this.inactiveMembersService.isInactiveOpenMember(xbrlReportRole.getSystemId(), filterOpenAxisValue.getId(), FilterViewType.TABLELINKBASE)).collect(Collectors.toList());
    }

    private void fillDates(TableLinkBaseStructure structure, Long xbrlRoleId) throws NotFoundException {
        List reportRolePeriodList = this.xbrlReportService.findReportRolePeriodList(xbrlRoleId);
        List activePeriods = reportRolePeriodList.stream().filter(it -> it.getActive() == null || it.getActive() != false).collect(Collectors.toList());
        String periodAxis = structure.getPeriodAxis();
        if (StringUtils.isNotBlank((CharSequence)periodAxis)) {
            AxisMemberHierarchy target;
            HashSet<String> periods = new HashSet<String>();
            periods.add("EMPTY_AXIS");
            structure.setPeriods(periods);
            switch (periodAxis) {
                case "x": {
                    target = structure.getXAxis();
                    break;
                }
                case "y": {
                    target = structure.getYAxis();
                    break;
                }
                case "z": {
                    target = structure.getZAxis();
                    break;
                }
                default: {
                    target = structure.getXAxis();
                }
            }
            for (XbrlPeriod xbrlPeriod : activePeriods) {
                AxisMemberHierarchy currentMemberHierarchy = new AxisMemberHierarchy();
                String period = PeriodDates.from((XbrlPeriod)xbrlPeriod).formatDate();
                currentMemberHierarchy.setAxis(periodAxis);
                currentMemberHierarchy.setLabel(period);
                currentMemberHierarchy.setId(period);
                currentMemberHierarchy.getAspectDataList().add(new AspectData("period", AspectType.forValue((String)"period"), period, null));
                target.getAxisMemberHierarchyList().add(currentMemberHierarchy);
            }
        } else {
            int processed = this.processingParamsPeriods(structure);
            if (processed > 0) {
                HashSet<String> periods = new HashSet<String>();
                periods.add("EMPTY_AXIS");
                structure.setPeriods(periods);
            } else {
                structure.setPeriods(activePeriods.stream().map(it -> PeriodDates.from((XbrlPeriod)it).formatDate()).collect(Collectors.toSet()));
            }
        }
    }

    private int processingParamsPeriods(TableLinkBaseStructure structure) {
        return this.processingMemberParamsPeriods(structure.getXAxis()) + this.processingMemberParamsPeriods(structure.getYAxis()) + this.processingMemberParamsPeriods(structure.getZAxis());
    }

    private int processingMemberParamsPeriods(AxisMemberHierarchy axis) {
        boolean axisHaveParamPeriod;
        int processed = 0;
        if (axis == null) {
            return processed;
        }
        if (axis.getAspectDataList() != null && (axisHaveParamPeriod = axis.getAspectDataList().stream().anyMatch(it -> it.getAspect().equals("period type")))) {
            ++processed;
        }
        for (AxisMemberHierarchy axisMemberHierarchy : axis.getAxisMemberHierarchyList()) {
            processed += this.processingMemberParamsPeriods(axisMemberHierarchy);
        }
        return processed;
    }
}

