/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.arelle.parse.HypercubeService;
import ru.cbr.xbrl.converter.exception.SkipTlbException;
import ru.cbr.xbrl.converter.model.tableLinkBase.AxisMemberHierarchy;
import ru.cbr.xbrl.converter.model.tableLinkBase.Group;
import ru.cbr.xbrl.converter.model.tableLinkBase.Header;
import ru.cbr.xbrl.converter.model.tableLinkBase.HeaderCell;
import ru.cbr.xbrl.converter.model.tableLinkBase.NodeType;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBase;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBaseStructure;
import ru.cbr.xbrl.converter.service.repair_tagselectors.RepairTagselectorsService;
import ru.cbr.xbrl.converter.utils.LabelUtils;
import ru.cbr.xbrl.converter.utils.MathUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;

@Service
public class TableLinkBaseStructureService {
    private static final Logger log = LoggerFactory.getLogger(TableLinkBaseStructureService.class);
    private static final String PERIOD = "period";
    private static final String X = "x";
    private static final String Y = "y";
    private static final String Z = "z";
    private static final String GENERATED = "EMPTY_AXIS";
    @Autowired
    private RepairTagselectorsService repairTagselectorsService;
    @Autowired
    private HypercubeService hypercubeService;

    public TableLinkBaseStructure createSafetyStructure(TableLinkBase tableLinkBase) throws SkipTlbException {
        if (tableLinkBase == null) {
            return null;
        }
        TableLinkBaseStructure tableLinkBaseStructure = null;
        try {
            tableLinkBaseStructure = this.createStructure(tableLinkBase);
        }
        catch (StackOverflowError e) {
            log.error("Stack overflow for " + tableLinkBase.getLabel());
        }
        return tableLinkBaseStructure;
    }

    private TableLinkBaseStructure createStructure(TableLinkBase tableLinkBase) throws SkipTlbException {
        if (StringUtils.isBlank((CharSequence)tableLinkBase.getLabel())) {
            return null;
        }
        TableLinkBaseStructure result = new TableLinkBaseStructure();
        String periodAxis = this.getPeriodAxis(tableLinkBase);
        result.setPeriodAxis(periodAxis);
        AxisMemberHierarchy zHierarchy = new AxisMemberHierarchy();
        Header headerZ = tableLinkBase.getHeaderZ();
        if (headerZ == null) {
            zHierarchy.setAxis(Z);
            AxisMemberHierarchy currentZMemberHierarchy = new AxisMemberHierarchy();
            currentZMemberHierarchy.setAxis(Z);
            currentZMemberHierarchy.setLabel(GENERATED);
            zHierarchy.getAxisMemberHierarchyList().add(currentZMemberHierarchy);
        } else if (!StringUtils.equals((CharSequence)periodAxis, (CharSequence)Z)) {
            LinkedList<AxisMemberHierarchy> zPeriodHierarchy = new LinkedList<AxisMemberHierarchy>();
            List zGroupLists = headerZ.getGroupList().stream().map(Group::getHeaderCellList).collect(Collectors.toList());
            List headerCellsLists = MathUtils.cartesianProduct(zGroupLists);
            for (List headerCellsList : headerCellsLists) {
                AxisMemberHierarchy currentZMemberHierarchy = new AxisMemberHierarchy();
                currentZMemberHierarchy.setAxis(Z);
                String label = headerCellsList.stream().map(h -> String.format("(%s)", LabelUtils.calcLabel((List)h.getAspectDataList(), (String)h.getLabLabel()))).collect(Collectors.joining(" "));
                currentZMemberHierarchy.setLabel(label);
                List aspectDataLists = headerCellsList.stream().map(HeaderCell::getAspectDataList).collect(Collectors.toList());
                List aspectDataList = aspectDataLists.stream().reduce(new ArrayList(), (a, b) -> {
                    a.addAll(b);
                    return a;
                });
                currentZMemberHierarchy.setAspectDataList(aspectDataList);
                Optional<HeaderCell> first = headerCellsList.stream().filter(it -> it.getNodeType() == NodeType.ASPECT).findFirst();
                if (first.isPresent()) {
                    currentZMemberHierarchy.setNodeType(NodeType.ASPECT);
                }
                zPeriodHierarchy.add(currentZMemberHierarchy);
            }
            zHierarchy.setAxis(Z);
            zHierarchy.getAxisMemberHierarchyList().addAll(zPeriodHierarchy);
        }
        AxisMemberHierarchy yHierarchy = new AxisMemberHierarchy();
        if (!StringUtils.equals((CharSequence)periodAxis, (CharSequence)Y)) {
            yHierarchy = this.buildAxisHierarchy(tableLinkBase.getHeaderY());
        }
        AxisMemberHierarchy xHierarchy = new AxisMemberHierarchy();
        if (!StringUtils.equals((CharSequence)periodAxis, (CharSequence)X)) {
            xHierarchy = this.buildAxisHierarchy(tableLinkBase.getHeaderX());
            if (xHierarchy == null) {
                throw new SkipTlbException();
            }
            xHierarchy.getAxisMemberHierarchyList().addAll(0, this.createDefaultXAxisHierarchy(yHierarchy.getRcCode()));
        } else {
            xHierarchy.setAxis(X);
            xHierarchy.getAxisMemberHierarchyList().addAll(this.createDefaultXAxisHierarchy(yHierarchy.getRcCode()));
        }
        result.setZAxis(zHierarchy);
        result.setXAxis(xHierarchy);
        result.setYAxis(yHierarchy);
        result.setRoleId(tableLinkBase.getRoleId());
        result.setDimensionsDefault(tableLinkBase.getDimensionsDefault());
        result.setEnumerations(tableLinkBase.getEnumerations());
        result.setLabel(tableLinkBase.getLabel());
        result.setName(tableLinkBase.getLinkrole());
        result.setDimensionsOfAspectNodes(result.findDimensionsOfAspectNodes());
        result.setDimensionPattens(result.findDimensionPatterns());
        this.inheritTagSelectors(result);
        this.setAbstractAspectNodeIfChildRuleNode(result);
        result.setXbrlRoleDimensionMemberMap(tableLinkBase.getXbrlRoleDimensionMemberMap());
        return result;
    }

    private List<AxisMemberHierarchy> createDefaultXAxisHierarchy(String rcCode) {
        ArrayList<AxisMemberHierarchy> resultList = new ArrayList<AxisMemberHierarchy>();
        AxisMemberHierarchy xTitleHeader = new AxisMemberHierarchy();
        xTitleHeader.setAxis(X);
        xTitleHeader.setLabel("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044f");
        xTitleHeader.setId("title");
        xTitleHeader.setDefinitionNodeId("x:title");
        resultList.add(xTitleHeader);
        if (!StringUtils.equalsIgnoreCase((CharSequence)rcCode, (CharSequence)"true")) {
            return resultList;
        }
        AxisMemberHierarchy xRcHeader = new AxisMemberHierarchy();
        xRcHeader.setAxis(X);
        xRcHeader.setLabel("");
        xRcHeader.setId("rcCode");
        xRcHeader.setDefinitionNodeId("x:rcCode");
        resultList.add(xRcHeader);
        return resultList;
    }

    private void setAbstractAspectNodeIfChildRuleNode(TableLinkBaseStructure result) {
        result.iterateAllAxisMemberHierarchy(axisMemberHierarchy -> {
            if (axisMemberHierarchy.getNodeType().equals((Object)NodeType.ASPECT)) {
                boolean childRuleNode = axisMemberHierarchy.getAxisMemberHierarchyList().stream().anyMatch(a -> a.getNodeType().equals((Object)NodeType.RULE));
                boolean childAspectNode = axisMemberHierarchy.getAxisMemberHierarchyList().stream().anyMatch(a -> a.getNodeType().equals((Object)NodeType.ASPECT));
                if (childRuleNode || childAspectNode) {
                    axisMemberHierarchy.setAbstractNode(true);
                }
            }
        });
    }

    private void inheritTagSelectors(TableLinkBaseStructure result) {
        result.getZAxis().iterate((axisMemberHierarchy, parents) -> this.inheriteTagSelector(axisMemberHierarchy, parents));
        result.getYAxis().iterate((axisMemberHierarchy, parents) -> this.inheriteTagSelector(axisMemberHierarchy, parents));
        result.getXAxis().iterate((axisMemberHierarchy, parents) -> this.inheriteTagSelector(axisMemberHierarchy, parents));
        this.repairTagselectorsService.fillRepairData(result);
    }

    private void inheriteTagSelector(AxisMemberHierarchy axisMemberHierarchy, List<AxisMemberHierarchy> parents) {
        AspectCellData aspectCellData = new AspectCellData(axisMemberHierarchy.getAspectDataList());
        AspectData concept = aspectCellData.getConcept();
        if (concept != null && StringUtils.isBlank((CharSequence)concept.getTagSelector())) {
            ListIterator<AxisMemberHierarchy> iterator = parents.listIterator(parents.size());
            while (iterator.hasPrevious()) {
                AxisMemberHierarchy previous = iterator.previous();
                String prevNodeTagSelector = previous.getNodeTagSelector();
                if (!StringUtils.isNotBlank((CharSequence)prevNodeTagSelector)) continue;
                concept.setTagSelector(prevNodeTagSelector);
                concept.setRepairTagSelector(prevNodeTagSelector);
                break;
            }
        }
    }

    private String getPeriodAxis(TableLinkBase tableLinkBase) {
        if (tableLinkBase == null) {
            return "";
        }
        Header headerX = tableLinkBase.getHeaderX();
        if (headerX != null && StringUtils.equals((CharSequence)headerX.getAspect(), (CharSequence)PERIOD)) {
            return X;
        }
        Header headerY = tableLinkBase.getHeaderY();
        if (headerY != null && StringUtils.equals((CharSequence)headerY.getAspect(), (CharSequence)PERIOD)) {
            return Y;
        }
        Header headerZ = tableLinkBase.getHeaderZ();
        if (headerZ != null && StringUtils.equals((CharSequence)headerZ.getAspect(), (CharSequence)PERIOD)) {
            return Z;
        }
        return "";
    }

    private AxisMemberHierarchy buildAxisHierarchy(Header axisHeader) {
        if (axisHeader == null) {
            return null;
        }
        AxisMemberHierarchy axisMemberHierarchy = new AxisMemberHierarchy();
        String axis = axisHeader.getAxis();
        axisMemberHierarchy.setAxis(axis);
        axisMemberHierarchy.setId(UUID.randomUUID().toString());
        axisMemberHierarchy.setRcCode(String.valueOf(axisHeader.isHasRcCode()));
        axisMemberHierarchy.setDefinitionNodeId(axis + ":root");
        List groupList = axisHeader.getGroupList();
        if (CollectionUtils.isEmpty((Collection)groupList)) {
            return axisMemberHierarchy;
        }
        Map headerByParentMap = axisHeader.getHeaderByParentMap();
        Map headerMap = axisHeader.getHeaderMap();
        HashSet rootParentIdSet = new HashSet(headerByParentMap.keySet());
        rootParentIdSet.removeAll(headerMap.keySet());
        LinkedList rootHeaderCellList = new LinkedList();
        for (String rootParentId : rootParentIdSet) {
            rootHeaderCellList.addAll((Collection)headerByParentMap.get(rootParentId));
        }
        for (HeaderCell rootHeaderCell : rootHeaderCellList) {
            if (CollectionUtils.isEmpty((Map)headerByParentMap) || rootHeaderCell.getConcepts().stream().anyMatch(s -> this.hypercubeService.isTechnicalConcept(s))) continue;
            axisMemberHierarchy.setUnitRole(rootHeaderCell.getUnitRole());
            AxisMemberHierarchy currentRootMemberAxisHierarchy = this.buildAxisHeaderHierarchy(rootHeaderCell, headerByParentMap, axis);
            axisMemberHierarchy.getAxisMemberHierarchyList().add(currentRootMemberAxisHierarchy);
        }
        return axisMemberHierarchy;
    }

    private AxisMemberHierarchy buildAxisHeaderHierarchy(HeaderCell currentRootHeaderCell, Map<String, List<HeaderCell>> headerByParentMap, String axis) {
        String id = currentRootHeaderCell.getId();
        List<HeaderCell> headerCellList = headerByParentMap.get(id);
        AxisMemberHierarchy axisMemberHierarchy = new AxisMemberHierarchy();
        axisMemberHierarchy.setId(currentRootHeaderCell.getId());
        axisMemberHierarchy.setNodeType(currentRootHeaderCell.getNodeType());
        axisMemberHierarchy.setAxis(axis);
        axisMemberHierarchy.setLabel(currentRootHeaderCell.getLabLabel());
        axisMemberHierarchy.setRcCode(currentRootHeaderCell.getRcCode());
        axisMemberHierarchy.setAbstractNode(currentRootHeaderCell.isAbstractNode());
        axisMemberHierarchy.setNodeTagSelector(currentRootHeaderCell.getNodeTagSelector());
        axisMemberHierarchy.setDefinitionNodeId(currentRootHeaderCell.getDefinitionNodeId());
        axisMemberHierarchy.setParentDefinitionNodeId(currentRootHeaderCell.getParentDefinitionNodeId());
        axisMemberHierarchy.setAspectDataList(currentRootHeaderCell.getAspectDataList());
        axisMemberHierarchy.setUnitRole(currentRootHeaderCell.getUnitRole());
        if (CollectionUtils.isEmpty(headerCellList)) {
            return axisMemberHierarchy;
        }
        for (HeaderCell headerCell : headerCellList) {
            if (headerCell.getConcepts().stream().anyMatch(s -> this.hypercubeService.isTechnicalConcept(s))) continue;
            axisMemberHierarchy.getAxisMemberHierarchyList().add(this.buildAxisHeaderHierarchy(headerCell, headerByParentMap, axis));
        }
        return axisMemberHierarchy;
    }
}

