/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import ru.cbr.xbrl.converter.config.ConfigProperties;
import ru.cbr.xbrl.converter.exception.DownloadException;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.TaxonomyEntryPointsNotFoundException;
import ru.cbr.xbrl.converter.exception.TaxonomyPackageXmlNotFoundException;
import ru.cbr.xbrl.converter.exception.TaxonomyVersionExistsException;
import ru.cbr.xbrl.converter.exception.UploadException;
import ru.cbr.xbrl.converter.exception.WrongTaxonomyPackageException;
import ru.cbr.xbrl.converter.exception.ZipExtractFileException;
import ru.cbr.xbrl.converter.model_main.Taxonomy;
import ru.cbr.xbrl.converter.service.TaxonomyService;
import ru.cbr.xbrl.converter.service.internal.TaxonomyCrudService;
import ru.cbr.xbrl.converter.taxonomy.taxonomy_package.TaxonomyPackageReader;

@Service
public class TaxonomyServiceImpl
implements TaxonomyService {
    private static final Logger log = LoggerFactory.getLogger(TaxonomyServiceImpl.class);
    @Autowired
    private TaxonomyCrudService taxonomyCrudService;
    @Autowired
    private ConfigProperties configProperties;

    public List<Taxonomy> list() {
        return this.taxonomyCrudService.list();
    }

    public Taxonomy find(Long id) throws NotFoundException {
        return this.taxonomyCrudService.find(id);
    }

    public Taxonomy findByVersion(String taxonomyVersion) throws NotFoundException {
        return this.taxonomyCrudService.findByVersion(taxonomyVersion);
    }

    public Taxonomy findByVersionSafe(String taxonomyVersion) {
        try {
            return this.taxonomyCrudService.findByVersion(taxonomyVersion);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    public void deleteWithFile(Long id) throws NotFoundException, IOException {
        Taxonomy taxonomy = this.find(id);
        Path filePath = Paths.get(taxonomy.getFilePath(), new String[0]);
        Files.delete(filePath);
        this.taxonomyCrudService.delete(taxonomy.getId());
    }

    public Taxonomy uploadLocal(String externalLocalPath) throws UploadException, ZipExtractFileException, TaxonomyVersionExistsException, WrongTaxonomyPackageException {
        String fileName = FilenameUtils.getName((String)externalLocalPath);
        String filePathInternal = ru.cbr.xbrl.converter.utils.FileUtils.relativePathToAbsolute((String)(this.configProperties.getTaxonomyStorePath() + File.separator + fileName));
        try {
            FileUtils.copyFile((File)new File(externalLocalPath), (File)new File(filePathInternal));
            Taxonomy created = this.processLoadedTaxonomy(filePathInternal);
            return created;
        }
        catch (IOException e) {
            throw new UploadException();
        }
        catch (TaxonomyEntryPointsNotFoundException e) {
            throw new WrongTaxonomyPackageException();
        }
        catch (TaxonomyPackageXmlNotFoundException e) {
            throw new WrongTaxonomyPackageException();
        }
    }

    public Taxonomy processLoadedTaxonomy(String filePathInternal) throws TaxonomyPackageXmlNotFoundException, TaxonomyEntryPointsNotFoundException, ZipExtractFileException, TaxonomyVersionExistsException, WrongTaxonomyPackageException {
        String fileName = FilenameUtils.getName((String)filePathInternal);
        Taxonomy taxonomy = new Taxonomy();
        taxonomy.setFileName(fileName);
        taxonomy.setFilePath(filePathInternal);
        taxonomy.setUploadTime(new Date());
        TaxonomyPackageReader.fillTaxonomyData((Taxonomy)taxonomy);
        String taxonomyVersion = taxonomy.getTaxonomyPackageVersion();
        Taxonomy existingTaxonomy = this.findByVersionSafe(taxonomyVersion);
        if (existingTaxonomy != null) {
            throw new TaxonomyVersionExistsException();
        }
        return this.taxonomyCrudService.create(taxonomy);
    }

    public byte[] download(Long id) throws NotFoundException, DownloadException {
        Taxonomy xbrlReport = this.find(id);
        try {
            FileInputStream inputStream = new FileInputStream(xbrlReport.getFilePath());
            return IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new DownloadException();
        }
    }

    public Taxonomy findLastTaxonomy() throws NotFoundException {
        return this.taxonomyCrudService.findLastTaxonomy();
    }
}

