/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;
import ru.cbr.xbrl.converter.config.ConfigProperties;
import ru.cbr.xbrl.converter.exception.ActionCancelledException;
import ru.cbr.xbrl.converter.exception.IncorrectTaxonomyUpdateUrl;
import ru.cbr.xbrl.converter.exception.ServerUnavailableException;
import ru.cbr.xbrl.converter.exception.TaxonomyEntryPointsNotFoundException;
import ru.cbr.xbrl.converter.exception.TaxonomyHashCheckingFailedException;
import ru.cbr.xbrl.converter.exception.TaxonomyPackageXmlNotFoundException;
import ru.cbr.xbrl.converter.exception.TaxonomyVersionExistsException;
import ru.cbr.xbrl.converter.exception.UploadException;
import ru.cbr.xbrl.converter.exception.WrongTaxonomyPackageException;
import ru.cbr.xbrl.converter.exception.ZipExtractFileException;
import ru.cbr.xbrl.converter.model.event.NotificationEvent;
import ru.cbr.xbrl.converter.model_main.Parameter;
import ru.cbr.xbrl.converter.model_main.ParameterName;
import ru.cbr.xbrl.converter.model_main.ParameterType;
import ru.cbr.xbrl.converter.model_main.Taxonomy;
import ru.cbr.xbrl.converter.service.TaxonomyService;
import ru.cbr.xbrl.converter.service.TaxonomyUpdateService;
import ru.cbr.xbrl.converter.service.event.NotificationEventService;
import ru.cbr.xbrl.converter.service.event.NotificationEventServiceImpl;
import ru.cbr.xbrl.converter.service.system.ParameterService;
import ru.cbr.xbrl.converter.taxonomy.taxonomy_package.data.TaxonomyDescription;
import ru.cbr.xbrl.converter.taxonomy.taxonomy_package.data.TaxonomyDescriptions;
import ru.cbr.xbrl.converter.utils.FileUtils;

@Service
public class TaxonomyUpdateServiceImpl
implements TaxonomyUpdateService {
    private static final Logger log = LoggerFactory.getLogger(TaxonomyUpdateServiceImpl.class);
    @Autowired
    private ConfigProperties configProperties;
    @Autowired
    private TaxonomyService taxonomyService;
    @Autowired
    private NotificationEventService notificationEventService;
    @Autowired
    private ParameterService parameterService;
    private Boolean isLastActionCancelled = false;

    public String getTaxonomyUpdateUrl(String newTaxonomyUpdateUrl) {
        String urlPath = this.configProperties.getTaxonomyHttpResource().replace("/^", "");
        Parameter parameter = this.parameterService.getParameter(ParameterName.TAXONOMY_UPDATE_RESOURCE_URL);
        if (parameter != null && this.isCorrectURL(parameter.getValue())) {
            urlPath = parameter.getValue();
        }
        if (!StringUtils.isEmpty((CharSequence)newTaxonomyUpdateUrl) && !newTaxonomyUpdateUrl.equalsIgnoreCase(urlPath)) {
            urlPath = newTaxonomyUpdateUrl;
            this.parameterService.saveParameter(ParameterName.TAXONOMY_UPDATE_RESOURCE_URL, newTaxonomyUpdateUrl, ParameterType.STRING);
        }
        return urlPath;
    }

    private boolean isCorrectURL(String url) {
        return !url.toLowerCase().contains("citytech-converter.wavea.cc");
    }

    public void saveTaxonomyFormSettings(String taxonomyUrl, Boolean taxonomyAutoUpdate) throws IncorrectTaxonomyUpdateUrl {
        this.checkUrl(taxonomyUrl);
        if (this.isCorrectURL(taxonomyUrl)) {
            this.parameterService.saveParameter(ParameterName.TAXONOMY_UPDATE_RESOURCE_URL, taxonomyUrl, ParameterType.STRING);
        }
        this.parameterService.saveParameter(ParameterName.TAXONOMY_AUTO_UPDATE, taxonomyAutoUpdate.toString(), ParameterType.BOOLEAN);
    }

    public Map<String, Object> getTaxonomyParams() {
        HashedMap map = new HashedMap();
        List parameters = this.parameterService.getParameters();
        parameters.forEach(arg_0 -> TaxonomyUpdateServiceImpl.lambda$getTaxonomyParams$0((Map)map, arg_0));
        if (map.get(ParameterName.TAXONOMY_UPDATE_RESOURCE_URL.name()) != null) {
            String url = (String)map.get(ParameterName.TAXONOMY_UPDATE_RESOURCE_URL.name());
            url = url.toLowerCase();
            log.info("url=" + url);
            if (!this.isCorrectURL(url)) {
                map.put(ParameterName.TAXONOMY_UPDATE_RESOURCE_URL.name(), "https://xbrl.ru/personal/anketaredaktorXBRL/taxonomies/");
            }
        }
        return map;
    }

    public String getTaxonomyUpdateResourceUrl(String newTaxonomyUpdateUrl) {
        String fileName = "Update.xml";
        String currentTaxonomyUpdateUrl = this.getTaxonomyUpdateUrl(newTaxonomyUpdateUrl);
        return UriComponentsBuilder.fromUriString((String)currentTaxonomyUpdateUrl).path(fileName).build().toUriString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Taxonomy uploadTaxonomyFromHttp(String taxonomyPackageUrl) throws UploadException, ZipExtractFileException, TaxonomyVersionExistsException, WrongTaxonomyPackageException, TaxonomyHashCheckingFailedException {
        File file;
        if (!taxonomyPackageUrl.matches("^http://")) {
            String updateXmlUrl = this.getTaxonomyUpdateResourceUrl(null);
            taxonomyPackageUrl = this.getTaxonomyPathOnHttpResource(updateXmlUrl, taxonomyPackageUrl);
        }
        if (this.isLastActionCancelled.booleanValue()) {
            this.cancelUploadTaxonomyProcess();
        }
        RestTemplate restTemplate = new RestTemplate();
        URL url = null;
        try {
            url = new URL(taxonomyPackageUrl);
        }
        catch (MalformedURLException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new UploadException();
        }
        if (this.isLastActionCancelled.booleanValue()) {
            this.cancelUploadTaxonomyProcess();
        }
        String md5 = (String)restTemplate.getForObject(StringUtils.replace((String)url.toString(), (String)".zip", (String)".md5"), String.class, new Object[0]);
        String fileName = FilenameUtils.getName((String)url.getPath());
        String taxonomyStore = FileUtils.relativePathToAbsolute((String)this.configProperties.getTaxonomyStorePath());
        String filePathInternal = FilenameUtils.concat((String)taxonomyStore, (String)fileName);
        if (this.isLastActionCancelled.booleanValue()) {
            this.cancelUploadTaxonomyProcess();
        }
        try {
            this.copyURLToFile(url, new File(filePathInternal), 60000, 60000);
        }
        catch (ActionCancelledException e) {
            if (new File(filePathInternal).delete()) throw new ActionCancelledException();
            log.info("\u0424\u0430\u0439\u043b \u0442\u0430\u043a\u0441\u043e\u043d\u043e\u043c\u0438\u0438: " + new File(filePathInternal).getAbsolutePath() + " \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0443\u0434\u0430\u043b\u0435\u043d \u043f\u043e\u0441\u043b\u0435 \u043e\u0448\u0438\u0431\u043a\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0438\u043b\u0438 \u043f\u0440\u0435\u0440\u044b\u0432\u0430\u043d\u0438\u044f \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0430.");
            throw new ActionCancelledException();
        }
        catch (IOException | RuntimeException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new TaxonomyHashCheckingFailedException();
        }
        if (this.isLastActionCancelled.booleanValue()) {
            this.cancelUploadTaxonomyProcess();
        }
        if (!(file = new File(filePathInternal)).exists() || file.isDirectory()) {
            log.warn("\u0421\u043a\u0430\u0447\u0438\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u043a\u0441\u043e\u043d\u043e\u043c\u0438\u0438 \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430. \u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0444\u0430\u0439\u043b \u0432 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f \u0441\u043a\u0430\u0447\u0438\u0432\u0430\u043d\u0438\u044f - " + filePathInternal);
            throw new TaxonomyHashCheckingFailedException();
        }
        try (FileInputStream is = new FileInputStream(filePathInternal);){
            String digest = DigestUtils.md5Hex((InputStream)is);
            if (this.isLastActionCancelled.booleanValue()) {
                this.cancelUploadTaxonomyProcess();
            }
            if (!StringUtils.equals((CharSequence)StringUtils.trim((String)md5), (CharSequence)StringUtils.trim((String)digest))) {
                log.warn("MD5 checksum for server taxonomy zip (" + md5 + ") does not equal md5 for downloaded taxonomy zip (" + digest + ").");
                throw new TaxonomyHashCheckingFailedException();
            }
            if (this.isLastActionCancelled.booleanValue()) {
                this.cancelUploadTaxonomyProcess();
            }
            Taxonomy taxonomy = this.taxonomyService.processLoadedTaxonomy(filePathInternal);
            return taxonomy;
        }
        catch (ActionCancelledException e) {
            if (file.delete()) throw new ActionCancelledException();
            log.info("\u0424\u0430\u0439\u043b \u0442\u0430\u043a\u0441\u043e\u043d\u043e\u043c\u0438\u0438: " + file.getAbsolutePath() + " \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0443\u0434\u0430\u043b\u0435\u043d \u043f\u043e\u0441\u043b\u0435 \u043e\u0448\u0438\u0431\u043a\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0438\u043b\u0438 \u043f\u0440\u0435\u0440\u044b\u0432\u0430\u043d\u0438\u044f \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0430.");
            throw new ActionCancelledException();
        }
        catch (IOException | RuntimeException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new TaxonomyHashCheckingFailedException();
        }
        catch (TaxonomyEntryPointsNotFoundException | TaxonomyPackageXmlNotFoundException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new UploadException();
        }
    }

    public List<TaxonomyDescription> getTaxonomyDescriptions(boolean checkUpdates, String taxonomyUpdateUrl) throws IncorrectTaxonomyUpdateUrl, ServerUnavailableException {
        this.checkUrl(taxonomyUpdateUrl);
        String updateXmlUrl = this.getTaxonomyUpdateResourceUrl(taxonomyUpdateUrl);
        TaxonomyDescriptions taxonomyDescriptions = checkUpdates ? this.loadUpdateXml(updateXmlUrl) : new TaxonomyDescriptions();
        List loadedTaxonomies = this.taxonomyService.list();
        List descriptions = taxonomyDescriptions.getDescriptions();
        for (Taxonomy loadedTaxonomy : loadedTaxonomies) {
            String loadedTaxonomyVersion = loadedTaxonomy.getDescriptionVersion();
            Optional<TaxonomyDescription> existingDescr = descriptions.stream().filter(descr -> descr.getVersion().equals(loadedTaxonomyVersion)).findFirst();
            if (existingDescr.isPresent()) {
                TaxonomyDescription description = existingDescr.get();
                description.setLoaded(Boolean.TRUE.booleanValue());
                description.setId(loadedTaxonomy.getId());
                description.setTaxonomyPackageVersion(loadedTaxonomy.getTaxonomyPackageVersion());
                continue;
            }
            descriptions.add(new TaxonomyDescription(loadedTaxonomy));
        }
        return descriptions;
    }

    private void checkUrl(String taxonomyUpdateUrl) throws IncorrectTaxonomyUpdateUrl {
        if (taxonomyUpdateUrl != null) {
            try {
                new URL(taxonomyUpdateUrl);
            }
            catch (MalformedURLException e) {
                log.error("URL '{}' is incorrect", (Object)taxonomyUpdateUrl, (Object)e);
                throw new IncorrectTaxonomyUpdateUrl();
            }
        }
    }

    public Boolean hasNewActual() throws IncorrectTaxonomyUpdateUrl, ServerUnavailableException {
        boolean checkUpdates = true;
        List newTaxonomyDescriptions = this.getTaxonomyDescriptions(checkUpdates, null);
        if (newTaxonomyDescriptions.isEmpty()) {
            log.info("Update.xml is empty");
            return false;
        }
        Collections.reverse(newTaxonomyDescriptions);
        Optional<TaxonomyDescription> actual = newTaxonomyDescriptions.stream().filter(d -> d.getActual() != null && d.getActual() != false).findFirst();
        if (actual.isPresent()) {
            return !actual.get().isLoaded();
        }
        log.error("Missing actual taxonomy in the file Update.xml");
        return false;
    }

    private TaxonomyDescriptions loadUpdateXml(String url) throws ServerUnavailableException {
        ResponseEntity response;
        RestTemplate restTemplate = new RestTemplate();
        try {
            response = restTemplate.getForEntity(url, TaxonomyDescriptions.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("Server is not available", (Throwable)e);
            throw new ServerUnavailableException();
        }
        return (TaxonomyDescriptions)response.getBody();
    }

    public String getTaxonomyPathOnHttpResource(String updateXmlUrl, String taxonomyArchive) {
        try {
            URL u = new URL(updateXmlUrl);
            String PATH_PREFIX = "/";
            String urlPath = PATH_PREFIX + FilenameUtils.getPath((String)u.getPath());
            if (urlPath.endsWith("/")) {
                urlPath = urlPath.substring(0, urlPath.length() - 1);
            }
            String taxonomyPath = urlPath + "/" + taxonomyArchive;
            URL res = new URL(u.getProtocol(), u.getHost(), u.getPort(), taxonomyPath);
            return res.toString();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyURLToFile(URL source, File destination, int connectionTimeout, int readTimeout) throws IOException {
        URLConnection connection = source.openConnection();
        connection.setConnectTimeout(connectionTimeout);
        connection.setReadTimeout(readTimeout);
        int byteInMb = 0x100000;
        int fileSizeMb = (int)(connection.getContentLengthLong() / 0x100000L);
        InputStream input = connection.getInputStream();
        try {
            FileOutputStream output = org.apache.commons.io.FileUtils.openOutputStream((File)destination);
            try {
                int n = 0;
                int previousUploaded = 0;
                byte[] buffer = new byte[4096];
                while (-1 != (n = input.read(buffer))) {
                    int uploaded;
                    output.write(buffer, 0, n);
                    if (this.isLastActionCancelled.booleanValue()) {
                        this.cancelUploadTaxonomyProcess();
                    }
                    if ((uploaded = (int)(output.getChannel().size() / 0x100000L)) == previousUploaded) continue;
                    this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.TAXONOMY, new NotificationEvent("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445", uploaded, fileSizeMb));
                    previousUploaded = uploaded;
                }
                output.close();
            }
            finally {
                IOUtils.closeQuietly((OutputStream)output);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    public Boolean getLastActionCancelled() {
        return this.isLastActionCancelled;
    }

    public void setLastActionCancelled(Boolean lastActionCancelled) {
        this.isLastActionCancelled = lastActionCancelled;
    }

    private void cancelUploadTaxonomyProcess() {
        log.info("Taxonomy downloading cancelled by user");
        this.setLastActionCancelled(Boolean.valueOf(false));
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.CANCEL, new NotificationEvent());
        throw new ActionCancelledException();
    }

    private static /* synthetic */ void lambda$getTaxonomyParams$0(Map map, Parameter parameter) {
        map.put(parameter.getName().name(), parameter.getType().equals((Object)ParameterType.BOOLEAN) ? Boolean.valueOf(parameter.getValue()) : parameter.getValue());
    }
}

