/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.config.ConfigProperties;
import ru.cbr.xbrl.converter.controller.import_export.ExportTemplateStruct;
import ru.cbr.xbrl.converter.exception.AccessDeniedDirectoryException;
import ru.cbr.xbrl.converter.exception.DeleteTemplateException;
import ru.cbr.xbrl.converter.exception.DeltaNotFoundException;
import ru.cbr.xbrl.converter.exception.DeltaTagNameNotCorrectException;
import ru.cbr.xbrl.converter.exception.FileAlreadyExistsException;
import ru.cbr.xbrl.converter.exception.IncorrectTemplateArchiveException;
import ru.cbr.xbrl.converter.exception.MappingNotFoundException;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.RewritableFileOpenException;
import ru.cbr.xbrl.converter.exception.TemplateArchiveEncryptionException;
import ru.cbr.xbrl.converter.exception.TemplateDoesNotExistException;
import ru.cbr.xbrl.converter.exception.TemplateNotFoundException;
import ru.cbr.xbrl.converter.exception.WriteFileException;
import ru.cbr.xbrl.converter.exception.WrongTemplatePackageFilesNumberException;
import ru.cbr.xbrl.converter.model.TemplateMapping;
import ru.cbr.xbrl.converter.model.XbrlDimension;
import ru.cbr.xbrl.converter.model.XbrlParameter;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.event.NotificationEvent;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.model.tableLinkBase.AspectNodeMember;
import ru.cbr.xbrl.converter.model.tableLinkBase.AxisMemberHierarchy;
import ru.cbr.xbrl.converter.model.tableLinkBase.EnumerateItem;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterOpenAxisValue;
import ru.cbr.xbrl.converter.model.tableLinkBase.NodeType;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBaseStructure;
import ru.cbr.xbrl.converter.model.web.rest.ColumnHeader;
import ru.cbr.xbrl.converter.model_main.Template;
import ru.cbr.xbrl.converter.repository_main.TemplateRepository;
import ru.cbr.xbrl.converter.service.AspectNodeService;
import ru.cbr.xbrl.converter.service.CellEditableCheckerService;
import ru.cbr.xbrl.converter.service.TableLinkBaseDynamicStructureService;
import ru.cbr.xbrl.converter.service.TemplateService;
import ru.cbr.xbrl.converter.service.XbrlDimensionService;
import ru.cbr.xbrl.converter.service.XbrlPackageService;
import ru.cbr.xbrl.converter.service.XbrlParameterService;
import ru.cbr.xbrl.converter.service.XbrlPeriodService;
import ru.cbr.xbrl.converter.service.XbrlReportService;
import ru.cbr.xbrl.converter.service.event.NotificationEventService;
import ru.cbr.xbrl.converter.service.event.NotificationEventServiceImpl;
import ru.cbr.xbrl.converter.service.import_export.EditXbrlService;
import ru.cbr.xbrl.converter.service.internal.XbrlFilterOpenAxisService;
import ru.cbr.xbrl.converter.service.internal.XbrlPackageCrudService;
import ru.cbr.xbrl.converter.utils.MathUtils;
import ru.cbr.xbrl.converter.utils.TemplateUtils;
import ru.cbr.xbrl.converter.utils.ZipUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XlsxTemplateFormWriter;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XslxTemplateWriter;
import ru.cbr.xbrl.converter.xbrl.import_export.xml.DeltaXmlParser;
import ru.cbr.xbrl.converter.xbrl.import_export.xml.DeltaXmlWriter;
import ru.cbr.xbrl.converter.xbrl.import_export.xml.MappingXmlParser;
import ru.cbr.xbrl.converter.xbrl.import_export.xml.MappingXmlWriter;

@Service
@Transactional(value="cacheTransactionManager")
public class TemplateServiceImpl
implements TemplateService {
    private static final Logger log = LoggerFactory.getLogger(TemplateServiceImpl.class);
    @Autowired
    private TemplateRepository templateRepository;
    @Autowired
    private ConfigProperties configProperties;
    @Autowired
    private XbrlPackageService xbrlPackageService;
    @Autowired
    private XbrlDimensionService xbrlDimensionService;
    @Autowired
    private XbrlFilterOpenAxisService filterOpenAxisService;
    @Autowired
    private EditXbrlService editXbrlService;
    @Autowired
    private TableLinkBaseDynamicStructureService tableLinkBaseDynamicStructureService;
    @Autowired
    private NotificationEventService notificationEventService;
    @Autowired
    private XbrlParameterService parameterService;
    @Autowired
    private AspectNodeService aspectNodeService;
    @Autowired
    private XbrlReportService xbrlReportService;
    @Autowired
    private CellEditableCheckerService cellEditableCheckerService;
    @Autowired
    private XbrlPeriodService xbrlPeriodService;
    @Autowired
    private XbrlPackageCrudService xbrlPackageCrudService;
    private ObjectMapper objectMapper = new ObjectMapper();
    private Map<String, List<AspectNodeMember>> closedMemberCache = new HashMap();

    public List<Template> getList() {
        return (List)this.templateRepository.findAll();
    }

    public List<Template> getSortedList() {
        XbrlPackage lastPackage = this.xbrlPackageCrudService.findLastXbrlPackage();
        List templateList = (List)this.templateRepository.findAll();
        return this.getSortedTemplates(templateList, lastPackage);
    }

    public Template find(Long id) throws NotFoundException {
        return (Template)this.templateRepository.findOne((Serializable)id);
    }

    public void delete(Long id) throws TemplateDoesNotExistException, DeleteTemplateException, IOException {
        Template template;
        try {
            template = this.find(id);
        }
        catch (NotFoundException e) {
            log.error("\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0448\u0430\u0431\u043b\u043e\u043d\u0435 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c " + id + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0411\u0414: ", (Throwable)e);
            throw new TemplateDoesNotExistException();
        }
        try {
            this.removeFromInternalTemplatesDir(template);
            this.templateRepository.delete((Serializable)id);
        }
        catch (IOException e) {
            log.error("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0448\u0430\u0431\u043b\u043e\u043d \u043f\u043e \u043f\u0443\u0442\u0438 " + this.getInternalTemplateAbsolutePath(template), (Throwable)e);
            throw new DeleteTemplateException(this.getInternalTemplateAbsolutePath(template));
        }
    }

    public List<Template> listByEntryPoint(String entryPoint) {
        return this.templateRepository.findAllByEntryPoint(entryPoint);
    }

    public int getNextTemplateVersion(String entryPoint) {
        Template template = this.templateRepository.findTopByEntryPointOrderByVersionDesc(entryPoint);
        if (template != null) {
            return template.getVersion() + 1;
        }
        return 1;
    }

    /*
     * Exception decompiling
     */
    public boolean uploadLocal(String localPath, boolean isUpdate) throws ZipException, IncorrectTemplateArchiveException, TemplateArchiveEncryptionException, IOException, MappingNotFoundException, DeltaNotFoundException, TemplateNotFoundException, WrongTemplatePackageFilesNumberException, DeltaTagNameNotCorrectException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Template processLoadedTemplate(InputStream mappingInputStream, InputStream deltaInputStream) throws IOException, DeltaNotFoundException, MappingNotFoundException, DeltaTagNameNotCorrectException {
        TemplateMapping mapping;
        Template template = new Template();
        try (BufferedInputStream inputStream = new BufferedInputStream(deltaInputStream);){
            new DeltaXmlParser(template, (InputStream)inputStream);
            if (StringUtils.isBlank((CharSequence)template.getName())) {
                throw new DeltaTagNameNotCorrectException("\u0418\u043c\u044f, \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0435 \u0432 \u0444\u0430\u0439\u043b\u0435 \u0434\u0435\u043b\u044c\u0442\u044b, \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c \u0438\u043b\u0438 \u0441\u043e\u0441\u0442\u043e\u044f\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0438\u0437 \u043f\u0440\u043e\u0431\u0435\u043b\u044c\u043d\u044b\u0445 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432");
            }
        }
        catch (DeltaTagNameNotCorrectException e) {
            throw e;
        }
        catch (Exception e) {
            log.info(ExceptionUtils.getStackTrace((Throwable)e));
            throw new DeltaNotFoundException();
        }
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(mappingInputStream);){
            mapping = new MappingXmlParser().parse((InputStream)bufferedInputStream);
        }
        catch (Exception e) {
            log.info(ExceptionUtils.getStackTrace((Throwable)e));
            throw new MappingNotFoundException();
        }
        HashMap zAxisLabelCodeMap = new HashMap();
        mapping.getZDimensions().forEach((k, v) -> zAxisLabelCodeMap.put(v.getLabel(), k));
        template.setZAxisLabelCodeMap(new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(zAxisLabelCodeMap));
        return template;
    }

    public Map<String, Date> prepareParameterPeriodMap() {
        List parameterList = this.parameterService.findAll();
        if (CollectionUtils.isEmpty((Collection)parameterList)) {
            return Collections.emptyMap();
        }
        return parameterList.stream().collect(Collectors.toMap(XbrlParameter::getQName, XbrlParameter::getValue, (o, o2) -> o2));
    }

    public void exportForm(Long templateId, String localPath, boolean multipleFiles, String mainZDim, boolean allowOverwriteFile) throws IOException, NotFoundException, XMLStreamException, FileAlreadyExistsException, WriteFileException, RewritableFileOpenException, ZipException, TemplateArchiveEncryptionException, IncorrectTemplateArchiveException, TemplateNotFoundException {
        TemplateMapping mapping;
        Template template = this.find(templateId);
        ZipFile zipFile = new ZipFile(this.getInternalTemplateAbsolutePath(template));
        try {
            if (!zipFile.isEncrypted()) {
                throw new TemplateArchiveEncryptionException();
            }
        }
        catch (ZipException e) {
            throw new IncorrectTemplateArchiveException();
        }
        zipFile.setPassword(ZipUtils.encodePassword((String)"WB_~xow^*nv32zY"));
        String extractPath = TemplateUtils.getTempDirPath();
        zipFile.extractAll(extractPath);
        try {
            mapping = new MappingXmlParser().parse((InputStream)new BufferedInputStream(this.getMappingInputStream(extractPath)));
        }
        catch (Exception e) {
            throw new TemplateArchiveEncryptionException();
        }
        Map zAxisStructure = mapping.getZDimensions();
        AspectData mainZDimData = (AspectData)zAxisStructure.get(this.getZAxisLabelCodeMap(template).get(mainZDim));
        Map dimMembersMap = mainZDimData != null ? this.fillDimensionValues(Collections.singletonList(mainZDimData)) : new HashMap();
        List mainZDimValues = this.buildZAxisDataCortege(dimMembersMap);
        if (CollectionUtils.isEmpty((Collection)mainZDimValues)) {
            mainZDimValues.add(Collections.emptyList());
        }
        XbrlReport xbrlReport = this.xbrlPackageService.findLastPackage().getXbrlReport();
        new XlsxTemplateFormWriter(this.getTemplateInputStream(extractPath), localPath, multipleFiles, mainZDimValues, this.xbrlPackageService.findLastPackage().getOgrn(), template, mapping, this.editXbrlService, this.xbrlPackageService.findLastPackage().getXbrlReport(), (TemplateService)this, this.prepareCurrentStatePeriodFormulaValue(mapping, xbrlReport), this.prepareEnumerations(xbrlReport), this.expandHeader(mapping.getRolesAspectData()), notificationEvent -> this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.EXPORT, notificationEvent), allowOverwriteFile);
        ru.cbr.xbrl.converter.utils.FileUtils.deleteDir((String)extractPath);
    }

    public boolean isBelong(List<AspectData> general, List<AspectData> part, boolean includeValue) {
        return part.stream().allMatch(partData -> this.isBelong(general, partData, includeValue));
    }

    public boolean isBelong(List<AspectData> general, AspectData part, boolean includeValue) {
        return general.stream().anyMatch(generalData -> this.haveSameParams(generalData, part) && (!includeValue || generalData.getAspectValue().equals(part.getAspectValue())));
    }

    public boolean haveSameParams(AspectData a, AspectData b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return (a.getAspect() == null && b.getAspect() == null || a.getAspect().equals(b.getAspect())) && (a.getDomain() == null && b.getDomain() == null || a.getDomain().equals(b.getDomain())) && (a.getType() == null && b.getType() == null || a.getType().equals((Object)b.getType()));
    }

    public List<List<AspectData>> expandOpenAxis(List<AspectData> axisData, String roleId, boolean hideParents) {
        List<List<Object>> tree = new ArrayList<List<AspectData>>();
        LinkedHashMap<String, List> valuesByHash = new LinkedHashMap<String, List>();
        for (AspectData aspectData : axisData) {
            if (!aspectData.getType().equals((Object)AspectType.DIMENSION)) continue;
            ArrayList relations = new ArrayList();
            String aspect = aspectData.getAspect();
            if (aspectData.getDimensionType().equals((Object)DimensionType.TYPED_MEMBER)) {
                this.filterOpenAxisService.getFilterOpenAxisValues(aspect).forEach(value -> relations.addAll(value.getAspectNodeMemberList()));
            } else {
                Object memberList = (List)this.closedMemberCache.get(aspect);
                if (memberList == null) {
                    memberList = this.aspectNodeService.getClosedAspectNodeMembersByDimension(aspect);
                }
                if (CollectionUtils.isEmpty((Collection)memberList)) {
                    this.closedMemberCache.put(aspect, new ArrayList());
                } else {
                    this.closedMemberCache.put(aspect, memberList);
                }
                relations.addAll(memberList);
            }
            for (AspectNodeMember relation : relations) {
                if (!relation.getXbrlReportRole().getRoleId().equals(roleId)) continue;
                AspectData branchElement = new AspectData(aspectData);
                branchElement.setAspectValue(relation.getFilterOpenAxisValue() != null ? relation.getFilterOpenAxisValue().getValue() : relation.getClosedMemberValue());
                branchElement.setLabel(relation.getClosedMemberLabel());
                branchElement.setHash(relation.getHash());
                branchElement.setCommonId(relation.getCommonId());
                List hashList = valuesByHash.computeIfAbsent(relation.getHash(), s -> new ArrayList());
                hashList.add(branchElement);
            }
        }
        boolean wasTypedDim = false;
        for (int i = 0; i < axisData.size(); ++i) {
            AspectData aspectData = axisData.get(i);
            for (String hash : valuesByHash.keySet()) {
                List parentBranch = tree.stream().filter(branch -> ((AspectData)branch.get(branch.size() - 1)).getCommonId().equals(hash)).findFirst().orElse(new ArrayList());
                if (wasTypedDim && parentBranch.size() == 0) continue;
                int branchIndex = this.getBranchIndex(tree, parentBranch) + 1;
                List valuesList = (List)valuesByHash.get(hash);
                int itemNum = 0;
                for (AspectData axisValue : valuesList) {
                    if (i != axisData.size() - 1 && !valuesByHash.containsKey(axisValue.getCommonId())) continue;
                    ArrayList<AspectData> newBranch = new ArrayList<AspectData>(parentBranch);
                    newBranch.add(axisValue);
                    if (newBranch.size() != axisData.size()) {
                        for (int n = 0; n < axisData.size(); ++n) {
                            AspectData data = axisData.get(n);
                            if (!data.getType().equals((Object)AspectType.DIMENSION) || !data.getDimensionType().equals((Object)DimensionType.EXPLICIT_MEMBER) || !newBranch.stream().noneMatch(branchData -> branchData.getAspect().equals(data.getAspect()))) continue;
                            newBranch.add(n, aspectData);
                        }
                    }
                    tree.add(branchIndex + itemNum, newBranch);
                    ++itemNum;
                }
            }
            if (wasTypedDim || !aspectData.getType().equals((Object)AspectType.DIMENSION) || !aspectData.getDimensionType().equals((Object)DimensionType.TYPED_MEMBER)) continue;
            wasTypedDim = true;
        }
        if (hideParents) {
            tree = tree.stream().filter(branch -> ((AspectData)branch.get(branch.size() - 1)).getAspect().equals(((AspectData)axisData.get(axisData.size() - 1)).getAspect())).collect(Collectors.toList());
        }
        return tree;
    }

    public Set<String> getZAxisTitlesForTemplate(Long templateId) throws NotFoundException, IOException {
        Template template = this.find(templateId);
        if (template == null) {
            return new HashSet<String>();
        }
        return this.getZAxisLabelCodeMap(this.find(templateId)).keySet();
    }

    private Map<String, String> getZAxisLabelCodeMap(Template template) throws IOException {
        return (Map)new ObjectMapper().readValue(template.getZAxisLabelCodeMap(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Map<String, List<AspectData>> processZCodes(Map<String, List<AspectData>> zCodes) {
        LinkedHashMap<String, List<AspectData>> result = new LinkedHashMap<String, List<AspectData>>();
        HashSet<String> zAxisDimSequenceSet = new HashSet<String>();
        for (String zCode : zCodes.keySet()) {
            List<AspectData> codeData = zCodes.get(zCode);
            ArrayList<AspectData> processedCodeData = new ArrayList<AspectData>();
            String zAxisDimSequence = "";
            for (AspectData aspectData : codeData) {
                zAxisDimSequence = zAxisDimSequence + aspectData.getAspect();
                if (aspectData.getDimensionType().equals((Object)DimensionType.TYPED_MEMBER)) {
                    processedCodeData.add(aspectData);
                    continue;
                }
                AspectData processed = new AspectData(aspectData);
                processed.setAspectValue("(bound dynamically)");
                processed.setLabel(this.xbrlDimensionService.getLabelByDimInt(aspectData.getAspect()));
                processedCodeData.add(processed);
            }
            if (zAxisDimSequenceSet.contains(zAxisDimSequence)) continue;
            result.put(zCode, processedCodeData);
            zAxisDimSequenceSet.add(zAxisDimSequence);
        }
        return result;
    }

    public Map<AspectData, Map<String, String>> fillDimensionValues(List<AspectData> zAspectData) {
        LinkedHashMap<AspectData, Map<String, String>> result = new LinkedHashMap<AspectData, Map<String, String>>();
        for (AspectData zDim : zAspectData) {
            String aspect = zDim.getAspect();
            Map<String, String> members = null;
            if (zDim.getDimensionType().equals((Object)DimensionType.TYPED_MEMBER)) {
                List filterOpenAxisValues = this.filterOpenAxisService.getFilterOpenAxisValues(aspect);
                members = filterOpenAxisValues.stream().map(FilterOpenAxisValue::getValue).collect(Collectors.toMap(value -> value, value -> value));
            }
            if (zDim.getDimensionType().equals((Object)DimensionType.EXPLICIT_MEMBER)) {
                List xbrlDimensions = this.xbrlDimensionService.findMembers(null, aspect);
                members = xbrlDimensions.stream().collect(Collectors.toMap(XbrlDimension::getMemInt, XbrlDimension::getMemIntLabel));
            }
            result.put(zDim, members);
        }
        return result;
    }

    public String getValueForExplicitDimension(AspectData aspectData) {
        return this.xbrlDimensionService.findMembers(null, aspectData.getAspect()).stream().filter(xbrlDimension -> xbrlDimension.getMemInt().equals(aspectData.getAspectValue())).map(XbrlDimension::getMemIntLabel).findFirst().orElse("");
    }

    public List<List<AspectData>> buildZAxisDataCortege(Map<AspectData, Map<String, String>> axisData) {
        ArrayList zAxisList = new ArrayList();
        for (AspectData zDim : axisData.keySet()) {
            ArrayList<AspectData> filledDims = new ArrayList<AspectData>();
            Map<String, String> members = axisData.get(zDim);
            for (String member : members.keySet()) {
                AspectData filledAxisDim = new AspectData(zDim);
                if (zDim.getDimensionType().equals((Object)DimensionType.TYPED_MEMBER)) {
                    filledAxisDim.setAspectValue(member);
                    filledAxisDim.setLabel(filledAxisDim.getLabel() + "-" + member);
                } else {
                    filledAxisDim.setAspectValue(member);
                    filledAxisDim.setLabel(filledAxisDim.getLabel() + "-" + members.get(member));
                }
                filledDims.add(filledAxisDim);
            }
            zAxisList.add(filledDims);
        }
        ArrayList<List<AspectData>> washedZAxisList = new ArrayList<List<AspectData>>();
        MathUtils.cartesianProduct(zAxisList).forEach(aspectDataList -> {
            if (this.tableLinkBaseDynamicStructureService.isAxisAvailable(aspectDataList)) {
                washedZAxisList.add((List<AspectData>)aspectDataList);
            }
        });
        return washedZAxisList;
    }

    public void fillAxisCodes(Map<String, List<AspectData>> codes, AxisMemberHierarchy parent, String currentBranchCode, List<AspectData> currentAspectData) {
        List children = parent.getAxisMemberHierarchyList();
        for (int i = 0; i < children.size(); ++i) {
            AxisMemberHierarchy child = (AxisMemberHierarchy)children.get(i);
            if (StringUtils.equals((CharSequence)child.getId(), (CharSequence)"rcCode")) continue;
            String branchCode = this.getBranchCode(child, currentBranchCode + (i + 1));
            ArrayList<AspectData> childData = new ArrayList<AspectData>(currentAspectData);
            childData.addAll(child.getAspectDataList());
            codes.put(branchCode, childData);
            if (child.getAxisMemberHierarchyList().size() > 0) {
                branchCode = branchCode + "-";
            }
            this.fillAxisCodes(codes, child, branchCode, childData);
        }
    }

    public void fillCodeItems(Map<String, AxisMemberHierarchy> codeItems, AxisMemberHierarchy parent, String currentBranchCode) {
        List children = parent.getAxisMemberHierarchyList();
        for (int i = 0; i < children.size(); ++i) {
            AxisMemberHierarchy child = (AxisMemberHierarchy)children.get(i);
            String branchCode = this.getBranchCode(child, currentBranchCode + (i + 1));
            codeItems.put(branchCode, child);
            if (child.getAxisMemberHierarchyList().size() > 0) {
                branchCode = branchCode + "-";
            }
            this.fillCodeItems(codeItems, child, branchCode);
        }
    }

    public void buildColumnsHierarchy(String roleCode, ColumnHeader parentHeader, AxisMemberHierarchy parent, String currentBranchCode) {
        List children = parent.getAxisMemberHierarchyList();
        for (int i = 0; i < children.size(); ++i) {
            AxisMemberHierarchy child = (AxisMemberHierarchy)children.get(i);
            String branchCode = this.getBranchCode(child, currentBranchCode + (i + 1));
            ColumnHeader column = new ColumnHeader();
            if (StringUtils.equals((CharSequence)child.getId(), (CharSequence)"rcCode")) {
                column.setCaption("");
                column.setDataField("rcCode");
            } else {
                column.setCaption(TemplateUtils.getTitleCode((boolean)true, (String)roleCode, (String)branchCode, (String)"0", (AxisMemberHierarchy)child));
                column.setDataField(branchCode);
            }
            column.setColspan(Integer.valueOf(0));
            column.setRcCode(child.getRcCode());
            column.setAspectDataList(child.getAspectDataList());
            column.setAbstractNode(child.isAbstractNode());
            column.setChildAspectNodes(child.getChildAspectNodes());
            column.setHash(child.getHash());
            parentHeader.getColumnList().add(column);
            if (child.getAxisMemberHierarchyList().size() > 0) {
                branchCode = branchCode + "-";
            }
            this.buildColumnsHierarchy(roleCode, column, child, branchCode);
        }
    }

    public void fillColumnsColspan(ColumnHeader columnHeader) {
        List columnHeaders = columnHeader.getColumnList();
        columnHeaders.forEach(arg_0 -> this.fillColumnsColspan(arg_0));
        if (columnHeaders.size() > 0) {
            int colSpan = columnHeaders.stream().mapToInt(ColumnHeader::getColspan).sum();
            columnHeader.setColspan(Integer.valueOf(colSpan));
        } else {
            columnHeader.setColspan(Integer.valueOf(1));
        }
    }

    public void findLeaveHeaders(List<ColumnHeader> leaves, ColumnHeader parent) {
        for (ColumnHeader child : parent.getColumnList()) {
            if (child.getColumnList().size() > 0) {
                this.findLeaveHeaders(leaves, child);
                continue;
            }
            leaves.add(child);
        }
    }

    private String getBranchCode(AxisMemberHierarchy child, String currentItemBranchCode) {
        String branchCode = child.getNodeType().equals((Object)NodeType.RULE) ? (StringUtils.isBlank((CharSequence)child.getLabel()) && child.getAspectDataList().stream().filter(aspectData -> aspectData.getType() != AspectType.PARAMS_PERIOD).collect(Collectors.toList()).size() == 0 ? currentItemBranchCode + "D" : currentItemBranchCode) : currentItemBranchCode + "N";
        return branchCode;
    }

    private Map<String, List<String>> expandHeader(Map<String, Map<String, Map<String, List<AspectData>>>> rolesAspectData) {
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        for (String roleCode : rolesAspectData.keySet()) {
            Map branchCodeValuesMap = this.getBranchCodeValuesMap(rolesAspectData.get(roleCode).get("X"), roleCode);
            this.fillAxisHeader(true, roleCode, branchCodeValuesMap, result);
            branchCodeValuesMap = this.getBranchCodeValuesMap(rolesAspectData.get(roleCode).get("Y"), roleCode);
            this.fillAxisHeader(false, roleCode, branchCodeValuesMap, result);
        }
        return result;
    }

    private void fillAxisHeader(boolean isForXAxis, String roleCode, Map<String, List<List<AspectData>>> branchCodeValuesMap, Map<String, List<String>> headerMap) {
        for (String branchCode : branchCodeValuesMap.keySet()) {
            String axisCode = "C_" + roleCode + ":" + (isForXAxis ? branchCode + ":" + "0" : "0:" + branchCode);
            headerMap.put(axisCode, new ArrayList());
            String previousFullLabel = "";
            for (List<AspectData> value : branchCodeValuesMap.get(branchCode)) {
                String fullLabel = this.getAspectDataBranchHash(value);
                String elementLabel = "";
                if (!fullLabel.equals(previousFullLabel)) {
                    AspectData lastDim = value.get(value.size() - 1);
                    elementLabel = lastDim.getAspectValue();
                }
                headerMap.get(axisCode).add(elementLabel);
                previousFullLabel = fullLabel;
            }
        }
    }

    private String getAspectDataBranchHash(List<AspectData> branch) {
        String hash = "";
        for (AspectData value : branch) {
            hash = hash.concat(value.getAspect() + "=" + value.getAspectValue() + "#");
        }
        return hash;
    }

    private Map<String, List<List<AspectData>>> getBranchCodeValuesMap(Map<String, List<AspectData>> codesDataMap, String roleId) {
        LinkedHashMap<String, List<List<AspectData>>> branchCodeValuesMap = new LinkedHashMap<String, List<List<AspectData>>>();
        codesDataMap.keySet().forEach(code -> {
            List codeData = ((List)codesDataMap.get(code)).stream().filter(aspectData -> !aspectData.getType().equals((Object)AspectType.PARAMS_PERIOD)).collect(Collectors.toList());
            List expandedAxis = this.expandOpenAxis(codeData, roleId, false);
            expandedAxis.removeIf(axis -> !this.isBelong(axis, codeData, false));
            branchCodeValuesMap.put((String)code, expandedAxis);
        });
        ArrayList codes = Lists.newArrayList(branchCodeValuesMap.keySet());
        for (int i = codes.size() - 1; i >= 0; --i) {
            String code2 = (String)codes.get(i);
            List values = (List)branchCodeValuesMap.get(code2);
            if (i - 1 < 0) continue;
            String parentCode = (String)codes.get(i - 1);
            List parentValues = (List)branchCodeValuesMap.get(parentCode);
            int parentValuesSize = parentValues.size();
            for (int j = 0; j < parentValuesSize; ++j) {
                List parentValue = (List)parentValues.get(j);
                int countChild = 0;
                for (List value : values) {
                    if (!this.isBelong(value, parentValue, true)) continue;
                    ++countChild;
                }
                if (countChild <= 0) continue;
                --countChild;
                for (int k = 0; k < countChild; ++k) {
                    parentValues.add(j + 1, parentValue);
                }
                parentValuesSize += countChild;
                j += countChild;
            }
        }
        return branchCodeValuesMap;
    }

    private int getBranchIndex(List<List<AspectData>> tree, List<AspectData> branch) {
        int index = -1;
        for (int i = 0; i < tree.size(); ++i) {
            List<AspectData> treeBranch = tree.get(i);
            if (treeBranch.size() != branch.size() || !this.isBelong(treeBranch, branch, true)) continue;
            index = i;
            break;
        }
        return index;
    }

    private Map<String, Map<String, List<EnumerateItem>>> prepareEnumerations(XbrlReport xbrlReport) {
        HashMap<String, Map<String, List<EnumerateItem>>> result = new HashMap<String, Map<String, List<EnumerateItem>>>();
        List xbrlReportRoles = xbrlReport.getXbrlReportRoles();
        for (XbrlReportRole xbrlReportRole : xbrlReportRoles) {
            String roleId = xbrlReportRole.getRoleId();
            try {
                TableLinkBaseStructure tableLinkBaseStructure = (TableLinkBaseStructure)this.objectMapper.readValue(xbrlReportRole.getStaticStructureJson(), TableLinkBaseStructure.class);
                result.put(roleId, tableLinkBaseStructure.getEnumerations());
            }
            catch (IOException e) {
                log.error("Parsing structure failing - row skip");
            }
        }
        return result;
    }

    private Map<String, Date> prepareCurrentStatePeriodFormulaValue(TemplateMapping mapping, XbrlReport xbrlReport) throws IOException {
        Map rolesAspectData = mapping.getRolesAspectData();
        if (CollectionUtils.isEmpty((Map)rolesAspectData) || xbrlReport == null || CollectionUtils.isEmpty((Collection)xbrlReport.getXbrlReportRoles())) {
            return Collections.emptyMap();
        }
        HashMap<String, Date> periodParameterValueMap = new HashMap<String, Date>();
        Set roleIdSet = rolesAspectData.keySet();
        List xbrlReportRoleList = xbrlReport.getXbrlReportRoles();
        for (XbrlReportRole xbrlReportRole : xbrlReportRoleList) {
            String systemId = StringUtils.substringAfterLast((String)xbrlReportRole.getSystemId(), (String)"/");
            if (StringUtils.isBlank((CharSequence)systemId) || !roleIdSet.contains(systemId)) continue;
            String staticStructureJson = xbrlReportRole.getStaticStructureJson();
            TableLinkBaseStructure tableLinkBaseStructure = (TableLinkBaseStructure)this.objectMapper.readValue(staticStructureJson, TableLinkBaseStructure.class);
            this.xbrlPackageService.preparePeriodParameterValueMap(periodParameterValueMap, tableLinkBaseStructure);
        }
        return periodParameterValueMap;
    }

    private void saveNewTemplateInternally(String tempDirPath, Template template) throws ZipException, IOException, TemplateNotFoundException, MappingNotFoundException, DeltaNotFoundException {
        try (InputStream templateInputStream = this.getTemplateInputStream(tempDirPath);
             InputStream mappingInputStream = this.getMappingInputStream(tempDirPath);
             InputStream deltaInputStream = this.getDeltaInputStream(tempDirPath);){
            ZipFile newZipFile = new ZipFile(this.getInternalTemplateAbsolutePath(template));
            newZipFile.addStream(templateInputStream, ZipUtils.getZipParametersToAddStreams((String)"WB_~xow^*nv32zY", (String)("Template_" + this.getPackageName(template) + ".xlsx")));
            newZipFile.addStream(mappingInputStream, ZipUtils.getZipParametersToAddStreams((String)"WB_~xow^*nv32zY", (String)("Mapping_" + this.getPackageName(template) + ".xml")));
            newZipFile.addStream(deltaInputStream, ZipUtils.getZipParametersToAddStreams((String)"WB_~xow^*nv32zY", (String)("Delta_" + this.getPackageName(template) + ".xml")));
        }
        ru.cbr.xbrl.converter.utils.FileUtils.deleteDir((String)tempDirPath);
    }

    private Template findDuplicateTemplate(Template template) {
        return this.templateRepository.findByVersionAndEntryPointAndTaxonomyVersionAndName(template.getVersion(), template.getEntryPoint(), template.getTaxonomyVersion(), template.getName());
    }

    private void removeFromInternalTemplatesDir(Template template) throws IOException {
        String internalTemplateAbsolutePath = this.getInternalTemplateAbsolutePath(template);
        FileUtils.touch((File)new File(internalTemplateAbsolutePath));
        FileUtils.forceDelete((File)FileUtils.getFile((String[])new String[]{internalTemplateAbsolutePath}));
    }

    private String getTemplatesDirectoryPath() throws IOException {
        String templateDirectoryPath = ru.cbr.xbrl.converter.utils.FileUtils.relativePathToAbsolute((String)this.configProperties.getTemplateStorePath());
        File templateDir = new File(templateDirectoryPath);
        templateDir.mkdirs();
        if (!templateDir.isDirectory()) {
            throw new IOException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u0438 \u0434\u043b\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0448\u0430\u0431\u043b\u043e\u043d\u0430");
        }
        return templateDirectoryPath;
    }

    private String getInternalTemplateAbsolutePath(Template template) throws IOException {
        String packageExtension = ZipUtils.getPackageExtension((boolean)true);
        return FilenameUtils.concat((String)this.getTemplatesDirectoryPath(), (String)("Package_" + this.getPackageName(template) + packageExtension));
    }

    private String getPackageName(Template template) {
        return FilenameUtils.removeExtension((String)template.getEntryPoint()) + "_" + template.getVersion() + "_" + template.getName().hashCode();
    }

    private boolean isNotTemplatePackageFilepathCorrect(String localPath) {
        String packageExtension = ZipUtils.getPackageExtension((boolean)false);
        return localPath == null || !new File(localPath).isFile() || !packageExtension.equals("." + FilenameUtils.getExtension((String)localPath)) || !FilenameUtils.getName((String)localPath).startsWith("Package_");
    }

    private InputStream getMappingInputStream(String tempDirPath) throws MappingNotFoundException, IOException {
        try {
            return new FileInputStream(this.getFilePath(tempDirPath, "Mapping_", ".xml").toString());
        }
        catch (FileNotFoundException e) {
            throw new MappingNotFoundException();
        }
    }

    private InputStream getTemplateInputStream(String tempDirPath) throws TemplateNotFoundException, IOException {
        try {
            return new FileInputStream(this.getFilePath(tempDirPath, "Template_", ".xlsx").toString());
        }
        catch (FileNotFoundException e) {
            throw new TemplateNotFoundException();
        }
    }

    private InputStream getDeltaInputStream(String tempDirPath) throws DeltaNotFoundException, IOException {
        try {
            return new FileInputStream(this.getFilePath(tempDirPath, "Delta_", ".xml").toString());
        }
        catch (FileNotFoundException e) {
            throw new DeltaNotFoundException();
        }
    }

    private Path getFilePath(String dirAbsolutePath, String filePrefix, String ext) throws IOException {
        try (Stream<Path> paths = Files.walk(Paths.get(dirAbsolutePath, new String[0]), new FileVisitOption[0]);){
            List list = paths.filter(path -> FilenameUtils.getName((String)path.toString()).startsWith(filePrefix) && ("." + FilenameUtils.getExtension((String)path.toString())).equals(ext)).collect(Collectors.toList());
            if (list.size() == 1) {
                Path path2 = (Path)list.get(0);
                return path2;
            }
        }
        throw new FileNotFoundException();
    }

    private List<Template> getSortedTemplates(List<Template> entryPointTemplateList, XbrlPackage lastPackage) {
        LinkedHashMap<String, List> templatesByEntryPoint = new LinkedHashMap<String, List>();
        if (lastPackage != null) {
            String activeEntryPointName = FilenameUtils.getName((String)lastPackage.getPathToXsd());
            templatesByEntryPoint.put(activeEntryPointName, new ArrayList());
        }
        entryPointTemplateList.sort(Comparator.comparing(Template::getEntryPoint));
        entryPointTemplateList.forEach(x -> {
            if (templatesByEntryPoint.containsKey(x.getEntryPoint())) {
                List templates = (List)templatesByEntryPoint.get(x.getEntryPoint());
                templates.add(x);
            } else {
                ArrayList<Template> templates = new ArrayList<Template>();
                templates.add((Template)x);
                templatesByEntryPoint.put(x.getEntryPoint(), templates);
            }
        });
        ArrayList<Template> result = new ArrayList<Template>();
        templatesByEntryPoint.forEach((entryPoint, templateList) -> result.addAll(this.getSortedGroupedTemplates(templateList, lastPackage)));
        return result;
    }

    private List<Template> getSortedGroupedTemplates(List<Template> entryPointTemplateList, XbrlPackage lastPackage) {
        String activeTaxonomy = lastPackage != null ? lastPackage.getTaxonomyVersion() : null;
        ArrayList activeTaxonomyTemplates = new ArrayList();
        ArrayList otherTaxonomyTemplates = new ArrayList();
        entryPointTemplateList.forEach(x -> {
            if (x.getTaxonomyVersion().equals(activeTaxonomy)) {
                activeTaxonomyTemplates.add(x);
            } else {
                otherTaxonomyTemplates.add(x);
            }
        });
        this.getTemplatesSortedByAllKeysWithoutEntryPoint(activeTaxonomyTemplates);
        this.getTemplatesSortedByAllKeysWithoutEntryPoint(otherTaxonomyTemplates);
        ArrayList<Template> result = new ArrayList<Template>();
        result.addAll(activeTaxonomyTemplates);
        result.addAll(otherTaxonomyTemplates);
        return result;
    }

    private void getTemplatesSortedByAllKeysWithoutEntryPoint(List<Template> templates) {
        templates.sort(Comparator.comparing(Template::getTaxonomyVersion).reversed().thenComparing(Template::getName).reversed().thenComparing(Template::getVersion).reversed());
    }

    private String extractZipFile(String localPath) throws IncorrectTemplateArchiveException, ZipException, TemplateArchiveEncryptionException, IOException, WrongTemplatePackageFilesNumberException {
        if (this.isNotTemplatePackageFilepathCorrect(localPath)) {
            throw new IncorrectTemplateArchiveException();
        }
        ZipFile zipFile = new ZipFile(localPath);
        try {
            if (!zipFile.isEncrypted()) {
                throw new TemplateArchiveEncryptionException();
            }
        }
        catch (ZipException e) {
            throw new IncorrectTemplateArchiveException();
        }
        zipFile.setPassword("WB_~xow^*nv32zY");
        List zipFileHeaders = zipFile.getFileHeaders();
        if (zipFileHeaders.size() != 3) {
            throw new WrongTemplatePackageFilesNumberException();
        }
        String tempTemplateFilesExtractionDirPath = TemplateUtils.getTempDirPath();
        try {
            zipFile.extractAll(tempTemplateFilesExtractionDirPath);
        }
        catch (ZipException e) {
            throw new TemplateArchiveEncryptionException();
        }
        return tempTemplateFilesExtractionDirPath;
    }

    @Transactional(value="cacheTransactionManager")
    public void exportTemplateMappingXml(ExportTemplateStruct exportTemplateStruct, OutputStream outputStream) {
        Date start = new Date();
        log.info("Export mapping XML started...");
        try {
            XbrlReport xbrlReport = this.xbrlReportService.find(exportTemplateStruct.getXbrlReportId());
            new MappingXmlWriter(xbrlReport, exportTemplateStruct, outputStream, (TemplateService)this);
            log.info("Export mapping XML completed in " + (new Date().getTime() - start.getTime()) + " msec");
        }
        catch (UnsupportedEncodingException | XMLStreamException | NotFoundException e) {
            log.error("Export mapping XML failed: " + e.getMessage());
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Transactional(value="cacheTransactionManager")
    public void exportTemplateDeltaXml(ExportTemplateStruct exportTemplateStruct, OutputStream outputStream) throws UnsupportedEncodingException, XMLStreamException {
        Date start = new Date();
        log.info("Export delta XML started...");
        try {
            new DeltaXmlWriter(exportTemplateStruct, outputStream);
            log.info("Export delta XML completed in " + (new Date().getTime() - start.getTime()) + " msec");
        }
        catch (UnsupportedEncodingException | XMLStreamException e) {
            log.error("Export delta XML failed: ", (Throwable)e);
            throw e;
        }
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public void exportTemplate(ExportTemplateStruct exportTemplateStruct) throws FileAlreadyExistsException, WriteFileException, NotFoundException, IOException, RewritableFileOpenException, XMLStreamException, AccessDeniedDirectoryException {
        Date start = new Date();
        log.info("Export template started...");
        String tempDirPath = TemplateUtils.getTempDirPath();
        this.exportXlsxTemplateFile(tempDirPath, exportTemplateStruct);
        String mappingTempFilePath = TemplateUtils.getMappingFilePath((String)tempDirPath, (ExportTemplateStruct)exportTemplateStruct);
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(mappingTempFilePath));){
            this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.EXPORT, new NotificationEvent("\u042d\u043a\u0441\u043f\u043e\u0440\u0442 mapping-\u0444\u0430\u0439\u043b\u0430 \u0448\u0430\u0431\u043b\u043e\u043d\u0430"));
            this.exportTemplateMappingXml(exportTemplateStruct, (OutputStream)outputStream);
        }
        catch (Exception e) {
            log.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0438\u0441\u0438 \u0444\u0430\u0439\u043b\u0430 \u043c\u0430\u043f\u043f\u0438\u043d\u0433\u0430: ", (Throwable)e);
            throw e;
        }
        String deltaTempFilePath = TemplateUtils.getDeltaFilePath((String)tempDirPath, (ExportTemplateStruct)exportTemplateStruct);
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(deltaTempFilePath));){
            this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.EXPORT, new NotificationEvent("\u042d\u043a\u0441\u043f\u043e\u0440\u0442 delta-\u0444\u0430\u0439\u043b\u0430 \u0448\u0430\u0431\u043b\u043e\u043d\u0430"));
            this.exportTemplateDeltaXml(exportTemplateStruct, (OutputStream)outputStream);
        }
        catch (Exception e) {
            log.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0438\u0441\u0438 \u0444\u0430\u0439\u043b\u0430 \u0434\u0435\u043b\u044c\u0442\u044b: ", (Throwable)e);
            throw e;
        }
        String templateTempFilePath = TemplateUtils.getTemplateFilePath((String)tempDirPath, (ExportTemplateStruct)exportTemplateStruct);
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.SAVE, new NotificationEvent("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u043f\u0430\u043a\u0435\u0442\u0430 \u0448\u0430\u0431\u043b\u043e\u043d\u0430"));
        try {
            ZipUtils.createZipWithPassword((ExportTemplateStruct)exportTemplateStruct, (ArrayList)new /* Unavailable Anonymous Inner Class!! */, (String)"WB_~xow^*nv32zY", (boolean)false);
        }
        catch (ZipException e) {
            log.error("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c zip-\u0430\u0440\u0445\u0438\u0432: ", (Throwable)e);
            throw new AccessDeniedDirectoryException();
        }
        finally {
            ru.cbr.xbrl.converter.utils.FileUtils.deleteDir((String)tempDirPath);
        }
        log.info("Export template completed in " + (new Date().getTime() - start.getTime()) + " msec");
    }

    public void clearClosedMemberCache() {
        this.closedMemberCache.clear();
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public void exportXlsxTemplateFile(String tempDirPath, ExportTemplateStruct exportTemplateStruct) throws IOException, NotFoundException, FileAlreadyExistsException, WriteFileException, RewritableFileOpenException {
        Date start = new Date();
        log.info("Export template started...");
        XbrlReport xbrlReport = this.xbrlReportService.find(exportTemplateStruct.getXbrlReportId());
        xbrlReport.getXbrlReportRoles().sort(Comparator.comparing(XbrlReportRole::getCompareString));
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        xbrlPackage.getXbrlReport().setXbrlReportRoles(xbrlPackage.getXbrlReport().getXbrlReportRoles().stream().filter(xbrlReportRole -> exportTemplateStruct.getReportRoleIds().contains(xbrlReportRole.getId())).collect(Collectors.toList()));
        String fullPath = TemplateUtils.getTemplateFilePath((String)tempDirPath, (ExportTemplateStruct)exportTemplateStruct);
        ru.cbr.xbrl.converter.utils.FileUtils.checkFileWritable((String)fullPath, (Boolean)false);
        XslxTemplateWriter xslxTemplateWriter = new XslxTemplateWriter(fullPath, xbrlPackage, notificationEvent -> this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.EXPORT, notificationEvent), arg_0 -> ((CellEditableCheckerService)this.cellEditableCheckerService).checkNotEditableExcludeMembers(arg_0), (TemplateService)this, this.xbrlPeriodService, this.parameterService);
        log.info("Export template completed in " + (new Date().getTime() - start.getTime()) + " msec");
        xslxTemplateWriter.draw();
    }
}

