/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import ru.cbr.xbrl.converter.model.DataType;
import ru.cbr.xbrl.converter.model.UnitsConfiguration;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlUnit;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlUnitId;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValue;
import ru.cbr.xbrl.converter.repository.XbrlUnitRepository;
import ru.cbr.xbrl.converter.service.ConceptService;
import ru.cbr.xbrl.converter.service.UnitService;
import ru.cbr.xbrl.converter.service.internal.xbrl.XbrlUnitCrudService;
import ru.cbr.xbrl.converter.service.internal.xbrl.XbrlValueCrudService;

@Service
public class UnitService {
    private static final Logger log = LoggerFactory.getLogger(UnitService.class);
    public static final String XBRLI_PURE = "xbrli:pure";
    public static final String XBRLI_SHARES = "xbrli:shares";
    public static final String XBRLI = "xbrli";
    public static final String ISO4217 = "iso4217";
    public static final String SHARES = "SHARES";
    public static final String PURE = "PURE";
    @Autowired
    private XbrlUnitCrudService xbrlUnitCrudService;
    @Autowired
    private XbrlValueCrudService xbrlValueCrudService;
    @Autowired
    private ConceptService conceptService;
    @Autowired
    private XbrlUnitRepository xbrlUnitRepository;
    HashMap<String, DataType> dataTypes = new HashMap();
    HashMap<DataType, String> xbrlUnits = new HashMap();

    @Transactional(value="cacheTransactionManager")
    public void updateAllFacts(Long xbrlReportId, UnitsConfiguration currentConfig) {
        XbrlUnit monetaryUnit = this.findOrCreateMonetaryUnit(xbrlReportId, currentConfig);
        XbrlUnit sharesUnit = this.findOrCreateSharesUnit(xbrlReportId, currentConfig);
        XbrlUnit pureUnit = this.findOrCreatePureUnit(xbrlReportId, currentConfig);
        block6: for (DataType dataType : DataType.values()) {
            switch (1.$SwitchMap$ru$cbr$xbrl$converter$model$DataType[dataType.ordinal()]) {
                case 1: {
                    this.xbrlValueCrudService.updateUnitDecimalsPrecisionByDataType(DataType.MONETARY, monetaryUnit, currentConfig.getCurrencyDecimals(), currentConfig.getCurrencyPrecision());
                    continue block6;
                }
                case 2: {
                    this.xbrlValueCrudService.updateUnitDecimalsPrecisionByDataType(DataType.SHARES, sharesUnit, currentConfig.getSharesDecimals(), currentConfig.getSharesPrecision());
                    continue block6;
                }
                case 3: {
                    this.xbrlValueCrudService.updateUnitDecimalsPrecisionByDataType(DataType.DECIMALS, pureUnit, currentConfig.getDecimalDecimals(), currentConfig.getDecimalPrecision());
                    continue block6;
                }
                case 4: {
                    this.xbrlValueCrudService.updateUnitDecimalsPrecisionByDataType(DataType.INTEGER, pureUnit, currentConfig.getIntegerDecimals(), currentConfig.getIntegerPrecision());
                }
            }
        }
    }

    public void fillValueXls(Long xbrlReportId, XbrlValue xbrlValue, UnitsConfiguration unitsConfiguration) {
        String xbrlUnit;
        if (xbrlValue.getDataType() == null) {
            DataType dataType = (DataType)this.dataTypes.get(xbrlValue.getXbrlValueId().getElementLabel());
            if (dataType == null) {
                log.info("fillValueXls getDataType for " + xbrlValue.getXbrlValueId().getElementLabel());
                xbrlValue.setDataType(this.conceptService.findTypeByConcept(xbrlValue.getXbrlValueId().getElementLabel()));
                this.dataTypes.putIfAbsent(xbrlValue.getXbrlValueId().getElementLabel(), xbrlValue.getDataType());
            } else {
                xbrlValue.setDataType(dataType);
            }
        }
        if ((xbrlUnit = (String)this.xbrlUnits.get(xbrlValue.getDataType())) == null) {
            log.info("xbrlUnit for " + xbrlValue.getDataType());
            switch (1.$SwitchMap$ru$cbr$xbrl$converter$model$DataType[xbrlValue.getDataType().ordinal()]) {
                case 1: {
                    XbrlUnit monetaryUnit = this.findOrCreateMonetaryUnit(xbrlReportId, unitsConfiguration);
                    xbrlUnit = monetaryUnit.getXbrlUnitId().getUnitId();
                    break;
                }
                case 2: {
                    XbrlUnit shareUnit = this.findOrCreateSharesUnit(xbrlReportId, unitsConfiguration);
                    xbrlUnit = shareUnit.getXbrlUnitId().getUnitId();
                    break;
                }
                case 5: {
                    xbrlUnit = "ffff####";
                    break;
                }
                case 3: 
                case 4: {
                    XbrlUnit pureUnit = this.findOrCreatePureUnit(xbrlReportId, unitsConfiguration);
                    xbrlUnit = pureUnit.getXbrlUnitId().getUnitId();
                }
            }
            this.xbrlUnits.putIfAbsent(xbrlValue.getDataType(), xbrlUnit);
        }
        Object pureUnit = null;
        switch (1.$SwitchMap$ru$cbr$xbrl$converter$model$DataType[xbrlValue.getDataType().ordinal()]) {
            case 1: {
                xbrlValue.setDecimals(unitsConfiguration.getCurrencyDecimals());
                xbrlValue.setPrecision(unitsConfiguration.getCurrencyPrecision());
                xbrlValue.setXbrlUnit(xbrlUnit);
                break;
            }
            case 2: {
                xbrlValue.setDecimals(unitsConfiguration.getSharesDecimals());
                xbrlValue.setPrecision(unitsConfiguration.getSharesPrecision());
                xbrlValue.setXbrlUnit(xbrlUnit);
                break;
            }
            case 3: {
                xbrlValue.setDecimals(unitsConfiguration.getDecimalDecimals());
                xbrlValue.setPrecision(unitsConfiguration.getDecimalPrecision());
                xbrlValue.setXbrlUnit(xbrlUnit);
                break;
            }
            case 4: {
                xbrlValue.setDecimals(unitsConfiguration.getIntegerDecimals());
                xbrlValue.setPrecision(unitsConfiguration.getIntegerPrecision());
                xbrlValue.setXbrlUnit(xbrlUnit);
            }
        }
    }

    public void fillValue(Long xbrlReportId, XbrlValue xbrlValue, UnitsConfiguration unitsConfiguration) {
        if (xbrlValue.getDataType() == null) {
            xbrlValue.setDataType(this.conceptService.findTypeByConcept(xbrlValue.getXbrlValueId().getElementLabel()));
        }
        XbrlUnit pureUnit = null;
        switch (1.$SwitchMap$ru$cbr$xbrl$converter$model$DataType[xbrlValue.getDataType().ordinal()]) {
            case 1: {
                XbrlUnit monetaryUnit = this.findOrCreateMonetaryUnit(xbrlReportId, unitsConfiguration);
                xbrlValue.setDecimals(unitsConfiguration.getCurrencyDecimals());
                xbrlValue.setPrecision(unitsConfiguration.getCurrencyPrecision());
                xbrlValue.setXbrlUnit(monetaryUnit.getXbrlUnitId().getUnitId());
                break;
            }
            case 2: {
                XbrlUnit shareUnit = this.findOrCreateSharesUnit(xbrlReportId, unitsConfiguration);
                xbrlValue.setDecimals(unitsConfiguration.getSharesDecimals());
                xbrlValue.setPrecision(unitsConfiguration.getSharesPrecision());
                xbrlValue.setXbrlUnit(shareUnit.getXbrlUnitId().getUnitId());
                break;
            }
            case 3: {
                pureUnit = this.findOrCreatePureUnit(xbrlReportId, unitsConfiguration);
                xbrlValue.setDecimals(unitsConfiguration.getDecimalDecimals());
                xbrlValue.setPrecision(unitsConfiguration.getDecimalPrecision());
                xbrlValue.setXbrlUnit(pureUnit.getXbrlUnitId().getUnitId());
                break;
            }
            case 4: {
                pureUnit = this.findOrCreatePureUnit(xbrlReportId, unitsConfiguration);
                xbrlValue.setDecimals(unitsConfiguration.getIntegerDecimals());
                xbrlValue.setPrecision(unitsConfiguration.getIntegerPrecision());
                xbrlValue.setXbrlUnit(pureUnit.getXbrlUnitId().getUnitId());
            }
        }
    }

    private XbrlUnit findOrCreateMonetaryUnit(Long xbrlReportId, UnitsConfiguration currentConfig) {
        String unitId = currentConfig.getCurrency();
        String measure = String.join((CharSequence)":", ISO4217, unitId);
        XbrlUnit xbrlUnit = this.xbrlUnitCrudService.findByMeasure(measure);
        if (xbrlUnit == null) {
            xbrlUnit = this.createXbrlUnit(xbrlReportId, unitId, measure);
        }
        return xbrlUnit;
    }

    private XbrlUnit findOrCreateSharesUnit(Long xbrlReportId, UnitsConfiguration currentConfig) {
        XbrlUnit xbrlUnit = this.xbrlUnitCrudService.findByMeasure(XBRLI_SHARES);
        if (xbrlUnit == null) {
            xbrlUnit = this.createXbrlUnit(xbrlReportId, SHARES, XBRLI_SHARES);
        }
        return xbrlUnit;
    }

    private XbrlUnit findOrCreatePureUnit(Long xbrlReportId, UnitsConfiguration currentConfig) {
        XbrlUnit xbrlUnit = this.xbrlUnitCrudService.findByMeasure(XBRLI_PURE);
        if (xbrlUnit == null) {
            xbrlUnit = this.createXbrlUnit(xbrlReportId, PURE, XBRLI_PURE);
        }
        return xbrlUnit;
    }

    public XbrlUnit findOrCreateUnit(Long xbrlReportId, String prefix, String unitId) {
        if (StringUtils.isBlank((CharSequence)unitId)) {
            return null;
        }
        String measure = String.join((CharSequence)":", prefix.toLowerCase(), unitId);
        XbrlUnit xbrlUnit = this.xbrlUnitCrudService.findByMeasure(measure);
        if (xbrlUnit == null) {
            xbrlUnit = this.createXbrlUnit(xbrlReportId, unitId, measure);
        }
        return xbrlUnit;
    }

    private XbrlUnit createXbrlUnit(Long xbrlReportId, String unitId, String measure) {
        XbrlUnit newXbrlUnit = new XbrlUnit();
        newXbrlUnit.setMeasure(measure);
        XbrlUnitId xbrlUnitId = new XbrlUnitId();
        xbrlUnitId.setUnitId(unitId.toUpperCase());
        xbrlUnitId.setXbrlReportId(xbrlReportId);
        newXbrlUnit.setXbrlUnitId(xbrlUnitId);
        XbrlUnit xbrlUnit = this.xbrlUnitCrudService.create(newXbrlUnit);
        log.info("Created unit " + xbrlUnit);
        return xbrlUnit;
    }

    public void clearUnusedXbrlUnits() {
        List allUnits = this.xbrlUnitRepository.findAll();
        List usedUnits = this.xbrlUnitRepository.findUsedUnits();
        allUnits.stream().forEach(u -> {
            boolean exists = usedUnits.stream().anyMatch(used -> used.getKey() != null && ((String)used.getKey()).equals(u.getXbrlUnitId().getUnitId()));
            if (!exists) {
                log.warn("Delete unused unit: {}", u);
                this.xbrlUnitRepository.delete(u);
            }
        });
    }
}

