/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import ru.cbr.xbrl.converter.exception.ActionCancelledException;
import ru.cbr.xbrl.converter.exception.IncompatibleSchemaRefException;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.model.XbrlPeriod;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.event.NotificationEvent;
import ru.cbr.xbrl.converter.model.log.EventLog;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.model.xbrl_content.PeriodType;
import ru.cbr.xbrl.converter.service.XbrlPackageService;
import ru.cbr.xbrl.converter.service.comparing.ComparingModelProcessor;
import ru.cbr.xbrl.converter.service.event.NotificationEventService;
import ru.cbr.xbrl.converter.service.event.NotificationEventServiceImpl;
import ru.cbr.xbrl.converter.service.import_export.PeriodDates;
import ru.cbr.xbrl.converter.service.internal.XbrlReportCrudService;
import ru.cbr.xbrl.converter.service.log.EventLogService;

@Service
public class XbrlComparingService {
    private static final Logger log = LoggerFactory.getLogger(XbrlComparingService.class);
    @Autowired
    private XbrlReportCrudService xbrlReportCrudService;
    @Autowired
    private EventLogService eventLogService;
    @Autowired
    private NamedParameterJdbcTemplate jdbcTemplate;
    @Autowired
    private ComparingModelProcessor comparingModelProcessor;
    @Autowired
    private XbrlPackageService xbrlPackageService;
    @Autowired
    private NotificationEventService notificationEventService;
    private boolean isLastActionCanceled = false;

    @Transactional(value="cacheTransactionManager")
    public List<EventLog> compare(Long xbrlReportId) throws NotFoundException, IncompatibleSchemaRefException {
        if (this.isLastActionCanceled) {
            this.cancelCompareProcess();
        }
        this.eventLogService.clearXlsxCompare();
        if (this.isLastActionCanceled) {
            this.cancelCompareProcess();
        }
        XbrlReport xbrlReport = this.xbrlReportCrudService.find(xbrlReportId);
        List xbrlPackagePeriodList = xbrlReport.getXbrlPackage().getXbrlPackagePeriodList();
        if (this.isLastActionCanceled) {
            this.cancelCompareProcess();
        }
        ArrayList<XbrlPeriod> xbrlPeriodFilteredList = new ArrayList<XbrlPeriod>();
        for (XbrlPeriod xbrlPeriod : xbrlPackagePeriodList) {
            String currentXbrlReportPath;
            if (xbrlPeriod == null || StringUtils.isBlank((CharSequence)xbrlPeriod.getFilePath())) continue;
            String filePath = currentXbrlReportPath = xbrlPeriod.getFilePath();
            if (!StringUtils.isBlank((CharSequence)currentXbrlReportPath) && !StringUtils.equals((CharSequence)currentXbrlReportPath, (CharSequence)filePath)) {
                throw new RuntimeException("\u041e\u0434\u043d\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0435 \u0441\u0440\u0430\u0432\u043d\u0435\u043d\u0438\u0435 \u043f\u0440\u043e\u0448\u043b\u044b\u0445 \u043f\u0435\u0440\u0438\u043e\u0434\u043e\u0432 \u0441 \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u0435\u043c \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u0438\u0445 \u043e\u0442\u0447\u0435\u0442\u043e\u0432 \u0432 \u0434\u0430\u043d\u043d\u044b\u0439 \u043c\u043e\u043c\u0435\u043d\u0442 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
            }
            xbrlPeriodFilteredList.add(xbrlPeriod);
        }
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        for (XbrlPeriod xbrlPeriod : xbrlPeriodFilteredList) {
            String otherXbrlInstance;
            if (this.isLastActionCanceled) {
                this.cancelCompareProcess();
            }
            if (StringUtils.isEmpty((CharSequence)(otherXbrlInstance = xbrlPeriod.getFilePath()))) continue;
            this.comparingModelProcessor.fillComparingModel(xbrlReport.getXbrlPackage(), otherXbrlInstance);
            this.calculateDifferences(xbrlReport, xbrlPeriod, xbrlPackage);
        }
        if (this.isLastActionCanceled) {
            this.cancelCompareProcess();
        }
        return new ArrayList<EventLog>();
    }

    private String extractDate(ResultSet resultSet, String startDateField, String endDateField, String instantDateField, String periodTypeField) throws SQLException {
        Date startDate = resultSet.getDate(startDateField);
        Date endDate = resultSet.getDate(endDateField);
        Date instantDate = resultSet.getDate(instantDateField);
        String periodTypeStr = resultSet.getString(periodTypeField);
        if (StringUtils.isBlank((CharSequence)periodTypeStr)) {
            return null;
        }
        PeriodType periodType = PeriodType.forValue((String)periodTypeStr);
        PeriodDates periodDates = null;
        if (periodType.equals((Object)PeriodType.INSTANT)) {
            periodDates = PeriodDates.buildInstant((java.util.Date)instantDate);
        } else if (periodType.equals((Object)PeriodType.DURATION)) {
            periodDates = PeriodDates.buildDuration((java.util.Date)startDate, (java.util.Date)endDate);
        }
        String period = periodDates.formatDate();
        return period;
    }

    private void calculateDifferences(XbrlReport xbrlReport, XbrlPeriod xbrlPeriod, XbrlPackage xbrlPackage) {
        java.util.Date end;
        RowCallbackHandler rowCallbackHandler = resultSet -> {
            if (this.isLastActionCanceled) {
                this.cancelCompareProcess();
            }
            String elementLabel = resultSet.getString("ELEMENTLABEL");
            String dimensions = resultSet.getString("DIMENSIONS");
            String currentVal = resultSet.getString("CURRENTVAL");
            String compareVal = resultSet.getString("COMPAREVAL");
            EventLog eventLog = new EventLog();
            eventLog.setEventLogType(EventLog.EventLogType.COMPARE_XBRL);
            eventLog.setPeriod(PeriodDates.from((XbrlPeriod)xbrlPeriod).formatDate());
            String period = this.extractDate(resultSet, "STARTDATE", "ENDDATE", "INSTANTDATE", "PERIODTYPE");
            if (period == null) {
                period = this.extractDate(resultSet, "COMPARESTARTDATE", "COMPAREENDDATE", "COMPAREINSTANTDATE", "COMPAREPERIODTYPE");
            }
            eventLog.setPeriod(period);
            eventLog.setConcept(elementLabel);
            eventLog.setDimensions(dimensions);
            eventLog.setCurrentValue(currentVal);
            eventLog.setCompareValue(compareVal);
            eventLog.setXbrlReportId(xbrlReport.getId());
            this.eventLogService.create(eventLog);
        };
        String query1 = "SELECT xvc.ELEMENTLABEL, xcc.DIMENSIONS, original.VALUE as \"CURRENTVAL\",  xvc.VALUE as \"COMPAREVAL\"  FROM XBRLVALUECOMP xvc\n                INNER JOIN XBRLCONTEXTCOMP xcc on xvc.XBRLCONTEXTID=xcc.CONTEXTID and ((xcc.PERIODTYPE='INSTANT' and xcc.INSTANTDATE <= :endDateInstant and xcc.INSTANTDATE >= :startDateInstant) or (xcc.PERIODTYPE='DURATION' and xcc.STARTDATE >= :startDateDuration and xcc.ENDDATE <= :endDateDuration))\n                LEFT JOIN\n                  (SELECT xv.ELEMENTLABEL, xc.DIMENSIONSHASH, xv.VALUE, xc.DIMENSIONS\n                    FROM XBRLVALUE xv\n                    INNER JOIN XBRLCONTEXT xc on xc.CONTEXTID=xv.XBRLCONTEXTID and ((xc.PERIODTYPE='INSTANT' and xc.INSTANTDATE <= :endDateInstantPkg and xc.INSTANTDATE >= :startDateInstantPkg) or (xc.PERIODTYPE='DURATION' and xc.STARTDATE >= :startDateDurationPkg and xc.ENDDATE <= :endDateDurationPkg))) as original on original.ELEMENTLABEL = xvc.ELEMENTLABEL and original.DIMENSIONSHASH = xcc.DIMENSIONSHASH\n                    where original.VALUE <> xvc.VALUE or (original.VALUE is null and xvc.VALUE is not null) or (original.VALUE is not null and xvc.VALUE is null)\n                UNION\n                SELECT original.ELEMENTLABEL, original.DIMENSIONS, original.VALUE,  xvc.VALUE  FROM XBRLVALUECOMP xvc\n                INNER JOIN XBRLCONTEXTCOMP xcc on xvc.XBRLCONTEXTID=xcc.CONTEXTID and ((xcc.PERIODTYPE='INSTANT' and xcc.INSTANTDATE <= :endDateInstant and xcc.INSTANTDATE >= :startDateInstant) or (xcc.PERIODTYPE='DURATION' and xcc.STARTDATE >= :startDateDuration and xcc.ENDDATE <= :endDateDuration))\n                RIGHT JOIN\n                  (SELECT xv.ELEMENTLABEL, xc.DIMENSIONSHASH, xv.VALUE, xc.DIMENSIONS\n                    FROM XBRLVALUE xv\n                    INNER JOIN XBRLCONTEXT xc on xc.CONTEXTID=xv.XBRLCONTEXTID and ((xc.PERIODTYPE='INSTANT' and xc.INSTANTDATE <= :endDateInstantPkg and xc.INSTANTDATE >= :startDateInstantPkg) or (xc.PERIODTYPE='DURATION' and xc.STARTDATE >= :startDateDurationPkg and xc.ENDDATE <= :endDateDurationPkg))) as original on original.ELEMENTLABEL = xvc.ELEMENTLABEL and original.DIMENSIONSHASH = xcc.DIMENSIONSHASH\n                    where original.VALUE <> xvc.VALUE or (original.VALUE is null and xvc.VALUE is not null) or (original.VALUE is not null and xvc.VALUE is null)\n";
        String instantQuery = "SELECT xvc.ELEMENTLABEL, xcc.DIMENSIONS, original.VALUE as \"CURRENTVAL\",  xvc.VALUE as \"COMPAREVAL\", xcc.STARTDATE as \"COMPARESTARTDATE\", xcc.ENDDATE as \"COMPAREENDDATE\", xcc.INSTANTDATE as \"COMPAREINSTANTDATE\", xcc.PERIODTYPE as \"COMPAREPERIODTYPE\", original.STARTDATE, original.ENDDATE, original.INSTANTDATE, original.PERIODTYPE  FROM XBRLVALUECOMP xvc \n                INNER JOIN XBRLCONTEXTCOMP xcc on xvc.XBRLCONTEXTID=xcc.CONTEXTID \n                LEFT JOIN\n                  (SELECT xv.ELEMENTLABEL, xc.DIMENSIONSHASH, xv.VALUE, xc.DIMENSIONS, xc.INSTANTDATE, xc.STARTDATE, xc.ENDDATE, xc.PERIODTYPE\n                    FROM XBRLVALUE xv\n                    INNER JOIN XBRLCONTEXT xc on xc.CONTEXTID=xv.XBRLCONTEXTID                   ) as original on original.ELEMENTLABEL = xvc.ELEMENTLABEL and original.DIMENSIONSHASH = xcc.DIMENSIONSHASH and xcc.PERIODTYPE=original.PERIODTYPE and xcc.INSTANTDATE = original.INSTANTDATE\n                WHERE original.PERIODTYPE=:INSTANT_PERIOD_TYPE and original.INSTANTDATE = :INSTANT_DATE and (original.VALUE <> xvc.VALUE or (original.VALUE is null and xvc.VALUE is not null) or (original.VALUE is not null and xvc.VALUE is null))\n              UNION\n                SELECT original.ELEMENTLABEL, original.DIMENSIONS, original.VALUE,  xvc.VALUE, xcc.STARTDATE as \"COMPARESTARTDATE\", xcc.ENDDATE as \"COMPAREENDDATE\", xcc.INSTANTDATE as \"COMPAREINSTANTDATE\", xcc.PERIODTYPE as \"COMPAREPERIODTYPE\", original.STARTDATE, original.ENDDATE, original.INSTANTDATE, original.PERIODTYPE FROM XBRLVALUECOMP xvc\n                INNER JOIN XBRLCONTEXTCOMP xcc on xvc.XBRLCONTEXTID=xcc.CONTEXTID \n                RIGHT JOIN\n                  (SELECT xv.ELEMENTLABEL, xc.DIMENSIONSHASH, xv.VALUE, xc.DIMENSIONS, xc.INSTANTDATE, xc.STARTDATE, xc.ENDDATE, xc.PERIODTYPE\n                    FROM XBRLVALUE xv\n                    INNER JOIN XBRLCONTEXT xc on xc.CONTEXTID=xv.XBRLCONTEXTID                   ) as original on original.ELEMENTLABEL = xvc.ELEMENTLABEL and original.DIMENSIONSHASH = xcc.DIMENSIONSHASH  and xcc.PERIODTYPE=original.PERIODTYPE and xcc.INSTANTDATE = original.INSTANTDATE\n              WHERE original.PERIODTYPE=:INSTANT_PERIOD_TYPE and original.INSTANTDATE = :INSTANT_DATE and (original.VALUE <> xvc.VALUE or (original.VALUE is null and xvc.VALUE is not null) or (original.VALUE is not null and xvc.VALUE is null))\n";
        String durationQuery = "SELECT xvc.ELEMENTLABEL, xcc.DIMENSIONS, original.VALUE as \"CURRENTVAL\",  xvc.VALUE as \"COMPAREVAL\", xcc.STARTDATE as \"COMPARESTARTDATE\", xcc.ENDDATE as \"COMPAREENDDATE\", xcc.INSTANTDATE as \"COMPAREINSTANTDATE\", xcc.PERIODTYPE as \"COMPAREPERIODTYPE\", original.STARTDATE, original.ENDDATE, original.INSTANTDATE, original.PERIODTYPE  FROM XBRLVALUECOMP xvc \n                INNER JOIN XBRLCONTEXTCOMP xcc on xvc.XBRLCONTEXTID=xcc.CONTEXTID \n                LEFT JOIN\n                  (SELECT xv.ELEMENTLABEL, xc.DIMENSIONSHASH, xv.VALUE, xc.DIMENSIONS, xc.INSTANTDATE, xc.STARTDATE, xc.ENDDATE, xc.PERIODTYPE\n                    FROM XBRLVALUE xv\n                    INNER JOIN XBRLCONTEXT xc on xc.CONTEXTID=xv.XBRLCONTEXTID                   ) as original on original.ELEMENTLABEL = xvc.ELEMENTLABEL and original.DIMENSIONSHASH = xcc.DIMENSIONSHASH and xcc.PERIODTYPE=original.PERIODTYPE and xcc.STARTDATE = original.STARTDATE and xcc.ENDDATE = original.ENDDATE\n                WHERE original.PERIODTYPE=:DURATION_PERIOD_TYPE and original.STARTDATE = :START_DATE and original.ENDDATE = :END_DATE and (original.VALUE <> xvc.VALUE or (original.VALUE is null and xvc.VALUE is not null) or (original.VALUE is not null and xvc.VALUE is null))\n                UNION\n                SELECT original.ELEMENTLABEL, original.DIMENSIONS, original.VALUE,  xvc.VALUE, xcc.STARTDATE as \"COMPARESTARTDATE\", xcc.ENDDATE as \"COMPAREENDDATE\", xcc.INSTANTDATE as \"COMPAREINSTANTDATE\", xcc.PERIODTYPE as \"COMPAREPERIODTYPE\", original.STARTDATE, original.ENDDATE, original.INSTANTDATE, original.PERIODTYPE FROM XBRLVALUECOMP xvc\n                INNER JOIN XBRLCONTEXTCOMP xcc on xvc.XBRLCONTEXTID=xcc.CONTEXTID \n                RIGHT JOIN\n                  (SELECT xv.ELEMENTLABEL, xc.DIMENSIONSHASH, xv.VALUE, xc.DIMENSIONS, xc.INSTANTDATE, xc.STARTDATE, xc.ENDDATE, xc.PERIODTYPE\n                    FROM XBRLVALUE xv\n                    INNER JOIN XBRLCONTEXT xc on xc.CONTEXTID=xv.XBRLCONTEXTID                   ) as original on original.ELEMENTLABEL = xvc.ELEMENTLABEL and original.DIMENSIONSHASH = xcc.DIMENSIONSHASH  and xcc.PERIODTYPE=original.PERIODTYPE and xcc.STARTDATE = original.STARTDATE and xcc.ENDDATE = original.ENDDATE\n               WHERE original.PERIODTYPE=:DURATION_PERIOD_TYPE and original.STARTDATE = :START_DATE and original.ENDDATE = :END_DATE and (original.VALUE <> xvc.VALUE or (original.VALUE is null and xvc.VALUE is not null) or (original.VALUE is not null and xvc.VALUE is null))\n";
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        java.util.Date start = xbrlPeriod.getStart();
        if (DateUtils.isSameDay((java.util.Date)start, (java.util.Date)(end = xbrlPeriod.getEnd()))) {
            namedParameters.put("INSTANT_PERIOD_TYPE", "INSTANT");
            namedParameters.put("INSTANT_DATE", start);
            this.jdbcTemplate.query(instantQuery, namedParameters, rowCallbackHandler);
            return;
        }
        namedParameters.put("DURATION_PERIOD_TYPE", "DURATION");
        namedParameters.put("START_DATE", start);
        namedParameters.put("END_DATE", end);
        this.jdbcTemplate.query(durationQuery, namedParameters, rowCallbackHandler);
        namedParameters.clear();
        namedParameters.put("INSTANT_PERIOD_TYPE", "INSTANT");
        namedParameters.put("INSTANT_DATE", start);
        this.jdbcTemplate.query(instantQuery, namedParameters, rowCallbackHandler);
        namedParameters.clear();
        namedParameters.put("INSTANT_PERIOD_TYPE", "INSTANT");
        namedParameters.put("INSTANT_DATE", end);
        this.jdbcTemplate.query(instantQuery, namedParameters, rowCallbackHandler);
    }

    private void cancelCompareProcess() {
        log.debug("Compare processing cancelled by user");
        this.isLastActionCanceled = false;
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.CANCEL, new NotificationEvent());
        throw new ActionCancelledException();
    }

    public void cancelProcessing() {
        this.isLastActionCanceled = true;
    }
}

