/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.map.SingletonMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Service;
import ru.cbr.xbrl.converter.model.XbrlDimension;
import ru.cbr.xbrl.converter.repository.XbrlDimensionRepository;
import ru.cbr.xbrl.converter.service.XbrlDimensionService;

@Service
public class XbrlDimensionServiceImpl
implements XbrlDimensionService {
    private static final Logger log = LoggerFactory.getLogger(XbrlDimensionServiceImpl.class);
    @Autowired
    private XbrlDimensionRepository xbrlDimensionRepository;
    @Autowired
    private NamedParameterJdbcTemplate jdbcTemplate;

    public XbrlDimension save(XbrlDimension xbrlDimension) {
        return (XbrlDimension)this.xbrlDimensionRepository.save((Object)xbrlDimension);
    }

    public List<XbrlDimension> findMembers(String roleSystemId, String dimint) {
        List members = this.xbrlDimensionRepository.findAllByRoleSystemIdAndDimInt(roleSystemId, dimint);
        if (CollectionUtils.isEmpty((Collection)members)) {
            return this.xbrlDimensionRepository.findAllByRoleSystemIdAndDimInt(null, dimint);
        }
        return members;
    }

    public boolean isExplicitDimension(String dimension) {
        List resultList = this.jdbcTemplate.query("select count(*) > 1 result from XbrlDimension where dimint = :dimInt", (Map)new SingletonMap((Object)"dimInt", (Object)dimension), (rs, rowNum) -> rs.getBoolean("result"));
        return (Boolean)resultList.iterator().next();
    }

    public List<XbrlDimension> findAll() {
        return this.xbrlDimensionRepository.findAll();
    }

    public String getLabelByDimInt(String dimInt) {
        return this.xbrlDimensionRepository.findFirstByDimInt(dimInt).getDimIntLabel();
    }
}

