/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import ru.cbr.xbrl.converter.arelle.ArelleOutputParser;
import ru.cbr.xbrl.converter.arelle.ArelleService;
import ru.cbr.xbrl.converter.exception.ActionCancelledException;
import ru.cbr.xbrl.converter.exception.CancelledException;
import ru.cbr.xbrl.converter.exception.CommandExecutionException;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.TaxonomyNotFoundException;
import ru.cbr.xbrl.converter.model.ValidationFormula;
import ru.cbr.xbrl.converter.model.ValidationRole;
import ru.cbr.xbrl.converter.model.XbrlFormula;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.XbrlReportValidationEvent;
import ru.cbr.xbrl.converter.model.event.NotificationEvent;
import ru.cbr.xbrl.converter.model.pkg.ContextPeriod;
import ru.cbr.xbrl.converter.model.validation.Dimension;
import ru.cbr.xbrl.converter.model.validation.ValidationEvent;
import ru.cbr.xbrl.converter.model.validation.ValidationItemRefContext;
import ru.cbr.xbrl.converter.model.xbrl_content.PeriodType;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextDimension;
import ru.cbr.xbrl.converter.model_main.Taxonomy;
import ru.cbr.xbrl.converter.service.ConceptInMemoryService;
import ru.cbr.xbrl.converter.service.DimensionsDefaultService;
import ru.cbr.xbrl.converter.service.TaxonomyService;
import ru.cbr.xbrl.converter.service.XbrlReportService;
import ru.cbr.xbrl.converter.service.XbrlRoleService;
import ru.cbr.xbrl.converter.service.XbrlValidateService;
import ru.cbr.xbrl.converter.service.event.NotificationEventService;
import ru.cbr.xbrl.converter.service.event.NotificationEventServiceImpl;
import ru.cbr.xbrl.converter.service.import_export.ExportXbrlService;
import ru.cbr.xbrl.converter.service.import_export.PeriodDates;
import ru.cbr.xbrl.converter.service.internal.XbrlReportValidationEventCrudService;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionData;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionRole;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionService;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;

@Service
public class XbrlValidateServiceImpl
implements XbrlValidateService {
    private static final Logger log = LoggerFactory.getLogger(XbrlValidateServiceImpl.class);
    @Autowired
    private ArelleService arelleService;
    @Autowired
    private SimpMessagingTemplate simpMessagingTemplate;
    @Autowired
    private XbrlReportService xbrlReportService;
    @Autowired
    private TaxonomyService taxonomyService;
    @Autowired
    private XbrlReportValidationEventCrudService xbrlReportValidationEventCrudService;
    @Autowired
    private ExportXbrlService exportXbrlService;
    @Autowired
    private NotificationEventService notificationEventService;
    @Autowired
    private XbrlRoleService xbrlRoleService;
    @Autowired
    private ConceptInMemoryService conceptInMemoryService;
    @Autowired
    private PresentationDefinitionService presentationDefinitionService;
    @Autowired
    private DimensionsDefaultService dimensionsDefaultService;
    private List<String> formulaRunIDsList = new ArrayList();
    private Queue<XbrlReportValidationEvent> eventsQueue = new ArrayBlockingQueue(10000);

    public List<ValidationEvent> validate(Long xbrlReportId) throws NotFoundException, CommandExecutionException, TaxonomyNotFoundException, CancelledException {
        return this.validateFormulas(xbrlReportId, new ArrayList());
    }

    public List<ValidationEvent> validateFormulas(Long xbrlReportId, List<String> formulaRunIDsList) throws NotFoundException, CommandExecutionException, TaxonomyNotFoundException, CancelledException {
        XbrlReport xbrlReport = this.xbrlReportService.find(xbrlReportId);
        if (this.xbrlReportService.isLastActionCanceled()) {
            this.cancelValidateProcess();
        }
        List validated = this.validate(xbrlReportId, xbrlReport.getFilePath(), formulaRunIDsList);
        if (this.xbrlReportService.isLastActionCanceled()) {
            this.cancelValidateProcess();
        }
        return validated;
    }

    public List<ValidationRole> getValidationRoles(Long xbrlReportId) throws NotFoundException {
        XbrlReport xbrlReport = this.xbrlReportService.find(xbrlReportId);
        if (this.xbrlReportService.isLastActionCanceled()) {
            this.cancelValidateProcess();
        }
        Map grpFormula = xbrlReport.getXbrlReportFormulaList().stream().filter(it -> it.getRoleId() != null).collect(Collectors.groupingBy(XbrlFormula::getRoleId, Collectors.toList()));
        ArrayList<ValidationRole> res = new ArrayList<ValidationRole>();
        xbrlReport.getXbrlReportRoles().stream().filter(it -> grpFormula.containsKey(it.getSystemId())).sorted(Comparator.comparing(XbrlReportRole::getCompareString)).forEach(r -> {
            ValidationRole vr = new ValidationRole();
            vr.setRoleId(r.getSystemId());
            vr.setRoleName(r.getTitle());
            vr.setValidationFormulas(((List)grpFormula.get(r.getSystemId())).stream().map(p -> {
                ValidationFormula v = new ValidationFormula();
                v.setId(p.getName());
                v.setLabel(p.getLabel());
                return v;
            }).collect(Collectors.toList()));
            res.add(vr);
        });
        return res;
    }

    public List<ValidationEvent> validate(Long xbrlReportId, String xbrlFullPath, List<String> formulaRunIDsList) throws NotFoundException, CommandExecutionException, TaxonomyNotFoundException {
        List validationEvents;
        Taxonomy taxonomy;
        this.eventsQueue.clear();
        XbrlReport xbrlReport = this.xbrlReportService.find(xbrlReportId);
        if (this.xbrlReportService.isLastActionCanceled()) {
            this.cancelValidateProcess();
        }
        String taxonomyVersion = xbrlReport.getXbrlPackage().getTaxonomyVersion();
        try {
            taxonomy = this.taxonomyService.findByVersion(taxonomyVersion);
        }
        catch (NotFoundException e) {
            if (this.xbrlReportService.isLastActionCanceled()) {
                this.cancelValidateProcess();
            }
            throw new TaxonomyNotFoundException();
        }
        if (this.xbrlReportService.isLastActionCanceled()) {
            this.cancelValidateProcess();
        }
        String taxonomyPath = taxonomy.getFilePath();
        String[] taxonomyPackages = new String[]{taxonomyPath};
        this.sendStartValidationEventMessage();
        this.xbrlReportValidationEventCrudService.deleteAll();
        if (this.xbrlReportService.isLastActionCanceled()) {
            this.cancelValidateProcess();
        }
        String formulaRunIDsFile = null;
        try {
            if (formulaRunIDsList.size() > 0) {
                Path path = Files.createTempFile("formula", null, new FileAttribute[0]);
                BufferedWriter f = new BufferedWriter(new FileWriter(path.toFile()));
                String formulaRunIDsListString = formulaRunIDsList.stream().collect(Collectors.joining("|"));
                f.write(formulaRunIDsListString);
                f.flush();
                f.close();
                log.info("formulaIds file:" + path.toString());
                formulaRunIDsFile = path.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            validationEvents = this.arelleService.validate(xbrlReport, xbrlFullPath, taxonomyPackages, formulaRunIDsFile);
        }
        catch (CancelledException e) {
            this.cancelValidateProcess();
            return null;
        }
        if (this.xbrlReportService.isLastActionCanceled()) {
            this.cancelValidateProcess();
        }
        for (ValidationEvent validationEvent : validationEvents) {
            if (this.xbrlReportService.isLastActionCanceled()) {
                this.cancelValidateProcess();
            }
            this.fillAspectData(xbrlReport.getXbrlPackage().getContextPeriod(), validationEvent);
            this.sendValidationEvent(xbrlReport, validationEvent);
        }
        if (this.xbrlReportService.isLastActionCanceled()) {
            this.cancelValidateProcess();
        }
        this.sendEndValidationEventMessage();
        return validationEvents;
    }

    public void fillAspectData(ContextPeriod contextPeriod, ValidationEvent validationEvent) {
        ArrayList<AspectData> aspectDataList = new ArrayList<AspectData>();
        String conceptValue = validationEvent.getConceptQName();
        AspectData conceptAspect = new AspectData();
        conceptAspect.setAspect("concept");
        conceptAspect.setAspectValue(conceptValue);
        conceptAspect.setType(AspectType.CONCEPT);
        aspectDataList.add(conceptAspect);
        PeriodType periodType = this.conceptInMemoryService.findPeriodTypeByConcept(conceptValue);
        if (validationEvent.getValidationItemRefContext() == null) {
            validationEvent.setValidationItemRefContext(new ValidationItemRefContext());
        }
        if (StringUtils.isBlank((CharSequence)validationEvent.getValidationItemRefContext().getStartDate()) && StringUtils.isBlank((CharSequence)validationEvent.getValidationItemRefContext().getEndDate()) && StringUtils.isBlank((CharSequence)validationEvent.getValidationItemRefContext().getInstant())) {
            PeriodDates periodDates = null;
            if (periodType == PeriodType.INSTANT) {
                periodDates = PeriodDates.buildInstant((Date)contextPeriod.getEndDate());
                validationEvent.getValidationItemRefContext().setInstant(PeriodDates.formatDate((Date)periodDates.getInstantDate()));
            } else {
                periodDates = PeriodDates.buildDuration((Date)contextPeriod.getStartDate(), (Date)contextPeriod.getEndDate());
                validationEvent.getValidationItemRefContext().setStartDate(PeriodDates.formatDate((Date)periodDates.getStartDate()));
                validationEvent.getValidationItemRefContext().setEndDate(PeriodDates.formatDate((Date)periodDates.getEndDate()));
            }
            ValidationItemRefContext contextRef = validationEvent.getValidationItemRefContext();
            if (contextRef == null) {
                return;
            }
            String instant = contextRef.getInstant();
            if (!StringUtils.contains((CharSequence)validationEvent.getId(), (CharSequence)"existenceAssertion")) {
                if (StringUtils.isNotBlank((CharSequence)instant)) {
                    validationEvent.setPeriodStart(instant);
                } else {
                    validationEvent.setPeriodStart(contextRef.getStartDate());
                    validationEvent.setPeriodStop(contextRef.getEndDate());
                }
            }
        }
        String startDate = validationEvent.getValidationItemRefContext().getStartDate();
        String endDate = validationEvent.getValidationItemRefContext().getEndDate();
        String instantDate = validationEvent.getValidationItemRefContext().getInstant();
        PeriodDates periodDates = null;
        if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
            String durationDate = startDate + " - " + endDate;
            periodDates = new PeriodDates(durationDate);
        } else if (StringUtils.isNotBlank((CharSequence)instantDate)) {
            periodDates = new PeriodDates(instantDate);
        }
        AspectData periodAspect = periodDates.buildAspectData();
        aspectDataList.add(periodAspect);
        List dimensions = validationEvent.getValidationItemRefContext().getDimensions();
        List xbrlContextDimensions = dimensions.stream().map(arg_0 -> this.buildContextDimension(arg_0)).collect(Collectors.toList());
        List dimensionAspects = xbrlContextDimensions.stream().map(XbrlContextDimension::toAspectData).collect(Collectors.toList());
        dimensionAspects = XbrlContextDimension.removeDefaultDimensions(dimensionAspects, (Map)this.dimensionsDefaultService.getDimensionsDefault());
        aspectDataList.addAll(dimensionAspects);
        validationEvent.getItemDescriptionList().stream().forEach(validationEvent1 -> this.fillAspectData(contextPeriod, validationEvent1));
        String dimensionsLabel = this.presentationDefinitionService.buildDimensionsLabel(xbrlContextDimensions);
        validationEvent.setSection(dimensionsLabel);
        Set pdRoles = this.xbrlRoleService.getPdRoleMap().findRoles(aspectDataList);
        Set tableRoles = this.xbrlRoleService.getTlbRoleMap().findRoles(aspectDataList);
        validationEvent.setTableRoles(tableRoles);
        validationEvent.setPresentationDefinitionRoles(pdRoles);
        validationEvent.setAspectDataList(aspectDataList);
        if (!CollectionUtils.isEmpty((Collection)pdRoles)) {
            ArrayList pdRolesTitle = new ArrayList();
            pdRoles.forEach(pdRoleId -> {
                PresentationDefinitionData pdData = this.presentationDefinitionService.getPresentationDefinitionData();
                PresentationDefinitionRole pdRole = (PresentationDefinitionRole)pdData.getRoleMap().get(DigestUtils.md5Hex((String)pdRoleId));
                if (pdRole != null) {
                    pdRolesTitle.add(pdRole.getTitle());
                }
            });
            validationEvent.setPreHeader(pdRolesTitle.stream().collect(Collectors.joining(", ")));
        }
        if (!CollectionUtils.isEmpty((Collection)tableRoles)) {
            ArrayList tableRolesTitle = new ArrayList();
            tableRoles.forEach(tableRoleId -> {
                try {
                    XbrlReportRole tableRole = this.xbrlReportService.findReportRoleBySystemId(tableRoleId);
                    if (tableRole != null) {
                        tableRolesTitle.add(tableRole.getTitle());
                    }
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
            });
            validationEvent.setTableHeader(tableRolesTitle.stream().collect(Collectors.joining(", ")));
        }
    }

    private XbrlContextDimension buildContextDimension(Dimension parsedDimension) {
        String member = parsedDimension.getMember();
        if (StringUtils.contains((CharSequence)member, (CharSequence)"<")) {
            Document doc;
            DocumentBuilder dBuilder;
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            try {
                dBuilder = dbFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                log.error("\u0420\u0430\u0437\u0431\u043e\u0440 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438. \u041e\u0448\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044f \u043e\u0442\u043a\u0440\u044b\u0442\u043e\u0439 \u043e\u0441\u0438 {}.", (Object)member);
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
                return new XbrlContextDimension(parsedDimension.getDimension(), parsedDimension.getMember());
            }
            if (dBuilder == null) {
                return new XbrlContextDimension(parsedDimension.getDimension(), parsedDimension.getMember());
            }
            try {
                doc = dBuilder.parse(new ByteArrayInputStream(IOUtils.toByteArray((Reader)new StringReader(member))));
            }
            catch (IOException | SAXException e) {
                log.error("\u0420\u0430\u0437\u0431\u043e\u0440 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438. \u041e\u0448\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044f \u043e\u0442\u043a\u0440\u044b\u0442\u043e\u0439 \u043e\u0441\u0438 {}.", (Object)member);
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
                return new XbrlContextDimension(parsedDimension.getDimension(), parsedDimension.getMember());
            }
            if (doc == null) {
                return new XbrlContextDimension(parsedDimension.getDimension(), parsedDimension.getMember());
            }
            Element documentElement = doc.getDocumentElement();
            if (documentElement == null) {
                return new XbrlContextDimension(parsedDimension.getDimension(), parsedDimension.getMember());
            }
            return new XbrlContextDimension(parsedDimension.getDimension(), documentElement.getTagName(), documentElement.getTextContent());
        }
        return new XbrlContextDimension(parsedDimension.getDimension(), parsedDimension.getMember());
    }

    public void cancelValidation() {
        this.arelleService.killCurrentArelleProcess();
    }

    public void sendValidationEvent(XbrlReport xbrlReport, ValidationEvent validationEvent) {
        try {
            XbrlReportValidationEvent xbrlReportValidationEvent = new XbrlReportValidationEvent(validationEvent);
            xbrlReportValidationEvent.setXbrlReport(xbrlReport);
            this.xbrlReportValidationEventCrudService.create(xbrlReportValidationEvent);
            log.info(xbrlReportValidationEvent.getType());
            log.info("add event:" + validationEvent.getType() + " " + validationEvent.getTableHeader() + " " + validationEvent.getMessage());
            this.eventsQueue.add(xbrlReportValidationEvent);
        }
        catch (JsonProcessingException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public List<XbrlReportValidationEvent> getValidationEvent() {
        ArrayList<XbrlReportValidationEvent> result = new ArrayList<XbrlReportValidationEvent>();
        for (int i = 0; i < 10 && !this.eventsQueue.isEmpty(); ++i) {
            result.add((XbrlReportValidationEvent)this.eventsQueue.poll());
            log.info(">>>>>" + ((XbrlReportValidationEvent)result.get(result.size() - 1)).getType());
        }
        if (result.size() > 0) {
            log.info("getValidationEvent:" + result.size());
            log.info("getValidationEvent:>queue:" + this.eventsQueue.size());
        }
        return result;
    }

    private void sendStartValidationEventMessage() {
        this.simpMessagingTemplate.convertAndSend((Object)"/topic/validation-started", (Object)"");
    }

    private void sendEndValidationEventMessage() {
        this.simpMessagingTemplate.convertAndSend((Object)"/topic/validation-ended", (Object)"");
    }

    public void cancelValidateProcess() {
        log.debug("Report processing cancelled by user");
        this.xbrlReportService.setLastActionCanceled(false);
        ArelleOutputParser.setIsLastActionCancelled((Boolean)false);
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.CANCEL, new NotificationEvent());
        throw new ActionCancelledException();
    }
}

