/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.import_export;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Currency;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.exception.CellDataValidationException;
import ru.cbr.xbrl.converter.model.tableLinkBase.EnumerateItem;

/*
 * Exception performing whole class analysis ignored.
 */
public class CellValidator {
    private static Set<String> EXCLUDED_CURRENCIES = new HashSet<String>(Collections.singletonList("RUR"));
    private static Set<String> AVAILABLE_CURRENCIES = Currency.getAvailableCurrencies().stream().map(Currency::getCurrencyCode).filter(c -> !EXCLUDED_CURRENCIES.contains(c)).collect(Collectors.toSet());

    public static boolean validateSafe(String cellData, String xsdType) {
        try {
            CellValidator.validate((String)cellData, (String)xsdType);
            return true;
        }
        catch (CellDataValidationException e) {
            return false;
        }
    }

    public static void validate(String cellData, String xsdType) throws CellDataValidationException {
        if (xsdType == null) {
            return;
        }
        switch (xsdType) {
            case "integer": {
                CellValidator.validateInteger((String)cellData);
                break;
            }
            case "decimal": {
                CellValidator.validateDecimal((String)cellData);
                break;
            }
            case "date": {
                CellValidator.validateDate((String)cellData);
            }
        }
    }

    private static void validateDate(String cellData) {
        if (StringUtils.isBlank((CharSequence)cellData)) {
            return;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        df.setLenient(false);
        try {
            df.parse(cellData);
        }
        catch (ParseException e) {
            throw new CellDataValidationException();
        }
    }

    private static void validateDecimal(String cellData) throws CellDataValidationException {
        if (!cellData.matches("(\\+|-)?([0-9]+(\\.[0-9]*)?|\\.[0-9]+)")) {
            throw new CellDataValidationException();
        }
    }

    private static void validateInteger(String cellData) throws CellDataValidationException {
        if (!cellData.matches("^(-)?\\d+$")) {
            throw new CellDataValidationException();
        }
        try {
            Integer.parseInt(cellData);
        }
        catch (NumberFormatException e) {
            throw new CellDataValidationException();
        }
    }

    public static boolean validatePattern(String cellValue, String regex) {
        if (StringUtils.isBlank((CharSequence)regex)) {
            return true;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(cellValue);
        return matcher.matches();
    }

    public static boolean validateEnumerations(Map<String, List<EnumerateItem>> enumerationsMap, String conceptId, String value) {
        if (CollectionUtils.isEmpty(enumerationsMap)) {
            return true;
        }
        List<EnumerateItem> enumerateItems = enumerationsMap.get(conceptId);
        if (CollectionUtils.isEmpty(enumerateItems)) {
            return true;
        }
        for (EnumerateItem enumerateItem : enumerateItems) {
            if (enumerateItem == null || !StringUtils.equals((CharSequence)enumerateItem.getMember(), (CharSequence)value)) continue;
            return true;
        }
        return false;
    }

    public static boolean validateUnitContent(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return true;
        }
        String[] measureParts = StringUtils.split((String)value, (String)":");
        if (measureParts.length != 2) {
            return false;
        }
        String measureCode = measureParts[1].toUpperCase();
        if (StringUtils.equals((CharSequence)measureParts[0], (CharSequence)"iso4217") && AVAILABLE_CURRENCIES.contains(measureCode)) {
            return true;
        }
        if (StringUtils.equals((CharSequence)measureParts[0], (CharSequence)"xbrli")) {
            return StringUtils.equalsIgnoreCase((CharSequence)measureParts[1], (CharSequence)"SHARES") || StringUtils.equalsIgnoreCase((CharSequence)measureParts[1], (CharSequence)"PURE");
        }
        return false;
    }

    private CellValidator() {
    }
}

