/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.import_export;

import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import ru.cbr.xbrl.converter.model.XbrlPeriod;
import ru.cbr.xbrl.converter.model.xbrl_content.PeriodType;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;

public class PeriodDates
implements Comparable<PeriodDates> {
    public static String delimiter = " - ";
    private static DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private Date startDate;
    private Date endDate;
    private Date instantDate;
    private PeriodType periodType;

    public PeriodDates(String dateString) {
        if (StringUtils.isNotBlank((CharSequence)dateString)) {
            if (dateString.matches("^\\d{4}-\\d{2}-\\d{2}" + delimiter + "\\d{4}-\\d{2}-\\d{2}$")) {
                String startDateString = dateString.substring(0, 10);
                this.startDate = this.parseDate(startDateString);
                String endDateString = dateString.substring(13, 23);
                this.endDate = this.parseDate(endDateString);
                this.periodType = PeriodType.DURATION;
            } else if (dateString.matches("^\\d{4}-\\d{2}-\\d{2}" + delimiter + "\\d{4}-\\d{2}-\\d{2}-instant")) {
                String endDateString = dateString.substring(13, 23);
                this.instantDate = this.parseDate(endDateString);
                this.periodType = PeriodType.INSTANT;
            } else if (dateString.matches("^\\d{4}-\\d{2}-\\d{2}.*")) {
                this.instantDate = this.parseDate(dateString.substring(0, 10));
                this.periodType = PeriodType.INSTANT;
            } else {
                boolean bl = true;
            }
        }
    }

    public String formatDate() {
        if (this.periodType == PeriodType.INSTANT) {
            DateTime instant = new DateTime((Object)this.instantDate);
            return formatter.print((ReadableInstant)instant);
        }
        DateTime start = new DateTime((Object)this.startDate);
        DateTime end = new DateTime((Object)this.endDate);
        return formatter.print((ReadableInstant)start) + delimiter + formatter.print((ReadableInstant)end);
    }

    public static String formatDate(Date date) {
        DateTime dateTime = new DateTime((Object)date);
        return formatter.print((ReadableInstant)dateTime);
    }

    public Date parseDate(String dateString) {
        DateTime dt = formatter.parseDateTime(dateString);
        return dt.toDate();
    }

    public static PeriodDates buildInstant(Date instantDate) {
        PeriodDates periodDates = new PeriodDates();
        periodDates.setInstantDate(instantDate);
        periodDates.setPeriodType(PeriodType.INSTANT);
        return periodDates;
    }

    public static PeriodDates buildDuration(Date startDate, Date endDate) {
        PeriodDates periodDates = new PeriodDates();
        periodDates.setStartDate(startDate);
        periodDates.setEndDate(endDate);
        periodDates.setPeriodType(PeriodType.DURATION);
        return periodDates;
    }

    public static PeriodDates from(XbrlPeriod xbrlPeriod) {
        PeriodDates periodDates = new PeriodDates();
        if (xbrlPeriod.getStart() != null && xbrlPeriod.getEnd() != null) {
            periodDates.startDate = xbrlPeriod.getStart();
            periodDates.endDate = xbrlPeriod.getEnd();
            periodDates.periodType = PeriodType.DURATION;
            return periodDates;
        }
        if (xbrlPeriod.getEnd() == null) {
            periodDates.instantDate = xbrlPeriod.getStart();
            periodDates.periodType = PeriodType.INSTANT;
            return periodDates;
        }
        throw new IllegalStateException();
    }

    public PeriodDates toInstant() {
        if (this.periodType == PeriodType.DURATION) {
            this.periodType = PeriodType.INSTANT;
            this.instantDate = this.endDate;
            this.endDate = null;
            this.startDate = null;
        }
        return this;
    }

    public AspectData buildAspectData() {
        AspectData aspectData = new AspectData();
        aspectData.setAspect("period");
        aspectData.setType(AspectType.PERIOD);
        aspectData.setAspectValue(this.formatDate());
        return aspectData;
    }

    public static boolean skipDefaultPeriod(List<Pair<String, String>> periods, String defaultPeriod, String period) {
        if (defaultPeriod != null && defaultPeriod.equals(period)) {
            String[] splitDefaultPeriod = defaultPeriod.split(delimiter);
            for (Pair<String, String> stringStringPair : periods) {
                String[] split = ((String)stringStringPair.getKey()).split(delimiter);
                if (((String)stringStringPair.getKey()).equals(defaultPeriod) || !splitDefaultPeriod[1].equals(split[1])) continue;
                return true;
            }
        }
        return false;
    }

    public void moveInstantDateOneDayAgo() {
        this.instantDate = DateUtils.addDays((Date)this.instantDate, (int)-1);
    }

    @Override
    public int compareTo(PeriodDates other) {
        Comparator<PeriodDates> comparator = Comparator.comparing(PeriodDates::getPeriodType).thenComparing(Comparator.comparing(PeriodDates::getInstantDate)).thenComparing(Comparator.comparing(PeriodDates::getStartDate)).thenComparing(Comparator.comparing(PeriodDates::getEndDate));
        return comparator.compare(this, other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PeriodDates)) {
            return false;
        }
        PeriodDates that = (PeriodDates)o;
        if (this.startDate != null && that.startDate == null || this.startDate == null && that.startDate != null || this.startDate != null && !DateUtils.isSameDay((Date)this.startDate, (Date)that.startDate)) {
            return false;
        }
        if (this.endDate != null && that.endDate == null || this.endDate == null && that.endDate != null || this.endDate != null && !DateUtils.isSameDay((Date)this.endDate, (Date)that.endDate)) {
            return false;
        }
        if (this.instantDate != null && that.instantDate == null || this.instantDate == null && that.instantDate != null || this.instantDate != null && !DateUtils.isSameDay((Date)this.instantDate, (Date)that.instantDate)) {
            return false;
        }
        return this.periodType == that.periodType;
    }

    public int hashCode() {
        int result = this.startDate != null ? this.startDate.hashCode() : 0;
        result = 31 * result + (this.endDate != null ? this.endDate.hashCode() : 0);
        result = 31 * result + (this.instantDate != null ? this.instantDate.hashCode() : 0);
        result = 31 * result + (this.periodType != null ? this.periodType.hashCode() : 0);
        return result;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Date getInstantDate() {
        return this.instantDate;
    }

    public PeriodType getPeriodType() {
        return this.periodType;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public void setInstantDate(Date instantDate) {
        this.instantDate = instantDate;
    }

    public void setPeriodType(PeriodType periodType) {
        this.periodType = periodType;
    }

    public String toString() {
        return "PeriodDates(startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ", instantDate=" + this.getInstantDate() + ", periodType=" + this.getPeriodType() + ")";
    }

    public PeriodDates() {
    }
}

