/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.import_export;

import java.beans.ConstructorProperties;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.XbrlExportException;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.interaction.ImportProcess;
import ru.cbr.xbrl.converter.model.interaction.ImportProcessStatus;
import ru.cbr.xbrl.converter.model.log.EventLog;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.model.validation.ValidationEvent;
import ru.cbr.xbrl.converter.repository.ImportProcessRepository;
import ru.cbr.xbrl.converter.service.XbrlPackageService;
import ru.cbr.xbrl.converter.service.XbrlValidateService;
import ru.cbr.xbrl.converter.service.import_export.ExportXbrlService;
import ru.cbr.xbrl.converter.service.import_export.ImportProcessInfoService;
import ru.cbr.xbrl.converter.service.import_export.ImportXbrlService;
import ru.cbr.xbrl.converter.service.import_export.TemporaryFileService;
import ru.cbr.xbrl.converter.service.log.EventLogService;

@Service
public class TaskExecutor {
    private static final Logger log = LoggerFactory.getLogger(TaskExecutor.class);
    private final ImportProcessRepository importProcessRepository;
    private final ImportProcessInfoService importProcessInfoService;
    private final XbrlPackageService xbrlPackageService;
    private final ImportXbrlService importXbrlService;
    private final ExportXbrlService exportXbrlService;
    private final EventLogService eventLogService;
    private final XbrlValidateService xbrlValidateService;
    private final TemporaryFileService temporaryFileService;
    private static final String PERIOD_START = "Period Start";
    private static final String PERIOD_END = "Period End";
    private static final String IDENTIFIER = "Identifier";
    private static final String TEMP_FOLDER = "packages";
    private DataFormatter formatter = new DataFormatter();
    private String pointOfEntry;
    private String periodStart;
    private String periodEnd;
    private String ogrn;

    @Scheduled(fixedRate=5000L)
    @Transactional(value="cacheTransactionManager")
    public void runTask() {
        List importProcessList;
        List inProgressProcesses = this.importProcessRepository.findByStatusOrderById(ImportProcessStatus.IN_PROGRESS);
        int tasksInProgress = inProgressProcesses.size();
        if (tasksInProgress < 1 && CollectionUtils.isNotEmpty((Collection)(importProcessList = this.importProcessRepository.findByStatusOrderById(ImportProcessStatus.NEW)))) {
            int amountForRun = 1 - tasksInProgress;
            int newTasks = importProcessList.size();
            if (newTasks < amountForRun) {
                amountForRun = newTasks;
            }
            for (int i = 0; i < amountForRun; ++i) {
                ImportProcess importProcess = (ImportProcess)importProcessList.get(i);
                importProcess.setStatus(ImportProcessStatus.IN_PROGRESS);
                ImportProcess savedProcess = (ImportProcess)this.importProcessRepository.save((Object)importProcess);
                this.runImportTask(savedProcess);
            }
        }
    }

    private void runImportTask(ImportProcess importProcess) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        File excel = new File(importProcess.getFilePath());
        String fileName = importProcess.getFileName();
        String versionTaxonomy = importProcess.getTaxonomyVersion();
        executorService.submit(() -> this.exportTask(excel, fileName, versionTaxonomy, importProcess));
    }

    @Transactional(value="cacheTransactionManager")
    public void exportTask(File excel, String fileName, String versionTaxonomy, ImportProcess importProcess) {
        XbrlPackage xbrlPackage = null;
        try {
            this.importProcessInfoService.addMappingProcessSuccess("\u0417\u0430\u043f\u0443\u0449\u0435\u043d \u043f\u0440\u043e\u0446\u0435\u0441\u0441 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f XBRL-\u043f\u0430\u043a\u0435\u0442\u0430 \u0434\u043b\u044f \u0448\u0430\u0431\u043b\u043e\u043d\u0430: \"" + fileName + "\"", null, importProcess);
            xbrlPackage = this.parseExcel(excel);
            xbrlPackage.setTaxonomyVersion(versionTaxonomy);
            String tempName = fileName.substring(0, fileName.lastIndexOf(46)) + "_" + System.currentTimeMillis() + fileName.substring(fileName.lastIndexOf(46));
            xbrlPackage.setName(tempName);
            String localPath = this.getPathForPackage();
            xbrlPackage.setPathForPackage(localPath);
            Date start = new Date();
            xbrlPackage = this.xbrlPackageService.create(xbrlPackage);
            this.importProcessInfoService.addMappingProcessSuccess("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 XBRL-\u043f\u0430\u043a\u0435\u0442\u0430 \u043d\u0430 \u043e\u0441\u043d\u043e\u0432\u0435 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u0432 \u043e\u0442\u0447\u0435\u0442\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e \u0434\u043b\u044f \u0448\u0430\u0431\u043b\u043e\u043d\u0430: \"" + fileName + "\"", null, importProcess);
            log.info("Create XBRL complete in " + (new Date().getTime() - start.getTime()) + " msec. ");
            start = new Date();
            this.xbrlPackageService.save(xbrlPackage.getId());
            log.info("Save XBRL complete in " + (new Date().getTime() - start.getTime()) + " msec. ");
            start = new Date();
            this.importProcessInfoService.addMappingProcessSuccess("\u0417\u0430\u043f\u0443\u0449\u0435\u043d \u043f\u0440\u043e\u0446\u0435\u0441\u0441 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0438\u0437 \u0448\u0430\u0431\u043b\u043e\u043d\u0430: \"" + fileName + "\"", null, importProcess);
            xbrlPackage = this.importXbrlService.importXlsxAndRefreshView(xbrlPackage.getId(), excel.getAbsolutePath(), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)).getXbrlPackage();
            this.importProcessInfoService.addMappingProcessSuccess("\u041f\u0440\u043e\u0446\u0435\u0441\u0441 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0438\u0437 \u0448\u0430\u0431\u043b\u043e\u043d\u0430: \"" + fileName + "\" \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d", null, importProcess);
            this.importProcessInfoService.addMappingProcessSuccess("\u0417\u0430\u043f\u0443\u0449\u0435\u043d \u043f\u0440\u043e\u0446\u0435\u0441\u0441 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438\u0438 \u043f\u043e\u0441\u043b\u0435 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0438\u0437 \u0448\u0430\u0431\u043b\u043e\u043d\u0430: \"" + fileName + "\"", null, importProcess);
            log.info("Import Excel XBRL complete in " + (new Date().getTime() - start.getTime()) + " msec. ");
            List events = this.xbrlValidateService.validate(xbrlPackage.getXbrlReport().getId());
            this.addValidationToConverterResponseData(events, importProcess);
            this.importProcessInfoService.addMappingProcessSuccess("\u041f\u0440\u043e\u0446\u0435\u0441\u0441 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438\u0438 \u043f\u043e\u0441\u043b\u0435 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0438\u0437 \u0448\u0430\u0431\u043b\u043e\u043d\u0430: \"" + fileName + "\" \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d", null, importProcess);
            this.importProcessInfoService.addMappingProcessSuccess("\u0417\u0430\u043f\u0443\u0449\u0435\u043d \u043f\u0440\u043e\u0446\u0435\u0441\u0441 \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430 XBRL \u0434\u043b\u044f \u0448\u0430\u0431\u043b\u043e\u043d\u0430: \"" + fileName + "\"", null, importProcess);
            String fullPath = FilenameUtils.concat((String)localPath, (String)xbrlPackage.generateXbrlZipName("XBRL", "xml"));
            this.exportXbrlXml(xbrlPackage, fullPath);
            File pack = new File(xbrlPackage.getPathForPackage() + File.separator + xbrlPackage.getName() + '.' + "ank");
            File xbrl = new File(fullPath);
            this.temporaryFileService.deleteTemporaryFile(pack);
            this.temporaryFileService.deleteTemporaryFile(excel);
            this.xbrlPackageService.close(xbrlPackage.getId());
            this.importProcessInfoService.addMappingProcessFinished("\u041f\u0440\u043e\u0446\u0435\u0441\u0441 \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430 XBRL \u0434\u043b\u044f \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \"" + fileName + "\" \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d", null, importProcess);
            importProcess.setStatus(ImportProcessStatus.SUCCESS);
            importProcess.setXbrlPath(xbrl.getAbsolutePath());
            this.importProcessRepository.save((Object)importProcess);
        }
        catch (Exception ex) {
            log.error("getXbrlFromExcel: ", (Throwable)ex);
            if (xbrlPackage != null) {
                try {
                    this.addLogsToConverterResponseData(importProcess, xbrlPackage, ex.getMessage());
                }
                catch (NotFoundException e) {
                    log.error("task executor", (Throwable)e);
                }
            } else {
                this.importProcessInfoService.addMappingProcessException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u043e \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u0432 \u0441\u0435\u0440\u0432\u0438\u0441\u0435 \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0430\u0446\u0438\u0438", ex.getMessage(), importProcess);
            }
            importProcess.setStatus(ImportProcessStatus.FAIL);
            this.importProcessRepository.save((Object)importProcess);
        }
    }

    private void exportXbrlXml(XbrlPackage xbrlPackage, String fullPath) throws XbrlExportException {
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(fullPath));){
            this.exportXbrlService.exportXbrlXml(xbrlPackage, (OutputStream)outputStream, Boolean.valueOf(true));
        }
        catch (FileNotFoundException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new XbrlExportException();
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new XbrlExportException();
        }
        catch (NotFoundException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new XbrlExportException();
        }
    }

    /*
     * Exception decompiling
     */
    private XbrlPackage parseExcel(File excel) throws IOException, ParseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isIncludedRow(Row row) {
        int rowIndex = row.getRowNum();
        return rowIndex < 8;
    }

    private boolean isIncludedCell(Cell cell) {
        return cell.getColumnIndex() == 0;
    }

    private void analyzeRow(Row row) {
        Iterator cellIterator = row.cellIterator();
        cellIterator.forEachRemaining(cell -> {
            if (this.isIncludedCell(cell)) {
                this.analyzeCell(cell, row);
            }
        });
    }

    private void analyzeCell(Cell cell, Row row) {
        if (cell.getRowIndex() == 0) {
            this.pointOfEntry = this.formatter.formatCellValue(cell).trim();
        } else {
            String formattedValue = this.formatter.formatCellValue(cell).trim();
            Cell cellValue = row.getCell(cell.getColumnIndex() + 1);
            if (cellValue != null) {
                String value = this.formatter.formatCellValue(cellValue);
                switch (formattedValue) {
                    case "Period Start": {
                        this.periodStart = value;
                        break;
                    }
                    case "Period End": {
                        this.periodEnd = value;
                        break;
                    }
                    case "Identifier": {
                        this.ogrn = value;
                        break;
                    }
                }
            }
        }
    }

    private String getPathForPackage() {
        String tempPath = System.getProperty("java.io.tmpdir") + TEMP_FOLDER;
        File theDir = new File(tempPath);
        if (!theDir.exists()) {
            theDir.mkdir();
        }
        return tempPath;
    }

    private void addLogsToConverterResponseData(ImportProcess importProcess, XbrlPackage xbrlPackage, String exception) throws NotFoundException {
        String logs = "";
        if (xbrlPackage != null) {
            try {
                XbrlReport report = xbrlPackage.getXbrlReport();
                if (report != null) {
                    List events = this.eventLogService.findAll(report.getId(), EventLog.EventLogType.IMPORT_XLSX);
                    for (EventLog event : events) {
                        logs = logs + event.getMessage() + " \u043d\u0430 \u043b\u0438\u0441\u0442\u0435: \"" + event.getRole() + "\" \u0432 \u044f\u0447\u0435\u0439\u043a\u0435: \"" + event.getAddress() + "\"\r\n";
                    }
                }
            }
            catch (Exception ex) {
                log.error("addLogsToConverter", (Throwable)ex);
            }
        }
        if (exception != null) {
            logs = logs + "\r\n" + exception;
        }
        this.importProcessInfoService.addMappingProcessException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u043e \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u0432 \u0441\u0435\u0440\u0432\u0438\u0441\u0435 \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0430\u0446\u0438\u0438", logs, importProcess);
    }

    private void addValidationToConverterResponseData(List<ValidationEvent> events, ImportProcess importProcess) {
        String warnings = events.stream().map(ValidationEvent::getMessage).collect(Collectors.joining("\r\n"));
        if (StringUtils.isNotEmpty((CharSequence)warnings)) {
            this.importProcessInfoService.addMappingProcessWarn("\u0418\u043c\u0435\u044e\u0442\u0441\u044f \u043e\u0448\u0438\u0431\u043a\u0438 \u043f\u0440\u0438 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438 \u043f\u0430\u043a\u0435\u0442\u0430 \u043f\u043e\u0441\u043b\u0435 \u0438\u043c\u043f\u043e\u0440\u0442\u0430", warnings, importProcess);
        }
    }

    @ConstructorProperties(value={"importProcessRepository", "importProcessInfoService", "xbrlPackageService", "importXbrlService", "exportXbrlService", "eventLogService", "xbrlValidateService", "temporaryFileService"})
    public TaskExecutor(ImportProcessRepository importProcessRepository, ImportProcessInfoService importProcessInfoService, XbrlPackageService xbrlPackageService, ImportXbrlService importXbrlService, ExportXbrlService exportXbrlService, EventLogService eventLogService, XbrlValidateService xbrlValidateService, TemporaryFileService temporaryFileService) {
        this.importProcessRepository = importProcessRepository;
        this.importProcessInfoService = importProcessInfoService;
        this.xbrlPackageService = xbrlPackageService;
        this.importXbrlService = importXbrlService;
        this.exportXbrlService = exportXbrlService;
        this.eventLogService = eventLogService;
        this.xbrlValidateService = xbrlValidateService;
        this.temporaryFileService = temporaryFileService;
    }

    private /* synthetic */ void lambda$parseExcel$1(Row row) {
        if (this.isIncludedRow(row)) {
            this.analyzeRow(row);
        }
    }
}

