/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.import_export;

import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import ru.cbr.xbrl.converter.exception.ImportProcessNotFoundException;
import ru.cbr.xbrl.converter.model.interaction.ConverterResponseData;
import ru.cbr.xbrl.converter.model.interaction.ImportProcess;
import ru.cbr.xbrl.converter.model.interaction.ImportProcessInfo;
import ru.cbr.xbrl.converter.model.interaction.ImportProcessStatus;
import ru.cbr.xbrl.converter.model.interaction.IntegrationServiceResponse;
import ru.cbr.xbrl.converter.repository.ImportProcessRepository;
import ru.cbr.xbrl.converter.service.XbrlPackageService;
import ru.cbr.xbrl.converter.service.XbrlValidateService;
import ru.cbr.xbrl.converter.service.import_export.ExportXbrlService;
import ru.cbr.xbrl.converter.service.import_export.ImportProcessInfoService;
import ru.cbr.xbrl.converter.service.import_export.ImportXbrlService;
import ru.cbr.xbrl.converter.service.import_export.TemporaryFileService;
import ru.cbr.xbrl.converter.service.import_export.XbrlManagerService;
import ru.cbr.xbrl.converter.service.log.EventLogService;

@Service
public class XbrlManagerServiceImpl
implements XbrlManagerService {
    private static final Logger log = LoggerFactory.getLogger(XbrlManagerServiceImpl.class);
    private final TemporaryFileService temporaryFileService;
    private final ImportProcessRepository importProcessRepository;
    private final ImportProcessInfoService importProcessInfoService;
    private final XbrlPackageService xbrlPackageService;
    private final ImportXbrlService importXbrlService;
    private final ExportXbrlService exportXbrlService;
    private final EventLogService eventLogService;
    private final XbrlValidateService xbrlValidateService;

    @Transactional(value="cacheTransactionManager")
    public Long createProcess(MultipartFile file, String versionTaxonomy, String fileName) {
        File excel = this.temporaryFileService.saveTemporaryFile(file);
        ImportProcess importProcess = new ImportProcess();
        importProcess.setFilePath(excel.getAbsolutePath());
        importProcess.setFileName(fileName);
        importProcess.setStatus(ImportProcessStatus.NEW);
        importProcess.setTaxonomyVersion(versionTaxonomy);
        ImportProcess savedProcess = (ImportProcess)this.importProcessRepository.save((Object)importProcess);
        this.importProcessInfoService.addMappingProcessSuccess("\u0424\u0430\u0439\u043b " + fileName + " \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u044c \u043d\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 xbrl", null, savedProcess);
        return savedProcess.getId();
    }

    @Transactional(value="cacheTransactionManager")
    public List<IntegrationServiceResponse> processInfo(Long importProcessId) {
        ImportProcess importProcess = (ImportProcess)this.importProcessRepository.findOne((Serializable)importProcessId);
        if (importProcess != null) {
            return importProcess.getInfos().stream().map(ImportProcessInfo::toResponse).collect(Collectors.toList());
        }
        throw new ImportProcessNotFoundException("\u041f\u0440\u043e\u0446\u0435\u0441\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0434\u043b\u044f id: " + importProcessId);
    }

    public ConverterResponseData downloadReport(Long importProcessId) throws IOException {
        File file;
        ImportProcess importProcess = (ImportProcess)this.importProcessRepository.findOne((Serializable)importProcessId);
        String tempName = importProcess.getFileName();
        ConverterResponseData responseData = new ConverterResponseData();
        if (importProcess != null && (file = new File(importProcess.getXbrlPath())).exists()) {
            responseData = this.addFileToResponseData(file, tempName.substring(0, tempName.lastIndexOf(46)));
        }
        return responseData;
    }

    public void deleteProcess(Long importProcessId) throws IOException {
        ImportProcess importProcess;
        if (importProcessId != null && (importProcess = (ImportProcess)this.importProcessRepository.findOne((Serializable)importProcessId)) != null) {
            File xbrl;
            File file;
            if (importProcess.getFilePath() != null && (file = new File(importProcess.getFilePath())).exists()) {
                this.temporaryFileService.deleteTemporaryFile(file);
            }
            if (importProcess.getXbrlPath() != null && (xbrl = new File(importProcess.getXbrlPath())).exists()) {
                this.temporaryFileService.deleteTemporaryFile(xbrl);
            }
            this.importProcessRepository.delete((Object)importProcess);
        }
    }

    private ConverterResponseData addFileToResponseData(File file, String fileName) throws IOException {
        ConverterResponseData converterResponseData = new ConverterResponseData();
        converterResponseData.setFileName(fileName + '.' + "xml");
        converterResponseData.setFileBytes(Files.readAllBytes(file.toPath()));
        return converterResponseData;
    }

    @ConstructorProperties(value={"temporaryFileService", "importProcessRepository", "importProcessInfoService", "xbrlPackageService", "importXbrlService", "exportXbrlService", "eventLogService", "xbrlValidateService"})
    public XbrlManagerServiceImpl(TemporaryFileService temporaryFileService, ImportProcessRepository importProcessRepository, ImportProcessInfoService importProcessInfoService, XbrlPackageService xbrlPackageService, ImportXbrlService importXbrlService, ExportXbrlService exportXbrlService, EventLogService eventLogService, XbrlValidateService xbrlValidateService) {
        this.temporaryFileService = temporaryFileService;
        this.importProcessRepository = importProcessRepository;
        this.importProcessInfoService = importProcessInfoService;
        this.xbrlPackageService = xbrlPackageService;
        this.importXbrlService = importXbrlService;
        this.exportXbrlService = exportXbrlService;
        this.eventLogService = eventLogService;
        this.xbrlValidateService = xbrlValidateService;
    }
}

