/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.import_export;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.util.Pair;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.exception.IncorrectXAxisException;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.UnsupportedAlternativeExportRoleException;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.tableLinkBase.AspectNodeMember;
import ru.cbr.xbrl.converter.model.tableLinkBase.AxisMemberHierarchy;
import ru.cbr.xbrl.converter.model.tableLinkBase.DimensionDTO;
import ru.cbr.xbrl.converter.model.tableLinkBase.EnumerateItem;
import ru.cbr.xbrl.converter.model.tableLinkBase.MemberDTO;
import ru.cbr.xbrl.converter.model.tableLinkBase.NodeType;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBaseStructure;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.Fact;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.PeriodLevel;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.TLBUiModel;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.YLevel;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.ZLevel;
import ru.cbr.xbrl.converter.model.web.rest.ColumnHeader;
import ru.cbr.xbrl.converter.service.AspectNodeService;
import ru.cbr.xbrl.converter.service.TableLinkBaseDataService;
import ru.cbr.xbrl.converter.service.XbrlReportService;
import ru.cbr.xbrl.converter.service.import_export.XlsAspectColumnService;
import ru.cbr.xbrl.converter.utils.LabelUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.BodyRow;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.Grid;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.TableLinkViewUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.TopHeaderModel;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XlsxAxisStructure;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XlsxParser;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XslxSheet;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class XlsAspectColumnServiceImpl
implements XlsAspectColumnService {
    private static final Logger log = LoggerFactory.getLogger(XlsAspectColumnServiceImpl.class);
    private static Boolean isRowWithOpenAxis = false;
    private static int countTypedMemberForRow;
    @Autowired
    private AspectNodeService aspectNodeService;
    @Autowired
    private TableLinkBaseDataService tableLinkBaseDataService;
    @Autowired
    private XbrlReportService xbrlReportService;
    private List<AspectCellData> editedCellList = new ArrayList();
    private List<AspectNodeMember> aspectNodeMemberList = new ArrayList();
    private List<AspectNodeMember> currentRowAspectNodeMemberList = new ArrayList();
    private Map<String, List<MemberDTO>> dimensionMemberCache = new HashMap();
    private final int ARTIFICIAL_BASE_PARENT_LEVEL = -1;

    private Grid buildGridStructure(AxisMemberHierarchy xHierarchy, AxisMemberHierarchy yHierarchy, String periodAxis, Map<String, String> dimensionsDefault) throws UnsupportedAlternativeExportRoleException {
        ColumnHeader xAspectColumnHeader = null;
        ColumnHeader yAspectColumnHeader = null;
        HashMap xLevelAspectColumnMap = new HashMap();
        HashMap yLevelAspectColumnMap = new HashMap();
        Function calcDimensionOpenHashByAspectCellData = this.aspectNodeService.calcDimensionOpenHashByAspectCellData(dimensionsDefault);
        ColumnHeader xHeader = this.tableLinkBaseDataService.buildColumnsFromHierarchyWithAspectColumn(xHierarchy, periodAxis, xAspectColumnHeader, xLevelAspectColumnMap, -1, calcDimensionOpenHashByAspectCellData);
        ColumnHeader yHeader = this.tableLinkBaseDataService.buildColumnsFromHierarchyWithAspectColumn(yHierarchy, periodAxis, yAspectColumnHeader, yLevelAspectColumnMap, -1, calcDimensionOpenHashByAspectCellData);
        TopHeaderModel.buildColumnAspectsMap((List)xHeader.getColumnList(), null);
        return XlsAspectColumnServiceImpl.buildHeaderCrossing((ColumnHeader)xHeader, (ColumnHeader)yHeader);
    }

    public void drawRoleWithYLevelColumns(XslxSheet xslxSheet, TLBUiModel tlbUiModel) throws UnsupportedAlternativeExportRoleException, IOException {
        TableLinkBaseStructure currentStructure = tlbUiModel.getStaticStructure();
        XbrlReportRole xbrlReportRole = this.xbrlReportService.findReportRoleSafe(tlbUiModel.getRoleId());
        TableLinkBaseStructure tableLinkBaseStructure = (TableLinkBaseStructure)new ObjectMapper().readValue(xbrlReportRole.getStaticStructureJson(), TableLinkBaseStructure.class);
        Grid grid = this.buildGridStructure(currentStructure.getXAxis(), tableLinkBaseStructure.getYAxis(), currentStructure.getPeriodAxis(), currentStructure.getDimensionsDefault());
        grid.setEnumerations(tlbUiModel.getEnumerations());
        boolean hasAspectX = grid.getHeaderList().stream().anyMatch(columnHeader -> columnHeader.getDataField().equals("aspectColumn"));
        List periodLevelList = tlbUiModel.getPeriodLevelList();
        int lastYOffset = 4;
        for (PeriodLevel periodLevel : periodLevelList) {
            boolean hasRows = false;
            int lastXOffset = 0;
            List zLevelList = periodLevel.getZLevelList();
            List bodyRowList = new ArrayList();
            for (ZLevel zLevel : zLevelList) {
                LinkedList yLevelList = new LinkedList();
                List yLevelListInitial = zLevel.getYLevelList();
                YLevel.collectFullAspectListForEachYLevel((List)yLevelListInitial, null);
                boolean hasYRc = yLevelListInitial.stream().anyMatch(yLevel -> StringUtils.isNotBlank((CharSequence)yLevel.getRcCode()));
                for (YLevel yLevel2 : yLevelListInitial) {
                    yLevelList.addAll(this.prepareYLevel(yLevel2, 0, hasAspectX, hasYRc));
                }
                bodyRowList = this.fillBodyRows(yLevelList);
                if (bodyRowList.size() > 0) {
                    hasRows = true;
                }
                Grid currentGrid = new Grid(grid);
                currentGrid.setBodyRowList(bodyRowList);
                currentGrid.setYOffset(lastYOffset);
                currentGrid.setXOffset(lastXOffset);
                currentGrid.setZAxis(zLevel);
                currentGrid.setPeriod(periodLevel);
                this.drawGrid(xslxSheet, currentGrid);
                lastXOffset = lastXOffset + currentGrid.getColumnCount() + 1;
            }
            int bodyRowListSize = bodyRowList.size();
            if (bodyRowListSize == 0) {
                bodyRowListSize = 1;
            }
            lastYOffset = lastYOffset + grid.getHeaderHeight() + bodyRowListSize + BooleanUtils.toInteger((boolean)hasRows);
        }
    }

    private void drawGrid(XslxSheet xslxSheet, Grid currentGrid) {
        int columnCount = currentGrid.getColumnCount();
        int xOffset = currentGrid.getXOffset();
        xslxSheet.setColumnWidth(xOffset, 12750);
        for (int i = xOffset; i <= columnCount + xOffset; ++i) {
            xslxSheet.setColumnWidth(i, 5100);
        }
        List headerList = currentGrid.getHeaderList();
        ColumnHeader titleHeader = null;
        ColumnHeader rcHeader = null;
        ColumnHeader aspectHeader = null;
        LinkedList<ColumnHeader> dataHeaderList = new LinkedList<ColumnHeader>();
        if (CollectionUtils.isEmpty((Collection)headerList)) {
            throw new RuntimeException("\u042d\u043a\u0441\u043f\u043e\u0440\u0442 xlsx, \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a \u043f\u043e \u043e\u0441\u0438 \u0445 \u043f\u0443\u0441\u0442\u043e\u0439");
        }
        for (ColumnHeader columnHeader : headerList) {
            if (StringUtils.equals((CharSequence)columnHeader.getDataField(), (CharSequence)"title")) {
                if (titleHeader != null) {
                    throw new RuntimeException("\u042d\u043a\u0441\u043f\u043e\u0440\u0442 xlsx, \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a \u0438\u043c\u0435\u0435\u0442 \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u044b \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430 \u0434\u043b\u044f \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430 \u043f\u043e y");
                }
                titleHeader = columnHeader;
                continue;
            }
            if (StringUtils.equals((CharSequence)columnHeader.getDataField(), (CharSequence)"aspectColumn")) {
                aspectHeader = columnHeader;
                continue;
            }
            if (StringUtils.equals((CharSequence)columnHeader.getDataField(), (CharSequence)"rcCode")) {
                rcHeader = columnHeader;
                continue;
            }
            dataHeaderList.add(columnHeader);
        }
        if (titleHeader == null) {
            throw new RuntimeException();
        }
        this.drawGridCoordinates(xslxSheet, currentGrid);
        int maxHeaderYOffset = currentGrid.getYOffset() - 1 + currentGrid.getHeaderHeight();
        LinkedHashMap<Integer, ColumnHeader> columnHashMap = new LinkedHashMap<Integer, ColumnHeader>();
        this.drawHeaderGroup(xslxSheet, titleHeader, xOffset, currentGrid.getYOffset() + 1, columnHashMap, false, maxHeaderYOffset);
        xOffset += titleHeader.getColspan().intValue();
        if (rcHeader != null) {
            this.drawHeaderGroup(xslxSheet, rcHeader, xOffset, currentGrid.getYOffset() + 1, columnHashMap, false, maxHeaderYOffset);
            xOffset += rcHeader.getColspan().intValue();
        }
        if (aspectHeader != null) {
            int aspectYOffset = currentGrid.getYOffset() + 1;
            for (ColumnHeader aspectHeaderItem : aspectHeader.getColumnList()) {
                this.drawHeaderGroup(xslxSheet, aspectHeaderItem, xOffset, aspectYOffset, columnHashMap, true, maxHeaderYOffset);
                ++aspectYOffset;
            }
            aspectHeader.setX(Integer.valueOf(xOffset));
            columnHashMap.put(columnHashMap.keySet().size(), aspectHeader);
            xOffset += aspectHeader.getColspan().intValue();
        }
        for (ColumnHeader dataHeader : dataHeaderList) {
            this.drawHeaderGroup(xslxSheet, dataHeader, xOffset, currentGrid.getYOffset() + 1, columnHashMap, false, maxHeaderYOffset);
            xOffset += dataHeader.getColspan().intValue();
        }
        List titleLeafList = this.getLeafList(Collections.singletonList(titleHeader));
        this.drawBody(currentGrid, columnHashMap, xslxSheet);
    }

    private void drawGridCoordinates(XslxSheet xslxSheet, Grid currentGrid) {
        int yOffset = currentGrid.getYOffset();
        int xOffset = currentGrid.getXOffset();
        Row row = xslxSheet.getRow(yOffset);
        Cell cellPeriod = xslxSheet.createCell(row, xOffset);
        cellPeriod.setCellStyle(xslxSheet.getCellStyleHeader());
        cellPeriod.setCellValue("T= " + currentGrid.getPeriod().getLabel());
        int lastColumnNumber = xOffset + currentGrid.getColumnCount() - 1;
        Cell cellZ = xslxSheet.createCell(row, lastColumnNumber);
        cellZ.setCellStyle(xslxSheet.getCellStyleHeader());
        cellZ.setCellValue("Z= " + currentGrid.getZAxis().getTitle());
        for (int columnNumber = xOffset + 1; columnNumber < lastColumnNumber; ++columnNumber) {
            Cell rowEmptyCell = xslxSheet.createCell(row, columnNumber);
            rowEmptyCell.setCellStyle(xslxSheet.getCellStyleHeader());
        }
    }

    private void drawBody(Grid grid, Map<Integer, ColumnHeader> columnMap, XslxSheet xslxSheet) {
        if (grid == null) {
            return;
        }
        List bodyRowList = grid.getBodyRowList();
        if (CollectionUtils.isEmpty(columnMap) || CollectionUtils.isEmpty((Collection)bodyRowList)) {
            return;
        }
        HashMap<CellAddress, CellAddress> mergedCellMap = new HashMap<CellAddress, CellAddress>();
        HashMap cellForMergeMap = new HashMap();
        ArrayList gridCommonAspectDataList = new ArrayList();
        gridCommonAspectDataList.addAll(grid.getPeriod().getAspectDataList());
        gridCommonAspectDataList.addAll(grid.getZAxis().getAspectDataList());
        int rowYOffset = grid.getYOffset() + grid.getHeaderHeight();
        for (BodyRow bodyRow : bodyRowList) {
            boolean beforeFilledCell = true;
            for (Map.Entry<Integer, ColumnHeader> columnEntry : columnMap.entrySet()) {
                ColumnHeader columnHeader = columnEntry.getValue();
                Row row = xslxSheet.getRow(rowYOffset);
                Cell cell = xslxSheet.createCell(row, columnHeader.getX().intValue());
                if (columnEntry.getKey() < grid.getYHeaderWidth()) {
                    cell.setCellStyle(xslxSheet.getCellStyleHeader());
                }
                Fact fact = (Fact)bodyRow.getValueMap().get(columnHeader.getDataField());
                ArrayList aspectDataList = new ArrayList();
                aspectDataList.addAll(columnHeader.getFullAspectDataList());
                aspectDataList.addAll(bodyRow.getAspectDataList());
                aspectDataList.addAll(gridCommonAspectDataList);
                AspectData concept = new AspectCellData(aspectDataList).getConcept();
                if (concept != null && xslxSheet.getEnumeratorData().getEnumPageItemsMap().containsKey(concept.getAspectValue())) {
                    xslxSheet.addEnumConstraintsToCell(cell, concept.getAspectValue());
                }
                if (fact == null) {
                    if (!beforeFilledCell) continue;
                    CellAddress previousRowCellAddress = new CellAddress(rowYOffset - 1, columnHeader.getX().intValue());
                    CellAddress currentCellAddress = new CellAddress(cell);
                    CellAddress parentCellAddress = (CellAddress)mergedCellMap.get(previousRowCellAddress);
                    if (parentCellAddress != null) {
                        mergedCellMap.put(currentCellAddress, new CellAddress(parentCellAddress.getRow(), parentCellAddress.getColumn()));
                        mergedCellMap.remove(previousRowCellAddress);
                        continue;
                    }
                    mergedCellMap.put(currentCellAddress, previousRowCellAddress);
                    continue;
                }
                beforeFilledCell = false;
                if (fact.isDisabled()) {
                    cell.setCellStyle(xslxSheet.getCellStyleDisabled());
                }
                if (concept == null) {
                    cell.setCellValue(fact.getValue());
                    continue;
                }
                cell.setCellValue(xslxSheet.checkEnumerationValue(fact.getValue(), concept.getAspectValue(), grid.getEnumerations()));
            }
            ++rowYOffset;
        }
    }

    private CellAddress getParentMergedCell(HashMap<CellAddress, CellAddress> mergedCellMap, CellAddress cellAddress) {
        CellAddress parentMergedCell = mergedCellMap.get(cellAddress);
        if (parentMergedCell == null) {
            return null;
        }
        if ((parentMergedCell = this.getParentMergedCell(mergedCellMap, parentMergedCell)) == null) {
            return cellAddress;
        }
        return parentMergedCell;
    }

    private void drawHeaderGroup(XslxSheet xslxSheet, ColumnHeader columnHeader, int xOffset, int yOffset, Map<Integer, ColumnHeader> columnHashMap, boolean isAspectColumn, int maxHeaderYOffset) {
        Row row = xslxSheet.getRow(yOffset);
        Cell cell = xslxSheet.createCell(row, xOffset);
        cell.setCellStyle(xslxSheet.getCellStyleHeader());
        List childColumnList = columnHeader.getColumnList();
        cell.setCellValue(columnHeader.getCaption());
        if (columnHeader.getColspan() > 1) {
            xslxSheet.addMergedRegion(new CellRangeAddress(yOffset, yOffset, xOffset, xOffset + columnHeader.getColspan() - 1));
        }
        columnHeader.setX(Integer.valueOf(xOffset));
        columnHeader.setY(Integer.valueOf(yOffset));
        if (CollectionUtils.isEmpty((Collection)childColumnList) && !isAspectColumn) {
            this.fillColumnHeaderLeafToCommonHeight(xslxSheet, xOffset, yOffset, maxHeaderYOffset);
            columnHashMap.put(columnHashMap.keySet().size(), columnHeader);
            return;
        }
        if (!columnHeader.isAbstractNode() && !isAspectColumn) {
            this.fillColumnHeaderLeafToCommonHeight(xslxSheet, xOffset, yOffset, maxHeaderYOffset);
            columnHashMap.put(columnHashMap.keySet().size(), columnHeader);
            ++xOffset;
        }
        ++yOffset;
        for (ColumnHeader header : childColumnList) {
            this.drawHeaderGroup(xslxSheet, header, xOffset, yOffset, columnHashMap, isAspectColumn, maxHeaderYOffset);
            xOffset += header.getColspan() == null ? 1 : header.getColspan();
        }
    }

    private void parseHeaderGroup(XSSFSheet xslxSheet, ColumnHeader columnHeader, int xOffset, int yOffset, Map<Integer, ColumnHeader> columnHashMap, boolean isAspectColumn, int maxHeaderYOffset) {
        String caption;
        XSSFRow row = xslxSheet.getRow(yOffset);
        Cell cell = row.getCell(xOffset);
        List childColumnList = columnHeader.getColumnList();
        String cellValue = cell != null ? cell.getStringCellValue() : "";
        String string = caption = columnHeader.getCaption() != null ? columnHeader.getCaption() : "";
        if (!StringUtils.equals((CharSequence)caption, (CharSequence)cellValue)) {
            log.info("\u0418\u043c\u043f\u043e\u0440\u0442 xlsx. \u041e\u0436\u0438\u0434\u0430\u043b\u043e\u0441\u044c {}, \u0437\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u0442\u0441\u044f {}", (Object)caption, (Object)cellValue);
        }
        columnHeader.setX(Integer.valueOf(xOffset));
        columnHeader.setY(Integer.valueOf(yOffset));
        if (CollectionUtils.isEmpty((Collection)childColumnList) && !isAspectColumn) {
            this.checkColumnHeaderLeafToCommonHeight(xslxSheet, xOffset, yOffset, maxHeaderYOffset);
            columnHashMap.put(columnHashMap.keySet().size(), columnHeader);
            return;
        }
        if (!columnHeader.isAbstractNode() && !isAspectColumn) {
            this.checkColumnHeaderLeafToCommonHeight(xslxSheet, xOffset, yOffset, maxHeaderYOffset);
            columnHashMap.put(columnHashMap.keySet().size(), columnHeader);
            ++xOffset;
        }
        ++yOffset;
        for (ColumnHeader header : childColumnList) {
            this.parseHeaderGroup(xslxSheet, header, xOffset, yOffset, columnHashMap, isAspectColumn, maxHeaderYOffset);
            xOffset += header.getColspan() == null ? 1 : header.getColspan();
        }
    }

    private void checkColumnHeaderLeafToCommonHeight(XSSFSheet xslxSheet, int xOffset, int yOffset, int maxHeaderYOffset) {
        if (yOffset >= maxHeaderYOffset) {
            return;
        }
        for (int i = yOffset + 1; i <= maxHeaderYOffset; ++i) {
            XSSFRow currentRow = xslxSheet.getRow(i);
            Cell currentCell = currentRow.getCell(xOffset);
            if (currentCell == null) {
                return;
            }
            String stringCellValue = (currentCell = XlsxParser.getStringCellValue((Cell)currentCell)).getStringCellValue();
            if (StringUtils.isBlank((CharSequence)stringCellValue)) continue;
            return;
        }
    }

    private void fillColumnHeaderLeafToCommonHeight(XslxSheet xslxSheet, int xOffset, int yOffset, int maxHeaderYOffset) {
        if (yOffset >= maxHeaderYOffset) {
            return;
        }
        for (int i = yOffset + 1; i <= maxHeaderYOffset; ++i) {
            Row currentRow = xslxSheet.getRow(i);
            Cell currentCell = xslxSheet.createCell(currentRow, xOffset);
            currentCell.setCellStyle(xslxSheet.getCellStyleHeader());
        }
    }

    private List<YLevel> prepareYLevel(YLevel yLevel, int nestLevel, boolean hasAspectX, boolean hasYRc) {
        List yLevelList = yLevel.getYLevelList();
        Fact fact = new Fact();
        NodeType nodeType = yLevel.getNodeType();
        if (nodeType == NodeType.ASPECT) {
            fact.setValue(LabelUtils.calcMemberValueLabel((List)yLevel.getAspectDataList()));
        } else {
            fact.setValue(!yLevel.getTitle().equals("") ? yLevel.getTitle() : "empty row header");
        }
        fact.setDisabled(true);
        yLevel.getFactMap().put("Level_" + nestLevel, fact);
        if (hasYRc) {
            Fact rcCodeFact = new Fact();
            rcCodeFact.setDisabled(true);
            rcCodeFact.setValue(yLevel.getRcCode());
            yLevel.getFactMap().put("rcCode", rcCodeFact);
        }
        if (hasAspectX) {
            Fact aspectXFact = new Fact();
            aspectXFact.setDisabled(true);
            yLevel.getFactMap().put("aspectColumn", aspectXFact);
        }
        if (CollectionUtils.isEmpty((Collection)yLevelList)) {
            return Collections.singletonList(yLevel);
        }
        ArrayList<YLevel> result = new ArrayList<YLevel>();
        if (nodeType == NodeType.ASPECT) {
            for (YLevel level2 : yLevelList) {
                List childLevelList = this.prepareYLevel(level2, nestLevel + 1, hasAspectX, hasYRc);
                for (YLevel yLevelAdditional : childLevelList) {
                    if (yLevelAdditional.getNodeType() != NodeType.ASPECT) continue;
                    YLevel modifiedYLevel = new YLevel(yLevel);
                    modifiedYLevel.setYLevelList(new ArrayList<YLevel>(Collections.singletonList(yLevelAdditional)));
                    result.add(modifiedYLevel);
                }
            }
            yLevelList.removeIf(level -> level.getNodeType() == NodeType.ASPECT);
            if (!CollectionUtils.isEmpty((Collection)yLevelList)) {
                result.add(yLevel);
            }
            return result;
        }
        if (nodeType == NodeType.RULE) {
            for (YLevel level3 : yLevelList) {
                result.addAll(this.prepareYLevel(level3, nestLevel + 1, hasAspectX, hasYRc));
            }
            yLevel.setYLevelList(result);
            return Collections.singletonList(yLevel);
        }
        return result;
    }

    private List<BodyRow> fillBodyRows(List<YLevel> yLevelList) {
        return this.fillBodyRows1(yLevelList);
    }

    private List<BodyRow> fillBodyRows1(List<YLevel> yLevelList) {
        return this.fillBodyRows1(yLevelList, null);
    }

    private List<BodyRow> fillBodyRows1(List<YLevel> yLevelList, BodyRow curBodyRow) {
        ArrayList<BodyRow> bodyRowList = new ArrayList<BodyRow>();
        int i = 0;
        for (YLevel yLevel : yLevelList) {
            BodyRow bodyRow = null;
            Map valueMap = null;
            if (i == 0 && curBodyRow != null) {
                bodyRow = curBodyRow;
                valueMap = bodyRow.getValueMap();
            } else {
                bodyRow = new BodyRow();
                valueMap = bodyRow.getValueMap();
                valueMap.putAll(this.getHeaderFactMap(yLevel.getFactMap()));
                bodyRowList.add(bodyRow);
            }
            ++i;
            valueMap.putAll(yLevel.getFactMap());
            bodyRow.setAspectDataList(yLevel.getFullAspectDataList());
            List yLevelChildList = yLevel.getYLevelList();
            if (CollectionUtils.isEmpty((Collection)yLevelChildList)) continue;
            NodeType nodeType = yLevel.getNodeType();
            if (nodeType == NodeType.RULE) {
                if (yLevel.isAbstractNode()) {
                    bodyRowList.addAll(this.fillBodyRows1(yLevelChildList, bodyRow));
                } else {
                    bodyRowList.addAll(this.fillBodyRows1(yLevelChildList));
                }
            }
            if (nodeType != NodeType.ASPECT) continue;
            bodyRowList.addAll(this.fillBodyRows1(yLevelChildList, bodyRow));
        }
        return bodyRowList;
    }

    private Map<String, Fact> getHeaderFactMap(Map<String, Fact> factMap) {
        HashMap<String, Fact> result = new HashMap<String, Fact>();
        for (Map.Entry<String, Fact> stringFactEntry : factMap.entrySet()) {
            if (!StringUtils.startsWith((CharSequence)stringFactEntry.getKey(), (CharSequence)"Level_")) continue;
            result.put(stringFactEntry.getKey(), stringFactEntry.getValue());
        }
        return result;
    }

    private Map<String, Fact> collectAspectNodeRowFactMap(YLevel yLevel) {
        HashMap<String, Fact> factMap = new HashMap<String, Fact>();
        if (yLevel.getNodeType() == NodeType.ASPECT) {
            factMap.putAll(this.getHeaderFactMap(yLevel.getFactMap()));
            List yLevelChildList = yLevel.getYLevelList();
            if (CollectionUtils.isEmpty((Collection)yLevelChildList)) {
                factMap.putAll(yLevel.getFactMap());
                return factMap;
            }
            YLevel level = (YLevel)yLevelChildList.get(0);
            if (level != null && level.getNodeType() == NodeType.ASPECT) {
                factMap.putAll(this.collectAspectNodeRowFactMap(level));
            } else {
                factMap.putAll(yLevel.getFactMap());
            }
        }
        return factMap;
    }

    private List<ColumnHeader> getLeafList(List<ColumnHeader> columnHeaders) {
        ArrayList<ColumnHeader> result = new ArrayList<ColumnHeader>();
        for (ColumnHeader columnHeader : columnHeaders) {
            if (StringUtils.startsWith((CharSequence)columnHeader.getHash(), (CharSequence)"aspectColumn")) continue;
            if (!columnHeader.isAbstractNode()) {
                result.add(columnHeader);
            }
            if (CollectionUtils.isEmpty((Collection)columnHeader.getColumnList())) continue;
            result.addAll(this.getLeafList(columnHeader.getColumnList()));
        }
        return result;
    }

    private static void collectLastByDepth(List<Map.Entry<Integer, ColumnHeader>> result, ColumnHeader columnHeader, int depth) {
        if (columnHeader.getColumnList().size() > 0) {
            int nextDepth = depth + 1;
            if (!columnHeader.isAbstractNode() && depth > -1) {
                result.add(new AbstractMap.SimpleEntry<Integer, ColumnHeader>(depth, columnHeader));
            }
            columnHeader.getColumnList().forEach(child -> XlsAspectColumnServiceImpl.collectLastByDepth((List)result, (ColumnHeader)child, (int)nextDepth));
        } else {
            result.add(new AbstractMap.SimpleEntry<Integer, ColumnHeader>(depth, columnHeader));
        }
    }

    private static Grid buildHeaderCrossing(ColumnHeader xHeader, ColumnHeader yHeader) throws UnsupportedAlternativeExportRoleException {
        int yHeaderWidth;
        int xHeaderDepth;
        List aspectYColumnList;
        List aspectXColumnList = xHeader.getColumnList().stream().filter(item -> StringUtils.equals((CharSequence)item.getDataField(), (CharSequence)"aspectColumn")).collect(Collectors.toList());
        boolean hasXAspect = true;
        boolean isLastXLevelAspect = true;
        boolean isLastYLevelAspect = true;
        ColumnHeader aspectXColumnHeader = new ColumnHeader();
        if (CollectionUtils.isEmpty(aspectXColumnList) || aspectXColumnList.size() != 1) {
            log.warn("\u042d\u043a\u0441\u043f\u043e\u0440\u0442 xlsx \u0432 \u043d\u043e\u0432\u043e\u043c \u0444\u043e\u0440\u043c\u0430\u0442\u0435. \u041f\u043e \u043e\u0441\u0438 \u0425 \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e aspect \u0441\u0442\u043e\u043b\u0431\u0446\u0430.");
            throw new UnsupportedAlternativeExportRoleException();
        }
        if (!CollectionUtils.isEmpty(aspectXColumnList) && aspectXColumnList.size() == 1 && (aspectXColumnHeader = (ColumnHeader)aspectXColumnList.get(0)).getColumnList().stream().allMatch(item -> StringUtils.isBlank((CharSequence)item.getHash()))) {
            hasXAspect = false;
            xHeader.getColumnList().removeIf(next -> StringUtils.equals((CharSequence)next.getDataField(), (CharSequence)"aspectColumn"));
        }
        if (CollectionUtils.isEmpty(aspectYColumnList = yHeader.getColumnList().stream().filter(item -> StringUtils.equals((CharSequence)item.getDataField(), (CharSequence)"aspectColumn")).collect(Collectors.toList())) || aspectYColumnList.size() != 1) {
            log.warn("\u042d\u043a\u0441\u043f\u043e\u0440\u0442 xlsx \u0432 \u043d\u043e\u0432\u043e\u043c \u0444\u043e\u0440\u043c\u0430\u0442\u0435. \u041f\u043e \u043e\u0441\u0438 Y \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e aspect \u0441\u0442\u043e\u043b\u0431\u0446\u0430.");
            throw new UnsupportedAlternativeExportRoleException();
        }
        ColumnHeader aspectYColumnHeader = (ColumnHeader)aspectYColumnList.get(0);
        if (hasXAspect) {
            xHeaderDepth = aspectXColumnHeader.getColumnList().size();
            ColumnHeader column = (ColumnHeader)aspectXColumnHeader.getColumnList().get(xHeaderDepth - 1);
            if (StringUtils.isBlank((CharSequence)column.getHash())) {
                isLastXLevelAspect = false;
            }
            if (aspectYColumnList.size() != 0) {
                ColumnHeader columnHeader2 = new ColumnHeader();
                columnHeader2.setAbstractNode(true);
                columnHeader2.setColspan(aspectXColumnHeader.getColspan());
                aspectXColumnHeader.getColumnList().add(columnHeader2);
            }
        } else {
            xHeaderDepth = TableLinkViewUtils.calcHeadersDepth((List)xHeader.getColumnList());
            isLastXLevelAspect = false;
        }
        ArrayList lastLevelX = new ArrayList();
        XlsAspectColumnServiceImpl.collectLastByDepth(lastLevelX, (ColumnHeader)xHeader, (int)-1);
        boolean hasRcCodeX = lastLevelX.stream().map(Map.Entry::getValue).anyMatch(columnHeader -> StringUtils.isNotBlank((CharSequence)columnHeader.getRcCode()));
        if (hasRcCodeX) {
            if (hasXAspect) {
                ColumnHeader columnHeader3 = new ColumnHeader();
                columnHeader3.setAbstractNode(true);
                columnHeader3.setColspan(aspectXColumnHeader.getColspan());
                aspectXColumnHeader.getColumnList().add(columnHeader3);
            }
            int maxDepth = lastLevelX.stream().mapToInt(Map.Entry::getKey).max().orElse(0);
            for (Map.Entry level : lastLevelX) {
                ColumnHeader levelHeaderElement = (ColumnHeader)level.getValue();
                if (!StringUtils.isNotBlank((CharSequence)levelHeaderElement.getRcCode())) continue;
                levelHeaderElement.setAbstractNode(true);
                ColumnHeader lastElement = levelHeaderElement;
                for (int i = ((Integer)level.getKey()).intValue(); i < maxDepth; ++i) {
                    ColumnHeader columnHeader4 = new ColumnHeader();
                    columnHeader4.setAbstractNode(true);
                    columnHeader4.setColspan(Integer.valueOf(1));
                    lastElement.getColumnList().add(0, columnHeader4);
                    lastElement = columnHeader4;
                }
                ColumnHeader rcPart = new ColumnHeader();
                rcPart.setDataField(levelHeaderElement.getDataField());
                rcPart.setCaption(levelHeaderElement.getRcCode());
                rcPart.setRcCode(levelHeaderElement.getRcCode());
                rcPart.setAbstractNode(levelHeaderElement.isAbstractNode());
                rcPart.setHash(levelHeaderElement.getHash());
                rcPart.setAspectDataList(levelHeaderElement.getAspectDataList());
                rcPart.setFullAspectDataList(levelHeaderElement.getFullAspectDataList());
                rcPart.setColspan(Integer.valueOf(1));
                lastElement.getColumnList().add(0, rcPart);
            }
            ++xHeaderDepth;
        }
        if ((yHeaderWidth = aspectYColumnHeader.getColumnList().size()) > 0) {
            ColumnHeader column = (ColumnHeader)aspectYColumnHeader.getColumnList().get(yHeaderWidth - 1);
            if (StringUtils.isBlank((CharSequence)column.getHash())) {
                isLastYLevelAspect = false;
            }
        } else {
            yHeaderWidth = 1;
            isLastYLevelAspect = false;
        }
        List xTitleColumnList = xHeader.getColumnList().stream().filter(item -> StringUtils.equals((CharSequence)item.getDataField(), (CharSequence)"title")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(xTitleColumnList) || xTitleColumnList.size() != 1) {
            log.warn("\u042d\u043a\u0441\u043f\u043e\u0440\u0442 xlsx \u0432 \u043d\u043e\u0432\u043e\u043c \u0444\u043e\u0440\u043c\u0430\u0442\u0435. \u041f\u043e \u043e\u0441\u0438 X \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e \u0441\u0442\u043e\u043b\u0431\u0446\u0430 title (\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044f)");
            throw new UnsupportedAlternativeExportRoleException();
        }
        if (aspectYColumnHeader.getColumnList().stream().anyMatch(columnHeader -> columnHeader.getCaption() != null)) {
            if (xHeaderDepth == 1) {
                ++xHeaderDepth;
            }
            if (hasRcCodeX) {
                ++xHeaderDepth;
            }
        }
        ColumnHeader xTitleHeader = (ColumnHeader)xTitleColumnList.get(0);
        xTitleHeader.setColspan(Integer.valueOf(yHeaderWidth));
        xTitleHeader.setAbstractNode(true);
        for (int i = 1; i < xHeaderDepth - 1; ++i) {
            ColumnHeader columnHeader5 = new ColumnHeader();
            columnHeader5.setAbstractNode(true);
            columnHeader5.setColspan(Integer.valueOf(yHeaderWidth));
            xTitleHeader.getColumnList().add(columnHeader5);
            xTitleHeader = columnHeader5;
        }
        xTitleHeader.setColumnList(aspectYColumnHeader.getColumnList());
        xHeader.setColspan(xHeader.getColumnList().stream().map(ColumnHeader::getColspan).reduce(0, Integer::sum));
        yHeader.getColumnList().removeIf(next -> StringUtils.equals((CharSequence)next.getDataField(), (CharSequence)"aspectColumn"));
        Grid grid = new Grid();
        grid.setColumnCount(xHeader.getColspan().intValue());
        grid.setRowCount(yHeader.getColspan() + xHeaderDepth);
        grid.setHeaderList(xHeader.getColumnList());
        grid.setYHeaderWidth(yHeaderWidth);
        grid.setHeaderHeight(xHeaderDepth + 1);
        grid.setTitleLeafList(xTitleHeader.getColumnList());
        return grid;
    }

    private static void prepareTlbUiModelForYLevelAsColumn(TLBUiModel tlbUiModel) throws UnsupportedAlternativeExportRoleException {
        List periodLevelList = tlbUiModel.getPeriodLevelList();
        for (PeriodLevel periodLevel : periodLevelList) {
            List zLevelList = periodLevel.getZLevelList();
            for (ZLevel zLevel : zLevelList) {
                List yLevelList = zLevel.getYLevelList();
                ((ColumnHeader)tlbUiModel.getColumnList().get(0)).setAbstractNode(true);
                for (YLevel yLevel : yLevelList) {
                    XlsAspectColumnServiceImpl.addDynamicColumn((ColumnHeader)((ColumnHeader)tlbUiModel.getColumnList().get(0)), (YLevel)yLevel, (Integer)0, null);
                }
            }
        }
        XlsAspectColumnServiceImpl.checkOneHeaderForRule((ColumnHeader)((ColumnHeader)tlbUiModel.getColumnList().get(0)));
    }

    private static Pair<Integer, Integer> addDynamicColumn(ColumnHeader columnHeader, YLevel yLevel, Integer colNum, Map<String, Fact> aspectFactMap) throws UnsupportedAlternativeExportRoleException {
        ColumnHeader columnHeaderNested = new ColumnHeader();
        columnHeaderNested.setAbstractNode(false);
        NodeType nodeType = yLevel.getNodeType();
        if (nodeType != NodeType.ASPECT) {
            throw new UnsupportedAlternativeExportRoleException();
        }
        List columnHeaderGeneratedTitleList = columnHeader.getColumnList().stream().map(ColumnHeader::getCaption).collect(Collectors.toList());
        if (nodeType == NodeType.ASPECT) {
            List aspectDataList = yLevel.getAspectDataList();
            if (CollectionUtils.isEmpty((Collection)aspectDataList)) {
                return new Pair((Object)0, (Object)0);
            }
            AspectData aspectDataItem = (AspectData)aspectDataList.get(0);
            if (aspectDataItem == null) {
                return new Pair((Object)0, (Object)0);
            }
            String title = aspectDataItem.getAxisLabel();
            if (!CollectionUtils.contains(columnHeaderGeneratedTitleList.iterator(), (Object)title)) {
                columnHeaderNested.setCaption(title);
                columnHeaderNested.setDataField("header_common_title_" + colNum);
                columnHeader.getColumnList().add(columnHeaderNested);
            }
            Fact fact = new Fact();
            fact.setDisabled(true);
            fact.setValue(((AspectData)yLevel.getAspectDataList().get(0)).getAxisValueLabel());
            if (!CollectionUtils.isEmpty(aspectFactMap)) {
                Set<Map.Entry<String, Fact>> yHeaderMapEntry = aspectFactMap.entrySet();
                for (Map.Entry<String, Fact> stringFactEntry : yHeaderMapEntry) {
                    if (!StringUtils.startsWith((CharSequence)stringFactEntry.getKey(), (CharSequence)"header_common_title_")) continue;
                    yLevel.getFactMap().put(stringFactEntry.getKey(), stringFactEntry.getValue());
                }
            }
            yLevel.getFactMap().put("header_common_title_" + colNum, fact);
        }
        if (nodeType == NodeType.RULE) {
            if (!CollectionUtils.contains(columnHeaderGeneratedTitleList.iterator(), (Object)("header_common_title_" + colNum))) {
                columnHeaderNested.setCaption("header_common_title_" + colNum);
                columnHeaderNested.setDataField("header_common_title_" + colNum);
                columnHeader.getColumnList().add(columnHeaderNested);
            }
            Fact fact = new Fact();
            fact.setDisabled(true);
            fact.setValue(yLevel.getTitle());
            yLevel.getFactMap().put("header_common_title_" + colNum, fact);
        }
        if (yLevel.isAbstractNode() || yLevel.getNodeType() == NodeType.ASPECT) {
            yLevel.setRowspan(Integer.valueOf(0));
        } else {
            yLevel.setRowspan(Integer.valueOf(1));
        }
        List yLevelList = yLevel.getYLevelList();
        if (CollectionUtils.isEmpty((Collection)yLevelList)) {
            yLevel.setLevel(Integer.valueOf(1));
            yLevel.setRowspan(Integer.valueOf(1));
            return new Pair((Object)1, (Object)1);
        }
        yLevel.setLevel(Integer.valueOf(1));
        Pair resultPair = new Pair((Object)0, (Object)0);
        for (YLevel level : yLevelList) {
            resultPair = XlsAspectColumnServiceImpl.addDynamicColumn((ColumnHeader)columnHeader, (YLevel)level, (Integer)(colNum + 1), (Map)(yLevel.getNodeType() == NodeType.RULE ? null : yLevel.getFactMap()));
            yLevel.setLevel(Integer.valueOf(Math.max(yLevel.getLevel(), (Integer)resultPair.getValue() + 1)));
            yLevel.setRowspan(Integer.valueOf(yLevel.getRowspan() + (Integer)resultPair.getKey()));
        }
        return new Pair((Object)yLevel.getRowspan(), (Object)((Integer)resultPair.getValue() + 1));
    }

    private static void checkOneHeaderForRule(ColumnHeader columnHeader) {
        Set ruleTitleSet = columnHeader.getColumnList().stream().map(ColumnHeader::getCaption).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(ruleTitleSet)) {
            columnHeader.getColumnList().clear();
            columnHeader.setDataField("header_common_title_0");
            return;
        }
        if (ruleTitleSet.size() == 1 && StringUtils.startsWith((CharSequence)((CharSequence)ruleTitleSet.iterator().next()), (CharSequence)"header_common_title_")) {
            columnHeader.getColumnList().clear();
            columnHeader.setDataField("header_common_title_0");
        }
    }

    private TLBUiModel searchXAxises(XbrlReportRole xbrlReportRole, TableLinkBaseStructure structure, XSSFSheet xlsxSheet) throws UnsupportedAlternativeExportRoleException, NotFoundException, IncorrectXAxisException {
        XlsxParser.isRoleWithCorrectXAxis = true;
        ColumnHeader xAspectColumnHeader = null;
        HashMap xLevelAspectColumnMap = new HashMap();
        Function calcDimensionOpenHashByAspectCellData = this.aspectNodeService.calcDimensionOpenHashByAspectCellData(structure.getDimensionsDefault());
        ColumnHeader xHeader = this.tableLinkBaseDataService.buildColumnsFromHierarchyWithAspectColumn(structure.getXAxis(), structure.getPeriodAxis(), xAspectColumnHeader, xLevelAspectColumnMap, -1, calcDimensionOpenHashByAspectCellData);
        List aspectXColumnList = xHeader.getColumnList().stream().filter(item -> StringUtils.equals((CharSequence)item.getDataField(), (CharSequence)"aspectColumn")).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(aspectXColumnList) && aspectXColumnList.size() == 1 && !((ColumnHeader)aspectXColumnList.get(0)).getColumnList().stream().allMatch(item -> StringUtils.isBlank((CharSequence)item.getCaption()))) {
            ColumnHeader aspectXColumnHeader = (ColumnHeader)aspectXColumnList.get(0);
            XlsxAxisStructure xStructure = new XlsxAxisStructure(structure.getXAxis());
            xStructure.setAbstractNode(true);
            xStructure.setLevel(Integer.valueOf(-1));
            Map<String, ColumnHeader> xMap = xHeader.getColumnList().stream().collect(Collectors.toMap(ColumnHeader::getDataField, o -> o));
            for (AxisMemberHierarchy axisMemberHierarchy : structure.getXAxis().getAxisMemberHierarchyList()) {
                this.prepareXlsxAxisStructure(xStructure, axisMemberHierarchy, xMap, 0);
            }
            int xHeaderDepth = aspectXColumnHeader.getColumnList().size();
            ArrayList<XSSFRow> headerRows = new ArrayList<XSSFRow>();
            for (int i = 0; i < xHeaderDepth; ++i) {
                headerRows.add(xlsxSheet.getRow(i + 5));
            }
            int yWidth = 0;
            XSSFRow labelsRow = xlsxSheet.getRow(4);
            for (Cell cell : labelsRow) {
                if (!cell.getStringCellValue().startsWith("Z=")) continue;
                yWidth = cell.getColumnIndex();
                break;
            }
            if (headerRows.size() > 0 && yWidth > 0) {
                List captionList = aspectXColumnHeader.getColumnList().stream().map(columnHeader -> columnHeader.getCaption() == null ? "" : columnHeader.getCaption()).collect(Collectors.toList());
                int aspectColumnIndex = yWidth;
                for (int i = 0; i <= yWidth; ++i) {
                    boolean isAspectColumn = true;
                    for (int j = 0; j < headerRows.size(); ++j) {
                        Cell cell = ((Row)headerRows.get(j)).getCell(i);
                        if (cell != null) {
                            cell.setCellType(CellType.STRING);
                        }
                        boolean bl = isAspectColumn = cell != null && ((String)captionList.get(j)).equals(cell.getStringCellValue());
                        if (!isAspectColumn) break;
                    }
                    if (!isAspectColumn) continue;
                    aspectColumnIndex = i;
                    break;
                }
                List mergedRegions = xlsxSheet.getMergedRegions();
                String[][] normalizedHeader = new String[yWidth - aspectColumnIndex][headerRows.size()];
                for (int i = 0; i < headerRows.size(); ++i) {
                    Row headerRow = (Row)headerRows.get(i);
                    for (int j = aspectColumnIndex + 1; j <= yWidth; ++j) {
                        Cell cell = headerRow.getCell(j);
                        if (cell == null) continue;
                        cell.setCellType(CellType.STRING);
                        String value = cell.getStringCellValue();
                        if (StringUtils.isBlank((CharSequence)value)) continue;
                        List currentRegions = mergedRegions.stream().filter(mergedRegion -> mergedRegion.containsRow(headerRow.getRowNum()) && mergedRegion.containsColumn(cell.getColumnIndex())).collect(Collectors.toList());
                        if (currentRegions.size() > 0) {
                            for (CellRangeAddress currentRegion : currentRegions) {
                                for (int k = currentRegion.getFirstColumn() - aspectColumnIndex - 1; k <= currentRegion.getLastColumn() - aspectColumnIndex - 1; ++k) {
                                    normalizedHeader[k][i] = value;
                                }
                            }
                            continue;
                        }
                        normalizedHeader[j - aspectColumnIndex - 1][i] = value;
                    }
                }
                ArrayList<AspectNodeMember> foundAxises = new ArrayList<AspectNodeMember>();
                for (int i = 0; i < normalizedHeader.length; ++i) {
                    String[] branch = normalizedHeader[i];
                    XlsxAxisStructure root = xStructure;
                    for (int j = 0; j < branch.length; ++j) {
                        String itemKey;
                        String levelCaption = (String)captionList.get(j);
                        String itemValue = normalizedHeader[i][j];
                        if (StringUtils.isBlank((CharSequence)itemValue)) continue;
                        if (!levelCaption.equals("") && root.getXlsxAxisStructureMap().containsKey(itemValue)) {
                            ArrayList items = new ArrayList(root.getXlsxAxisStructureMap().keySet());
                            Integer[] sameValueIndexes = new Integer[2];
                            for (int k = 0; k < normalizedHeader.length; ++k) {
                                if (normalizedHeader[k][j] == null) {
                                    XlsxParser.isRoleWithCorrectXAxis = false;
                                    throw new IncorrectXAxisException();
                                }
                                if (!normalizedHeader[k][j].equals(itemValue)) continue;
                                sameValueIndexes[sameValueIndexes[0] == null ? 0 : 1] = k;
                            }
                            itemKey = sameValueIndexes[0] != null && sameValueIndexes[1] != null ? (items.indexOf(itemValue) > items.indexOf("") ? (sameValueIndexes[0] == i ? itemValue : "") : (sameValueIndexes[0] == i ? "" : itemValue)) : itemValue;
                        } else {
                            itemKey = levelCaption.equals("") ? itemValue : "";
                        }
                        String normalizedHeaderStr = Arrays.deepToString((Object[])normalizedHeader);
                        if (normalizedHeaderStr.contains("null")) {
                            XlsxParser.isRoleWithCorrectXAxis = false;
                            throw new IncorrectXAxisException();
                        }
                        XlsxAxisStructure xlsxAxisStructure = new XlsxAxisStructure((XlsxAxisStructure)((List)root.getXlsxAxisStructureMap().get(itemKey)).get(0));
                        if (xlsxAxisStructure.getNodeType().equals((Object)NodeType.ASPECT)) {
                            xlsxAxisStructure.getAspectDataList().addAll(0, root.getAspectDataList());
                            List aspectDataList = xlsxAxisStructure.getAspectDataList();
                            for (AspectData aspectData : aspectDataList) {
                                if (aspectData.getType() != AspectType.DIMENSION || !StringUtils.contains((CharSequence)levelCaption, (CharSequence)aspectData.getLabel()) || !StringUtils.equals((CharSequence)aspectData.getAspectValue(), (CharSequence)"(bound dynamically)")) continue;
                                String aspect = aspectData.getAspect();
                                if (aspectData.getDimensionType() == DimensionType.EXPLICIT_MEMBER) {
                                    aspectData.setAspectValue(this.getDimensionMember(aspect, itemValue));
                                } else {
                                    aspectData.setAspectValue(itemValue);
                                }
                                aspectData.setAxisLabel(aspectData.getLabel());
                                aspectData.setLabel(aspectData.getAxisLabel() + "-" + itemValue);
                                aspectData.setAxisValueLabel(itemValue);
                                AspectNodeMember aspectNodeMember = new AspectNodeMember();
                                aspectNodeMember.setDimension(aspect);
                                aspectNodeMember.setHash(StringUtils.isBlank((CharSequence)root.getHash()) ? root.getId() : root.getHash());
                                xlsxAxisStructure.setHash(aspectNodeMember.getHash() + "#" + xlsxAxisStructure.getDefinitionNodeId() + "#" + aspect + "#" + DigestUtils.md5Hex((String)itemValue));
                                aspectNodeMember.setCommonId(xlsxAxisStructure.getHash());
                                aspectNodeMember.setClosedMemberLabel(itemValue);
                                foundAxises.add(aspectNodeMember);
                            }
                        }
                        root = xlsxAxisStructure;
                    }
                }
                if (foundAxises.size() > 0) {
                    for (AspectNodeMember aspectNodeMember : foundAxises) {
                        try {
                            this.aspectNodeService.saveMember(xbrlReportRole.getId(), aspectNodeMember.getDimension(), aspectNodeMember.getClosedMemberLabel(), aspectNodeMember.getHash(), null, aspectNodeMember.getCommonId());
                        }
                        catch (NotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                    return this.tableLinkBaseDataService.getTableLinkBaseUIFrom(xbrlReportRole);
                }
            }
        }
        return null;
    }

    public List<AspectCellData> parseAspectAsColumnsRole(XbrlReportRole xbrlReportRole, TLBUiModel processedTlbUiModel, XSSFSheet xlsxSheet) throws UnsupportedAlternativeExportRoleException, IOException, NotFoundException, IncorrectXAxisException {
        int maxYOffset;
        this.editedCellList.clear();
        this.aspectNodeMemberList.clear();
        XlsxParser.incorrectImportedAxisLines.clear();
        ObjectMapper mapper = new ObjectMapper();
        TableLinkBaseStructure structure = (TableLinkBaseStructure)mapper.readValue(xbrlReportRole.getStaticStructureJson(), TableLinkBaseStructure.class);
        log.info("searchXAxises>start");
        Optional<TLBUiModel> importedXModel = Optional.ofNullable(this.searchXAxises(xbrlReportRole, structure, xlsxSheet));
        if (importedXModel.isPresent()) {
            processedTlbUiModel = importedXModel.get();
        }
        log.info("searchXAxises>end");
        AxisMemberHierarchy yAxis = structure.getYAxis();
        TableLinkBaseStructure processedStructure = processedTlbUiModel.getStaticStructure();
        if (CollectionUtils.isEmpty((Collection)processedStructure.getYAxis().getAxisMemberHierarchyList())) {
            this.mergeStructures(yAxis, processedStructure.getYAxis());
        }
        Grid grid = this.buildGridStructure(processedStructure.getXAxis(), yAxis, processedStructure.getPeriodAxis(), processedStructure.getDimensionsDefault());
        List axisMemberHierarchyList = yAxis.getAxisMemberHierarchyList();
        if (CollectionUtils.isEmpty((Collection)axisMemberHierarchyList)) {
            return Collections.emptyList();
        }
        XlsxAxisStructure xlsxAxisStructure = new XlsxAxisStructure(yAxis);
        xlsxAxisStructure.setAbstractNode(true);
        xlsxAxisStructure.setLevel(Integer.valueOf(-1));
        Map<String, ColumnHeader> columnHeaderMap = grid.getTitleLeafList().stream().collect(Collectors.toMap(ColumnHeader::getDataField, o -> o));
        for (AxisMemberHierarchy axisMemberHierarchy : axisMemberHierarchyList) {
            this.prepareXlsxAxisStructure(xlsxAxisStructure, axisMemberHierarchy, columnHeaderMap, 0);
        }
        boolean nextGridExists = true;
        int currentRowYOffset = maxYOffset = 4;
        Integer xOffset = 0;
        HashMap<Integer, Integer> gridXOffsetMap = new HashMap<Integer, Integer>();
        gridXOffsetMap.put(0, xOffset);
        xlsxSheet.getLastRowNum();
        int currentGridNumInRow = 0;
        grid.setEnumerations(structure.getEnumerations());
        while (nextGridExists) {
            Grid currentGrid = new Grid(grid);
            currentGrid.setYOffset(currentRowYOffset);
            currentGrid.setXOffset(xOffset.intValue());
            CellAddress lastParsedCellAddress = this.parseAspectAsColumnsGrid(currentGrid, xlsxAxisStructure, structure.getZAxis(), processedTlbUiModel.getPeriodLevelList(), xlsxSheet);
            if (lastParsedCellAddress == null) {
                throw new UnsupportedAlternativeExportRoleException();
            }
            maxYOffset = Math.max(lastParsedCellAddress.getRow(), maxYOffset);
            gridXOffsetMap.put(currentGridNumInRow, xOffset);
            xOffset = (Integer)gridXOffsetMap.get(++currentGridNumInRow);
            if (xOffset == null) {
                xOffset = this.skipEmptyColumns(lastParsedCellAddress.getColumn() + 1, currentGrid.getYOffset(), xlsxSheet);
            }
            if (xOffset != 0) continue;
            currentGridNumInRow = 0;
            currentRowYOffset = maxYOffset = this.skipEmptyRows(maxYOffset, xlsxSheet);
            if (maxYOffset != 0) continue;
            nextGridExists = false;
        }
        log.info("saveMember>start");
        long d1 = System.currentTimeMillis();
        this.aspectNodeService.saveMembers(xbrlReportRole, this.aspectNodeMemberList);
        log.info("saveMember>end" + (System.currentTimeMillis() - d1));
        return this.editedCellList;
    }

    public void clearDimensionMemberCache() {
        this.dimensionMemberCache.clear();
    }

    public List<AspectCellData> parseGrid() {
        return Collections.emptyList();
    }

    private void prepareXlsxAxisStructure(XlsxAxisStructure xlsxAxisStructure, AxisMemberHierarchy axisMemberHierarchy, Map<String, ColumnHeader> columnHeaderMap, int level) {
        String label;
        if (axisMemberHierarchy == null) {
            log.info("\u0418\u043c\u043f\u043e\u0440\u0442 xlsx. \u041f\u043e\u0441\u0442\u0440\u043e\u0435\u043d\u0438\u0435 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043f\u043e \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0443 \u043e\u0441\u0438 y. \u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0430.");
            return;
        }
        List axisMemberHierarchyList = axisMemberHierarchy.getAxisMemberHierarchyList();
        XlsxAxisStructure currentAxisStructure = new XlsxAxisStructure(axisMemberHierarchy);
        currentAxisStructure.setParentStructure(xlsxAxisStructure);
        String string = label = StringUtils.isBlank((CharSequence)currentAxisStructure.getLabel()) ? "" : currentAxisStructure.getLabel();
        if (label.equals("") && axisMemberHierarchy.getNodeType().equals((Object)NodeType.RULE)) {
            label = "empty row header";
        }
        xlsxAxisStructure.getXlsxAxisStructureLabelSet().add(label);
        if (xlsxAxisStructure.getXlsxAxisStructureMap().containsKey(label)) {
            ((List)xlsxAxisStructure.getXlsxAxisStructureMap().get(label)).add(currentAxisStructure);
        } else {
            xlsxAxisStructure.getXlsxAxisStructureMap().put(label, new /* Unavailable Anonymous Inner Class!! */);
        }
        if (axisMemberHierarchy.getNodeType() == NodeType.ASPECT) {
            xlsxAxisStructure.setHasChildListAspect(true);
            if (xlsxAxisStructure.getChildAspectStructure() != null) {
                log.error("\u0418\u043c\u043f\u043e\u0440\u0442 xlsx. \u0424\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u044b \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430. \u041d\u0430 \u0443\u0440\u043e\u0432\u043d\u0435 {} \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043e \u0431\u043e\u043b\u0435\u0435, \u0447\u0435\u043c \u043e\u0434\u043d\u0430 \u0430\u0441\u043f\u0435\u043a\u0442 \u043d\u043e\u0434\u0430", (Object)level);
            } else {
                xlsxAxisStructure.setChildAspectStructure(currentAxisStructure);
            }
        }
        currentAxisStructure.setColumnHeader(columnHeaderMap.get("Level_" + level));
        currentAxisStructure.setLevel(Integer.valueOf(level));
        if (CollectionUtils.isEmpty((Collection)axisMemberHierarchyList)) {
            return;
        }
        for (AxisMemberHierarchy childAxisMemberHierarchy : axisMemberHierarchyList) {
            this.prepareXlsxAxisStructure(currentAxisStructure, childAxisMemberHierarchy, columnHeaderMap, level + 1);
        }
    }

    private int skipEmptyRows(int maxYOffset, XSSFSheet xlsxSheet) {
        int lastRowNum = xlsxSheet.getLastRowNum();
        while (maxYOffset < lastRowNum) {
            XSSFRow row = xlsxSheet.getRow(maxYOffset);
            if (row == null) {
                ++maxYOffset;
                continue;
            }
            XSSFCell cell = row.getCell(0);
            if (cell == null || !StringUtils.startsWith((CharSequence)cell.getStringCellValue(), (CharSequence)"T= ")) {
                ++maxYOffset;
                continue;
            }
            return maxYOffset;
        }
        return 0;
    }

    private int skipEmptyColumns(int column, int yOffset, XSSFSheet xlsxSheet) {
        XSSFRow row = xlsxSheet.getRow(yOffset);
        short lastCellNum = row.getLastCellNum();
        while (column < lastCellNum) {
            XSSFCell cell = row.getCell(column);
            if (cell == null || !StringUtils.startsWith((CharSequence)cell.getStringCellValue(), (CharSequence)"T= ")) {
                ++column;
                continue;
            }
            return column;
        }
        return 0;
    }

    private void mergeStructures(AxisMemberHierarchy yAxis, AxisMemberHierarchy processedYAxis) {
        yAxis.getLabel();
        processedYAxis.getLabel();
    }

    private Map<String, ColumnHeader> prepareRuleNodeTitle(AxisMemberHierarchy yAxis, List<ColumnHeader> columnHeaderList) {
        AspectCellData aspectCellData = new AspectCellData(yAxis.getAspectDataList());
        List axisMemberHierarchyList = yAxis.getAxisMemberHierarchyList();
        if (CollectionUtils.isEmpty((Collection)axisMemberHierarchyList)) {
            return null;
        }
        for (AxisMemberHierarchy axisMemberHierarchy : axisMemberHierarchyList) {
            Map map = this.prepareRuleNodeTitle(axisMemberHierarchy, columnHeaderList);
        }
        return null;
    }

    private CellAddress parseAspectAsColumnsGrid(Grid grid, XlsxAxisStructure xlsxAxisStructure, AxisMemberHierarchy zAxis, List<PeriodLevel> periodLevelList, XSSFSheet xssfSheet) throws UnsupportedAlternativeExportRoleException {
        int columnCount = grid.getColumnCount();
        int xOffset = grid.getXOffset();
        xssfSheet.setColumnWidth(xOffset, 12750);
        for (int i = xOffset; i <= columnCount; ++i) {
            xssfSheet.setColumnWidth(i, 5100);
        }
        List headerList = grid.getHeaderList();
        ColumnHeader titleHeader = null;
        ColumnHeader rcHeader = null;
        ColumnHeader aspectHeader = null;
        LinkedList<ColumnHeader> dataHeaderList = new LinkedList<ColumnHeader>();
        if (CollectionUtils.isEmpty((Collection)headerList)) {
            throw new RuntimeException("\u042d\u043a\u0441\u043f\u043e\u0440\u0442 xlsx, \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a \u043f\u043e \u043e\u0441\u0438 \u0445 \u043f\u0443\u0441\u0442\u043e\u0439");
        }
        for (ColumnHeader columnHeader : headerList) {
            if (StringUtils.equals((CharSequence)columnHeader.getDataField(), (CharSequence)"title")) {
                if (titleHeader != null) {
                    throw new RuntimeException("\u042d\u043a\u0441\u043f\u043e\u0440\u0442 xlsx, \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a \u0438\u043c\u0435\u0435\u0442 \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u044b \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430 \u0434\u043b\u044f \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430 \u043f\u043e y");
                }
                titleHeader = columnHeader;
                continue;
            }
            if (StringUtils.equals((CharSequence)columnHeader.getDataField(), (CharSequence)"rcCode")) {
                rcHeader = columnHeader;
                continue;
            }
            if (StringUtils.equals((CharSequence)columnHeader.getDataField(), (CharSequence)"aspectColumn")) {
                aspectHeader = columnHeader;
                continue;
            }
            dataHeaderList.add(columnHeader);
        }
        if (titleHeader == null) {
            throw new RuntimeException();
        }
        LinkedHashMap columnHashMap = new LinkedHashMap();
        this.parseGridCoordinates(xssfSheet, grid, zAxis);
        int maxHeaderYOffset = grid.getYOffset() - 1 + grid.getHeaderHeight();
        this.parseHeaderGroup(xssfSheet, titleHeader, xOffset, grid.getYOffset() + 1, columnHashMap, false, maxHeaderYOffset);
        xOffset += titleHeader.getColspan().intValue();
        if (rcHeader != null) {
            this.parseHeaderGroup(xssfSheet, rcHeader, xOffset, grid.getYOffset() + 1, columnHashMap, false, maxHeaderYOffset);
            xOffset += rcHeader.getColspan().intValue();
        }
        if (aspectHeader != null) {
            int aspectYOffset = grid.getYOffset() + 1;
            for (ColumnHeader aspectHeaderItem : aspectHeader.getColumnList()) {
                this.parseHeaderGroup(xssfSheet, aspectHeaderItem, xOffset, aspectYOffset, columnHashMap, true, maxHeaderYOffset);
                ++aspectYOffset;
            }
            xOffset += aspectHeader.getColspan().intValue();
        }
        for (ColumnHeader dataHeader : dataHeaderList) {
            this.parseHeaderGroup(xssfSheet, dataHeader, xOffset, grid.getYOffset() + 1, columnHashMap, false, maxHeaderYOffset);
            xOffset += dataHeader.getColspan().intValue();
        }
        return this.parseBody(grid, xlsxAxisStructure, columnHashMap, periodLevelList, xssfSheet);
    }

    private CellAddress parseBody(Grid grid, XlsxAxisStructure xlsxAxisStructure, Map<Integer, ColumnHeader> columnMap, List<PeriodLevel> periodLevelList, XSSFSheet xssfSheet) throws UnsupportedAlternativeExportRoleException {
        Optional<Integer> maxValue;
        if (grid == null) {
            log.error("\u0418\u043c\u043f\u043e\u0440\u0442 xlsx. \u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u043b\u0438\u0441\u0442\u0430. \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u044f\u0447\u0435\u0439\u043a\u0438");
            return null;
        }
        if (CollectionUtils.isEmpty(columnMap)) {
            log.error("\u0418\u043c\u043f\u043e\u0440\u0442 xlsx. \u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u043b\u0438\u0441\u0442\u0430. \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u044f\u0447\u0435\u0439\u043a\u0438");
            return null;
        }
        ArrayList gridCommonAspectDataList = new ArrayList();
        if (grid.getPeriod() != null) {
            gridCommonAspectDataList.addAll(grid.getPeriod().getAspectDataList());
        }
        if (grid.getZAxis() != null) {
            gridCommonAspectDataList.addAll(grid.getZAxis().getAspectDataList());
        }
        XlsxAxisStructure currentAxisStructureItem = xlsxAxisStructure;
        int rowYOffset = grid.getYOffset() + grid.getHeaderHeight();
        boolean rowHasValue = true;
        while (rowHasValue) {
            boolean isNewRow = true;
            XSSFRow row = xssfSheet.getRow(rowYOffset);
            if (row == null || rowYOffset > xssfSheet.getLastRowNum()) break;
            rowHasValue = false;
            this.currentRowAspectNodeMemberList = new ArrayList();
            isRowWithOpenAxis = false;
            int countPrecedingEmptyCells = 0;
            countTypedMemberForRow = 0;
            boolean isRowFirstTime = true;
            for (Map.Entry<Integer, ColumnHeader> columnEntry : columnMap.entrySet()) {
                Cell cell;
                ColumnHeader columnHeader = columnEntry.getValue();
                if (columnHeader.getDataField().equals("rcCode") || (cell = row.getCell(columnHeader.getX().intValue())) == null) continue;
                cell = XlsxParser.getStringCellValue((Cell)cell);
                String cellValue = cell.getStringCellValue();
                if (isNewRow && StringUtils.isBlank((CharSequence)cellValue)) {
                    ++countPrecedingEmptyCells;
                    if (rowYOffset > xssfSheet.getLastRowNum()) continue;
                    rowHasValue = true;
                    continue;
                }
                rowHasValue = true;
                if (columnEntry.getKey() < grid.getYHeaderWidth()) {
                    try {
                        currentAxisStructureItem = this.getCurrentAxisStructureItem(currentAxisStructureItem, columnHeader, cell, grid.getXOffset());
                    }
                    catch (Exception e) {
                        log.error("\u0418\u043c\u043f\u043e\u0440\u0442 xlsx. \u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u043e\u0447\u0435\u0440\u0435\u0434\u043d\u043e\u0433\u043e \u0443\u0437\u043b\u0430 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430.");
                        log.warn(ExceptionUtils.getStackTrace((Throwable)e));
                        throw new UnsupportedAlternativeExportRoleException();
                    }
                    if (isRowWithOpenAxis.booleanValue() && isRowFirstTime) {
                        if (currentAxisStructureItem.getAspectDataList() != null) {
                            boolean isAspectNode = currentAxisStructureItem.getNodeType() == NodeType.ASPECT;
                            countTypedMemberForRow = (int)((long)countTypedMemberForRow + currentAxisStructureItem.getAspectDataList().stream().filter(x -> ("(bound dynamically)".equals(x.getAspectValue()) || isAspectNode) && DimensionType.EXPLICIT_MEMBER.equals((Object)x.getDimensionType()) || DimensionType.TYPED_MEMBER.equals((Object)x.getDimensionType())).count());
                        }
                        this.countTypedMembersPerRow(currentAxisStructureItem.getXlsxAxisStructureMap());
                        isRowFirstTime = false;
                    }
                    cell.getCellStyle();
                } else {
                    ArrayList aspectDataList = new ArrayList();
                    aspectDataList.addAll(columnHeader.getFullAspectDataList());
                    aspectDataList.addAll(gridCommonAspectDataList);
                    ArrayList fullAxisData = new ArrayList();
                    for (XlsxAxisStructure axis = currentAxisStructureItem; axis != null; axis = axis.getParentStructure()) {
                        fullAxisData.addAll(0, axis.getAspectDataList());
                    }
                    aspectDataList.addAll(fullAxisData);
                    for (PeriodLevel periodLevel : periodLevelList) {
                        if (periodLevel.getLabel() == null || grid.getPeriod() == null || grid.getPeriod().getLabel() == null || !periodLevel.getLabel().equals(grid.getPeriod().getLabel())) continue;
                        Optional<ZLevel> currentZLevel = periodLevel.getZLevelList().stream().filter(x -> x.getTitle().equals(grid.getZAxis().getTitle())).findFirst();
                        currentZLevel.ifPresent(zLevel -> aspectDataList.addAll(zLevel.getAspectDataList()));
                    }
                    AspectData concept = new AspectCellData(aspectDataList).getConceptByTag(currentAxisStructureItem.getTagSelector());
                    AspectData fake = null;
                    if (currentAxisStructureItem.getTagSelector() != null) {
                        fake = new AspectData();
                        fake.setType(AspectType.TAG_LABEL);
                        fake.setTagSelector(currentAxisStructureItem.getTagSelector());
                    }
                    AspectCellData aspectCellData = new AspectCellData(aspectDataList);
                    Map enumerations = grid.getEnumerations();
                    if (StringUtils.isNotBlank((CharSequence)cellValue) && concept != null && !CollectionUtils.isEmpty((Map)enumerations) && enumerations.containsKey(concept.getAspectValue())) {
                        Optional enumerateItemOptional = XslxSheet.getEnumeratedFactValueByLabel((Map)enumerations, (String)cellValue, (String)concept.getAspectValue());
                        if (!enumerateItemOptional.isPresent()) {
                            log.warn("\u0418\u043c\u043f\u043e\u0440\u0442 xlsx. \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430 \u043f\u043e \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u043c\u0443 \u044f\u0440\u043b\u044b\u043a\u0443. {} \u041a\u043e\u043d\u0446\u0435\u043f\u0442 {}, \u044f\u0440\u043b\u044b\u043a {}", new Object[]{"", concept.getLabel(), cellValue});
                        }
                        String enumValue = enumerateItemOptional.isPresent() ? ((EnumerateItem)enumerateItemOptional.get()).getMember() : cellValue;
                        aspectCellData.setCellValue(enumValue);
                    } else {
                        aspectCellData.setCellValue(cellValue);
                    }
                    CellReference cellReference = new CellReference(cell);
                    aspectCellData.setAddress(cellReference.formatAsString());
                    if (StringUtils.isNotBlank((CharSequence)aspectCellData.getCellValue())) {
                        if (fake != null) {
                            aspectCellData.getAspectDataList().add(fake);
                        }
                        List aspectCellDataListNoBD = aspectCellData.getAspectDataList().stream().filter(d -> !"(bound dynamically)".equals(d.getAspectValue())).collect(Collectors.toList());
                        aspectCellData.setAspectDataList(aspectCellDataListNoBD);
                        this.editedCellList.add(aspectCellData);
                    }
                }
                isNewRow = false;
            }
            if (countPrecedingEmptyCells >= grid.getYHeaderWidth()) {
                int lineNumber = rowYOffset + 1;
                log.error("\u041d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043e\u0441\u0438. \u0421\u0442\u0440\u043e\u043a\u0430: " + lineNumber);
                XlsxParser.incorrectImportedAxisLines.add(lineNumber);
            }
            long countEmptyLabelRowMembers = this.currentRowAspectNodeMemberList.stream().filter(x -> StringUtils.isBlank((CharSequence)x.getClosedMemberLabel())).count();
            if (isRowWithOpenAxis.booleanValue() && (countEmptyLabelRowMembers != 0L || countTypedMemberForRow != this.currentRowAspectNodeMemberList.size())) {
                int lineNumber = rowYOffset + 1;
                log.error("\u041d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043e\u0439 \u043e\u0441\u0438. \u0421\u0442\u0440\u043e\u043a\u0430: " + lineNumber);
                XlsxParser.incorrectImportedAxisLines.add(lineNumber);
            } else {
                this.aspectNodeMemberList.addAll(this.currentRowAspectNodeMemberList);
            }
            ++rowYOffset;
        }
        if ((maxValue = columnMap.values().stream().map(ColumnHeader::getX).reduce(Integer::max)).isPresent()) {
            return new CellAddress(rowYOffset - 1, maxValue.get().intValue());
        }
        log.error("\u0418\u043c\u043f\u043e\u0440\u0442 xlsx. \u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u043b\u0438\u0441\u0442\u0430. \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u044f\u0447\u0435\u0439\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0446\u044b.");
        return null;
    }

    private void countTypedMembersPerRow(Map<String, List<XlsxAxisStructure>> structureMap) {
        if (structureMap != null) {
            for (Map.Entry<String, List<XlsxAxisStructure>> entry : structureMap.entrySet()) {
                for (XlsxAxisStructure value : entry.getValue()) {
                    List aspectDataList = value.getAspectDataList();
                    if (aspectDataList != null) {
                        boolean isAspectNode = value.getNodeType() == NodeType.ASPECT;
                        countTypedMemberForRow = (int)((long)countTypedMemberForRow + aspectDataList.stream().filter(x -> ("(bound dynamically)".equals(x.getAspectValue()) || isAspectNode) && DimensionType.EXPLICIT_MEMBER.equals((Object)x.getDimensionType()) || DimensionType.TYPED_MEMBER.equals((Object)x.getDimensionType())).count());
                    }
                    this.countTypedMembersPerRow(value.getXlsxAxisStructureMap());
                }
            }
        }
    }

    private XlsxAxisStructure getCurrentAxisStructureItem(XlsxAxisStructure currentAxisStructureItem, ColumnHeader columnHeader, Cell cell, int xOffset) throws Exception {
        if (currentAxisStructureItem == null || columnHeader == null || cell == null) {
            return null;
        }
        while (columnHeader.getX() != null && columnHeader.getX() - xOffset < currentAxisStructureItem.getLevel() + 1) {
            if ((currentAxisStructureItem = currentAxisStructureItem.getParentStructure()) != null) continue;
            return null;
        }
        if (columnHeader.getX() == null) {
            return null;
        }
        Set xlsxAxisStructureLabelSet = currentAxisStructureItem.getXlsxAxisStructureLabelSet();
        boolean hasChildListAspect = currentAxisStructureItem.isHasChildListAspect();
        cell.setCellType(CellType.STRING);
        String cellValue = cell.getStringCellValue();
        if (cellValue == null || cellValue.equals("")) {
            return currentAxisStructureItem;
        }
        if (xlsxAxisStructureLabelSet.contains(cellValue)) {
            List list = (List)currentAxisStructureItem.getXlsxAxisStructureMap().get(cellValue);
            XlsxAxisStructure res = (XlsxAxisStructure)list.get(0);
            XlsxAxisStructure parent = res.getParentStructure();
            if (parent != null && parent.getNodeType() == NodeType.ASPECT && res.getNodeType() == NodeType.RULE) {
                XlsxAxisStructure xlsxAxisStructure = new XlsxAxisStructure(currentAxisStructureItem);
                for (AspectData aspectData : res.getAspectDataList()) {
                    Optional<AspectData> existingAspectData = xlsxAxisStructure.getAspectDataList().stream().filter(p -> p.getAspect().equals(aspectData.getAspect())).findFirst();
                    if (existingAspectData.isPresent()) {
                        existingAspectData.get().setAspectValue(aspectData.getAspectValue());
                        continue;
                    }
                    xlsxAxisStructure.getAspectDataList().add(aspectData);
                }
                res = xlsxAxisStructure;
            }
            if (list.size() > 1) {
                list.remove(0);
            }
            return res;
        }
        if (hasChildListAspect) {
            isRowWithOpenAxis = true;
            XlsxAxisStructure xlsxAxisStructure = new XlsxAxisStructure(currentAxisStructureItem.getChildAspectStructure());
            xlsxAxisStructure.getAspectDataList().addAll(0, currentAxisStructureItem.getAspectDataList());
            List aspectDataList = xlsxAxisStructure.getAspectDataList();
            for (AspectData aspectData : aspectDataList) {
                if (aspectData.getType() != AspectType.DIMENSION || !StringUtils.contains((CharSequence)columnHeader.getCaption(), (CharSequence)aspectData.getLabel()) || !StringUtils.equals((CharSequence)aspectData.getAspectValue(), (CharSequence)"(bound dynamically)")) continue;
                String aspect = aspectData.getAspect();
                if (aspectData.getDimensionType() == DimensionType.EXPLICIT_MEMBER) {
                    aspectData.setAspectValue(this.getDimensionMember(aspect, cellValue));
                } else {
                    aspectData.setAspectValue(cellValue);
                }
                aspectData.setAxisLabel(aspectData.getLabel());
                aspectData.setLabel(aspectData.getAxisLabel() + "-" + cellValue);
                aspectData.setAxisValueLabel(cellValue);
                AspectNodeMember aspectNodeMember = new AspectNodeMember();
                aspectNodeMember.setDimension(aspect);
                aspectNodeMember.setHash(StringUtils.isBlank((CharSequence)currentAxisStructureItem.getHash()) ? currentAxisStructureItem.getId() : currentAxisStructureItem.getHash());
                xlsxAxisStructure.setHash(aspectNodeMember.getHash() + "#" + xlsxAxisStructure.getDefinitionNodeId() + "#" + aspect + "#" + DigestUtils.md5Hex((String)cellValue));
                aspectNodeMember.setCommonId(xlsxAxisStructure.getHash());
                aspectNodeMember.setClosedMemberLabel(cellValue);
                this.currentRowAspectNodeMemberList.add(aspectNodeMember);
            }
            return xlsxAxisStructure;
        }
        log.error("\u0418\u043c\u043f\u043e\u0440\u0442 xlsx. \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0434\u043e\u0447\u0435\u0440\u043d\u0435\u0433\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430.");
        throw new Exception();
    }

    private String getDimensionMember(String dimension, String memberValue) {
        DimensionDTO dimensionMemberDTO;
        List memberDTOList = (List)this.dimensionMemberCache.get(dimension);
        if (CollectionUtils.isEmpty((Collection)memberDTOList) && (dimensionMemberDTO = this.aspectNodeService.getMembersForDimension(dimension)) != null && !CollectionUtils.isEmpty((Collection)dimensionMemberDTO.getMembers())) {
            memberDTOList = dimensionMemberDTO.getMembers();
            this.dimensionMemberCache.put(dimension, memberDTOList);
        }
        for (MemberDTO memberDTO : memberDTOList) {
            if (!StringUtils.equals((CharSequence)memberDTO.getLabel().trim(), (CharSequence)memberValue.trim())) continue;
            return memberDTO.getValue();
        }
        return null;
    }

    private void parseGridCoordinates(XSSFSheet xssfSheet, Grid grid, AxisMemberHierarchy zAxis) {
        int yOffset = grid.getYOffset();
        int xOffset = grid.getXOffset();
        XSSFRow row = xssfSheet.getRow(yOffset);
        XSSFCell periodCell = row.getCell(xOffset);
        if (periodCell == null) {
            log.warn("\u0418\u043c\u043f\u043e\u0440\u0442 xlsx. \u041e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0438\u043e\u0434\u0430, \u044f\u0447\u0435\u0439\u043a\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430");
            return;
        }
        periodCell.setCellType(CellType.STRING);
        String stringCellValue = periodCell.getStringCellValue();
        String period = StringUtils.substringAfter((String)stringCellValue, (String)"T= ");
        if (StringUtils.isBlank((CharSequence)period)) {
            log.warn("\u0418\u043c\u043f\u043e\u0440\u0442 xlsx. \u041e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0438\u043e\u0434\u0430");
            return;
        }
        XSSFCell zCell = row.getCell(xOffset = xOffset + grid.getColumnCount() - 1);
        if (zCell == null) {
            log.warn("\u0418\u043c\u043f\u043e\u0440\u0442 xlsx. \u041e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044f \u043e\u0441\u0438 z, \u044f\u0447\u0435\u0439\u043a\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430");
            return;
        }
        zCell.setCellType(CellType.STRING);
        stringCellValue = zCell.getStringCellValue();
        String zValue = StringUtils.trim((String)StringUtils.substringAfter((String)stringCellValue, (String)"Z= "));
        if (StringUtils.isBlank((CharSequence)zValue)) {
            log.warn("\u0418\u043c\u043f\u043e\u0440\u0442 xlsx. \u041e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044f \u043e\u0441\u0438 z");
            return;
        }
        PeriodLevel periodLevel = new PeriodLevel();
        period = StringUtils.trim((String)period);
        periodLevel.setLabel(StringUtils.trim((String)period));
        if (!StringUtils.equals((CharSequence)period, (CharSequence)"EMPTY_AXIS")) {
            AspectData globalPeriodAspectData = new AspectData();
            globalPeriodAspectData.setAspect(AspectType.PERIOD.toValue());
            globalPeriodAspectData.setType(AspectType.PERIOD);
            globalPeriodAspectData.setAspectValue(period);
            periodLevel.getAspectDataList().add(globalPeriodAspectData);
        }
        grid.setPeriod(periodLevel);
        ZLevel zLevel = new ZLevel();
        if (!StringUtils.equals((CharSequence)zValue, (CharSequence)"EMPTY_AXIS")) {
            List axisMemberHierarchyList = zAxis.getAxisMemberHierarchyList();
            for (AxisMemberHierarchy axisMemberHierarchy : axisMemberHierarchyList) {
                if (!StringUtils.equals((CharSequence)axisMemberHierarchy.getLabel(), (CharSequence)zValue)) continue;
                zLevel.getAspectDataList().addAll(axisMemberHierarchy.getAspectDataList());
            }
        }
        zLevel.setTitle(StringUtils.trim((String)zValue));
        grid.setZAxis(zLevel);
    }
}

