/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.internal;

import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import ru.cbr.xbrl.converter.config.ConfigProperties;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.model_main.Taxonomy;
import ru.cbr.xbrl.converter.repository_main.TaxonomyRepository;
import ru.cbr.xbrl.converter.service.internal.TaxonomyCrudService;

@Service
public class TaxonomyCrudServiceImpl
implements TaxonomyCrudService {
    private static final Logger log = LoggerFactory.getLogger(TaxonomyCrudServiceImpl.class);
    @Autowired
    private TaxonomyRepository taxonomyRepository;
    @Autowired
    private ConfigProperties configProperties;

    public List<Taxonomy> list() {
        return (List)this.taxonomyRepository.findAll();
    }

    public List<Taxonomy> listActive() {
        return this.taxonomyRepository.findByActive(Boolean.TRUE);
    }

    public Taxonomy find(Long id) throws NotFoundException {
        Taxonomy taxonomy = (Taxonomy)this.taxonomyRepository.findOne((Serializable)id);
        if (taxonomy == null) {
            log.error("Taxonomy not found with id " + id);
            throw new NotFoundException();
        }
        return taxonomy;
    }

    public Taxonomy findByVersion(String taxonomyVersion) throws NotFoundException {
        Taxonomy taxonomy = this.taxonomyRepository.findFirstByTaxonomyPackageVersionOrderByUploadTimeDesc(taxonomyVersion);
        if (taxonomy == null) {
            log.warn("Taxonomy version not found with version " + taxonomyVersion);
            throw new NotFoundException();
        }
        return taxonomy;
    }

    public Taxonomy create(Taxonomy taxonomy) {
        return (Taxonomy)this.taxonomyRepository.save((Object)taxonomy);
    }

    public Taxonomy update(Taxonomy taxonomy) throws NotFoundException {
        Taxonomy existingTaxonomy = this.find(taxonomy.getId());
        return (Taxonomy)this.taxonomyRepository.save((Object)taxonomy);
    }

    public void delete(Long id) throws NotFoundException {
        Taxonomy existingTaxonomy = this.find(id);
        this.taxonomyRepository.delete((Object)existingTaxonomy);
    }

    public Taxonomy findLastTaxonomy() throws NotFoundException {
        Taxonomy taxonomy = this.taxonomyRepository.findFirstByOrderByUploadTimeDesc();
        if (taxonomy == null) {
            log.error("Last taxonomy not found");
            throw new NotFoundException();
        }
        return taxonomy;
    }
}

