/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterOpenAxis;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterOpenAxisValue;
import ru.cbr.xbrl.converter.repository.FilterOpenAxisRepository;
import ru.cbr.xbrl.converter.repository.FilterOpenAxisValueRepository;
import ru.cbr.xbrl.converter.service.internal.XbrlFilterOpenAxisService;

@Service
public class XbrlFilterOpenAxisServiceImpl
implements XbrlFilterOpenAxisService {
    private final FilterOpenAxisRepository filterOpenAxisRepository;
    private final FilterOpenAxisValueRepository filterOpenAxisValueRepository;

    @Autowired
    public XbrlFilterOpenAxisServiceImpl(FilterOpenAxisRepository filterOpenAxisRepository, FilterOpenAxisValueRepository filterOpenAxisValueRepository) {
        this.filterOpenAxisRepository = filterOpenAxisRepository;
        this.filterOpenAxisValueRepository = filterOpenAxisValueRepository;
    }

    public List<FilterOpenAxis> findFilterOpenAxisBySystemId(String systemId) {
        return this.filterOpenAxisRepository.findAllBySystemId(systemId);
    }

    public FilterOpenAxis update(FilterOpenAxis filterOpenAxis) {
        return (FilterOpenAxis)this.filterOpenAxisRepository.save((Object)filterOpenAxis);
    }

    public FilterOpenAxis find(Long axisId) {
        return (FilterOpenAxis)this.filterOpenAxisRepository.findOne((Serializable)axisId);
    }

    public List<FilterOpenAxis> findAll() {
        return this.filterOpenAxisRepository.findAll();
    }

    public List<FilterOpenAxisValue> getFilterOpenAxisValues(String systemId) {
        List filterOpenAxisList = this.findFilterOpenAxisBySystemId(systemId);
        if (!filterOpenAxisList.isEmpty()) {
            FilterOpenAxis filterOpenAxis = (FilterOpenAxis)filterOpenAxisList.get(0);
            List values = filterOpenAxis.getAxisMemberList();
            return values;
        }
        return new ArrayList<FilterOpenAxisValue>();
    }

    public FilterOpenAxisValue getFilterOpenAxisValue(Long filterOpenAxisValueId) {
        return (FilterOpenAxisValue)this.filterOpenAxisValueRepository.findOne((Serializable)filterOpenAxisValueId);
    }

    public Long countAllBySystemId(String systemId) {
        return this.filterOpenAxisRepository.countAllBySystemId(systemId);
    }
}

