/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.internal;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.model.XbrlPeriod;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.XbrlRolePeriod;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterOpenAxis;
import ru.cbr.xbrl.converter.model.tableLinkBase.XbrlRoleDimension;
import ru.cbr.xbrl.converter.repository.XbrlPdRolePeriodRepository;
import ru.cbr.xbrl.converter.repository.XbrlReportRepository;
import ru.cbr.xbrl.converter.repository.XbrlReportRoleRepository;
import ru.cbr.xbrl.converter.repository.XbrlRolePeriodRepository;
import ru.cbr.xbrl.converter.service.internal.XbrlReportCrudService;

@Service
public class XbrlReportCrudServiceImpl
implements XbrlReportCrudService {
    private static final Logger log = LoggerFactory.getLogger(XbrlReportCrudServiceImpl.class);
    @Autowired
    private XbrlReportRepository xbrlReportRepository;
    @Autowired
    private XbrlReportRoleRepository xbrlReportRoleRepository;
    @Autowired
    private XbrlRolePeriodRepository xbrlRolePeriodRepository;
    @Autowired
    private XbrlPdRolePeriodRepository xbrlPdRolePeriodRepository;

    public List<XbrlReport> list() {
        return (List)this.xbrlReportRepository.findAll();
    }

    public XbrlReport find(Long id) throws NotFoundException {
        XbrlReport report = (XbrlReport)this.xbrlReportRepository.findOne((Serializable)id);
        if (report == null) {
            log.error("XbrlReport not found with id " + id);
            throw new NotFoundException();
        }
        return report;
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public XbrlReportRole findRole(Long xbrlRoleId) throws NotFoundException {
        XbrlReportRole reportRole = (XbrlReportRole)this.xbrlReportRoleRepository.findOne((Serializable)xbrlRoleId);
        if (reportRole == null) {
            log.error("Role not found with id " + xbrlRoleId);
            throw new NotFoundException();
        }
        return this.prepareXbrlReportRole(reportRole);
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public XbrlReportRole findRoleBySystemId(String systemId) throws NotFoundException {
        XbrlReportRole reportRole = this.xbrlReportRoleRepository.findBySystemId(systemId);
        if (reportRole == null) {
            log.error("Role not found with systemId " + systemId);
            throw new NotFoundException();
        }
        return this.prepareXbrlReportRole(reportRole);
    }

    private XbrlReportRole prepareXbrlReportRole(XbrlReportRole reportRole) {
        List periodList = reportRole.getPeriodList();
        List xbrlRoleDimensionList = reportRole.getXbrlRoleDimensionList();
        if (CollectionUtils.isEmpty((Collection)periodList) && CollectionUtils.isEmpty((Collection)xbrlRoleDimensionList)) {
            return reportRole;
        }
        periodList.size();
        if (xbrlRoleDimensionList.size() > 0) {
            for (XbrlRoleDimension xbrlRoleDimension : xbrlRoleDimensionList) {
                FilterOpenAxis filterOpenAxis = xbrlRoleDimension.getFilterOpenAxis();
                if (filterOpenAxis == null) continue;
                filterOpenAxis.getAxisMemberList().size();
            }
        }
        return reportRole;
    }

    @Transactional(value="cacheTransactionManager")
    public XbrlRolePeriod updateRolePeriod(XbrlRolePeriod xbrlRolePeriod) throws NotFoundException {
        return (XbrlRolePeriod)this.xbrlRolePeriodRepository.save((Object)xbrlRolePeriod);
    }

    public XbrlReport create(XbrlReport xbrlReport) {
        return (XbrlReport)this.xbrlReportRepository.save((Object)xbrlReport);
    }

    public XbrlReportRole create(XbrlReportRole xbrlReportRole) {
        return (XbrlReportRole)this.xbrlReportRoleRepository.save((Object)xbrlReportRole);
    }

    public XbrlReport update(XbrlReport xbrlReport) throws NotFoundException {
        XbrlReport existingReport = this.find(xbrlReport.getId());
        return (XbrlReport)this.xbrlReportRepository.save((Object)xbrlReport);
    }

    public void delete(Long id) throws NotFoundException {
        XbrlReport existingReport = this.find(id);
        this.xbrlReportRepository.delete((Object)existingReport);
    }

    public void clearRolesByXbrlReport(XbrlReport xbrlReport) {
        xbrlReport.getXbrlReportRoles().forEach(xbrlReportRole -> xbrlReportRole.getPeriodList().clear());
        this.xbrlRolePeriodRepository.deleteAll();
        this.xbrlPdRolePeriodRepository.deleteAll();
        xbrlReport.getXbrlReportRoles().clear();
        this.xbrlReportRoleRepository.deleteAllByXbrlReport(xbrlReport);
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public List<XbrlRolePeriod> findAllByPeriodAndRole(XbrlPeriod xbrlPeriod, XbrlReportRole role) {
        return this.xbrlRolePeriodRepository.findAllByXbrlPeriodAndXbrlReportRole(xbrlPeriod, role);
    }

    @Transactional(value="cacheTransactionManager")
    public void deleteRolePeriod(XbrlRolePeriod rolePeriod) {
        this.xbrlRolePeriodRepository.delete((Object)rolePeriod);
    }

    @Transactional(value="cacheTransactionManager")
    public void deleteRolePeriodByRole(XbrlReportRole xbrlReportRole) {
        this.xbrlRolePeriodRepository.deleteAllByReportRole(xbrlReportRole);
    }

    public XbrlReportRole updateXbrlReportRole(XbrlReportRole xbrlReportRole) {
        return (XbrlReportRole)this.xbrlReportRoleRepository.save((Object)xbrlReportRole);
    }
}

