/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.internal.xbrl;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import ru.cbr.xbrl.converter.arelle.parse.DimConceptProcessor;
import ru.cbr.xbrl.converter.arelle.parse.DimParser;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBaseStructure;
import ru.cbr.xbrl.converter.model.xbrl_content.RoleCell;
import ru.cbr.xbrl.converter.repository.RoleCellRepository;
import ru.cbr.xbrl.converter.repository.XbrlReportRoleRepository;
import ru.cbr.xbrl.converter.service.TableLinkBaseDataService;
import ru.cbr.xbrl.converter.service.XbrlReportService;
import ru.cbr.xbrl.converter.service.internal.xbrl.RoleCellService;

@Service
public class RoleCellServiceImpl
implements RoleCellService {
    private static final Logger log = LoggerFactory.getLogger(RoleCellServiceImpl.class);
    @Autowired
    private RoleCellRepository roleCellRepository;
    @Autowired
    private XbrlReportService xbrlReportService;
    @Autowired
    private XbrlReportRoleRepository xbrlReportRoleRepository;
    @Autowired
    private TableLinkBaseDataService tableLinkBaseDataService;
    private static final int MEGABYTE = 0x100000;

    public void parseDimFile(Long xbrlReportId, String fullFileName) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            XbrlReport xbrlReport = this.xbrlReportService.find(xbrlReportId);
            Map dimensionsDefault = this.getDimensionsDefault(xbrlReport);
            List roles = xbrlReport.getXbrlReportRoles();
            DimParser.parseFile((String)fullFileName, (role, dimConcepts) -> {
                String linkrole = (String)role.getLeft();
                Boolean isAbstractRole = !dimConcepts.stream().filter(dimConcept -> BooleanUtils.isFalse((Boolean)dimConcept.getAbstractNode())).findFirst().isPresent();
                try {
                    Optional<XbrlReportRole> roleOptional = roles.stream().filter(xbrlReportRole -> linkrole.startsWith(xbrlReportRole.getSystemId())).findFirst();
                    if (roleOptional.isPresent()) {
                        XbrlReportRole xbrlReportRole2 = this.xbrlReportService.findReportRole(roleOptional.get().getId());
                        List existingCells = new ArrayList();
                        if (StringUtils.isNotBlank((CharSequence)xbrlReportRole2.getRoleCellsJson())) {
                            existingCells = (List)objectMapper.readValue(xbrlReportRole2.getRoleCellsJson(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                        }
                        DimConceptProcessor dimConceptProcessor = new DimConceptProcessor(dimensionsDefault, dimConcepts);
                        dimConceptProcessor.buildCellExclusionsData();
                        List roleCellList = dimConceptProcessor.getRoleCells();
                        roleCellList.forEach(roleCell -> {
                            roleCell.getRoleCellId().setXbrlReportId(xbrlReportId);
                            roleCell.getRoleCellId().setXbrlReportRoleId(xbrlReportRole2.getId());
                        });
                        existingCells.addAll(roleCellList);
                        String json = objectMapper.writeValueAsString(existingCells);
                        xbrlReportRole2.setRoleCellsJson(json);
                        this.xbrlReportRoleRepository.save((Object)xbrlReportRole2);
                    }
                }
                catch (NotFoundException e) {
                    log.warn("Role not found: " + linkrole);
                }
                catch (JsonProcessingException e) {
                    log.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
                catch (IOException e) {
                    log.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
                catch (OutOfMemoryError e) {
                    MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
                    MemoryUsage heapUsage = memoryBean.getHeapMemoryUsage();
                    long maxMemory = heapUsage.getMax() / 0x100000L;
                    long usedMemory = heapUsage.getUsed() / 0x100000L;
                    log.error(" : Memory Use :" + usedMemory + "M/" + maxMemory + "M");
                    log.error("role " + linkrole);
                    log.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }
        catch (NotFoundException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public RoleCell saveRoleCell(RoleCell roleCell) {
        return (RoleCell)this.roleCellRepository.save((Object)roleCell);
    }

    public Map<String, String> getDimensionsDefault(XbrlReport xbrlReport) {
        if (xbrlReport.getXbrlReportRoles().isEmpty()) {
            return new HashMap<String, String>();
        }
        XbrlReportRole role = (XbrlReportRole)xbrlReport.getXbrlReportRoles().get(0);
        try {
            ObjectMapper mapper = new ObjectMapper();
            TableLinkBaseStructure structure = (TableLinkBaseStructure)mapper.readValue(role.getStaticStructureJson(), TableLinkBaseStructure.class);
            Map dimensionsDefault = structure.getDimensionsDefault();
            return dimensionsDefault;
        }
        catch (JsonParseException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (JsonMappingException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return null;
    }
}

