/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.internal.xbrl;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Service;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.model.XbrlContextPDRole;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.xbrl_content.PeriodType;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContext;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextId;
import ru.cbr.xbrl.converter.repository.XbrlContextRepository;
import ru.cbr.xbrl.converter.service.import_export.PeriodDates;
import ru.cbr.xbrl.converter.service.internal.xbrl.XbrlContextCrudService;

@Service
public class XbrlContextCrudServiceImpl
implements XbrlContextCrudService {
    private static final Logger log = LoggerFactory.getLogger(XbrlContextCrudServiceImpl.class);
    @PersistenceContext(unitName="cachePU")
    private EntityManager entityManager;
    @Autowired
    private XbrlContextRepository xbrlContextRepository;
    @Autowired
    private NamedParameterJdbcTemplate jdbcTemplate;

    public List<XbrlContext> list() {
        return this.xbrlContextRepository.findAll();
    }

    public Slice<XbrlContext> list(Pageable pageable) {
        return this.xbrlContextRepository.findAll(pageable);
    }

    public XbrlContext find(XbrlContextId id) throws NotFoundException {
        XbrlContext xbrlContext = (XbrlContext)this.xbrlContextRepository.findOne((Serializable)id);
        if (xbrlContext == null) {
            log.trace("Xbrl Context not found with id " + id);
            throw new NotFoundException();
        }
        return xbrlContext;
    }

    public XbrlContext create(XbrlContext xbrlContext) {
        return (XbrlContext)this.xbrlContextRepository.save((Object)xbrlContext);
    }

    public XbrlContext update(XbrlContext xbrlContext) throws NotFoundException {
        XbrlContext existingXbrlContext = this.find(xbrlContext.getXbrlContextId());
        return (XbrlContext)this.xbrlContextRepository.save((Object)xbrlContext);
    }

    public void delete(XbrlContextId id) throws NotFoundException {
        XbrlContext xbrlContext = this.find(id);
        this.xbrlContextRepository.delete((Object)xbrlContext);
    }

    public Stream<XbrlContext> streamAll() {
        return this.xbrlContextRepository.streamAll();
    }

    public void deleteAllByXbrlReport(XbrlReport xbrlReport) {
        this.entityManager.createQuery("delete from XbrlContext c where c.xbrlContextId.xbrlReportId = :r").setParameter("r", (Object)xbrlReport.getId()).executeUpdate();
    }

    public long count() {
        return this.xbrlContextRepository.count();
    }

    public List<XbrlContext> findByIdentifier(String identifier) {
        return this.xbrlContextRepository.findByIdentifier(identifier);
    }

    public List<XbrlContext> findByPeriodDates(PeriodDates periodDates) {
        PeriodType periodType = periodDates.getPeriodType();
        if (periodType.equals((Object)PeriodType.DURATION)) {
            Date startDate = periodDates.getStartDate();
            Date endDate = periodDates.getEndDate();
            return this.xbrlContextRepository.findContextByPeriodTypeAndStartDateAndEndDate(periodType, startDate, endDate);
        }
        if (periodType.equals((Object)PeriodType.INSTANT)) {
            Date instantDate = periodDates.getInstantDate();
            return this.xbrlContextRepository.findContextByPeriodTypeAndInstantDate(periodType, instantDate);
        }
        throw new IllegalArgumentException("Wrong periodType");
    }

    public List<XbrlContext> findByPeriodDatesAndDimensionsHash(PeriodDates periodDates, String dimensionsHash) {
        if (StringUtils.isBlank((CharSequence)dimensionsHash) || periodDates == null) {
            return Collections.emptyList();
        }
        PeriodType periodType = periodDates.getPeriodType();
        if (periodType == null) {
            return Collections.emptyList();
        }
        if (periodType.equals((Object)PeriodType.INSTANT) && periodDates.getInstantDate() != null) {
            return this.xbrlContextRepository.findByInstantDateAndDimensionsHash(periodDates.getInstantDate(), dimensionsHash);
        }
        if (periodType.equals((Object)PeriodType.DURATION) && periodDates.getStartDate() != null && periodDates.getEndDate() != null) {
            return this.xbrlContextRepository.findByStartDateAndEndDateAndDimensionsHash(periodDates.getStartDate(), periodDates.getEndDate(), dimensionsHash);
        }
        return Collections.emptyList();
    }

    public List<XbrlContext> findByPDRoleSystemId(String systemId) {
        return this.xbrlContextRepository.findByPDRoleSystemId(systemId);
    }

    public List<XbrlContextPDRole> findContextPDRole() {
        return this.jdbcTemplate.query("select distinct xvr.rolesystemid, c.contextid from xbrlcontext c inner join xbrlvalue xv on c.contextid = xv.xbrlcontextid inner join xbrlvaluerole xvr on xvr.guid = xv.guid", (RowMapper)new /* Unavailable Anonymous Inner Class!! */);
    }
}

