/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.internal.xbrl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.model.DataType;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.XbrlValueContextCounter;
import ru.cbr.xbrl.converter.model.tableLinkBase.XbrlValueDTO;
import ru.cbr.xbrl.converter.model.web.rest.AspectDataWrapper;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextDimension;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlUnit;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValue;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValueId;
import ru.cbr.xbrl.converter.repository.XbrlValueRepository;
import ru.cbr.xbrl.converter.service.EnumerationsService;
import ru.cbr.xbrl.converter.service.XbrlRoleService;
import ru.cbr.xbrl.converter.service.internal.xbrl.XbrlFootnoteCrudService;
import ru.cbr.xbrl.converter.service.internal.xbrl.XbrlValueCrudService;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;

@Service
public class XbrlValueCrudServiceImpl
implements XbrlValueCrudService {
    private static final Logger log = LoggerFactory.getLogger(XbrlValueCrudServiceImpl.class);
    @Autowired
    private XbrlValueRepository xbrlValueRepository;
    @Autowired
    private XbrlRoleService xbrlRoleService;
    @Autowired
    private XbrlFootnoteCrudService xbrlFootnoteCrudService;
    @Autowired
    private EnumerationsService enumerationService;
    @PersistenceContext(unitName="cachePU")
    private EntityManager entityManager;

    public List<XbrlValue> list() {
        return this.xbrlValueRepository.findAll();
    }

    public Slice<XbrlValue> list(Pageable pageable) {
        return this.xbrlValueRepository.findAll(pageable);
    }

    public XbrlValue find(XbrlValueId id) {
        XbrlValue xbrlValue = (XbrlValue)this.xbrlValueRepository.findOne((Serializable)id);
        if (xbrlValue == null) {
            log.trace("Xbrl value not found with id " + id);
        }
        return xbrlValue;
    }

    public XbrlValue create(XbrlValue xbrlValue) {
        return (XbrlValue)this.xbrlValueRepository.save((Object)xbrlValue);
    }

    public XbrlValue update(XbrlValue xbrlValue) {
        XbrlValue existingXbrlValue = this.find(xbrlValue.getXbrlValueId());
        return (XbrlValue)this.xbrlValueRepository.save((Object)xbrlValue);
    }

    public void delete(XbrlValueId id) throws NotFoundException {
        XbrlValue xbrlValue = this.find(id);
        this.xbrlValueRepository.delete((Object)xbrlValue);
    }

    public void deleteFound(XbrlValue xbrlValue) {
        if (xbrlValue == null) {
            log.warn("Found XbrlValue for deleting is null");
            return;
        }
        if (xbrlValue.getXbrlValueId() == null || StringUtils.isBlank((CharSequence)xbrlValue.getXbrlValueId().getElementLabel())) {
            log.warn("Found XbrlValue has empty id fields");
            return;
        }
        this.xbrlValueRepository.delete((Object)xbrlValue);
    }

    public void deleteAllByXbrlReport(XbrlReport xbrlReport) {
        this.entityManager.createQuery("delete from XbrlValue c where c.xbrlValueId.xbrlReportId = :r").setParameter("r", (Object)xbrlReport.getId()).executeUpdate();
    }

    public long count() {
        return this.xbrlValueRepository.count();
    }

    public void updateUnitDecimalsPrecisionByDataType(DataType dataType, XbrlUnit xbrlUnit, Integer decimals, Integer precision) {
        this.entityManager.createQuery("update XbrlValue set decimals = :decimals, precision = :precision, xbrlUnit = :xbrlUnit where dataType = :dataType").setParameter("xbrlUnit", (Object)xbrlUnit.getXbrlUnitId().getUnitId()).setParameter("decimals", (Object)decimals).setParameter("precision", (Object)precision).setParameter("dataType", (Object)dataType).executeUpdate();
    }

    public XbrlValue findByIdForFootnote(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        List valueList = this.xbrlValueRepository.findById(id);
        if (CollectionUtils.isEmpty((Collection)valueList)) {
            return null;
        }
        if (valueList.size() > 1) {
            log.warn("\u0421\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0444\u0430\u043a\u0442\u043e\u0432, \u0438\u043c\u0435\u044e\u0449\u0438\u0445 id {} \u0434\u043b\u044f \u0441\u0432\u044f\u0437\u0438 \u0441 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u044f\u043c\u0438: ", (Object)id);
            for (XbrlValue xbrlValue : valueList) {
                XbrlValueId xbrlValueId = xbrlValue.getXbrlValueId();
                log.warn("\u0424\u0430\u043a\u0442 label - {}, contextId - {}, reportId - {}", new Object[]{xbrlValueId.getElementLabel(), xbrlValueId.getXbrlContextId(), xbrlValueId.getXbrlReportId()});
            }
        }
        return (XbrlValue)valueList.iterator().next();
    }

    public List<XbrlValue> findAllByIdForFootnote(String id) {
        return this.xbrlValueRepository.findById(id);
    }

    public List<XbrlValue> findByElementNameAndElementUriAndContextAndReportId(String elementName, String elementUri, String context, Long id) {
        return this.xbrlValueRepository.findByElementNameAndElementUriAndContextAndReportId(elementName, elementUri, context, id);
    }

    public List<XbrlValue> findByContextIdHash(String contextidHash) {
        return this.xbrlValueRepository.findByContextIdHash(contextidHash);
    }

    public List<XbrlValue> findByContextId(String contextId) {
        return this.xbrlValueRepository.findByXbrlValueIdXbrlContextId(contextId);
    }

    public Long countByContextId(String contextId) {
        return this.xbrlValueRepository.countByXbrlValueIdXbrlContextId(contextId);
    }

    public List<XbrlValueContextCounter> findValueCountGroupByXbrlContextId() {
        return this.xbrlValueRepository.findValueCountGroupByXbrlContextId();
    }

    public XbrlValue findByGuid(String guid) {
        return this.xbrlValueRepository.findByGuid(guid);
    }

    public void updateContextConnection(XbrlValue xbrlValue, String newContextId) {
        XbrlValueId xbrlValueId = xbrlValue.getXbrlValueId();
        String oldXbrlContextId = xbrlValueId.getXbrlContextId();
        this.xbrlValueRepository.updateContextConnection(newContextId, xbrlValueId.getElementLabel(), xbrlValueId.getXbrlReportId(), oldXbrlContextId);
        xbrlValueId.setXbrlContextId(newContextId);
        if (StringUtils.isBlank((CharSequence)xbrlValue.getId())) {
            return;
        }
        XbrlValueId oldXbrlValueId = new XbrlValueId(xbrlValueId.getElementLabel(), xbrlValueId.getXbrlReportId(), oldXbrlContextId);
        this.xbrlFootnoteCrudService.moveFootnotes(xbrlValue, oldXbrlValueId);
    }

    public List<XbrlValueDTO> findAllByValue(String query) {
        List byValue = this.xbrlValueRepository.findAllByValue(query);
        this.enumerationService.getMembersByLabelContains(query).forEach(member -> byValue.addAll(this.xbrlValueRepository.findAllByValue(member)));
        return byValue;
    }

    public List<AspectDataWrapper> getAspectDataByXbrlValueDTO(List<XbrlValueDTO> xbrlValueDTOList) {
        ArrayList aspectDataWrapperList = new ArrayList();
        xbrlValueDTOList.forEach(xbrlValueDTO -> {
            AspectDataWrapper aspectDataWrapper = new AspectDataWrapper();
            aspectDataWrapper.getAspectDataList().add(xbrlValueDTO.getPeriodDates().buildAspectData());
            AspectData conceptAspect = new AspectData();
            conceptAspect.setAspect("concept");
            conceptAspect.setAspectValue(xbrlValueDTO.getElementLabel());
            conceptAspect.setType(AspectType.CONCEPT);
            aspectDataWrapper.getAspectDataList().add(conceptAspect);
            if (StringUtils.isNotEmpty((CharSequence)xbrlValueDTO.getDimensions())) {
                List dimensions = XbrlContextDimension.dimensionsFromString((String)xbrlValueDTO.getDimensions());
                aspectDataWrapper.getAspectDataList().addAll(dimensions.stream().map(XbrlContextDimension::toAspectData).collect(Collectors.toList()));
            }
            aspectDataWrapper.setPresdefRoleSystemId((String)this.xbrlRoleService.getPdRoleMap().findRoles(aspectDataWrapper.getAspectDataList()).stream().findFirst().orElse(null));
            Optional<Set> roles = Optional.ofNullable(this.xbrlRoleService.getTlbRoleMap().findRoles(aspectDataWrapper.getAspectDataList()));
            roles.ifPresent(strings -> aspectDataWrapper.setTableRoleSystemId((String)strings.stream().findFirst().get()));
            aspectDataWrapperList.add(aspectDataWrapper);
        });
        return aspectDataWrapperList.stream().sorted(Comparator.comparing(AspectDataWrapper::getTableRoleSystemId)).collect(Collectors.toList());
    }

    public boolean isEmpty() {
        return !this.xbrlValueRepository.exists();
    }
}

