/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.label_linkbase;

import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import ru.cbr.xbrl.converter.exception.CancelledException;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.TaxonomyNotFoundException;
import ru.cbr.xbrl.converter.exception.UploadException;
import ru.cbr.xbrl.converter.model.label_linkbase.LabelRole;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.repository.LabelRoleRepository;
import ru.cbr.xbrl.converter.service.XbrlPackageService;
import ru.cbr.xbrl.converter.service.XbrlReportService;
import ru.cbr.xbrl.converter.xbrl.import_export.label_linkbase.LabelLinkbaseParser;

@Service
public class LabelLinkbaseService {
    private static final Logger log = LoggerFactory.getLogger(LabelLinkbaseService.class);
    @Autowired
    private LabelRoleRepository labelRoleRepository;
    @Autowired
    private XbrlReportService xbrlReportService;
    @Autowired
    private XbrlPackageService xbrlPackageService;

    public List<LabelRole> parse(String fileName) {
        List labelRoles = new LabelLinkbaseParser(fileName).getLabelRoleList();
        System.out.println(labelRoles);
        return labelRoles;
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public List<LabelRole> list() {
        List list = this.labelRoleRepository.findAll();
        return list;
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public String getActiveLabelRole() {
        return this.list().stream().filter(LabelRole::isActive).findFirst().orElseGet(LabelRole::new).getName();
    }

    @Transactional(value="cacheTransactionManager")
    public void load(String fileName) {
        List roles = this.list();
        if (roles.isEmpty()) {
            List labelRoles = this.parse(fileName);
            labelRoles.forEach(labelRole -> this.labelRoleRepository.save(labelRole));
        }
    }

    @Transactional(value="cacheTransactionManager")
    public List<LabelRole> setActive(String activeLabelRoleName) throws CancelledException, TaxonomyNotFoundException, NotFoundException, UploadException {
        this.labelRoleRepository.findAll().forEach(labelRole -> {
            labelRole.setActive(Objects.equals(labelRole.getName(), activeLabelRoleName));
            this.labelRoleRepository.save(labelRole);
        });
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        this.xbrlReportService.processXbrlFile(xbrlPackage);
        return this.list();
    }
}

