/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.taxonomy.taxonomy_package;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.JAXB;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.exception.TaxonomyEntryPointsNotFoundException;
import ru.cbr.xbrl.converter.exception.TaxonomyPackageXmlNotFoundException;
import ru.cbr.xbrl.converter.exception.WrongTaxonomyPackageException;
import ru.cbr.xbrl.converter.exception.ZipExtractFileException;
import ru.cbr.xbrl.converter.model_main.Taxonomy;
import ru.cbr.xbrl.converter.model_main.TaxonomyEntryPoint;
import ru.cbr.xbrl.converter.taxonomy.taxonomy_package.data.EntryPoints;
import ru.cbr.xbrl.converter.taxonomy.taxonomy_package.data.TaxonomyDescription;
import ru.cbr.xbrl.converter.taxonomy.taxonomy_package.data.taxonomy_package.TaxonomyPackage;
import ru.cbr.xbrl.converter.utils.ZipUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class TaxonomyPackageReader {
    private static final Logger log = LoggerFactory.getLogger(TaxonomyPackageReader.class);
    public static final String TAXONOMY_PACKAGE_XML = "taxonomyPackage.xml";
    public static final String DESCRIPTION_XML = "description.xml";
    public static final String TAXONOMY_ENTRY_POINTS_XML = "entry_point.xml";

    public static void fillTaxonomyData(Taxonomy taxonomy) throws TaxonomyPackageXmlNotFoundException, TaxonomyEntryPointsNotFoundException, ZipExtractFileException, WrongTaxonomyPackageException {
        TaxonomyPackageReader.fillTaxonomyPackage((Taxonomy)taxonomy);
        TaxonomyPackageReader.fillDescription((Taxonomy)taxonomy);
        TaxonomyPackageReader.fillEntryPoints((Taxonomy)taxonomy);
    }

    private static TaxonomyPackage parseTaxonomyPackageXml(String taxonomyPackageFullPath) throws TaxonomyPackageXmlNotFoundException, ZipExtractFileException, WrongTaxonomyPackageException {
        TaxonomyPackage taxonomyPackage;
        String fileName = "taxonomyPackage.xml";
        String entryFileName = ZipUtils.findEntry((String)taxonomyPackageFullPath, (String)fileName);
        String xml = ZipUtils.extractTextFileContent((String)taxonomyPackageFullPath, (String)entryFileName);
        if (StringUtils.isEmpty((CharSequence)xml)) {
            return null;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
        try {
            taxonomyPackage = (TaxonomyPackage)JAXB.unmarshal((InputStream)is, TaxonomyPackage.class);
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new WrongTaxonomyPackageException();
        }
        return taxonomyPackage;
    }

    private static TaxonomyDescription parseTaxonomyPackageDescription(String taxonomyPackageFullPath) throws ZipExtractFileException, WrongTaxonomyPackageException {
        TaxonomyDescription taxonomyDescription;
        String fileName = "description.xml";
        String entryFileName = ZipUtils.findEntry((String)taxonomyPackageFullPath, (String)fileName);
        String xml = ZipUtils.extractTextFileContent((String)taxonomyPackageFullPath, (String)entryFileName);
        if (StringUtils.isEmpty((CharSequence)xml)) {
            return null;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
        try {
            taxonomyDescription = (TaxonomyDescription)JAXB.unmarshal((InputStream)is, TaxonomyDescription.class);
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new WrongTaxonomyPackageException();
        }
        return taxonomyDescription;
    }

    private static EntryPoints parseTaxonomyEntryPoints(String taxonomyPackageFullPath) throws ZipExtractFileException, WrongTaxonomyPackageException {
        EntryPoints entryPoints;
        String fileName = "entry_point.xml";
        String entryFileName = ZipUtils.findEntry((String)taxonomyPackageFullPath, (String)fileName);
        String xml = ZipUtils.extractTextFileContent((String)taxonomyPackageFullPath, (String)entryFileName);
        if (StringUtils.isEmpty((CharSequence)xml)) {
            return null;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
        try {
            entryPoints = (EntryPoints)JAXB.unmarshal((InputStream)is, EntryPoints.class);
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new WrongTaxonomyPackageException();
        }
        return entryPoints;
    }

    private static void fillTaxonomyPackage(Taxonomy taxonomy) throws TaxonomyPackageXmlNotFoundException, ZipExtractFileException, WrongTaxonomyPackageException {
        String taxonomyPackageFullPath = taxonomy.getFilePath();
        TaxonomyPackage taxonomyPackage = TaxonomyPackageReader.parseTaxonomyPackageXml((String)taxonomyPackageFullPath);
        if (taxonomyPackage == null) {
            throw new TaxonomyPackageXmlNotFoundException();
        }
        taxonomy.setTaxonomyPackageIdentifier(taxonomyPackage.getIdentifier());
        taxonomy.setTaxonomyPackageName(taxonomyPackage.getName());
        taxonomy.setTaxonomyPackageVersion(taxonomyPackage.getVersion());
    }

    private static void fillDescription(Taxonomy taxonomy) throws ZipExtractFileException, WrongTaxonomyPackageException {
        String taxonomyPackageFullPath = taxonomy.getFilePath();
        TaxonomyDescription taxonomyDescription = TaxonomyPackageReader.parseTaxonomyPackageDescription((String)taxonomyPackageFullPath);
        if (taxonomyDescription == null) {
            return;
        }
        taxonomy.setDescriptionVersion(taxonomyDescription.getVersion());
        taxonomy.setDescriptionDateBegin(taxonomyDescription.getDateBegin());
        taxonomy.setDescriptionDateEnd(taxonomyDescription.getDateEnd());
        taxonomy.setDescriptionDatePublic(taxonomyDescription.getDatePublic());
        taxonomy.setDescriptionComments(taxonomyDescription.getComments());
    }

    private static void fillEntryPoints(Taxonomy taxonomy) throws TaxonomyEntryPointsNotFoundException, ZipExtractFileException, WrongTaxonomyPackageException {
        String taxonomyPackageFullPath = taxonomy.getFilePath();
        EntryPoints entryPoints = TaxonomyPackageReader.parseTaxonomyEntryPoints((String)taxonomyPackageFullPath);
        if (entryPoints == null) {
            throw new TaxonomyEntryPointsNotFoundException();
        }
        entryPoints.getEntryPoints().stream().forEach(tep -> {
            TaxonomyEntryPoint entryPoint = new TaxonomyEntryPoint();
            entryPoint.setNfoType(tep.getNfoType());
            entryPoint.setReportType(tep.getReportType());
            entryPoint.setReportPeriodType(tep.getReportPeriodType());
            entryPoint.setPathToXsd(tep.getPathToXsd());
            entryPoint.setNfoTypeRus(tep.getNfoTypeRus());
            entryPoint.setReportTypeRus(tep.getReportTypeRus());
            entryPoint.setReportPeriodTypeRus(tep.getReportPeriodTypeRus());
            entryPoint.setTaxonomy(taxonomy);
            taxonomy.getTaxonomyEntryPoints().add(entryPoint);
        });
    }
}

