/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class LogsAcrhive {
    private static final Logger log = LoggerFactory.getLogger(LogsAcrhive.class);

    public static void createArchive(String electronLogFile, String localFilePath) {
        String dir = FilenameUtils.getFullPath((String)electronLogFile);
        DirectoryStream.Filter pathFilter = LogsAcrhive.getPathFilter();
        File zipFile = new File(localFilePath);
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(zipFile));){
            Files.newDirectoryStream(Paths.get(dir, new String[0]), pathFilter).forEach(path -> LogsAcrhive.addEntry((ZipOutputStream)zipOutputStream, (Path)path));
            zipOutputStream.close();
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private static void addEntry(ZipOutputStream zipOutputStream, Path path) {
        Path fileName = path.getFileName();
        ZipEntry entry = new ZipEntry(fileName.toString());
        try {
            zipOutputStream.putNextEntry(entry);
            try (FileInputStream is = new FileInputStream(path.toFile());){
                IOUtils.copyLarge((InputStream)is, (OutputStream)zipOutputStream);
            }
            zipOutputStream.closeEntry();
        }
        catch (IOException e) {
            log.error("Cannot add entry: " + path);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private static DirectoryStream.Filter<Path> getPathFilter() {
        return path -> {
            Path fileName = path.getFileName();
            return path.toFile().isFile() && fileName.toString().matches("^application.log(\\.\\d+)?$");
        };
    }
}

