/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import ru.cbr.xbrl.converter.controller.import_export.ExportTemplateStruct;
import ru.cbr.xbrl.converter.model.tableLinkBase.AxisMemberHierarchy;
import ru.cbr.xbrl.converter.utils.ZipUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;

/*
 * Exception performing whole class analysis ignored.
 */
public class TemplateUtils {
    public static final String TITLE_PREFIX = "C_";
    public static final String TRANSPOSITION_PREFIX = "T_";
    public static final String HIDE_PREFIX = "H_";
    public static final String MULTIPLIER_PREFIX = "M_";
    public static final String RANGE_PREFIX = "R_";
    public static final String SKIP_CORTEGE_CELL_CODE = "<->";
    public static final String OPEN_AXIS_SYMBOL = "N";
    public static final String DYNAMIC_AXIS_SYMBOL = "D";
    public static final String Z_AXIS_SYMBOL = "Z";
    public static final String MAPPING_CODE_SEPARATOR = ":";
    public static final String AXIS_CODE_SEPARATOR = "-";
    public static final String GLOBAL_PARAMETERS = "\u0413\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b";
    public static final String TEMPLATE_PREFIX = "Template_";
    public static final String MAPPING_PREFIX = "Mapping_";
    public static final String DELTA_PREFIX = "Delta_";
    public static final String PACKAGE_PREFIX = "Package_";
    public static final String TEMPLATE_EXTENSION = ".xlsx";
    public static final String MAPPING_EXTENSION = ".xml";
    public static final String DELTA_EXTENSION = ".xml";
    public static final String INTERNAL_PACKAGE_EXTENSION = ".prt";
    public static final String EXTERNAL_PACKAGE_EXTENSION = ".zip";
    public static final String PASSWORD = "WB_~xow^*nv32zY";
    public static final int STANDARD_TEMPLATE_FILES_SET_SIZE = 3;

    public static String getTitleCode(boolean isForColumns, String roleCode, String xCode, String yCode, AxisMemberHierarchy child) {
        String title;
        if (isForColumns && xCode.contains("N") || !isForColumns && yCode.contains("N")) {
            title = "C_" + roleCode + ":" + xCode + ":" + yCode;
        } else if (StringUtils.isBlank((CharSequence)child.getLabel())) {
            ArrayList<String> labels = new ArrayList<String>();
            List aspectDataList = child.getAspectDataList();
            if (aspectDataList.stream().filter(aspectData -> aspectData.getType() != AspectType.PARAMS_PERIOD).collect(Collectors.toList()).size() == 0) {
                title = "C_" + roleCode + ":" + xCode + ":" + yCode;
            } else {
                for (AspectData aspectData2 : aspectDataList) {
                    if (aspectData2.getType() != AspectType.CONCEPT && aspectData2.getType() != AspectType.DIMENSION || aspectData2.getLabel() == null) continue;
                    labels.add(aspectData2.getLabel());
                }
                title = String.join((CharSequence)", ", labels);
            }
        } else {
            title = child.getLabel();
        }
        return title;
    }

    public static String getTempDirPath() throws IOException {
        Path extractPath = Files.createTempDirectory(UUID.randomUUID().toString(), new FileAttribute[0]);
        if (!extractPath.toFile().exists()) {
            throw new IOException();
        }
        return extractPath.toString();
    }

    public static String getMappingFilePath(String dirAbsolutePath, ExportTemplateStruct exportTemplateStruct) {
        return TemplateUtils.getTempFilePath((String)dirAbsolutePath, (String)TemplateUtils.getFileName((ExportTemplateStruct)exportTemplateStruct, (String)"Mapping_", (String)".xml"));
    }

    public static String getDeltaFilePath(String dirAbsolutePath, ExportTemplateStruct exportTemplateStruct) {
        return TemplateUtils.getTempFilePath((String)dirAbsolutePath, (String)TemplateUtils.getFileName((ExportTemplateStruct)exportTemplateStruct, (String)"Delta_", (String)".xml"));
    }

    public static String getTemplateFilePath(String dirAbsolutePath, ExportTemplateStruct exportTemplateStruct) {
        return TemplateUtils.getTempFilePath((String)dirAbsolutePath, (String)TemplateUtils.getFileName((ExportTemplateStruct)exportTemplateStruct, (String)"Template_", (String)".xlsx"));
    }

    static String getPackageFilePath(String dirAbsolutePath, ExportTemplateStruct exportTemplateStruct, boolean isInternalPackage) {
        String packageExtension = ZipUtils.getPackageExtension((boolean)isInternalPackage);
        return TemplateUtils.getTempFilePath((String)dirAbsolutePath, (String)TemplateUtils.getFileName((ExportTemplateStruct)exportTemplateStruct, (String)"Package_", (String)packageExtension));
    }

    private static String getTempFilePath(String tempDirAbsolutePath, String fileName) {
        return FilenameUtils.concat((String)tempDirAbsolutePath, (String)fileName);
    }

    private static String getFileName(ExportTemplateStruct exportTemplateStruct, String prefix, String extension) {
        return prefix + TemplateUtils.getBaseName((ExportTemplateStruct)exportTemplateStruct) + extension;
    }

    private static String getBaseName(ExportTemplateStruct exportTemplateStruct) {
        String entryPoint = FilenameUtils.getBaseName((String)exportTemplateStruct.getEntryPoint());
        return entryPoint + "_" + LocalDate.now().toString() + "_" + exportTemplateStruct.getVersion();
    }
}

