/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.utils;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.model.XbrlParameter;
import ru.cbr.xbrl.converter.utils.XbrlParametersUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class XbrlParametersUtils {
    private static final Logger log = LoggerFactory.getLogger(XbrlParametersUtils.class);

    public static List<XbrlParameter> parseParameterFile(String fileFullName) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{XmlXbrlParameters.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            File file = new File(fileFullName);
            if (file.length() == 0L) {
                log.info("Empty parametersFile");
                return new ArrayList<XbrlParameter>();
            }
            XmlXbrlParameters parsedParameters = (XmlXbrlParameters)unmarshaller.unmarshal(file);
            List<XbrlParameter> xbrlParameters = parsedParameters.getParameters().stream().filter(param -> param.getValue().matches("^\\d{4}-\\d{2}-\\d{2}")).map(xmlXbrlParameter -> xmlXbrlParameter.buildXbrlParameter()).collect(Collectors.toList());
            System.out.println(xbrlParameters);
            return xbrlParameters;
        }
        catch (JAXBException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    private static Date parseDate(String dateString) {
        SimpleDateFormat parser = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = parser.parse(dateString);
            return date;
        }
        catch (ParseException e1) {
            return null;
        }
    }

    private XbrlParametersUtils() {
    }

    static /* synthetic */ Date access$000(String x0) {
        return XbrlParametersUtils.parseDate((String)x0);
    }
}

